/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser;

import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateDefinition;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateNonTypeParameter;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinding;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.core.runtime.CoreException;

public class DependentValue
implements IValue {
    public static final int MAX_RECURSION_DEPTH = 25;
    private ICPPEvaluation fEvaluation;
    private char[] fSignature;

    private DependentValue(ICPPEvaluation evaluation) {
        this.fEvaluation = evaluation;
    }

    @Override
    public Long numericalValue() {
        return null;
    }

    @Override
    public final Number numberValue() {
        return null;
    }

    @Override
    public final ICPPEvaluation getEvaluation() {
        return this.fEvaluation;
    }

    @Override
    public final char[] getSignature() {
        if (this.fSignature == null) {
            this.fSignature = this.fEvaluation.getSignature();
        }
        return this.fSignature;
    }

    @Override
    @Deprecated
    public char[] getInternalExpression() {
        return CharArrayUtils.EMPTY_CHAR_ARRAY;
    }

    @Override
    @Deprecated
    public IBinding[] getUnknownBindings() {
        return IBinding.EMPTY_BINDING_ARRAY;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buf) throws CoreException {
        buf.putShort((short)5);
        this.fEvaluation.marshal(buf, true);
    }

    public static IValue unmarshal(short firstBytes, ITypeMarshalBuffer buf) throws CoreException {
        ISerializableEvaluation eval = buf.unmarshalEvaluation();
        if (eval instanceof ICPPEvaluation) {
            return new DependentValue((ICPPEvaluation)eval);
        }
        return IntegralValue.UNKNOWN;
    }

    public int hashCode() {
        return CharArrayUtils.hash(this.getSignature());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DependentValue)) {
            return false;
        }
        DependentValue rhs = (DependentValue)obj;
        return CharArrayUtils.equals(this.getSignature(), rhs.getSignature());
    }

    public String toString() {
        return new String(this.getSignature());
    }

    public static DependentValue create(ICPPTemplateDefinition template, ICPPTemplateNonTypeParameter tntp) {
        EvalBinding eval = new EvalBinding((IBinding)tntp, null, template);
        return new DependentValue(eval);
    }

    public static DependentValue create(ICPPEvaluation eval) {
        return new DependentValue(eval);
    }

    @Override
    public final int numberOfSubValues() {
        return 1;
    }

    @Override
    public final ICPPEvaluation getSubValue(int index) {
        return index == 0 ? this.fEvaluation : EvalFixed.INCOMPLETE;
    }

    @Override
    public final ICPPEvaluation[] getAllSubValues() {
        return new ICPPEvaluation[]{this.getEvaluation()};
    }

    @Override
    public void setSubValue(int position, ICPPEvaluation newValue) {
        if (position != 0) {
            throw new IllegalArgumentException("Invalid offset in POD value: " + position);
        }
        this.fEvaluation = newValue;
    }

    @Override
    public IValue clone() {
        return new DependentValue(this.fEvaluation);
    }
}

