/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.internal.core.dom.parser.ISerializableEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalCompositeAccess;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.core.runtime.CoreException;

public class EvalReference
extends CPPDependentEvaluation {
    protected final ActivationRecord owningRecord;
    protected IBinding referredBinding;
    protected EvalCompositeAccess referredSubValue;

    EvalReference(ActivationRecord owningRecord, IBinding referredBinding, IBinding templateDefinition) {
        super(templateDefinition);
        this.owningRecord = owningRecord;
        this.referredBinding = referredBinding;
    }

    EvalReference(ActivationRecord owningRecord, IBinding referredBinding, IASTNode point) {
        this(owningRecord, referredBinding, EvalReference.findEnclosingTemplate(point));
    }

    EvalReference(ActivationRecord owningRecord, EvalCompositeAccess referredSubValue, IBinding templateDefinition) {
        super(templateDefinition);
        this.owningRecord = owningRecord;
        this.referredSubValue = referredSubValue;
        this.referredBinding = null;
    }

    EvalReference(ActivationRecord owningRecord, EvalCompositeAccess referredSubValue, IASTNode point) {
        this(owningRecord, referredSubValue, EvalReference.findEnclosingTemplate(point));
    }

    @Override
    public final boolean isInitializerList() {
        return this.getTargetEvaluation().isInitializerList();
    }

    @Override
    public final boolean isFunctionSet() {
        return this.getTargetEvaluation().isFunctionSet();
    }

    @Override
    public final boolean isTypeDependent() {
        return this.getTargetEvaluation().isTypeDependent();
    }

    @Override
    public final boolean isValueDependent() {
        return this.getTargetEvaluation().isValueDependent();
    }

    @Override
    public final boolean isConstantExpression(IASTNode point) {
        return this.getTargetEvaluation().isConstantExpression(point);
    }

    @Override
    public IType getType(IASTNode point) {
        return this.getTargetEvaluation().getType(point);
    }

    @Override
    public IValue getValue(IASTNode point) {
        return this.getTargetEvaluation().getValue(point);
    }

    public final ICPPEvaluation getTargetEvaluation() {
        if (this.referredSubValue != null) {
            return this.referredSubValue;
        }
        ICPPEvaluation targetValue = this.owningRecord.getVariable(this.referredBinding);
        return targetValue == null ? EvalFixed.INCOMPLETE : targetValue;
    }

    public void update(ICPPEvaluation eval) {
        if (this.referredBinding != null) {
            ICPPEvaluation oldValue = this.owningRecord.getVariable(this.referredBinding);
            if (oldValue instanceof EvalReference) {
                ((EvalReference)oldValue).update(eval);
            } else {
                this.owningRecord.update(this.referredBinding, eval);
            }
        } else {
            this.referredSubValue.update(eval);
        }
    }

    public final IBinding getReferredBinding() {
        return this.referredBinding;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory(IASTNode point) {
        return this.getTargetEvaluation().getValueCategory(point);
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        if (this.referredSubValue != null) {
            return this.referredSubValue.computeForFunctionCall(record, context);
        }
        ICPPEvaluation referredEval = this.owningRecord.getVariable(this.referredBinding);
        if (referredEval instanceof EvalReference) {
            return referredEval.computeForFunctionCall(record, context);
        }
        return referredEval;
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        return this.getTargetEvaluation().determinePackSize(tpMap);
    }

    @Override
    public boolean referencesTemplateParameter() {
        return this.getTargetEvaluation().referencesTemplateParameter();
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        return this.getTargetEvaluation().instantiate(context, maxDepth);
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        short firstBytes = 18;
        if (this.referredSubValue != null) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        buffer.putShort(firstBytes);
        if (this.referredSubValue != null) {
            buffer.marshalEvaluation(this.referredSubValue, includeValue);
        } else {
            buffer.marshalBinding(this.referredBinding);
            buffer.marshalEvaluation(this.owningRecord.getVariable(this.referredBinding), includeValue);
        }
        this.marshalTemplateDefinition(buffer);
    }

    public static ISerializableEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        boolean subValue;
        boolean bl = subValue = (firstBytes & 0x20) != 0;
        if (subValue) {
            EvalCompositeAccess referredSubValue = (EvalCompositeAccess)buffer.unmarshalEvaluation();
            IBinding templateDefinition = buffer.unmarshalBinding();
            return new EvalReference(new ActivationRecord(), referredSubValue, templateDefinition);
        }
        IBinding referredBinding = buffer.unmarshalBinding();
        ICPPEvaluation value = (ICPPEvaluation)buffer.unmarshalEvaluation();
        ActivationRecord record = new ActivationRecord();
        record.update(referredBinding, value);
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalReference(record, referredBinding, templateDefinition);
    }
}

