/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IFileNomination;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.parser.IScannerExtensionConfiguration;
import org.eclipse.cdt.core.index.IIndexMacro;
import org.eclipse.cdt.core.parser.AbstractParserLogService;
import org.eclipse.cdt.core.parser.EndOfFileException;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.FileContent;
import org.eclipse.cdt.core.parser.GCCKeywords;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IMacro;
import org.eclipse.cdt.core.parser.IParserLogService;
import org.eclipse.cdt.core.parser.IScanner;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.parser.ISignificantMacros;
import org.eclipse.cdt.core.parser.IToken;
import org.eclipse.cdt.core.parser.IncludeExportPatterns;
import org.eclipse.cdt.core.parser.IncludeFileContentProvider;
import org.eclipse.cdt.core.parser.Keywords;
import org.eclipse.cdt.core.parser.OffsetLimitReachedException;
import org.eclipse.cdt.core.parser.ParseError;
import org.eclipse.cdt.core.parser.ParserLanguage;
import org.eclipse.cdt.core.parser.util.CharArrayIntMap;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.core.parser.util.CharArrayObjectMap;
import org.eclipse.cdt.core.parser.util.CharArraySet;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.dom.IIncludeFileResolutionHeuristics;
import org.eclipse.cdt.internal.core.parser.EmptyFilesProvider;
import org.eclipse.cdt.internal.core.parser.IMacroDictionary;
import org.eclipse.cdt.internal.core.parser.scanner.ASTDirectiveWithCondition;
import org.eclipse.cdt.internal.core.parser.scanner.ASTElse;
import org.eclipse.cdt.internal.core.parser.scanner.ASTEndif;
import org.eclipse.cdt.internal.core.parser.scanner.ASTInclusionStatement;
import org.eclipse.cdt.internal.core.parser.scanner.AbstractCharArray;
import org.eclipse.cdt.internal.core.parser.scanner.CharArray;
import org.eclipse.cdt.internal.core.parser.scanner.CounterMacro;
import org.eclipse.cdt.internal.core.parser.scanner.DateMacro;
import org.eclipse.cdt.internal.core.parser.scanner.DynamicMacro;
import org.eclipse.cdt.internal.core.parser.scanner.ExpressionEvaluator;
import org.eclipse.cdt.internal.core.parser.scanner.FileMacro;
import org.eclipse.cdt.internal.core.parser.scanner.FunctionStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner.ILexerLog;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationCtx;
import org.eclipse.cdt.internal.core.parser.scanner.ILocationResolver;
import org.eclipse.cdt.internal.core.parser.scanner.ITokenSequence;
import org.eclipse.cdt.internal.core.parser.scanner.ImageLocationInfo;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeGuardDetection;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeSearchPath;
import org.eclipse.cdt.internal.core.parser.scanner.IncludeSearchPathElement;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContent;
import org.eclipse.cdt.internal.core.parser.scanner.InternalFileContentProvider;
import org.eclipse.cdt.internal.core.parser.scanner.Lexer;
import org.eclipse.cdt.internal.core.parser.scanner.LineMacro;
import org.eclipse.cdt.internal.core.parser.scanner.LocationCtxMacroExpansion;
import org.eclipse.cdt.internal.core.parser.scanner.LocationMap;
import org.eclipse.cdt.internal.core.parser.scanner.MacroDefinitionParser;
import org.eclipse.cdt.internal.core.parser.scanner.MacroExpander;
import org.eclipse.cdt.internal.core.parser.scanner.ObjectStyleMacro;
import org.eclipse.cdt.internal.core.parser.scanner.PreprocessorMacro;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerContext;
import org.eclipse.cdt.internal.core.parser.scanner.ScannerUtility;
import org.eclipse.cdt.internal.core.parser.scanner.SignificantMacros;
import org.eclipse.cdt.internal.core.parser.scanner.StringType;
import org.eclipse.cdt.internal.core.parser.scanner.TimeMacro;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.eclipse.cdt.internal.core.parser.scanner.TokenList;
import org.eclipse.cdt.internal.core.parser.scanner.TokenWithImage;
import org.eclipse.cdt.internal.core.parser.scanner.UndefinedMacro;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;

public class CPreprocessor
implements ILexerLog,
IScanner,
IAdaptable {
    public static final String PROP_VALUE = "CPreprocessor";
    public static final int tDEFINED = -200;
    public static final int tEXPANDED_IDENTIFIER = -199;
    public static final int tSCOPE_MARKER = -198;
    public static final int tSPACE = -197;
    public static final int tNOSPACE = -196;
    public static final int tMACRO_PARAMETER = -195;
    public static final int t__HAS_FEATURE = -194;
    private static final int ORIGIN_PREPROCESSOR_DIRECTIVE = 2;
    private static final int ORIGIN_INACTIVE_CODE = 3;
    private static final char[] ONE = "1".toCharArray();
    private static final ObjectStyleMacro __CDT_PARSER__ = new ObjectStyleMacro("__CDT_PARSER__".toCharArray(), ONE);
    private static final ObjectStyleMacro __cplusplus = new ObjectStyleMacro("__cplusplus".toCharArray(), "201103L".toCharArray());
    private static final ObjectStyleMacro __STDC__ = new ObjectStyleMacro("__STDC__".toCharArray(), ONE);
    private static final ObjectStyleMacro __STDC_HOSTED__ = new ObjectStyleMacro("__STDC_HOSTED__".toCharArray(), ONE);
    private static final ObjectStyleMacro __STDC_VERSION__ = new ObjectStyleMacro("__STDC_VERSION__".toCharArray(), "199901L".toCharArray());
    private static final DynamicMacro __FILE__ = new FileMacro("__FILE__".toCharArray());
    private static final DynamicMacro __DATE__ = new DateMacro("__DATE__".toCharArray());
    private static final DynamicMacro __TIME__ = new TimeMacro("__TIME__".toCharArray());
    private static final DynamicMacro __LINE__ = new LineMacro("__LINE__".toCharArray());
    private static final char[] __COUNTER__ = "__COUNTER__".toCharArray();
    private static final char[] ONCE = "once".toCharArray();
    static final int NO_EXPANSION = 1;
    static final int PROTECT_INTRINSICS = 2;
    static final int STOP_AT_NL = 4;
    static final int CHECK_NUMBERS = 8;
    static final int REPORT_SIGNIFICANT_MACROS = 16;
    static final int IGNORE_UNDEFINED_SIGNIFICANT_MACROS = 32;
    private static final int MAX_INCLUSION_DEPTH = 200;
    private static final String TRACE_NO_GUARD = "org.eclipse.cdt.core/debug/scanner/missingIncludeGuards";
    private final IIncludeFileTester<InternalFileContent> createCodeReaderTester = new IIncludeFileTester<InternalFileContent>(){

        @Override
        public InternalFileContent checkFile(String path, boolean isHeuristicMatch, IncludeSearchPathElement onPath) {
            IFileNomination once = CPreprocessor.this.fFileContentProvider.isIncludedWithPragmaOnceSemantics(path);
            InternalFileContent fc = once != null ? new InternalFileContent(path, InternalFileContent.InclusionKind.SKIP_FILE) : CPreprocessor.this.fFileContentProvider.getContentForInclusion(path, CPreprocessor.this.fMacroDictionaryFacade);
            if (fc != null) {
                fc.setFoundByHeuristics(isHeuristicMatch);
                fc.setFoundOnPath(onPath);
            }
            return fc;
        }
    };
    private final IIncludeFileTester<IncludeResolution> createPathTester = new IIncludeFileTester<IncludeResolution>(){

        @Override
        public IncludeResolution checkFile(String path, boolean isHeuristicMatch, IncludeSearchPathElement onPath) {
            if (CPreprocessor.this.fFileContentProvider.getInclusionExists(path)) {
                return new IncludeResolution(path, isHeuristicMatch);
            }
            return null;
        }
    };
    private Set<String> sSupportedFeatures;
    TokenSequence fInputToMacroExpansion = new TokenSequence(false);
    TokenSequence fLineInputToMacroExpansion = new TokenSequence(true);
    private final AbstractParserLogService fLog;
    private final InternalFileContentProvider fFileContentProvider;
    private final IIncludeFileResolutionHeuristics fIncludeFileResolutionHeuristics;
    private final ExpressionEvaluator fExpressionEvaluator;
    private final MacroDefinitionParser fMacroDefinitionParser;
    private final MacroExpander fMacroExpander;
    private final Lexer.LexerOptions fLexOptions = new Lexer.LexerOptions();
    private final char[] fAdditionalNumericLiteralSuffixes;
    private final CharArrayIntMap fKeywords;
    private final CharArrayIntMap fPPKeywords;
    private final IncludeSearchPath fIncludeSearchPath;
    private String[][] fPreIncludedFiles = null;
    private int fContentAssistLimit = -1;
    private boolean fHandledCompletion = false;
    private boolean fSplitShiftRightOperator = false;
    private final CharArrayMap<PreprocessorMacro> fMacroDictionary = new CharArrayMap(512);
    private final IMacroDictionary fMacroDictionaryFacade = new MacroDictionary();
    private final LocationMap fLocationMap;
    private CharArraySet fPreventInclusion;
    private CharArraySet fImports;
    private final ScannerContext fRootContext;
    protected ScannerContext fCurrentContext;
    private boolean isCancelled = false;
    private boolean fIsFirstFetchToken = true;
    private Token fPrefetchedTokens;
    private Token fLastToken;
    private InternalFileContent fRootContent;
    private boolean fHandledEndOfTranslationUnit;
    private char[] fExternIncludeGuard;
    private Set<String> fTracedGuards;

    public CPreprocessor(FileContent fileContent, IScannerInfo info, ParserLanguage language, IParserLogService log, IScannerExtensionConfiguration configuration, IncludeFileContentProvider readerFactory) {
        Token.resetCounterFor(info);
        if (readerFactory instanceof InternalFileContentProvider) {
            this.fFileContentProvider = (InternalFileContentProvider)readerFactory;
        } else if (readerFactory == null) {
            this.fFileContentProvider = EmptyFilesProvider.getInstance();
        } else {
            throw new IllegalArgumentException("Illegal reader factory");
        }
        if (!(fileContent instanceof InternalFileContent)) {
            throw new IllegalArgumentException("Illegal file content object");
        }
        this.fRootContent = (InternalFileContent)fileContent;
        this.fLog = AbstractParserLogService.convert(log);
        this.fAdditionalNumericLiteralSuffixes = this.nonNull(configuration.supportAdditionalNumericLiteralSuffixes());
        this.fLexOptions.fSupportDollarInIdentifiers = configuration.support$InIdentifiers();
        this.fLexOptions.fSupportAtSignInIdentifiers = configuration.supportAtSignInIdentifiers();
        this.fLexOptions.fSupportMinAndMax = configuration.supportMinAndMaxOperators();
        this.fLexOptions.fSupportSlashPercentComments = configuration.supportSlashPercentComments();
        this.fLexOptions.fSupportUTFLiterals = configuration.supportUTFLiterals();
        this.fLexOptions.fSupportRawStringLiterals = configuration.supportRawStringLiterals();
        this.fLexOptions.fSupportUserDefinedLiterals = configuration.supportUserDefinedLiterals();
        if (info instanceof ExtendedScannerInfo) {
            this.fLexOptions.fIncludeExportPatterns = ((ExtendedScannerInfo)info).getIncludeExportPatterns();
        }
        this.fLocationMap = new LocationMap(this.fLexOptions);
        this.fKeywords = new CharArrayIntMap(40, -1);
        this.fPPKeywords = new CharArrayIntMap(40, -1);
        this.configureKeywords(language, configuration);
        this.fExpressionEvaluator = new ExpressionEvaluator(this);
        this.fMacroDefinitionParser = new MacroDefinitionParser();
        this.fMacroExpander = new MacroExpander(this, this.fMacroDictionary, this.fLocationMap, this.fLexOptions);
        this.fIncludeFileResolutionHeuristics = this.fFileContentProvider.getIncludeHeuristics();
        String contextPath = this.fFileContentProvider.getContextPath();
        if (contextPath == null) {
            contextPath = this.fRootContent.getFileLocation();
        }
        this.fIncludeSearchPath = CPreprocessor.configureIncludeSearchPath(new File(contextPath).getParentFile(), info);
        this.setupMacroDictionary(configuration, info, language);
        ILocationCtx ctx = this.fLocationMap.pushTranslationUnit(this.fRootContent.getFileLocation(), this.fRootContent.getSource());
        Lexer lexer = new Lexer(this.fRootContent.getSource(), this.fLexOptions, (ILexerLog)this, (Object)this);
        this.fRootContext = this.fCurrentContext = new ScannerContext(ctx, null, lexer);
        if (info instanceof IExtendedScannerInfo) {
            IExtendedScannerInfo einfo = (IExtendedScannerInfo)info;
            this.fPreIncludedFiles = new String[][]{einfo.getMacroFiles(), einfo.getIncludeFiles()};
        }
        this.fFileContentProvider.resetForTranslationUnit();
    }

    private char[] detectIncludeGuard(String filePath, AbstractCharArray source, ScannerContext ctx) {
        char[] guard;
        if (!this.fFileContentProvider.shouldIndexAllHeaderVersions(filePath) && (guard = IncludeGuardDetection.detectIncludeGuard(source, this.fLexOptions, this.fPPKeywords)) != null) {
            IFileNomination nom = this.fLocationMap.reportPragmaOnceSemantics(ctx.getLocationCtx());
            this.fFileContentProvider.reportPragmaOnceSemantics(filePath, nom);
            ctx.internalModification(guard);
            ctx.setPragmaOnce(true);
            return guard;
        }
        ctx.trackSignificantMacros();
        if (ctx != this.fRootContext && this.fLog.isTracing(TRACE_NO_GUARD)) {
            if (this.fTracedGuards == null) {
                this.fTracedGuards = new HashSet<String>();
            }
            if (this.fTracedGuards.add(filePath)) {
                this.fLog.traceLog(TRACE_NO_GUARD, "No include guard in " + filePath);
            }
        }
        return null;
    }

    @Override
    public void setSplitShiftROperator(boolean val) {
        this.fSplitShiftRightOperator = val;
    }

    @Override
    public void setComputeImageLocations(boolean val) {
        this.fLexOptions.fCreateImageLocations = val;
    }

    @Override
    public void setTrackIncludeExport(IncludeExportPatterns patterns) {
        this.fLexOptions.fIncludeExportPatterns = patterns;
    }

    @Override
    public void setContentAssistMode(int offset) {
        this.fContentAssistLimit = offset;
        this.fRootContext.getLexer().setContentAssistMode(offset);
    }

    public boolean isContentAssistMode() {
        return this.fRootContext.getLexer().isContentAssistMode();
    }

    @Override
    public void setProcessInactiveCode(boolean val) {
        this.fRootContext.setParseInactiveCode(val);
    }

    @Override
    public void setScanComments(boolean val) {
    }

    @Override
    public ILocationResolver getLocationResolver() {
        return this.fLocationMap;
    }

    @Override
    public char[] getAdditionalNumericLiteralSuffixes() {
        return this.fAdditionalNumericLiteralSuffixes;
    }

    private void configureKeywords(ParserLanguage language, IScannerExtensionConfiguration configuration) {
        Keywords.addKeywordsPreprocessor(this.fPPKeywords);
        if (language == ParserLanguage.C) {
            Keywords.addKeywordsC(this.fKeywords);
        } else {
            Keywords.addKeywordsCpp(this.fKeywords);
        }
        CharArrayIntMap additionalKeywords = configuration.getAdditionalKeywords();
        if (additionalKeywords != null) {
            this.fKeywords.putAll(additionalKeywords);
        }
        if ((additionalKeywords = configuration.getAdditionalPreprocessorKeywords()) != null) {
            this.fPPKeywords.putAll(additionalKeywords);
        }
    }

    protected String getCurrentFilename() {
        return this.fLocationMap.getCurrentFilePath();
    }

    private char[] nonNull(char[] array) {
        return array == null ? CharArrayUtils.EMPTY_CHAR_ARRAY : array;
    }

    public static IncludeSearchPath configureIncludeSearchPath(File directory, IScannerInfo info) {
        boolean inhibitUseOfCurrentFileDirectory = false;
        ArrayList<IncludeSearchPathElement> elements = new ArrayList<IncludeSearchPathElement>();
        if (info != null) {
            String[] paths;
            int n;
            IExtendedScannerInfo einfo;
            String[] paths2;
            if (info instanceof IExtendedScannerInfo && (paths2 = (einfo = (IExtendedScannerInfo)info).getLocalIncludePath()) != null) {
                String[] stringArray = paths2;
                int n2 = paths2.length;
                n = 0;
                while (n < n2) {
                    String path = stringArray[n];
                    if ("-".equals(path)) {
                        inhibitUseOfCurrentFileDirectory = true;
                    } else {
                        elements.add(new IncludeSearchPathElement(CPreprocessor.makeAbsolute(directory, path), true));
                    }
                    ++n;
                }
            }
            if ((paths = info.getIncludePaths()) != null) {
                String[] stringArray = paths;
                n = paths.length;
                int n3 = 0;
                while (n3 < n) {
                    String path = stringArray[n3];
                    if ("-".equals(path)) {
                        inhibitUseOfCurrentFileDirectory = true;
                    } else {
                        elements.add(new IncludeSearchPathElement(CPreprocessor.makeAbsolute(directory, path), false));
                    }
                    ++n3;
                }
            }
        }
        return new IncludeSearchPath(elements, inhibitUseOfCurrentFileDirectory);
    }

    private static String makeAbsolute(File directory, String includePath) {
        if (directory == null || new File(includePath).isAbsolute()) {
            return includePath;
        }
        return ScannerUtility.createReconciledPath(directory.getAbsolutePath(), includePath);
    }

    private void setupMacroDictionary(IScannerExtensionConfiguration config, IScannerInfo info, ParserLanguage lang) {
        Map<String, String> macroDict;
        this.fMacroDictionary.put(__CDT_PARSER__.getNameCharArray(), __CDT_PARSER__);
        this.fMacroDictionary.put(__STDC__.getNameCharArray(), __STDC__);
        this.fMacroDictionary.put(__FILE__.getNameCharArray(), __FILE__);
        this.fMacroDictionary.put(__DATE__.getNameCharArray(), __DATE__);
        this.fMacroDictionary.put(__TIME__.getNameCharArray(), __TIME__);
        this.fMacroDictionary.put(__LINE__.getNameCharArray(), __LINE__);
        this.fMacroDictionary.put(__COUNTER__, new CounterMacro(__COUNTER__));
        if (lang == ParserLanguage.CPP) {
            this.fMacroDictionary.put(__cplusplus.getNameCharArray(), __cplusplus);
        } else {
            this.fMacroDictionary.put(__STDC_HOSTED__.getNameCharArray(), __STDC_HOSTED__);
            this.fMacroDictionary.put(__STDC_VERSION__.getNameCharArray(), __STDC_VERSION__);
        }
        IMacro[] toAdd = config.getAdditionalMacros();
        if (toAdd != null) {
            IMacro[] iMacroArray = toAdd;
            int n = toAdd.length;
            int n2 = 0;
            while (n2 < n) {
                IMacro macro = iMacroArray[n2];
                this.addMacroDefinition(macro.getSignature(), macro.getExpansion());
                ++n2;
            }
        }
        if ((macroDict = info.getDefinedSymbols()) != null) {
            for (Map.Entry<String, String> entry : macroDict.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue().trim();
                this.addMacroDefinition(key.toCharArray(), value.toCharArray());
            }
        }
        Collection<PreprocessorMacro> predefined = this.fMacroDictionary.values();
        for (PreprocessorMacro macro : predefined) {
            this.fLocationMap.registerPredefinedMacro(macro);
        }
    }

    private void beforeFirstFetchToken() {
        InternalFileContent content;
        if (this.fPreIncludedFiles != null) {
            this.handlePreIncludedFiles();
            this.fPreIncludedFiles = null;
        }
        String location = this.fLocationMap.getTranslationUnitPath();
        try {
            content = this.fFileContentProvider.getContentForContextToHeaderGap(location, this.fMacroDictionaryFacade);
        }
        catch (InternalFileContentProvider.DependsOnOutdatedFileException e) {
            throw new RuntimeException(e);
        }
        if (content != null && content.getKind() == InternalFileContent.InclusionKind.FOUND_IN_INDEX) {
            this.processInclusionFromIndex(0, content, false);
        }
        this.detectIncludeGuard(location, this.fRootContent.getSource(), this.fRootContext);
        this.fLocationMap.parsingFile(this.fFileContentProvider, this.fRootContent);
        this.fRootContent = null;
    }

    private void handlePreIncludedFiles() {
        String[] include;
        String[] imacro = this.fPreIncludedFiles[0];
        if (imacro != null && imacro.length > 0) {
            char[] buffer = this.createSyntheticFile(imacro);
            ILocationCtx ctx = this.fLocationMap.pushPreInclusion(new CharArray(buffer), 0, true);
            ScannerContext preCtx = this.fCurrentContext = new ScannerContext(ctx, this.fCurrentContext, new Lexer(buffer, this.fLexOptions, (ILexerLog)this, (Object)this));
            try {
                while (this.internalFetchToken(preCtx, 8, false).getType() != 144) {
                }
                ILocationCtx locationCtx = this.fCurrentContext.getLocationCtx();
                this.fLocationMap.popContext(locationCtx);
                this.fCurrentContext = this.fCurrentContext.getParent();
                assert (this.fCurrentContext == this.fRootContext);
            }
            catch (OffsetLimitReachedException offsetLimitReachedException) {
                // empty catch block
            }
        }
        if ((include = this.fPreIncludedFiles[1]) != null && include.length > 0) {
            char[] buffer = this.createSyntheticFile(include);
            ILocationCtx ctx = this.fLocationMap.pushPreInclusion(new CharArray(buffer), 0, false);
            this.fCurrentContext = new ScannerContext(ctx, this.fCurrentContext, new Lexer(buffer, this.fLexOptions, (ILexerLog)this, (Object)this));
        }
        this.fPreIncludedFiles = null;
    }

    private char[] createSyntheticFile(String[] files) {
        int totalLength = 0;
        char[] instruction = "#include <".toCharArray();
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String file = stringArray[n2];
            totalLength += instruction.length + 2 + file.length();
            ++n2;
        }
        char[] buffer = new char[totalLength];
        int pos = 0;
        String[] stringArray2 = files;
        int n3 = files.length;
        int n4 = 0;
        while (n4 < n3) {
            String file = stringArray2[n4];
            char[] fileName = file.toCharArray();
            System.arraycopy(instruction, 0, buffer, pos, instruction.length);
            System.arraycopy(fileName, 0, buffer, pos += instruction.length, fileName.length);
            pos += fileName.length;
            buffer[pos++] = 62;
            buffer[pos++] = 10;
            ++n4;
        }
        return buffer;
    }

    public PreprocessorMacro addMacroDefinition(char[] key, char[] value) {
        Lexer lex = new Lexer(key, this.fLexOptions, ILexerLog.NULL, null);
        try {
            PreprocessorMacro result = this.fMacroDefinitionParser.parseMacroDefinition(lex, ILexerLog.NULL, value);
            this.fLocationMap.registerPredefinedMacro(result);
            this.fMacroDictionary.put(result.getNameCharArray(), result);
            return result;
        }
        catch (Exception e) {
            this.fLog.traceLog("Invalid macro definition: '" + String.valueOf(key) + "'");
            return null;
        }
    }

    @Override
    public Map<String, IMacroBinding> getMacroDefinitions() {
        HashMap<String, IMacroBinding> hashMap = new HashMap<String, IMacroBinding>(this.fMacroDictionary.size());
        for (char[] key : this.fMacroDictionary.keys()) {
            hashMap.put(String.valueOf(key), this.fMacroDictionary.get(key));
        }
        return hashMap;
    }

    @Override
    public boolean isOnTopContext() {
        ScannerContext ctx = this.fCurrentContext;
        while (ctx != null && ctx.getLocationCtx() instanceof LocationCtxMacroExpansion) {
            ctx = ctx.getParent();
        }
        return ctx == this.fRootContext;
    }

    @Override
    public void cancel() {
        this.isCancelled = true;
    }

    private Token fetchToken() throws OffsetLimitReachedException {
        Token t;
        if (this.fIsFirstFetchToken) {
            this.beforeFirstFetchToken();
            this.fIsFirstFetchToken = false;
        }
        if ((t = this.fPrefetchedTokens) != null) {
            this.fPrefetchedTokens = (Token)t.getNext();
            t.setNext(null);
            return t;
        }
        try {
            t = this.internalFetchToken(this.fRootContext, 56, false);
        }
        catch (OffsetLimitReachedException e) {
            this.fHandledCompletion = true;
            throw e;
        }
        int offset = this.fLocationMap.getSequenceNumberForOffset(t.getOffset());
        int endOffset = this.fLocationMap.getSequenceNumberForOffset(t.getEndOffset());
        t.setOffset(offset, endOffset);
        t.setNext(null);
        return t;
    }

    private void pushbackToken(Token t) {
        t.setNext(this.fPrefetchedTokens);
        this.fPrefetchedTokens = t;
    }

    public IToken nextTokenRaw() throws OffsetLimitReachedException {
        if (this.isCancelled) {
            throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
        }
        Token t1 = this.fetchToken();
        switch (t1.getType()) {
            case 140: {
                this.fHandledCompletion = true;
                break;
            }
            case 144: {
                if (this.fContentAssistLimit < 0) break;
                int useType = this.fHandledCompletion ? 141 : 140;
                int sequenceNumber = this.fLocationMap.getSequenceNumberForOffset(this.fContentAssistLimit);
                t1 = new Token(useType, null, sequenceNumber, sequenceNumber);
                this.fHandledCompletion = true;
                break;
            }
            case 5200: {
                this.handlePragmaOperator(t1);
                return this.nextTokenRaw();
            }
        }
        if (this.fLastToken != null) {
            this.fLastToken.setNext(t1);
        }
        this.fLastToken = t1;
        return t1;
    }

    private void handlePragmaOperator(Token t1) throws OffsetLimitReachedException {
        int end;
        Token t2 = this.fetchToken();
        if (t2.getType() == 8) {
            Token t3 = this.fetchToken();
            end = t3.getEndOffset();
            int tt = t3.getType();
            if (tt == 130 || tt == 131 || tt == 5000 || tt == 5001) {
                Token t4 = this.fetchToken();
                end = t4.getEndOffset();
                if (t4.getType() == 9) {
                    this.fLocationMap.encounterPragmaOperator(t1.getOffset(), t3.getOffset(), t3.getEndOffset(), t4.getEndOffset());
                    return;
                }
                end = t3.getEndOffset();
                this.pushbackToken(t4);
            } else if (t3.getType() == 9) {
                end = t3.getEndOffset();
            } else {
                end = t2.getEndOffset();
                this.pushbackToken(t3);
            }
        } else {
            end = t1.getEndOffset();
            this.pushbackToken(t2);
        }
        this.fLocationMap.encounterProblem(0x2000006, t1.getCharImage(), t1.getOffset(), end);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public IToken nextToken() throws EndOfFileException {
        if (this.isCancelled) {
            throw new ParseError(ParseError.ParseErrorKind.TIMEOUT_OR_CANCELLED);
        }
        t1 = this.fetchToken();
        udlSuffix = null;
        tt1 = t1.getType();
        switch (tt1) {
            case 140: {
                this.fHandledCompletion = true;
                break;
            }
            case 144: {
                if (this.fContentAssistLimit < 0) {
                    this.fPrefetchedTokens = t1;
                    throw new EndOfFileException(t1.getOffset());
                }
                useType = this.fHandledCompletion != false ? 141 : 140;
                sequenceNumber = this.fLocationMap.getSequenceNumberForOffset(this.fContentAssistLimit);
                t1 = new Token(useType, null, sequenceNumber, sequenceNumber);
                this.fHandledCompletion = true;
                break;
            }
            case 5200: {
                this.handlePragmaOperator(t1);
                return this.nextToken();
            }
            case 51002: {
                udlSuffix = CPreprocessor.getUserDefinedLiteralSuffix(t1);
            }
            case 130: 
            case 131: 
            case 5000: 
            case 5001: {
                st = StringType.fromToken(t1);
                buf = null;
                endOffset = t1.getEndOffset();
                block14: while (true) {
                    t2 = this.fetchToken();
                    tt2 = t2.getType();
                    switch (tt2) {
                        case 51002: {
                            if (udlSuffix != null) ** GOTO lbl36
                            udlSuffix = CPreprocessor.getUserDefinedLiteralSuffix(t2);
                            ** GOTO lbl38
lbl36:
                            // 1 sources

                            if (!Arrays.equals(udlSuffix, CPreprocessor.getUserDefinedLiteralSuffix(t2))) {
                                this.handleProblem(0x2000010, udlSuffix, t2.getOffset(), endOffset);
                            }
                        }
lbl38:
                        // 5 sources

                        case 130: 
                        case 131: 
                        case 5000: 
                        case 5001: {
                            st = StringType.max(st, StringType.fromToken(t2));
                            if (buf == null) {
                                buf = new StringBuilder();
                                this.appendStringContent(buf, t1);
                            }
                            this.appendStringContent(buf, t2);
                            endOffset = t2.getEndOffset();
                            continue block14;
                        }
                        case 145: {
                            this.skipInactiveCode();
                            continue block14;
                        }
                        case 5200: {
                            this.handlePragmaOperator(t2);
                            continue block14;
                        }
                    }
                    break;
                }
                this.pushbackToken(t2);
                if (buf == null) break;
                prefix = st.getPrefix();
                imageLength = buf.length() + prefix.length + 2 + (udlSuffix == null ? 0 : udlSuffix.length);
                image = new char[imageLength];
                off = -1;
                tokenType = st.getTokenValue();
                var18_19 = prefix;
                var17_20 = prefix.length;
                var16_21 = 0;
                while (var16_21 < var17_20) {
                    c = var18_19[var16_21];
                    image[++off] = c;
                    ++var16_21;
                }
                image[++off] = 34;
                buf.getChars(0, buf.length(), image, ++off);
                image[off += buf.length()] = 34;
                if (udlSuffix != null) {
                    System.arraycopy(udlSuffix, 0, image, ++off, udlSuffix.length);
                    tokenType = 51002;
                }
                t1 = new TokenWithImage(tokenType, null, t1.getOffset(), endOffset, image);
                break;
            }
            case 44: {
                if (!this.fSplitShiftRightOperator) break;
                offset = t1.getOffset();
                endOffset = t1.getEndOffset();
                t1.setType(5201);
                t1.setOffset(offset, offset + 1);
                t2 = new Token(5201, t1.fSource, offset + 1, endOffset);
                this.pushbackToken(t2);
            }
        }
        if (this.fLastToken != null) {
            this.fLastToken.setNext(t1);
        }
        this.fLastToken = t1;
        return t1;
    }

    @Override
    public void skipInactiveCode() throws OffsetLimitReachedException {
        Lexer lexer = this.fCurrentContext.getLexer();
        if (lexer != null) {
            ScannerContext.CodeState state = this.fCurrentContext.getCodeState();
            while (state != ScannerContext.CodeState.eActive) {
                state = this.skipBranch(lexer, false);
            }
            this.fCurrentContext.clearInactiveCodeMarkerToken();
        }
    }

    @Override
    public int getCodeBranchNesting() {
        return this.fCurrentContext.getCodeBranchNesting();
    }

    private void appendStringContent(StringBuilder buf, Token t1) {
        char[] image = t1.getCharImage();
        int length = image.length;
        int start = 1;
        char[] cArray = image;
        int n = image.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == '\"') break;
            ++start;
            ++n2;
        }
        if (length > 1) {
            int diff = 0;
            if (t1.getType() == 51002) {
                diff = t1.getImage().lastIndexOf(34) - start;
            } else {
                int n3 = diff = image[length - 1] == '\"' ? length - start - 1 : length - start;
            }
            if (diff > 0) {
                buf.append(image, start, diff);
            }
        }
    }

    Token internalFetchToken(ScannerContext uptoEndOfCtx, int options, boolean withinExpansion) throws OffsetLimitReachedException {
        Token ppToken = this.fCurrentContext.currentLexerToken();
        block10: while (true) {
            switch (ppToken.getType()) {
                case -100: {
                    ppToken = this.fCurrentContext.nextPPToken();
                    continue block10;
                }
                case -99: {
                    if ((options & 4) != 0) {
                        return ppToken;
                    }
                    ppToken = this.fCurrentContext.nextPPToken();
                    continue block10;
                }
                case -96: {
                    this.handleProblem(0x1000001, ppToken.getCharImage(), ppToken.getOffset(), ppToken.getEndOffset());
                    ppToken = this.fCurrentContext.nextPPToken();
                    continue block10;
                }
                case 144: {
                    if (this.fCurrentContext == uptoEndOfCtx || uptoEndOfCtx == null) {
                        if (this.fCurrentContext == this.fRootContext && !this.fHandledEndOfTranslationUnit && (options & 4) == 0) {
                            this.fHandledEndOfTranslationUnit = true;
                            this.fLocationMap.endTranslationUnit(ppToken.getEndOffset(), this.fCurrentContext.getSignificantMacros());
                        }
                        return ppToken;
                    }
                    ILocationCtx locationCtx = this.fCurrentContext.getLocationCtx();
                    ASTInclusionStatement inc = locationCtx.getInclusionStatement();
                    if (inc != null) {
                        this.completeInclusion(inc);
                    }
                    this.fLocationMap.popContext(locationCtx);
                    this.fCurrentContext.propagateSignificantMacros();
                    this.fCurrentContext = this.fCurrentContext.getParent();
                    assert (this.fCurrentContext != null);
                    ppToken = this.fCurrentContext.currentLexerToken();
                    continue block10;
                }
                case 138: {
                    Lexer lexer = this.fCurrentContext.getLexer();
                    if (lexer == null || !lexer.currentTokenIsFirstOnLine()) break block10;
                    this.executeDirective(lexer, ppToken.getOffset(), withinExpansion);
                    ppToken = this.fCurrentContext.currentLexerToken();
                    continue block10;
                }
                case 1: {
                    Lexer lexer;
                    this.fCurrentContext.nextPPToken();
                    if ((options & 1) == 0) {
                        lexer = this.fCurrentContext.getLexer();
                        if (lexer != null && this.expandMacro(ppToken, lexer, options, withinExpansion)) {
                            ppToken = this.fCurrentContext.currentLexerToken();
                            continue block10;
                        }
                        char[] name = ppToken.getCharImage();
                        int tokenType = this.fKeywords.get(name);
                        if (tokenType != this.fKeywords.undefined) {
                            ppToken.setType(tokenType);
                        }
                    }
                    return ppToken;
                }
                case 2: {
                    if ((options & 8) == 0) break block10;
                    this.checkNumber(ppToken, false);
                    break block10;
                }
                case 129: {
                    if ((options & 8) == 0) break block10;
                    this.checkNumber(ppToken, true);
                }
            }
            break;
        }
        this.fCurrentContext.nextPPToken();
        return ppToken;
    }

    private void completeInclusion(ASTInclusionStatement inc) {
        CharArrayObjectMap<char[]> sigMacros = this.fCurrentContext.getSignificantMacros();
        ISignificantMacros sig = sigMacros == null || sigMacros.isEmpty() ? ISignificantMacros.NONE : new SignificantMacros(sigMacros);
        inc.setSignificantMacros(sig);
        if (!inc.hasPragmaOnceSemantics()) {
            this.fFileContentProvider.addLoadedVersions(inc.getPath(), this.fCurrentContext.getLoadedVersionCount(), sig);
        }
    }

    private void checkNumber(Token number, boolean isFloat) {
        char[] image = number.getCharImage();
        boolean hasExponent = false;
        boolean isBin = false;
        boolean isHex = false;
        boolean isOctal = false;
        boolean hasDot = false;
        boolean badSuffix = false;
        int pos = 0;
        if (image.length > 1 && image[0] == '0') {
            switch (image[++pos]) {
                case 'B': 
                case 'b': {
                    isBin = true;
                    ++pos;
                    break;
                }
                case 'X': 
                case 'x': {
                    isHex = true;
                    ++pos;
                    break;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': {
                    if (!isFloat) {
                        isOctal = true;
                    }
                    ++pos;
                    break;
                }
                case '8': 
                case '9': {
                    if (!isFloat) {
                        this.handleProblem(0x1000007, image, number.getOffset(), number.getEndOffset());
                        return;
                    }
                    ++pos;
                }
            }
        }
        block29: while (pos < image.length) {
            block48: {
                block47: {
                    if (!isBin) break block47;
                    switch (image[pos]) {
                        case '0': 
                        case '1': {
                            break block48;
                        }
                        case '.': 
                        case 'E': 
                        case 'e': {
                            this.handleProblem(0x1000011, "0b".toCharArray(), number.getOffset(), number.getEndOffset());
                            return;
                        }
                    }
                    break;
                }
                block10 : switch (image[pos]) {
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        break;
                    }
                    case '8': 
                    case '9': {
                        if (!isOctal) break;
                        this.handleProblem(0x1000007, image, number.getOffset(), number.getEndOffset());
                        return;
                    }
                    case 'A': 
                    case 'B': 
                    case 'C': 
                    case 'D': 
                    case 'F': 
                    case 'a': 
                    case 'b': 
                    case 'c': 
                    case 'd': 
                    case 'f': {
                        if (!isHex || hasExponent) break block29;
                        break;
                    }
                    case '.': {
                        if (hasDot) {
                            this.handleProblem(0x1000004, image, number.getOffset(), number.getEndOffset());
                            return;
                        }
                        hasDot = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (isHex && !hasExponent) break;
                        if (!isFloat || isHex || hasExponent || pos + 1 >= image.length) break block29;
                        switch (image[pos + 1]) {
                            case '+': 
                            case '-': 
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                hasExponent = true;
                                ++pos;
                                break block10;
                            }
                        }
                        break block29;
                    }
                    case 'P': 
                    case 'p': {
                        if (!isFloat || !isHex || hasExponent || pos + 1 >= image.length) break block29;
                        switch (image[pos + 1]) {
                            case '+': 
                            case '-': 
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                hasExponent = true;
                                ++pos;
                                break block10;
                            }
                        }
                        break block29;
                    }
                    default: {
                        break block29;
                    }
                }
            }
            ++pos;
        }
        if (pos < image.length) {
            char c = image[pos];
            if (Character.isLetter(c) || c == '_') {
                int suffixStart = pos;
                while (pos < image.length) {
                    c = image[pos];
                    block24 : switch (c) {
                        case 'L': 
                        case 'U': 
                        case 'l': 
                        case 'u': {
                            break;
                        }
                        case 'F': 
                        case 'f': {
                            if (isFloat) break;
                        }
                        case '0': 
                        case '1': 
                        case '2': 
                        case '3': 
                        case '4': 
                        case '5': 
                        case '6': 
                        case '7': 
                        case '8': 
                        case '9': 
                        case 'A': 
                        case 'B': 
                        case 'C': 
                        case 'D': 
                        case 'E': 
                        case 'G': 
                        case 'H': 
                        case 'I': 
                        case 'J': 
                        case 'K': 
                        case 'M': 
                        case 'N': 
                        case 'O': 
                        case 'P': 
                        case 'Q': 
                        case 'R': 
                        case 'S': 
                        case 'T': 
                        case 'V': 
                        case 'W': 
                        case 'X': 
                        case 'Y': 
                        case 'Z': 
                        case '_': 
                        case 'a': 
                        case 'b': 
                        case 'c': 
                        case 'd': 
                        case 'e': 
                        case 'g': 
                        case 'h': 
                        case 'i': 
                        case 'j': 
                        case 'k': 
                        case 'm': 
                        case 'n': 
                        case 'o': 
                        case 'p': 
                        case 'q': 
                        case 'r': 
                        case 's': 
                        case 't': 
                        case 'v': 
                        case 'w': 
                        case 'x': 
                        case 'y': 
                        case 'z': {
                            if (this.fLexOptions.fSupportUserDefinedLiterals) break;
                        }
                        default: {
                            int i = 0;
                            while (i < this.fAdditionalNumericLiteralSuffixes.length) {
                                if (this.fAdditionalNumericLiteralSuffixes[i] == c) break block24;
                                badSuffix = true;
                                ++i;
                            }
                            if (!badSuffix) break;
                            char[] suffix = CharArrayUtils.subarray(image, suffixStart, -1);
                            this.handleProblem(0x1000010, suffix, number.getOffset(), number.getEndOffset());
                            return;
                        }
                    }
                    ++pos;
                }
                return;
            }
        } else {
            return;
        }
        if (isBin) {
            this.handleProblem(0x100000F, image, number.getOffset(), number.getEndOffset());
        } else if (isFloat) {
            this.handleProblem(0x1000004, image, number.getOffset(), number.getEndOffset());
        } else if (isHex) {
            this.handleProblem(0x1000005, image, number.getOffset(), number.getEndOffset());
        } else if (isOctal) {
            this.handleProblem(0x1000007, image, number.getOffset(), number.getEndOffset());
        } else {
            this.handleProblem(0x1000008, image, number.getOffset(), number.getEndOffset());
        }
    }

    private <T> T findInclusion(String includeDirective, boolean quoteInclude, boolean includeNext, String currentFile, IIncludeFileTester<T> tester) {
        String location;
        String fileLocation;
        File currentDir;
        T reader = null;
        String absoluteInclusionPath = CPreprocessor.getAbsoluteInclusionPath(includeDirective, currentFile);
        if (absoluteInclusionPath != null) {
            return tester.checkFile(absoluteInclusionPath, false, null);
        }
        if (currentFile != null && quoteInclude && !includeNext && !this.fIncludeSearchPath.isInhibitUseOfCurrentFileDirectory() && (currentDir = new File(currentFile).getParentFile()) != null && (reader = (T)tester.checkFile(fileLocation = ScannerUtility.createReconciledPath(currentDir.getAbsolutePath(), includeDirective), false, null)) != null) {
            return reader;
        }
        IncludeSearchPathElement searchAfter = null;
        if (includeNext && currentFile != null && (searchAfter = this.fCurrentContext.getFoundOnPath()) == null) {
            String directive = this.fCurrentContext.getFoundViaDirective();
            if (directive == null) {
                directive = new File(currentFile).getName();
            }
            searchAfter = this.findFileInIncludePath(currentFile, directive);
        }
        IncludeSearchPathElement[] includeSearchPathElementArray = this.fIncludeSearchPath.getElements();
        int n = includeSearchPathElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            String fileLocation2;
            IncludeSearchPathElement path = includeSearchPathElementArray[n2];
            if (searchAfter != null) {
                if (searchAfter.equals(path)) {
                    searchAfter = null;
                }
            } else if ((quoteInclude || !path.isForQuoteIncludesOnly()) && (fileLocation2 = path.getLocation(includeDirective)) != null && (reader = (T)tester.checkFile(fileLocation2, false, path)) != null) {
                return reader;
            }
            ++n2;
        }
        if (this.fIncludeFileResolutionHeuristics != null && (location = this.fIncludeFileResolutionHeuristics.findInclusion(includeDirective, currentFile)) != null) {
            return tester.checkFile(location, true, null);
        }
        return null;
    }

    public static String getAbsoluteInclusionPath(String includeDirective, String currentFile) {
        char firstChar;
        if (new File(includeDirective).isAbsolute()) {
            return includeDirective;
        }
        if (!(File.separatorChar != '\\' || includeDirective.isEmpty() || (firstChar = includeDirective.charAt(0)) != '\\' && firstChar != '/')) {
            if (currentFile != null && currentFile.length() > 1 && currentFile.charAt(1) == ':') {
                return String.valueOf(currentFile.substring(0, 2)) + includeDirective;
            }
            return includeDirective;
        }
        return null;
    }

    private IncludeSearchPathElement findFileInIncludePath(String file, String includeDirective) {
        IncludeSearchPathElement[] includeSearchPathElementArray = this.fIncludeSearchPath.getElements();
        int n = includeSearchPathElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IncludeSearchPathElement path = includeSearchPathElementArray[n2];
            String fileLocation = path.getLocation(includeDirective);
            if (file.equals(fileLocation)) {
                return path;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Scanner @ file:");
        buffer.append(this.fCurrentContext.toString());
        buffer.append(" line: ");
        buffer.append(this.fLocationMap.getCurrentLineNumber(this.fCurrentContext.currentLexerToken().getOffset()));
        return buffer.toString();
    }

    private void addMacroDefinition(IIndexMacro macro) {
        try {
            char[] expansionImage = macro.getExpansionImage();
            if (expansionImage == null) {
                this.fMacroDictionary.remove(macro.getNameCharArray());
            } else {
                PreprocessorMacro result = MacroDefinitionParser.parseMacroDefinition(macro.getNameCharArray(), macro.getParameterList(), expansionImage);
                this.fLocationMap.registerMacroFromIndex(result, macro.getDefinition(), -1);
                this.fMacroDictionary.put(result.getNameCharArray(), result);
            }
        }
        catch (Exception e) {
            this.fLog.traceLog("Invalid macro definition: '" + macro.getName() + "'");
        }
    }

    public ILocationResolver getLocationMap() {
        return this.fLocationMap;
    }

    @Override
    public void handleComment(boolean isBlockComment, int offset, int endOffset, AbstractCharArray input) {
        this.fLocationMap.encounteredComment(offset, endOffset, isBlockComment, input);
    }

    @Override
    public void handleProblem(int id, char[] arg, int offset, int endOffset) {
        this.fLocationMap.encounterProblem(id, arg, offset, endOffset);
    }

    private void executeDirective(Lexer lexer, int startOffset, boolean withinExpansion) throws OffsetLimitReachedException {
        Token ident = lexer.nextToken();
        switch (ident.getType()) {
            case 140: {
                lexer.nextToken();
                TokenWithImage completionToken = new TokenWithImage(ident.getType(), null, startOffset, ident.getEndOffset(), ("#" + ident.getImage()).toCharArray());
                throw new OffsetLimitReachedException(2, completionToken);
            }
            case -99: {
                return;
            }
            case 2: 
            case 144: {
                lexer.consumeLine(2);
                return;
            }
            case 1: {
                break;
            }
            default: {
                int endOffset = lexer.consumeLine(2);
                this.handleProblem(0x2000006, ident.getCharImage(), startOffset, endOffset);
                return;
            }
        }
        char[] name = ident.getCharImage();
        int type = this.fPPKeywords.get(name);
        switch (type) {
            case 6: 
            case 11: 
            case 12: {
                this.executeInclude(lexer, startOffset, type, this.fCurrentContext.getCodeState() == ScannerContext.CodeState.eActive, withinExpansion);
                break;
            }
            case 7: {
                ScannerContext.CodeState state = this.fCurrentContext.getCodeState();
                if (state == ScannerContext.CodeState.eSkipInactive) {
                    lexer.consumeLine(2);
                    break;
                }
                this.executeDefine(lexer, startOffset, state == ScannerContext.CodeState.eActive);
                break;
            }
            case 8: {
                ScannerContext.CodeState state = this.fCurrentContext.getCodeState();
                if (state == ScannerContext.CodeState.eSkipInactive) {
                    lexer.consumeLine(2);
                    break;
                }
                this.executeUndefine(lexer, startOffset, this.fCurrentContext.getCodeState() == ScannerContext.CodeState.eActive);
                break;
            }
            case 1: {
                if (this.executeIfdef(lexer, startOffset, false, withinExpansion) != ScannerContext.CodeState.eSkipInactive) break;
                this.skipOverConditionalCode(lexer, withinExpansion);
                break;
            }
            case 2: {
                if (this.executeIfdef(lexer, startOffset, true, withinExpansion) != ScannerContext.CodeState.eSkipInactive) break;
                this.skipOverConditionalCode(lexer, withinExpansion);
                break;
            }
            case 0: {
                if (this.executeIf(lexer, startOffset, false, withinExpansion) != ScannerContext.CodeState.eSkipInactive) break;
                this.skipOverConditionalCode(lexer, withinExpansion);
                break;
            }
            case 3: {
                if (this.executeIf(lexer, startOffset, true, withinExpansion) != ScannerContext.CodeState.eSkipInactive) break;
                this.skipOverConditionalCode(lexer, withinExpansion);
                break;
            }
            case 4: {
                if (this.executeElse(lexer, startOffset, withinExpansion) != ScannerContext.CodeState.eSkipInactive) break;
                this.skipOverConditionalCode(lexer, withinExpansion);
                break;
            }
            case 5: {
                this.executeEndif(lexer, startOffset, withinExpansion);
                break;
            }
            case 9: 
            case 13: {
                int condOffset = lexer.nextToken().getOffset();
                int condEndOffset = lexer.consumeLine(2);
                if (condEndOffset < condOffset) {
                    condOffset = condEndOffset;
                }
                if (this.fCurrentContext.getCodeState() != ScannerContext.CodeState.eActive) break;
                int endOffset = lexer.currentToken().getEndOffset();
                char[] warning = lexer.getInputChars(condOffset, condEndOffset);
                int id = type == 9 ? 0x2000001 : 0x200000E;
                this.handleProblem(id, warning, condOffset, condEndOffset);
                this.fLocationMap.encounterPoundError(startOffset, condOffset, condEndOffset, endOffset);
                break;
            }
            case 10: {
                Token pragmaToken = lexer.nextToken();
                int condOffset = pragmaToken.getOffset();
                int condEndOffset = lexer.consumeLine(2);
                if (condEndOffset < condOffset) {
                    condOffset = condEndOffset;
                }
                if (this.fCurrentContext.getCodeState() != ScannerContext.CodeState.eActive) break;
                int endOffset = lexer.currentToken().getEndOffset();
                this.fLocationMap.encounterPoundPragma(startOffset, condOffset, condEndOffset, endOffset);
                if (!CharArrayUtils.equals(ONCE, pragmaToken.getCharImage())) break;
                IFileNomination nom = this.fLocationMap.reportPragmaOnceSemantics(this.fCurrentContext.getLocationCtx());
                this.fFileContentProvider.reportPragmaOnceSemantics(this.getCurrentFilename(), nom);
                break;
            }
            case -2: {
                lexer.consumeLine(2);
                break;
            }
            default: {
                int endOffset = lexer.consumeLine(2);
                if (this.fCurrentContext.getCodeState() != ScannerContext.CodeState.eActive) break;
                this.handleProblem(0x2000006, ident.getCharImage(), startOffset, endOffset);
            }
        }
    }

    private void executeInclude(Lexer lexer, int poundOffset, int includeType, boolean active, boolean withinExpansion) throws OffsetLimitReachedException {
        char[] externGuard = this.fExternIncludeGuard;
        this.fExternIncludeGuard = null;
        if (withinExpansion) {
            char[] name = lexer.currentToken().getCharImage();
            int endOffset = lexer.consumeLine(2);
            this.handleProblem(0x2000006, name, poundOffset, endOffset);
            return;
        }
        lexer.setInsideIncludeDirective(true);
        Token header = lexer.nextToken();
        lexer.setInsideIncludeDirective(false);
        int condEndOffset = header.getEndOffset();
        int[] nameOffsets = new int[]{header.getOffset(), condEndOffset};
        char[] headerName = null;
        boolean userInclude = true;
        block1 : switch (header.getType()) {
            case -97: {
                userInclude = false;
                headerName = this.extractHeaderName(header.getCharImage(), '<', '>', nameOffsets);
                condEndOffset = lexer.consumeLine(2);
                break;
            }
            case -98: {
                headerName = this.extractHeaderName(header.getCharImage(), '\"', '\"', nameOffsets);
                condEndOffset = lexer.consumeLine(2);
                break;
            }
            case 140: {
                throw new OffsetLimitReachedException(2, header);
            }
            case 1: {
                TokenList tl = new TokenList();
                condEndOffset = nameOffsets[1] = this.getTokensWithinPPDirective(false, tl, false);
                Token t = tl.first();
                if (t == null) break;
                switch (t.getType()) {
                    case 130: {
                        headerName = this.extractHeaderName(t.getCharImage(), '\"', '\"', new int[2]);
                        break;
                    }
                    case 42: {
                        userInclude = false;
                        boolean complete = false;
                        StringBuilder buf = new StringBuilder();
                        t = (Token)t.getNext();
                        while (t != null) {
                            if (t.getType() == 46) {
                                complete = true;
                                break;
                            }
                            buf.append(t.getImage());
                            t = (Token)t.getNext();
                        }
                        if (!complete) break block1;
                        headerName = new char[buf.length()];
                        buf.getChars(0, buf.length(), headerName, 0);
                    }
                }
                break;
            }
            default: {
                condEndOffset = lexer.consumeLine(2);
            }
        }
        if (headerName == null || headerName.length == 0) {
            if (active) {
                this.handleProblem(0x2000006, lexer.getInputChars(poundOffset, condEndOffset), poundOffset, condEndOffset);
            }
            return;
        }
        if (includeType == 12) {
            if (this.fImports != null && this.fImports.containsKey(headerName)) {
                return;
            }
            if (active) {
                if (this.fImports == null) {
                    this.fImports = new CharArraySet(0);
                }
                this.fImports.put(headerName);
            }
        }
        if (active && this.fCurrentContext.getDepth() == 200 || this.fPreventInclusion != null && this.fPreventInclusion.containsKey(headerName)) {
            this.handleProblem(0x200000F, lexer.getInputChars(poundOffset, condEndOffset), poundOffset, condEndOffset);
            if (this.fPreventInclusion == null) {
                this.fPreventInclusion = new CharArraySet(0);
            }
            this.fPreventInclusion.put(headerName);
            return;
        }
        boolean includeNext = includeType == 11;
        String includeDirective = new String(headerName);
        if (!active) {
            IncludeResolution resolved;
            String path = null;
            boolean isHeuristic = false;
            IFileNomination nominationDelegate = null;
            if (externGuard != null && (resolved = this.findInclusion(includeDirective, userInclude, includeNext, this.getCurrentFilename(), this.createPathTester)) != null && (nominationDelegate = this.fFileContentProvider.isIncludedWithPragmaOnceSemantics(resolved.fLocation)) != null) {
                path = resolved.fLocation;
                isHeuristic = resolved.fHeuristic;
            }
            this.fLocationMap.encounterPoundInclude(poundOffset, nameOffsets[0], nameOffsets[1], condEndOffset, headerName, path, userInclude, active, isHeuristic, nominationDelegate);
            return;
        }
        InternalFileContent fi = this.findInclusion(includeDirective, userInclude, includeNext, this.getCurrentFilename(), this.createCodeReaderTester);
        if (fi == null) {
            int len = headerName.length + 2;
            StringBuilder name = new StringBuilder(len);
            name.append(userInclude ? (char)'\"' : '<');
            name.append(headerName);
            name.append(userInclude ? (char)'\"' : '>');
            char[] nameChars = new char[len];
            name.getChars(0, len, nameChars, 0);
            this.handleProblem(0x2000002, nameChars, poundOffset, condEndOffset);
            this.fLocationMap.encounterPoundInclude(poundOffset, nameOffsets[0], nameOffsets[1], condEndOffset, headerName, null, userInclude, active, false, null);
            return;
        }
        String path = fi.getFileLocation();
        boolean isHeuristic = fi.isFoundByHeuristics();
        boolean pragmaOnceContext = this.fCurrentContext.isPragmaOnce();
        IFileNomination nominationDelegate = null;
        ASTInclusionStatement stmt = null;
        List<ISignificantMacros> loadedVerisons = null;
        switch (fi.getKind()) {
            case FOUND_IN_INDEX: {
                nominationDelegate = fi.getFilesIncluded().get(0);
                try {
                    ISignificantMacros sm = nominationDelegate.getSignificantMacros();
                    this.fCurrentContext.addSignificantMacros(sm);
                    if (pragmaOnceContext && !nominationDelegate.hasPragmaOnceSemantics()) {
                        loadedVerisons = this.fFileContentProvider.getLoadedVersions(path);
                    }
                }
                catch (CoreException sm) {
                    // empty catch block
                }
                this.processInclusionFromIndex(poundOffset, fi, true);
                break;
            }
            case USE_SOURCE: {
                AbstractCharArray source = fi.getSource();
                if (source != null) {
                    ILocationCtx ctx = this.fLocationMap.pushInclusion(poundOffset, nameOffsets[0], nameOffsets[1], condEndOffset, source, path, headerName, userInclude, isHeuristic, fi.isSource());
                    ScannerContext fctx = new ScannerContext(ctx, this.fCurrentContext, new Lexer(source, this.fLexOptions, (ILexerLog)this, (Object)this));
                    fctx.setFoundOnPath(fi.getFoundOnPath(), includeDirective);
                    this.detectIncludeGuard(path, source, fctx);
                    this.fCurrentContext = fctx;
                    stmt = ctx.getInclusionStatement();
                    stmt.setIncludedFileTimestamp(fi.getTimestamp());
                    stmt.setIncludedFileSize(fi.getFileSize());
                    stmt.setIncludedFileContentsHash(source.getContentsHash());
                    stmt.setIncludedFileReadTime(fi.getReadTime());
                    stmt.setErrorInIncludedFile(source.hasError());
                    if (!this.fCurrentContext.isPragmaOnce()) {
                        loadedVerisons = this.fFileContentProvider.getLoadedVersions(path);
                        fctx.setLoadedVersionCount(loadedVerisons.size());
                    }
                }
                this.fLocationMap.parsingFile(this.fFileContentProvider, fi);
                break;
            }
        }
        if (stmt == null) {
            stmt = this.fLocationMap.encounterPoundInclude(poundOffset, nameOffsets[0], nameOffsets[1], condEndOffset, headerName, path, userInclude, active, isHeuristic, nominationDelegate);
        }
        if (pragmaOnceContext && loadedVerisons != null && !loadedVerisons.isEmpty()) {
            stmt.setLoadedVersions(loadedVerisons.toArray(new ISignificantMacros[loadedVerisons.size()]));
        }
    }

    private void processInclusionFromIndex(int offset, InternalFileContent fi, boolean updateContext) {
        List<IIndexMacro> mdefs = fi.getMacroDefinitions();
        for (IIndexMacro macro : mdefs) {
            this.addMacroDefinition(macro);
            if (!updateContext) continue;
            this.fCurrentContext.internalModification(macro.getNameCharArray());
        }
        for (InternalFileContent.FileVersion version : fi.getNonPragmaOnceVersions()) {
            this.fFileContentProvider.addLoadedVersions(version.fPath, Integer.MAX_VALUE, version.fSigMacros);
        }
        this.fLocationMap.skippedFile(this.fLocationMap.getSequenceNumberForOffset(offset), fi);
    }

    private char[] extractHeaderName(char[] image, char startDelim, char endDelim, int[] offsets) {
        int start = 0;
        int length = image.length;
        if (length > 0 && image[length - 1] == endDelim) {
            offsets[1] = offsets[1] - 1;
            if (--length > 0 && image[0] == startDelim) {
                offsets[0] = offsets[0] + 1;
                ++start;
                --length;
            }
        }
        char[] headerName = new char[length];
        System.arraycopy(image, start, headerName, 0, length);
        return headerName;
    }

    private void executeDefine(Lexer lexer, int startOffset, boolean isActive) throws OffsetLimitReachedException {
        try {
            ObjectStyleMacro macrodef = this.fMacroDefinitionParser.parseMacroDefinition(lexer, this);
            if (isActive) {
                char[] macroName = macrodef.getNameCharArray();
                this.fMacroDictionary.put(macroName, macrodef);
                this.fCurrentContext.internalModification(macroName);
            }
            Token name = this.fMacroDefinitionParser.getNameToken();
            this.fLocationMap.encounterPoundDefine(startOffset, name.getOffset(), name.getEndOffset(), macrodef.getExpansionOffset(), macrodef.getExpansionEndOffset(), isActive, macrodef);
        }
        catch (MacroDefinitionParser.InvalidMacroDefinitionException e) {
            lexer.consumeLine(2);
            this.handleProblem(0x2000005, e.fName, e.fStartOffset, e.fEndOffset);
        }
    }

    private void executeUndefine(Lexer lexer, int startOffset, boolean isActive) throws OffsetLimitReachedException {
        PreprocessorMacro definition;
        Token name = lexer.nextToken();
        int tt = name.getType();
        if (tt != 1) {
            if (tt == 140) {
                throw new OffsetLimitReachedException(2, name);
            }
            lexer.consumeLine(2);
            this.handleProblem(0x2000005, name.getCharImage(), startOffset, name.getEndOffset());
            return;
        }
        lexer.consumeLine(2);
        int endOffset = lexer.currentToken().getEndOffset();
        char[] namechars = name.getCharImage();
        if (isActive) {
            definition = this.fMacroDictionary.remove(namechars, 0, namechars.length);
            this.fCurrentContext.internalModification(namechars);
        } else {
            definition = this.fMacroDictionary.get(namechars);
        }
        this.fLocationMap.encounterPoundUndef(definition, startOffset, name.getOffset(), name.getEndOffset(), endOffset, namechars, isActive);
    }

    private ScannerContext.CodeState executeIfdef(Lexer lexer, int offset, boolean isIfndef, boolean withinExpansion) throws OffsetLimitReachedException {
        Token name = lexer.nextToken();
        lexer.consumeLine(2);
        int tt = name.getType();
        int nameOffset = name.getOffset();
        int nameEndOffset = name.getEndOffset();
        int endOffset = lexer.currentToken().getEndOffset();
        boolean isTaken = false;
        PreprocessorMacro macro = null;
        ScannerContext.Conditional conditional = this.fCurrentContext.newBranch(ScannerContext.BranchKind.eIf, withinExpansion);
        if (conditional.canHaveActiveBranch(withinExpansion)) {
            if (tt != 1) {
                if (tt == 140) {
                    throw new OffsetLimitReachedException(2, name);
                }
                this.handleProblem(0x2000003, name.getCharImage(), offset, nameEndOffset);
            } else {
                char[] namechars = name.getCharImage();
                if (isIfndef && IncludeGuardDetection.detectIncludeEndif(lexer)) {
                    this.fExternIncludeGuard = namechars;
                }
                boolean bl = isTaken = (macro = this.fMacroDictionary.get(namechars)) == null == isIfndef;
                if (macro == null) {
                    macro = new UndefinedMacro(namechars);
                    this.fCurrentContext.significantMacroUndefined(namechars);
                } else {
                    this.fCurrentContext.significantMacroDefined(namechars);
                }
            }
        }
        ASTDirectiveWithCondition stmt = isIfndef ? this.fLocationMap.encounterPoundIfndef(offset, nameOffset, nameEndOffset, endOffset, isTaken, macro) : this.fLocationMap.encounterPoundIfdef(offset, nameOffset, nameEndOffset, endOffset, isTaken, macro);
        if (!conditional.isActive(withinExpansion)) {
            stmt.setInactive();
        }
        return this.fCurrentContext.setBranchState(conditional, isTaken, withinExpansion, offset);
    }

    private ScannerContext.CodeState executeIf(Lexer lexer, int startOffset, boolean isElif, boolean withinExpansion) throws OffsetLimitReachedException {
        int endOffset;
        int condEndOffset;
        ScannerContext.Conditional cond = this.fCurrentContext.newBranch(isElif ? ScannerContext.BranchKind.eElif : ScannerContext.BranchKind.eIf, withinExpansion);
        if (cond == null) {
            char[] name = lexer.currentToken().getCharImage();
            int condEndOffset2 = lexer.consumeLine(2);
            this.handleProblem(0x2000004, name, startOffset, condEndOffset2);
            return this.fCurrentContext.getCodeState();
        }
        boolean isTaken = false;
        IASTName[] refs = IASTName.EMPTY_NAME_ARRAY;
        int condOffset = lexer.nextToken().getOffset();
        if (cond.canHaveActiveBranch(withinExpansion)) {
            char[] macro = IncludeGuardDetection.detectIfNotDefinedIncludeEndif(lexer);
            if (macro != null) {
                this.fExternIncludeGuard = macro;
            }
            TokenList condition = new TokenList();
            condEndOffset = this.getTokensWithinPPDirective(true, condition, withinExpansion);
            endOffset = lexer.currentToken().getEndOffset();
            if (condition.first() == null) {
                this.handleProblem(0x100000C, null, startOffset, endOffset);
            } else {
                try {
                    this.fExpressionEvaluator.clearMacrosInDefinedExpression();
                    isTaken = this.fExpressionEvaluator.evaluate(condition, this.fMacroDictionary, this.fLocationMap);
                    IASTName[] iASTNameArray = refs = this.fExpressionEvaluator.clearMacrosInDefinedExpression();
                    int n = refs.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IASTName iastName = iASTNameArray[n2];
                        IBinding mb = iastName.getBinding();
                        if (mb instanceof UndefinedMacro) {
                            this.fCurrentContext.significantMacroUndefined(iastName.toCharArray());
                        } else {
                            this.fCurrentContext.significantMacroDefined(iastName.toCharArray());
                        }
                        ++n2;
                    }
                }
                catch (ExpressionEvaluator.EvalException e) {
                    this.handleProblem(e.getProblemID(), e.getProblemArg(), condOffset, endOffset);
                }
            }
        } else {
            condEndOffset = lexer.consumeLine(2);
            endOffset = lexer.currentToken().getEndOffset();
        }
        ASTDirectiveWithCondition stmt = isElif ? this.fLocationMap.encounterPoundElif(startOffset, condOffset, condEndOffset, endOffset, isTaken, refs) : this.fLocationMap.encounterPoundIf(startOffset, condOffset, condEndOffset, endOffset, isTaken, refs);
        if (!cond.isActive(withinExpansion)) {
            stmt.setInactive();
        }
        return this.fCurrentContext.setBranchState(cond, isTaken, withinExpansion, startOffset);
    }

    private ScannerContext.CodeState executeElse(Lexer lexer, int startOffset, boolean withinExpansion) throws OffsetLimitReachedException {
        int endOffset = lexer.consumeLine(2);
        ScannerContext.Conditional cond = this.fCurrentContext.newBranch(ScannerContext.BranchKind.eElse, withinExpansion);
        if (cond == null) {
            this.handleProblem(0x2000004, Keywords.cELSE, startOffset, endOffset);
            return this.fCurrentContext.getCodeState();
        }
        boolean isTaken = cond.canHaveActiveBranch(withinExpansion);
        ASTElse stmt = this.fLocationMap.encounterPoundElse(startOffset, endOffset, isTaken);
        if (!cond.isActive(withinExpansion)) {
            stmt.setInactive();
        }
        return this.fCurrentContext.setBranchState(cond, isTaken, withinExpansion, startOffset);
    }

    private ScannerContext.CodeState executeEndif(Lexer lexer, int startOffset, boolean withinExpansion) throws OffsetLimitReachedException {
        int endOffset = lexer.consumeLine(2);
        ScannerContext.Conditional cond = this.fCurrentContext.newBranch(ScannerContext.BranchKind.eEnd, withinExpansion);
        if (cond == null) {
            this.handleProblem(0x2000004, Keywords.cENDIF, startOffset, endOffset);
        } else {
            ASTEndif stmt = this.fLocationMap.encounterPoundEndIf(startOffset, endOffset);
            if (!cond.isActive(withinExpansion)) {
                stmt.setInactive();
            }
        }
        return this.fCurrentContext.setBranchEndState(cond, withinExpansion, startOffset);
    }

    private int getTokensWithinPPDirective(boolean isCondition, TokenList result, boolean withinExpansion) throws OffsetLimitReachedException {
        ScannerContext scannerCtx = this.fCurrentContext;
        scannerCtx.clearInactiveCodeMarkerToken();
        int options = 20;
        if (isCondition) {
            options |= 2;
        }
        block8: while (true) {
            Token t = this.internalFetchToken(scannerCtx, options, withinExpansion);
            switch (t.getType()) {
                case 140: 
                case 144: {
                    scannerCtx.consumeLine(2);
                    break block8;
                }
                case -99: {
                    break block8;
                }
                case 1: {
                    break;
                }
                case -200: {
                    options |= 1;
                    break;
                }
                case -194: {
                    options |= 1;
                    break;
                }
                case 8: {
                    break;
                }
                default: {
                    options &= 0xFFFFFFFE;
                }
            }
            result.append(t);
        }
        return scannerCtx.consumeLine(2);
    }

    private void skipOverConditionalCode(Lexer lexer, boolean withinExpansion) throws OffsetLimitReachedException {
        ScannerContext.CodeState state = ScannerContext.CodeState.eSkipInactive;
        while (state == ScannerContext.CodeState.eSkipInactive) {
            state = this.skipBranch(lexer, withinExpansion);
        }
    }

    private ScannerContext.CodeState skipBranch(Lexer lexer, boolean withinExpansion) throws OffsetLimitReachedException {
        block9: while (true) {
            Token pound;
            int tt;
            if ((tt = (pound = lexer.nextDirective()).getType()) != 138) {
                if (tt == 140) {
                    throw new OffsetLimitReachedException(3, pound);
                }
                return ScannerContext.CodeState.eActive;
            }
            Token ident = lexer.nextToken();
            tt = ident.getType();
            if (tt != 1) {
                if (tt == 140) {
                    throw new OffsetLimitReachedException(3, ident);
                }
                lexer.consumeLine(2);
                continue;
            }
            char[] name = ident.getCharImage();
            int type = this.fPPKeywords.get(name);
            switch (type) {
                case 6: 
                case 11: 
                case 12: {
                    this.executeInclude(lexer, ident.getOffset(), type, false, withinExpansion);
                    continue block9;
                }
                case 1: {
                    return this.executeIfdef(lexer, pound.getOffset(), false, withinExpansion);
                }
                case 2: {
                    return this.executeIfdef(lexer, pound.getOffset(), true, withinExpansion);
                }
                case 0: {
                    return this.executeIf(lexer, pound.getOffset(), false, withinExpansion);
                }
                case 3: {
                    return this.executeIf(lexer, pound.getOffset(), true, withinExpansion);
                }
                case 4: {
                    return this.executeElse(lexer, pound.getOffset(), withinExpansion);
                }
                case 5: {
                    return this.executeEndif(lexer, pound.getOffset(), withinExpansion);
                }
            }
            lexer.consumeLine(2);
        }
    }

    private boolean expandMacro(Token identifier, Lexer lexer, int options, boolean withinExpansion) throws OffsetLimitReachedException {
        boolean stopAtNewline;
        PreprocessorMacro macro;
        boolean reportSignificant = (options & 0x10) != 0;
        char[] name = identifier.getCharImage();
        if ((options & 2) != 0) {
            if (CharArrayUtils.equals(name, Keywords.cDEFINED)) {
                identifier.setType(-200);
                return false;
            }
            if (CharArrayUtils.equals(name, Keywords.c__HAS_FEATURE)) {
                identifier.setType(-194);
                return false;
            }
        }
        if ((macro = this.fMacroDictionary.get(name)) == null) {
            if (reportSignificant && (options & 0x20) == 0) {
                this.fCurrentContext.significantMacroUndefined(name);
            }
            return false;
        }
        boolean bl = stopAtNewline = (options & 4) != 0;
        if (macro instanceof FunctionStyleMacro) {
            Token t = lexer.currentToken();
            if (!stopAtNewline) {
                while (t.getType() == -99) {
                    t = lexer.nextToken();
                }
            }
            if (t.getType() != 8) {
                if (reportSignificant) {
                    this.fCurrentContext.significantMacro(macro);
                }
                return false;
            }
        }
        boolean contentAssist = this.fContentAssistLimit >= 0 && this.fCurrentContext == this.fRootContext;
        TokenSequence input = stopAtNewline ? this.fLineInputToMacroExpansion : this.fInputToMacroExpansion;
        MacroExpander expander = withinExpansion ? new MacroExpander(this, this.fMacroDictionary, this.fLocationMap, this.fLexOptions) : this.fMacroExpander;
        TokenList replacement = expander.expand(input, options, macro, identifier, contentAssist, this.fCurrentContext);
        IASTName[] expansions = expander.clearImplicitExpansions();
        ImageLocationInfo[] ili = expander.clearImageLocationInfos();
        Token last = replacement.last();
        int length = last == null ? 0 : last.getEndOffset();
        ILocationCtx ctx = this.fLocationMap.pushMacroExpansion(identifier.getOffset(), identifier.getEndOffset(), lexer.getLastEndOffset(), length, macro, expansions, ili);
        this.fCurrentContext = new ScannerContext(ctx, this.fCurrentContext, replacement);
        return true;
    }

    private static char[] getUserDefinedLiteralSuffix(IToken token) {
        if (token.getType() != 51002) {
            throw new IllegalArgumentException();
        }
        char[] image = token.getCharImage();
        int offset = CharArrayUtils.lastIndexOf('\"', image) + 1;
        if (offset <= 0) {
            throw new IllegalArgumentException();
        }
        if (offset == image.length) {
            return CharArrayUtils.EMPTY_CHAR_ARRAY;
        }
        return CharArrayUtils.subarray(image, offset, image.length);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(this.fMacroExpander.getClass())) {
            return (T)this.fMacroExpander;
        }
        return null;
    }

    public static boolean isPreprocessorProvidedMacro(char[] name) {
        return CharArrayUtils.equals(__LINE__.getNameCharArray(), name) || CharArrayUtils.equals(__FILE__.getNameCharArray(), name) || CharArrayUtils.equals(__DATE__.getNameCharArray(), name) || CharArrayUtils.equals(__TIME__.getNameCharArray(), name);
    }

    public Set<String> getSupportedFeatures() {
        if (this.sSupportedFeatures == null) {
            this.sSupportedFeatures = new HashSet<String>();
            this.sSupportedFeatures.add("cxx_exceptions");
            this.sSupportedFeatures.add("cxx_rtti");
            this.sSupportedFeatures.add("cxx_alias_templates");
            this.sSupportedFeatures.add("cxx_alignas");
            this.sSupportedFeatures.add("cxx_alignof");
            this.sSupportedFeatures.add("cxx_atomic");
            this.sSupportedFeatures.add("cxx_attributes");
            this.sSupportedFeatures.add("cxx_auto_type");
            this.sSupportedFeatures.add("cxx_constexpr");
            this.sSupportedFeatures.add("cxx_decltype");
            this.sSupportedFeatures.add("cxx_default_function_template_args");
            this.sSupportedFeatures.add("cxx_defaulted_functions");
            this.sSupportedFeatures.add("cxx_delegating_constructors");
            this.sSupportedFeatures.add("cxx_deleted_functions");
            this.sSupportedFeatures.add("cxx_explicit_conversions");
            this.sSupportedFeatures.add("cxx_generalized_initializers");
            this.sSupportedFeatures.add("cxx_inheriting_constructors");
            this.sSupportedFeatures.add("cxx_inline_namespaces");
            this.sSupportedFeatures.add("cxx_lambdas");
            this.sSupportedFeatures.add("cxx_local_type_template_args");
            this.sSupportedFeatures.add("cxx_noexcept");
            this.sSupportedFeatures.add("cxx_nonstatic_member_init");
            this.sSupportedFeatures.add("cxx_nullptr");
            this.sSupportedFeatures.add("cxx_override_control");
            this.sSupportedFeatures.add("cxx_range_for");
            this.sSupportedFeatures.add("cxx_raw_string_literals");
            this.sSupportedFeatures.add("cxx_reference_qualified_functions");
            this.sSupportedFeatures.add("cxx_rvalue_references");
            this.sSupportedFeatures.add("cxx_static_assert");
            this.sSupportedFeatures.add("cxx_strong_enums");
            this.sSupportedFeatures.add("cxx_thread_local");
            this.sSupportedFeatures.add("cxx_trailing_return");
            this.sSupportedFeatures.add("cxx_unicode_literals");
            this.sSupportedFeatures.add("cxx_user_literals");
            this.sSupportedFeatures.add("cxx_variadic_templates");
            this.sSupportedFeatures.add("cxx_relaxed_constexpr");
            this.sSupportedFeatures.add("cxx_variable_templates");
            this.sSupportedFeatures.add("c_alignas");
            this.sSupportedFeatures.add("c_alignof");
            this.addTypeTraitPrimitive("has_trivial_copy", GCCKeywords.cp__has_trivial_copy);
            this.addTypeTraitPrimitive("is_abstract", GCCKeywords.cp__is_abstract);
            this.addTypeTraitPrimitive("is_base_of", GCCKeywords.cp__is_base_of);
            this.addTypeTraitPrimitive("is_class", GCCKeywords.cp__is_class);
            this.addTypeTraitPrimitive("is_empty", GCCKeywords.cp__is_empty);
            this.addTypeTraitPrimitive("is_enum", GCCKeywords.cp__is_enum);
            this.addTypeTraitPrimitive("is_final", GCCKeywords.cp__is_final);
            this.addTypeTraitPrimitive("is_pod", GCCKeywords.cp__is_pod);
            this.addTypeTraitPrimitive("is_polymorphic", GCCKeywords.cp__is_polymorphic);
            this.addTypeTraitPrimitive("is_standard_layout", GCCKeywords.cp__is_standard_layout);
            this.addTypeTraitPrimitive("is_trivial", GCCKeywords.cp__is_trivial);
            this.addTypeTraitPrimitive("is_trivially_copyable", GCCKeywords.cp__is_trivially_copyable);
            this.addTypeTraitPrimitive("is_union", GCCKeywords.cp__is_union);
            this.addTypeTraitPrimitive("underlying_type", GCCKeywords.cp__underlying_type);
        }
        return this.sSupportedFeatures;
    }

    private void addTypeTraitPrimitive(String featureName, char[] keyword) {
        if (this.fKeywords.containsKey(keyword)) {
            this.sSupportedFeatures.add(featureName);
        }
    }

    private static interface IIncludeFileTester<T> {
        public T checkFile(String var1, boolean var2, IncludeSearchPathElement var3);
    }

    private static class IncludeResolution {
        final String fLocation;
        final boolean fHeuristic;

        IncludeResolution(String location, boolean heusistic) {
            this.fLocation = location;
            this.fHeuristic = heusistic;
        }
    }

    private final class MacroDictionary
    implements IMacroDictionary,
    ISignificantMacros.IVisitor {
        private MacroDictionary() {
        }

        @Override
        public boolean satisfies(ISignificantMacros significantMacros) {
            return significantMacros.accept(this);
        }

        @Override
        public boolean visitDefined(char[] macro) {
            return this.isDefined(macro);
        }

        @Override
        public boolean visitUndefined(char[] macro) {
            return !this.isDefined(macro);
        }

        @Override
        public boolean visitValue(char[] macro, char[] value) {
            PreprocessorMacro m = (PreprocessorMacro)CPreprocessor.this.fMacroDictionary.get(macro);
            return m != null && CharArrayUtils.equals(SignificantMacros.shortenValue(m.getExpansion()), value);
        }

        private boolean isDefined(char[] macro) {
            return CPreprocessor.this.fMacroDictionary.containsKey(macro);
        }
    }

    private final class TokenSequence
    implements ITokenSequence {
        private final boolean fStopAtNewline;

        TokenSequence(boolean stopAtNewline) {
            this.fStopAtNewline = stopAtNewline;
        }

        @Override
        public Token nextToken() throws OffsetLimitReachedException {
            Lexer lexer = CPreprocessor.this.fCurrentContext.getLexer();
            Token t = lexer.nextToken();
            if (t.getType() == 138 && lexer.currentTokenIsFirstOnLine()) {
                CPreprocessor.this.executeDirective(lexer, t.getOffset(), true);
                t = lexer.currentToken();
            }
            if (this.fStopAtNewline && t.getType() == -99) {
                return new Token(144, null, 0, 0);
            }
            return t;
        }

        @Override
        public int getLastEndOffset() {
            return CPreprocessor.this.fCurrentContext.getLexer().getLastEndOffset();
        }

        @Override
        public Token currentToken() {
            Token t = CPreprocessor.this.fCurrentContext.currentLexerToken();
            if (this.fStopAtNewline && t.getType() == -99) {
                return new Token(144, null, 0, 0);
            }
            return t;
        }
    }
}

