/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.pdom.dom.cpp;

import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.dom.ILinkage;
import org.eclipse.cdt.core.dom.ast.DOMException;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IScope;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunction;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPFunctionType;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPMethod;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPParameter;
import org.eclipse.cdt.internal.core.dom.parser.ProblemFunctionType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPComputableFunction;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPExecution;
import org.eclipse.cdt.internal.core.index.IndexCPPSignatureUtil;
import org.eclipse.cdt.internal.core.pdom.db.Database;
import org.eclipse.cdt.internal.core.pdom.dom.IPDOMOverloader;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMBinding;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.PDOMNode;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPAnnotations;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPBinding;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPLinkage;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPParameter;
import org.eclipse.cdt.internal.core.pdom.dom.cpp.PDOMCPPTypeList;
import org.eclipse.core.runtime.CoreException;

class PDOMCPPFunction
extends PDOMCPPBinding
implements ICPPFunction,
IPDOMOverloader,
ICPPComputableFunction {
    private static final int NUM_PARAMS = 32;
    private static final int FIRST_PARAM = 36;
    protected static final int FUNCTION_TYPE = 40;
    private static final int SIGNATURE_HASH = 46;
    protected static final int EXCEPTION_SPEC = 50;
    private static final int ANNOTATION = 54;
    private static final int REQUIRED_ARG_COUNT = 56;
    private static final int FUNCTION_BODY = 58;
    protected static final int RECORD_SIZE = 64;
    private short fAnnotations = (short)-1;
    private int fRequiredArgCount = -1;
    private ICPPFunctionType fType;

    public PDOMCPPFunction(PDOMCPPLinkage linkage, PDOMNode parent, ICPPFunction function, boolean setTypes, IASTNode point) throws CoreException, DOMException {
        super(linkage, parent, function.getNameCharArray());
        Database db = this.getDB();
        Integer sigHash = IndexCPPSignatureUtil.getSignatureHash(function);
        this.getDB().putInt(this.record + 46L, sigHash != null ? sigHash : 0);
        db.putShort(this.record + 54L, this.getAnnotations(function));
        db.putShort(this.record + 56L, (short)function.getRequiredArgumentCount());
        if (setTypes) {
            PDOMCPPLinkage pDOMCPPLinkage = linkage;
            pDOMCPPLinkage.getClass();
            new PDOMCPPLinkage.ConfigureFunction(pDOMCPPLinkage, function, this, point);
        }
    }

    private short getAnnotations(ICPPFunction function) {
        return PDOMCPPAnnotations.encodeFunctionAnnotations(function);
    }

    public void initData(ICPPFunctionType ftype, ICPPParameter[] params, IType[] exceptionSpec, ICPPExecution functionBody) {
        try {
            this.setType(ftype);
            this.setParameters(params);
            this.storeExceptionSpec(exceptionSpec);
            ((PDOMLinkage)this.getLinkage()).storeExecution(this.record + 58L, functionBody);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
        }
    }

    @Override
    public void update(PDOMLinkage linkage, IBinding newBinding, IASTNode point) throws CoreException {
        int requiredCount;
        if (!(newBinding instanceof ICPPFunction)) {
            return;
        }
        ICPPFunction func = (ICPPFunction)newBinding;
        ICPPFunctionType newType = func.getType();
        ICPPParameter[] newParams = func.getParameters();
        short newAnnotation = this.getAnnotations(func);
        int newBindingRequiredArgCount = func.getRequiredArgumentCount();
        this.fType = null;
        linkage.storeType(this.record + 40L, newType);
        PDOMCPPParameter oldParams = this.getFirstParameter(null);
        if (oldParams != null && this.hasDeclaration()) {
            int parCount = 0;
            requiredCount = 0;
            ICPPParameter[] iCPPParameterArray = newParams;
            int n = newParams.length;
            int n2 = 0;
            while (n2 < n) {
                ICPPParameter newPar = iCPPParameterArray[n2];
                if (++parCount <= newBindingRequiredArgCount && !oldParams.hasDefaultValue()) {
                    requiredCount = parCount;
                }
                oldParams.update(newPar);
                long next = oldParams.getNextPtr();
                if (next == 0L) break;
                oldParams = new PDOMCPPParameter(linkage, next, null);
                ++n2;
            }
            if (parCount < newBindingRequiredArgCount) {
                requiredCount = newBindingRequiredArgCount;
            }
        } else {
            requiredCount = newBindingRequiredArgCount;
            this.setParameters(newParams);
            if (oldParams != null) {
                oldParams.delete(linkage);
            }
        }
        Database db = this.getDB();
        db.putShort(this.record + 54L, newAnnotation);
        this.fAnnotations = newAnnotation;
        db.putShort(this.record + 56L, (short)requiredCount);
        this.fRequiredArgCount = requiredCount;
        long oldRec = db.getRecPtr(this.record + 50L);
        this.storeExceptionSpec(this.extractExceptionSpec(func));
        if (oldRec != 0L) {
            PDOMCPPTypeList.clearTypes(this, oldRec);
        }
        linkage.storeExecution(this.record + 58L, CPPFunction.getFunctionBodyExecution(func, point));
    }

    private void storeExceptionSpec(IType[] exceptionSpec) throws CoreException {
        long typelist = PDOMCPPTypeList.putTypes(this, exceptionSpec);
        this.getDB().putRecPtr(this.record + 50L, typelist);
    }

    IType[] extractExceptionSpec(ICPPFunction binding) {
        Object exceptionSpec = binding instanceof ICPPMethod && ((ICPPMethod)binding).isImplicit() ? null : binding.getExceptionSpecification();
        return exceptionSpec;
    }

    private void setParameters(ICPPParameter[] params) throws CoreException {
        ILinkage linkage = this.getLinkage();
        Database db = this.getDB();
        db.putInt(this.record + 32L, params.length);
        db.putRecPtr(this.record + 36L, 0L);
        PDOMNode next = null;
        int i = params.length;
        while (--i >= 0) {
            next = new PDOMCPPParameter((PDOMLinkage)linkage, this, params[i], (PDOMCPPParameter)next);
        }
        db.putRecPtr(this.record + 36L, next == null ? 0L : next.getRecord());
    }

    private void setType(ICPPFunctionType ft) throws CoreException {
        this.fType = null;
        ((PDOMLinkage)this.getLinkage()).storeType(this.record + 40L, ft);
    }

    @Override
    public int getSignatureHash() throws CoreException {
        return this.getDB().getInt(this.record + 46L);
    }

    public static int getSignatureHash(PDOMLinkage linkage, long record) throws CoreException {
        return linkage.getDB().getInt(record + 46L);
    }

    public PDOMCPPFunction(PDOMLinkage linkage, long bindingRecord) {
        super(linkage, bindingRecord);
    }

    @Override
    protected int getRecordSize() {
        return 64;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    private PDOMCPPParameter getFirstParameter(IType type) throws CoreException {
        long rec = this.getDB().getRecPtr(this.record + 36L);
        return rec != 0L ? new PDOMCPPParameter((PDOMLinkage)this.getLinkage(), rec, type) : null;
    }

    @Override
    public boolean isInline() {
        return PDOMCPPAnnotations.isInline(this.getAnnotations());
    }

    @Override
    public int getRequiredArgumentCount() {
        if (this.fRequiredArgCount == -1) {
            try {
                this.fRequiredArgCount = this.getDB().getShort(this.record + 56L);
            }
            catch (CoreException e) {
                this.fRequiredArgCount = 0;
            }
        }
        return this.fRequiredArgCount;
    }

    protected final short getAnnotations() {
        if (this.fAnnotations == -1) {
            try {
                this.fAnnotations = this.getDB().getShort(this.record + 54L);
            }
            catch (CoreException e) {
                this.fAnnotations = 0;
            }
        }
        return this.fAnnotations;
    }

    @Override
    public boolean isExternC() {
        return PDOMCPPAnnotations.isExternC(this.getAnnotations());
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public IScope getFunctionScope() {
        return null;
    }

    @Override
    public ICPPParameter[] getParameters() {
        try {
            ILinkage linkage = this.getLinkage();
            Database db = this.getDB();
            ICPPFunctionType ft = this.getType();
            IType[] ptypes = ft == null ? IType.EMPTY_TYPE_ARRAY : ft.getParameterTypes();
            int n = db.getInt(this.record + 32L);
            ICPPParameter[] result = new ICPPParameter[n];
            long next = db.getRecPtr(this.record + 36L);
            int i = 0;
            while (i < n && next != 0L) {
                IType type = i < ptypes.length ? ptypes[i] : null;
                PDOMCPPParameter par = new PDOMCPPParameter((PDOMLinkage)linkage, next, type);
                next = par.getNextPtr();
                result[i] = par;
                ++i;
            }
            return result;
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return ICPPParameter.EMPTY_CPPPARAMETER_ARRAY;
        }
    }

    @Override
    public final ICPPFunctionType getType() {
        if (this.fType == null) {
            try {
                this.fType = (ICPPFunctionType)((PDOMLinkage)this.getLinkage()).loadType(this.record + 40L);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
                this.fType = new ProblemFunctionType(10005);
            }
        }
        return this.fType;
    }

    @Override
    public boolean isAuto() {
        return false;
    }

    @Override
    public boolean isConstexpr() {
        return PDOMCPPAnnotations.isConstexpr(this.getAnnotations());
    }

    @Override
    public boolean isDeleted() {
        return PDOMCPPAnnotations.isDeletedFunction(this.getAnnotations());
    }

    @Override
    public boolean isExtern() {
        return PDOMCPPAnnotations.isExtern(this.getAnnotations());
    }

    @Override
    public boolean isRegister() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return PDOMCPPAnnotations.isStatic(this.getAnnotations());
    }

    @Override
    public boolean takesVarArgs() {
        return PDOMCPPAnnotations.isVarargsFunction(this.getAnnotations());
    }

    @Override
    public boolean isNoReturn() {
        return PDOMCPPAnnotations.isNoReturnFunction(this.getAnnotations());
    }

    @Override
    public boolean hasParameterPack() {
        return PDOMCPPAnnotations.hasParameterPack(this.getAnnotations());
    }

    public Object clone() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int pdomCompareTo(PDOMBinding other) {
        int cmp = super.pdomCompareTo(other);
        return cmp == 0 ? PDOMCPPFunction.compareSignatures(this, other) : cmp;
    }

    protected static int compareSignatures(IPDOMOverloader a, Object b) {
        if (b instanceof IPDOMOverloader) {
            IPDOMOverloader bb = (IPDOMOverloader)b;
            try {
                int mySM = a.getSignatureHash();
                int otherSM = bb.getSignatureHash();
                return mySM == otherSM ? 0 : (mySM < otherSM ? -1 : 1);
            }
            catch (CoreException e) {
                CCorePlugin.log(e);
            }
        } else assert (false);
        return 0;
    }

    @Override
    public IType[] getExceptionSpecification() {
        try {
            long rec = this.getPDOM().getDB().getRecPtr(this.record + 50L);
            return PDOMCPPTypeList.getTypes(this, rec);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }

    @Override
    public ICPPExecution getFunctionBodyExecution(IASTNode point) {
        if (!this.isConstexpr()) {
            return null;
        }
        try {
            return (ICPPExecution)((PDOMLinkage)this.getLinkage()).loadExecution(this.record + 58L);
        }
        catch (CoreException e) {
            CCorePlugin.log(e);
            return null;
        }
    }
}

