/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils;

import java.util.ArrayList;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateCountingRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateDataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.ImmediateRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IProcesses;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommandControlService;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.ui.model.VisualizerExecutionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.DSFSessionState;
import org.eclipse.cdt.dsf.gdb.multicorevisualizer.internal.utils.IDSFTargetDataProxy;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS;
import org.eclipse.cdt.dsf.gdb.service.IGDBHardwareAndOS2;
import org.eclipse.cdt.dsf.gdb.service.IGDBProcesses;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;

public class DSFDebugModel
implements IDSFTargetDataProxy {
    @Override
    @ConfinedToDsfExecutor(value="sessionState.getDsfSession().getExecutor()")
    public void getCPUs(DSFSessionState sessionState, final DataRequestMonitor<IGDBHardwareAndOS.ICPUDMContext[]> rm) {
        ICommandControlService controlService = sessionState.getService(ICommandControlService.class);
        IGDBHardwareAndOS hwService = sessionState.getService(IGDBHardwareAndOS.class);
        if (controlService == null || hwService == null) {
            rm.done((Object)new IGDBHardwareAndOS.ICPUDMContext[0]);
            return;
        }
        IGDBHardwareAndOS.IHardwareTargetDMContext contextToUse = (IGDBHardwareAndOS.IHardwareTargetDMContext)DMContexts.getAncestorOfType((IDMContext)controlService.getContext(), IGDBHardwareAndOS.IHardwareTargetDMContext.class);
        hwService.getCPUs(contextToUse, (DataRequestMonitor)new ImmediateDataRequestMonitor<IGDBHardwareAndOS.ICPUDMContext[]>(rm){

            protected void handleCompleted() {
                IGDBHardwareAndOS.ICPUDMContext[] cpuContexts = this.isSuccess() ? (IGDBHardwareAndOS.ICPUDMContext[])this.getData() : new IGDBHardwareAndOS.ICPUDMContext[]{};
                rm.done((Object)cpuContexts);
            }
        });
    }

    @Override
    @ConfinedToDsfExecutor(value="sessionState.getDsfSession().getExecutor()")
    public void getLoad(DSFSessionState sessionState, IDMContext context, DataRequestMonitor<IGDBHardwareAndOS2.ILoadInfo> rm) {
        IGDBHardwareAndOS2 hwService = sessionState.getService(IGDBHardwareAndOS2.class);
        if (hwService == null) {
            rm.setData(null);
            rm.done();
            return;
        }
        hwService.getLoadInfo(context, rm);
    }

    @Override
    @ConfinedToDsfExecutor(value="sessionState.getDsfSession().getExecutor()")
    public void getCores(DSFSessionState sessionState, DataRequestMonitor<IGDBHardwareAndOS.ICoreDMContext[]> rm) {
        this.getCores(sessionState, null, rm);
    }

    @Override
    @ConfinedToDsfExecutor(value="sessionState.getDsfSession().getExecutor()")
    public void getCores(DSFSessionState sessionState, IGDBHardwareAndOS.ICPUDMContext cpuContext, final DataRequestMonitor<IGDBHardwareAndOS.ICoreDMContext[]> rm) {
        IGDBHardwareAndOS hwService = sessionState.getService(IGDBHardwareAndOS.class);
        if (hwService == null) {
            rm.done((Object)new IGDBHardwareAndOS.ICoreDMContext[0]);
            return;
        }
        IGDBHardwareAndOS.ICPUDMContext targetContextToUse = cpuContext;
        if (targetContextToUse == null) {
            ICommandControlService controlService = sessionState.getService(ICommandControlService.class);
            targetContextToUse = DMContexts.getAncestorOfType((IDMContext)controlService.getContext(), IGDBHardwareAndOS.IHardwareTargetDMContext.class);
        }
        hwService.getCores((IDMContext)targetContextToUse, (DataRequestMonitor)new ImmediateDataRequestMonitor<IGDBHardwareAndOS.ICoreDMContext[]>(){

            protected void handleCompleted() {
                IGDBHardwareAndOS.ICoreDMContext[] coreContexts = (IGDBHardwareAndOS.ICoreDMContext[])this.getData();
                if (!this.isSuccess() || coreContexts == null || coreContexts.length < 1) {
                    rm.done((Object)new IGDBHardwareAndOS.ICoreDMContext[0]);
                } else {
                    rm.done((Object)coreContexts);
                }
            }
        });
    }

    @Override
    @ConfinedToDsfExecutor(value="sessionState.getDsfSession().getExecutor()")
    public void getThreads(DSFSessionState sessionState, IGDBHardwareAndOS.ICPUDMContext cpuContext, final IGDBHardwareAndOS.ICoreDMContext coreContext, final DataRequestMonitor<IDMContext[]> rm) {
        final IProcesses procService = sessionState.getService(IProcesses.class);
        ICommandControlService.ICommandControlDMContext controlContext = (ICommandControlService.ICommandControlDMContext)DMContexts.getAncestorOfType((IDMContext)coreContext, ICommandControlService.ICommandControlDMContext.class);
        if (procService == null || controlContext == null) {
            rm.done((Object)new IDMContext[0]);
            return;
        }
        procService.getProcessesBeingDebugged((IDMContext)controlContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IDMContext[]>(){

            protected void handleCompleted() {
                IDMContext[] processContexts = (IDMContext[])this.getData();
                if (!this.isSuccess() || processContexts == null || processContexts.length < 1) {
                    rm.done((Object)new IDMContext[0]);
                    return;
                }
                final ArrayList threadContextsList = new ArrayList();
                final ImmediateCountingRequestMonitor crm1 = new ImmediateCountingRequestMonitor((RequestMonitor)new ImmediateRequestMonitor(){

                    protected void handleCompleted() {
                        IDMContext[] threadContexts = threadContextsList.toArray(new IDMContext[threadContextsList.size()]);
                        rm.done((Object)threadContexts);
                    }
                });
                crm1.setDoneCount(processContexts.length);
                IDMContext[] iDMContextArray = processContexts;
                int n = processContexts.length;
                int n2 = 0;
                while (n2 < n) {
                    IDMContext processContext = iDMContextArray[n2];
                    IRunControl.IContainerDMContext containerContext = (IRunControl.IContainerDMContext)DMContexts.getAncestorOfType((IDMContext)processContext, IRunControl.IContainerDMContext.class);
                    procService.getProcessesBeingDebugged((IDMContext)containerContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IDMContext[]>((RequestMonitor)crm1){

                        protected void handleCompleted() {
                            IDMContext[] threadContexts = (IDMContext[])this.getData();
                            if (!this.isSuccess() || threadContexts == null || threadContexts.length < 1) {
                                crm1.done();
                                return;
                            }
                            final ImmediateCountingRequestMonitor crm2 = new ImmediateCountingRequestMonitor((RequestMonitor)crm1);
                            crm2.setDoneCount(threadContexts.length);
                            IDMContext[] iDMContextArray = threadContexts;
                            int n = threadContexts.length;
                            int n2 = 0;
                            while (n2 < n) {
                                final IDMContext threadContext = iDMContextArray[n2];
                                IProcesses.IThreadDMContext threadContext2 = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)threadContext, IProcesses.IThreadDMContext.class);
                                procService.getExecutionData(threadContext2, (DataRequestMonitor)new ImmediateDataRequestMonitor<IProcesses.IThreadDMData>((RequestMonitor)crm2){

                                    protected void handleCompleted() {
                                        String[] cores;
                                        IProcesses.IThreadDMData data = (IProcesses.IThreadDMData)this.getData();
                                        if (data != null && data instanceof IGDBProcesses.IGdbThreadDMData && (cores = ((IGDBProcesses.IGdbThreadDMData)data).getCores()) != null && cores.length == 1 && coreContext.getId().equals(cores[0])) {
                                            threadContextsList.add(threadContext);
                                        }
                                        crm2.done();
                                    }
                                });
                                ++n2;
                            }
                        }
                    });
                    ++n2;
                }
            }
        });
    }

    @Override
    @ConfinedToDsfExecutor(value="sessionState.getDsfSession().getExecutor()")
    public void getThreadData(DSFSessionState sessionState, IGDBHardwareAndOS.ICPUDMContext cpuContext, IGDBHardwareAndOS.ICoreDMContext coreContext, IMIExecutionDMContext execContext, DataRequestMonitor<IProcesses.IThreadDMData> rm) {
        IProcesses procService = sessionState.getService(IProcesses.class);
        if (procService == null) {
            rm.setData(null);
            rm.done();
            return;
        }
        IProcesses.IThreadDMContext threadContext = (IProcesses.IThreadDMContext)DMContexts.getAncestorOfType((IDMContext)execContext, IProcesses.IThreadDMContext.class);
        procService.getExecutionData(threadContext, rm);
    }

    @Override
    @ConfinedToDsfExecutor(value="sessionState.getDsfSession().getExecutor()")
    public void getTopFrameData(DSFSessionState sessionState, IMIExecutionDMContext execContext, final DataRequestMonitor<IStack.IFrameDMData> rm) {
        final IStack.IFrameDMData nullFrameData = null;
        final IStack stackService = sessionState.getService(IStack.class);
        if (stackService != null) {
            stackService.getTopFrame((IDMContext)execContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IFrameDMContext>(null){

                protected void handleCompleted() {
                    IStack.IFrameDMContext targetFrameContext;
                    IStack.IFrameDMContext iFrameDMContext = targetFrameContext = this.isSuccess() ? (IStack.IFrameDMContext)this.getData() : null;
                    if (targetFrameContext != null) {
                        stackService.getFrameData(targetFrameContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IStack.IFrameDMData>(null){

                            protected void handleCompleted() {
                                IStack.IFrameDMData frameData = this.isSuccess() ? (IStack.IFrameDMData)this.getData() : null;
                                rm.done((Object)frameData);
                            }
                        });
                    } else {
                        rm.done((Object)nullFrameData);
                    }
                }
            });
        } else {
            rm.done(nullFrameData);
        }
    }

    @Override
    @ConfinedToDsfExecutor(value="sessionState.getDsfSession().getExecutor()")
    public void getThreadExecutionState(DSFSessionState sessionState, IGDBHardwareAndOS.ICPUDMContext cpuContext, IGDBHardwareAndOS.ICoreDMContext coreContext, IMIExecutionDMContext execContext, IProcesses.IThreadDMData threadData, DataRequestMonitor<VisualizerExecutionState> rm) {
        IRunControl runControl = sessionState.getService(IRunControl.class);
        if (runControl == null) {
            rm.setData(null);
            rm.done();
            return;
        }
        if (!runControl.isSuspended((IRunControl.IExecutionDMContext)execContext)) {
            rm.done((Object)VisualizerExecutionState.RUNNING);
        } else {
            DSFDebugModel.getThreadSuspendReason(sessionState, execContext, rm);
        }
    }

    @ConfinedToDsfExecutor(value="sessionState.getDsfSession().getExecutor()")
    private static void getThreadSuspendReason(DSFSessionState sessionState, IMIExecutionDMContext execContext, final DataRequestMonitor<VisualizerExecutionState> rm) {
        IRunControl runControl = sessionState.getService(IRunControl.class);
        if (runControl != null) {
            runControl.getExecutionData((IRunControl.IExecutionDMContext)execContext, (DataRequestMonitor)new ImmediateDataRequestMonitor<IRunControl.IExecutionDMData>(){

                protected void handleCompleted() {
                    String details;
                    IRunControl.IExecutionDMData executionData = (IRunControl.IExecutionDMData)this.getData();
                    VisualizerExecutionState state = VisualizerExecutionState.SUSPENDED;
                    if (this.isSuccess() && executionData != null && executionData.getStateChangeReason() == IRunControl.StateChangeReason.SIGNAL && executionData instanceof IRunControl.IExecutionDMData2 && (details = ((IRunControl.IExecutionDMData2)executionData).getDetails()) != null && DSFDebugModel.isCrashSignal(details)) {
                        state = VisualizerExecutionState.CRASHED;
                    }
                    rm.done((Object)state);
                }
            });
        } else {
            rm.setData(null);
            rm.done();
        }
    }

    public static boolean isCrashSignal(String signalInfo) {
        return signalInfo.startsWith("SIGHUP") || signalInfo.startsWith("SIGILL") || signalInfo.startsWith("SIGABRT") || signalInfo.startsWith("SIGBUS") || signalInfo.startsWith("SIGSEGV");
    }
}

