/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.dsf.mi.service.command;

import com.ibm.icu.text.MessageFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.datamodel.DMContexts;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.debug.service.IStack;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.debug.service.command.ICommandListener;
import org.eclipse.cdt.dsf.debug.service.command.ICommandResult;
import org.eclipse.cdt.dsf.debug.service.command.ICommandToken;
import org.eclipse.cdt.dsf.debug.service.command.IEventListener;
import org.eclipse.cdt.dsf.gdb.internal.GdbDebugOptions;
import org.eclipse.cdt.dsf.gdb.internal.GdbPlugin;
import org.eclipse.cdt.dsf.mi.service.IMICommandControl;
import org.eclipse.cdt.dsf.mi.service.IMIContainerDMContext;
import org.eclipse.cdt.dsf.mi.service.IMIExecutionDMContext;
import org.eclipse.cdt.dsf.mi.service.command.CommandFactory;
import org.eclipse.cdt.dsf.mi.service.command.MIControlDMContext;
import org.eclipse.cdt.dsf.mi.service.command.commands.MICommand;
import org.eclipse.cdt.dsf.mi.service.command.commands.RawCommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConst;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.mi.service.command.output.MIList;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOOBRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIParser;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResult;
import org.eclipse.cdt.dsf.mi.service.command.output.MIResultRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIStreamRecord;
import org.eclipse.cdt.dsf.mi.service.command.output.MIValue;
import org.eclipse.cdt.dsf.service.AbstractDsfService;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public abstract class AbstractMIControl
extends AbstractDsfService
implements IMICommandControl {
    private static final String MI_TRACE_IDENTIFIER = "[MI]";
    private static final int NUMBER_CONCURRENT_COMMANDS = 3;
    private static final int DEVELOPMENT_TRACE_LIMIT_CHARS = 5000;
    private TxThread fTxThread;
    private RxThread fRxThread;
    private ErrorThread fErrorThread;
    private boolean fUseThreadAndFrameOptions;
    private int fCurrentStackLevel = -1;
    private String fCurrentThreadId = null;
    private boolean fUseThreadGroupOption;
    private final BlockingQueue<CommandHandle> fTxCommands = new LinkedBlockingQueue<CommandHandle>();
    private final Map<Integer, CommandHandle> fRxCommands = Collections.synchronizedMap(new HashMap());
    private final CommandHandle fTerminatorHandle = new CommandHandle(null, null);
    private final List<ICommandListener> fCommandProcessors = new ArrayList<ICommandListener>();
    private final List<IEventListener> fEventProcessors = new ArrayList<IEventListener>();
    private final List<CommandHandle> fCommandQueue = new ArrayList<CommandHandle>();
    private boolean fStoppedCommandProcessing = false;
    private OutputStream fTracingStream = null;
    private CommandFactory fCommandFactory;
    private int fTokenIdCounter = 0;

    public AbstractMIControl(DsfSession session) {
        this(session, false, false, new CommandFactory());
    }

    public AbstractMIControl(DsfSession session, boolean useThreadAndFrameOptions, CommandFactory factory) {
        this(session, false, useThreadAndFrameOptions, factory);
    }

    public AbstractMIControl(DsfSession session, boolean useThreadGroupOption, boolean useThreadAndFrameOptions, CommandFactory factory) {
        super(session);
        assert (!useThreadGroupOption || useThreadAndFrameOptions);
        this.fUseThreadGroupOption = useThreadGroupOption;
        this.fUseThreadAndFrameOptions = useThreadAndFrameOptions;
        if (this.fUseThreadGroupOption) {
            this.fUseThreadAndFrameOptions = true;
        }
        this.fCommandFactory = factory;
    }

    protected synchronized void setMITracingStream(OutputStream tracingStream) {
        this.fTracingStream = tracingStream;
    }

    private synchronized OutputStream getMITracingStream() {
        return this.fTracingStream;
    }

    protected void setUseThreadAndFrameOptions(boolean shouldUse) {
        this.fUseThreadAndFrameOptions = shouldUse;
    }

    protected void setUseThreadGroupOptions(boolean shouldUse) {
        this.fUseThreadGroupOption = shouldUse;
        if (shouldUse) {
            this.fUseThreadAndFrameOptions = true;
        }
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.fCommandFactory;
    }

    protected void startCommandProcessing(InputStream inStream, OutputStream outStream) {
        this.startCommandProcessing(inStream, outStream, null);
    }

    protected void startCommandProcessing(InputStream inStream, OutputStream outStream, InputStream errorStream) {
        this.fTxThread = new TxThread(outStream);
        this.fRxThread = new RxThread(inStream);
        if (errorStream != null) {
            this.fErrorThread = new ErrorThread(errorStream);
        }
        this.fTxThread.start();
        this.fRxThread.start();
        if (this.fErrorThread != null) {
            this.fErrorThread.start();
        }
    }

    private Status genStatus(String str) {
        return new Status(4, "org.eclipse.cdt.dsf.gdb", 10001, str, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopCommandProcessing() {
        if (this.fStoppedCommandProcessing) {
            return;
        }
        this.fStoppedCommandProcessing = true;
        for (CommandHandle commandHandle : this.fCommandQueue) {
            if (commandHandle.getRequestMonitor() == null) continue;
            commandHandle.getRequestMonitor().setStatus((IStatus)this.genStatus("Connection is shut down"));
            commandHandle.getRequestMonitor().done();
        }
        this.fCommandQueue.clear();
        Map<Integer, CommandHandle> map = this.fRxCommands;
        synchronized (map) {
            for (CommandHandle commandHandle3 : this.fRxCommands.values()) {
                if (commandHandle3.getRequestMonitor() == null) continue;
                commandHandle3.getRequestMonitor().setStatus((IStatus)this.genStatus("Connection is shut down"));
                commandHandle3.getRequestMonitor().done();
            }
            this.fRxCommands.clear();
        }
        ArrayList arrayList = new ArrayList();
        this.fTxCommands.drainTo(arrayList);
        for (CommandHandle commandHandle : arrayList) {
            if (commandHandle.getRequestMonitor() == null) continue;
            commandHandle.getRequestMonitor().setStatus((IStatus)this.genStatus("Connection is shut down"));
            commandHandle.getRequestMonitor().done();
        }
        this.fTxCommands.add(this.fTerminatorHandle);
    }

    public <V extends ICommandResult> ICommandToken queueCommand(ICommand<V> command, DataRequestMonitor<V> rm) {
        MICommand miCommand = (MICommand)command;
        DataRequestMonitor<V> miDone = rm;
        CommandHandle handle = new CommandHandle(miCommand, miDone);
        if (this.fStoppedCommandProcessing) {
            rm.setStatus((IStatus)this.genStatus("Connection is shut down"));
            rm.done();
        } else {
            this.fCommandQueue.add(handle);
            this.processCommandQueued(handle);
            if (this.fRxCommands.size() < 3) {
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        AbstractMIControl.this.processNextQueuedCommand();
                    }
                });
            }
        }
        return handle;
    }

    private void processNextQueuedCommand() {
        CommandHandle handle;
        if (!this.fCommandQueue.isEmpty() && (handle = this.fCommandQueue.remove(0)) != null) {
            this.processCommandSent(handle);
            if (!this.fUseThreadAndFrameOptions || !handle.getCommand().supportsThreadAndFrameOptions()) {
                IDMContext targetContext = handle.fCommand.getContext();
                String targetThread = handle.getThreadId();
                int targetFrame = handle.getStackFrameId();
                IRunControl runControl = (IRunControl)this.getServicesTracker().getService(IRunControl.class);
                IMIExecutionDMContext execDmc = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)targetContext, IMIExecutionDMContext.class);
                if (runControl != null && execDmc != null && runControl.isSuspended((IRunControl.IExecutionDMContext)execDmc)) {
                    CommandHandle cmdHandle;
                    if (targetThread != null && !targetThread.equals("0") && !targetThread.equals(this.fCurrentThreadId)) {
                        this.fCurrentThreadId = targetThread;
                        this.resetCurrentStackLevel();
                        cmdHandle = new CommandHandle((MICommand)this.getCommandFactory().createMIThreadSelect(targetContext, targetThread), null);
                        cmdHandle.generateTokenId();
                        this.fTxCommands.add(cmdHandle);
                    }
                    if (targetFrame >= 0 && targetFrame != this.fCurrentStackLevel) {
                        this.fCurrentStackLevel = targetFrame;
                        cmdHandle = new CommandHandle((MICommand)this.getCommandFactory().createMIStackSelectFrame(targetContext, targetFrame), null);
                        cmdHandle.generateTokenId();
                        this.fTxCommands.add(cmdHandle);
                    }
                }
            }
            if (!(handle.getCommand() instanceof RawCommand)) {
                handle.generateTokenId();
            }
            this.fTxCommands.add(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCommand(ICommandToken token) {
        List<CommandHandle> list = this.fCommandQueue;
        synchronized (list) {
            for (CommandHandle handle : this.fCommandQueue) {
                if (!handle.equals(token)) continue;
                this.fCommandQueue.remove(handle);
                final CommandHandle finalHandle = handle;
                this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        AbstractMIControl.this.processCommandRemoved(finalHandle);
                    }
                });
                break;
            }
        }
    }

    public void addCommandListener(ICommandListener processor) {
        this.fCommandProcessors.add(processor);
    }

    public void removeCommandListener(ICommandListener processor) {
        this.fCommandProcessors.remove(processor);
    }

    public void addEventListener(IEventListener processor) {
        this.fEventProcessors.add(processor);
    }

    public void removeEventListener(IEventListener processor) {
        this.fEventProcessors.remove(processor);
    }

    @Deprecated
    public abstract MIControlDMContext getControlDMContext();

    public boolean isActive() {
        return !this.fStoppedCommandProcessing;
    }

    private void processCommandQueued(CommandHandle commandHandle) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandQueued((ICommandToken)commandHandle);
        }
    }

    private void processCommandRemoved(CommandHandle commandHandle) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandRemoved((ICommandToken)commandHandle);
        }
    }

    private void processCommandSent(CommandHandle commandHandle) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandSent((ICommandToken)commandHandle);
        }
    }

    private void processCommandDone(CommandHandle commandHandle, ICommandResult result) {
        for (ICommandListener processor : this.fCommandProcessors) {
            processor.commandDone((ICommandToken)commandHandle, result);
        }
    }

    private void processEvent(MIOutput output) {
        for (IEventListener processor : this.fEventProcessors) {
            processor.eventReceived((Object)output);
        }
    }

    private int getNewTokenId() {
        int count;
        if ((count = ++this.fTokenIdCounter) <= 0) {
            this.fTokenIdCounter = 1;
            count = 1;
        }
        return count;
    }

    public void resetCurrentThreadLevel() {
        this.fCurrentThreadId = null;
    }

    public void resetCurrentStackLevel() {
        this.fCurrentStackLevel = -1;
    }

    @ConfinedToDsfExecutor(value="this.getExecutor()")
    protected void commandFailed(ICommandToken token, int statusCode, String errorMessage) {
        if (!(token instanceof CommandHandle) || !(token.getCommand() instanceof MICommand)) {
            return;
        }
        CommandHandle commandHandle = (CommandHandle)token;
        Integer tokenId = commandHandle.getTokenId();
        CommandHandle h = this.fRxCommands.remove(tokenId);
        if (h == null) {
            return;
        }
        MIConst value = new MIConst();
        value.setCString(errorMessage);
        MIResult result = new MIResult();
        result.setVariable("msg");
        result.setMIValue(value);
        MIResultRecord resultRecord = new MIResultRecord();
        resultRecord.setToken(tokenId);
        resultRecord.setResultClass("error");
        resultRecord.setMIResults(new MIResult[]{result});
        MIOutput miOutput = new MIOutput(resultRecord, new MIOOBRecord[0]);
        MIInfo info = commandHandle.getCommand().getResult(miOutput);
        DataRequestMonitor<MIInfo> rm = commandHandle.getRequestMonitor();
        if (rm != null) {
            rm.setData((Object)info);
            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", statusCode, errorMessage, null));
            rm.done();
            this.processCommandDone(commandHandle, info);
        }
    }

    private class CommandHandle
    implements ICommandToken {
        private MICommand<MIInfo> fCommand;
        private DataRequestMonitor<MIInfo> fRequestMonitor;
        private int fTokenId;

        CommandHandle(MICommand<MIInfo> c, DataRequestMonitor<MIInfo> d) {
            this.fCommand = c;
            this.fRequestMonitor = d;
            this.fTokenId = -1;
        }

        public MICommand<MIInfo> getCommand() {
            return this.fCommand;
        }

        public DataRequestMonitor<MIInfo> getRequestMonitor() {
            return this.fRequestMonitor;
        }

        public void generateTokenId() {
            this.fTokenId = AbstractMIControl.this.getNewTokenId();
        }

        public Integer getTokenId() {
            return this.fTokenId;
        }

        public int getStackFrameId() {
            IStack.IFrameDMContext frameCtx = (IStack.IFrameDMContext)DMContexts.getAncestorOfType((IDMContext)this.fCommand.getContext(), IStack.IFrameDMContext.class);
            if (frameCtx != null) {
                return frameCtx.getLevel();
            }
            return -1;
        }

        public String getThreadId() {
            IMIExecutionDMContext execCtx = (IMIExecutionDMContext)DMContexts.getAncestorOfType((IDMContext)this.fCommand.getContext(), IMIExecutionDMContext.class);
            if (execCtx != null) {
                return execCtx.getThreadId();
            }
            return null;
        }

        public String getGroupId() {
            IMIContainerDMContext containerCtx = (IMIContainerDMContext)DMContexts.getAncestorOfType((IDMContext)this.fCommand.getContext(), IMIContainerDMContext.class);
            if (containerCtx != null) {
                return containerCtx.getGroupId();
            }
            return null;
        }

        public String toString() {
            return String.valueOf(Integer.toString(this.fTokenId)) + this.fCommand;
        }
    }

    private class ErrorThread
    extends Thread {
        private final InputStream fErrorStream;
        private final MIParser fMiParser;

        public ErrorThread(InputStream errorStream) {
            super("MI Error Thread");
            this.fMiParser = new MIParser();
            this.fErrorStream = errorStream;
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.fErrorStream));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    MIOOBRecord oob = this.fMiParser.parseMIOOBRecord("&" + line + "\n");
                    final MIOutput response = new MIOutput(oob, new MIStreamRecord[0]);
                    AbstractMIControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            AbstractMIControl.this.processEvent(response);
                        }

                        public String toString() {
                            return "MI error output received: " + response;
                        }
                    });
                }
            }
            catch (IOException iOException) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
            try {
                this.fErrorStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class RxThread
    extends Thread {
        private final InputStream fInputStream;
        private final MIParser fMiParser;
        private final List<MIOOBRecord> fAccumulatedOOBRecords;
        private final List<MIStreamRecord> fAccumulatedStreamRecords;

        public RxThread(InputStream inputStream) {
            super("MI RX Thread");
            this.fMiParser = new MIParser();
            this.fAccumulatedOOBRecords = new LinkedList<MIOOBRecord>();
            this.fAccumulatedStreamRecords = new LinkedList<MIStreamRecord>();
            this.fInputStream = inputStream;
        }

        @Override
        public void run() {
            BufferedReader reader = new BufferedReader(new InputStreamReader(this.fInputStream));
            try {
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.length() == 0) continue;
                    if (GdbDebugOptions.DEBUG) {
                        if (line.length() < 5000) {
                            GdbDebugOptions.trace(String.format("%s %s  %s\n", GdbPlugin.getDebugTime(), AbstractMIControl.MI_TRACE_IDENTIFIER, line));
                        } else {
                            GdbDebugOptions.trace(String.format("%s %s  %s\n", GdbPlugin.getDebugTime(), AbstractMIControl.MI_TRACE_IDENTIFIER, String.valueOf(line.substring(0, 5000)) + " [remaining output truncated. Refer to 'gdb traces' if full output needed.]"));
                        }
                    }
                    String finalLine = line;
                    if (AbstractMIControl.this.getMITracingStream() != null) {
                        try {
                            String message = String.valueOf(GdbPlugin.getDebugTime()) + " " + finalLine + "\n";
                            while (message.length() > 100) {
                                String partial = String.valueOf(message.substring(0, 100)) + "\\\n";
                                message = message.substring(100);
                                AbstractMIControl.this.getMITracingStream().write(partial.getBytes());
                            }
                            AbstractMIControl.this.getMITracingStream().write(message.getBytes());
                        }
                        catch (IOException e) {
                            AbstractMIControl.this.setMITracingStream(null);
                        }
                    }
                    this.processMIOutput(line);
                }
            }
            catch (IOException iOException) {
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
            try {
                this.fInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private MIResult findResultRecord(MIResult[] results, String variable) {
            int i = 0;
            while (i < results.length) {
                if (variable.equals(results[i].getVariable())) {
                    return results[i];
                }
                ++i;
            }
            return null;
        }

        private String getStatusString(MICommand<MIInfo> origCommand, MIOutput response) {
            String message = null;
            Object[] parameters = null;
            if (response != null && response.getMIResultRecord() != null) {
                MIResult messageRes;
                MIResult[] results = response.getMIResultRecord().getMIResults();
                MIResult paramsRes = this.findResultRecord(results, "parameters");
                if (paramsRes != null && paramsRes.getMIValue() instanceof MIList) {
                    MIValue[] paramValues = ((MIList)paramsRes.getMIValue()).getMIValues();
                    parameters = new String[paramValues.length];
                    int i = 0;
                    while (i < paramValues.length) {
                        parameters[i] = paramValues[i] instanceof MIConst ? ((MIConst)paramValues[i]).getString() : "";
                        ++i;
                    }
                }
                if ((messageRes = this.findResultRecord(results, "message")) != null && messageRes.getMIValue() instanceof MIConst) {
                    message = ((MIConst)messageRes.getMIValue()).getString();
                } else {
                    messageRes = this.findResultRecord(results, "msg");
                    if (messageRes != null && messageRes.getMIValue() instanceof MIConst) {
                        message = ((MIConst)messageRes.getMIValue()).getString();
                    }
                }
            }
            StringBuilder clientMsg = new StringBuilder();
            clientMsg.append("Failed to execute MI command:\n");
            clientMsg.append(origCommand.toString());
            if (message != null) {
                clientMsg.append("Error message from debugger back end:\n");
                if (parameters != null) {
                    try {
                        clientMsg.append(MessageFormat.format(message, parameters));
                    }
                    catch (IllegalArgumentException e2) {
                        clientMsg.append(message);
                        clientMsg.append(Arrays.toString(parameters));
                    }
                } else {
                    clientMsg.append(message);
                }
            }
            return clientMsg.toString();
        }

        private String getBackendMessage(MIOutput response) {
            String message = null;
            String[] parameters = null;
            if (response != null && response.getMIResultRecord() != null) {
                MIResult messageRes;
                MIResult[] results = response.getMIResultRecord().getMIResults();
                MIResult paramsRes = this.findResultRecord(results, "parameters");
                if (paramsRes != null && paramsRes.getMIValue() instanceof MIList) {
                    MIValue[] paramValues = ((MIList)paramsRes.getMIValue()).getMIValues();
                    parameters = new String[paramValues.length];
                    int i = 0;
                    while (i < paramValues.length) {
                        parameters[i] = paramValues[i] instanceof MIConst ? ((MIConst)paramValues[i]).getString() : "";
                        ++i;
                    }
                }
                if ((messageRes = this.findResultRecord(results, "message")) != null && messageRes.getMIValue() instanceof MIConst) {
                    message = ((MIConst)messageRes.getMIValue()).getString();
                } else {
                    messageRes = this.findResultRecord(results, "msg");
                    if (messageRes != null && messageRes.getMIValue() instanceof MIConst) {
                        message = ((MIConst)messageRes.getMIValue()).getString();
                    }
                }
            }
            StringBuilder clientMsg = new StringBuilder();
            if (message != null) {
                if (parameters != null) {
                    try {
                        clientMsg.append(MessageFormat.format(message, parameters));
                    }
                    catch (IllegalArgumentException e2) {
                        clientMsg.append(message);
                        clientMsg.append(Arrays.toString(parameters));
                    }
                } else {
                    clientMsg.append(message);
                }
            }
            return clientMsg.toString();
        }

        void processMIOutput(String line) {
            MIParser.RecordType recordType = this.fMiParser.getRecordType(line);
            if (recordType == MIParser.RecordType.ResultRecord) {
                MIResultRecord rr = this.fMiParser.parseMIResultRecord(line);
                int id = rr.getToken();
                final CommandHandle commandHandle = (CommandHandle)AbstractMIControl.this.fRxCommands.remove(id);
                if (commandHandle != null) {
                    MIOutput response = new MIOutput(rr, this.fAccumulatedOOBRecords.toArray(new MIOOBRecord[this.fAccumulatedOOBRecords.size()]));
                    this.fAccumulatedOOBRecords.clear();
                    this.fAccumulatedStreamRecords.clear();
                    MIInfo result = commandHandle.getCommand().getResult(response);
                    DataRequestMonitor<MIInfo> rm = commandHandle.getRequestMonitor();
                    if (rm != null) {
                        rm.setData((Object)result);
                        String errorResult = rr.getResultClass();
                        if (errorResult.equals("error")) {
                            String status = this.getStatusString((MICommand<MIInfo>)commandHandle.getCommand(), response);
                            String message = this.getBackendMessage(response);
                            Exception exception = new Exception(message);
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.cdt.dsf.gdb", 10004, status, (Throwable)exception));
                        }
                        final MIInfo finalResult = result;
                        AbstractMIControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                if (commandHandle.getRequestMonitor() != null) {
                                    commandHandle.getRequestMonitor().done();
                                }
                                AbstractMIControl.this.processCommandDone(commandHandle, finalResult);
                            }

                            public String toString() {
                                return "MI command output received for: " + commandHandle.getCommand();
                            }
                        });
                    } else {
                        final MIInfo finalResult = result;
                        AbstractMIControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                            public void run() {
                                AbstractMIControl.this.processCommandDone(commandHandle, finalResult);
                            }

                            public String toString() {
                                return "MI command output received for: " + commandHandle.getCommand();
                            }
                        });
                    }
                } else {
                    final MIOutput response = new MIOutput(rr, new MIOOBRecord[0]);
                    AbstractMIControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                        public void run() {
                            AbstractMIControl.this.processEvent(response);
                        }

                        public String toString() {
                            return "MI asynchronous output received: " + response;
                        }
                    });
                }
            } else if (recordType == MIParser.RecordType.OOBRecord) {
                MIOOBRecord oob = this.fMiParser.parseMIOOBRecord(line);
                this.fAccumulatedOOBRecords.add(oob);
                if (AbstractMIControl.this.fRxCommands.isEmpty() && this.fAccumulatedOOBRecords.size() > 20) {
                    this.fAccumulatedOOBRecords.remove(0);
                }
                final MIOutput response = new MIOutput(oob, this.fAccumulatedStreamRecords.toArray(new MIStreamRecord[this.fAccumulatedStreamRecords.size()]));
                if (oob instanceof MIStreamRecord) {
                    this.fAccumulatedStreamRecords.add((MIStreamRecord)oob);
                    if (this.fAccumulatedStreamRecords.size() > 20) {
                        this.fAccumulatedStreamRecords.remove(0);
                    }
                }
                AbstractMIControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                    public void run() {
                        AbstractMIControl.this.processEvent(response);
                    }

                    public String toString() {
                        return "MI asynchronous output received: " + response;
                    }
                });
            }
            AbstractMIControl.this.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    AbstractMIControl.this.processNextQueuedCommand();
                }
            });
        }
    }

    private class TxThread
    extends Thread {
        private final OutputStream fOutputStream;

        public TxThread(OutputStream outStream) {
            super("MI TX Thread");
            this.fOutputStream = outStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                CommandHandle commandHandle = null;
                BlockingQueue blockingQueue = AbstractMIControl.this.fTxCommands;
                synchronized (blockingQueue) {
                    try {
                        commandHandle = (CommandHandle)AbstractMIControl.this.fTxCommands.take();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    if (commandHandle == AbstractMIControl.this.fTerminatorHandle) {
                        break;
                    }
                    if (!(commandHandle.getCommand() instanceof RawCommand)) {
                        AbstractMIControl.this.fRxCommands.put(commandHandle.getTokenId(), commandHandle);
                    }
                }
                String str = commandHandle.getCommand() instanceof RawCommand ? commandHandle.getCommand().constructCommand() : (AbstractMIControl.this.fUseThreadGroupOption ? commandHandle.getTokenId() + commandHandle.getCommand().constructCommand(commandHandle.getGroupId(), commandHandle.getThreadId(), commandHandle.getStackFrameId()) : (AbstractMIControl.this.fUseThreadAndFrameOptions ? commandHandle.getTokenId() + commandHandle.getCommand().constructCommand(commandHandle.getThreadId(), commandHandle.getStackFrameId()) : commandHandle.getTokenId() + commandHandle.getCommand().constructCommand()));
                try {
                    if (this.fOutputStream == null) continue;
                    if (GdbDebugOptions.DEBUG) {
                        GdbDebugOptions.trace(String.format("%s %s  %s", GdbPlugin.getDebugTime(), AbstractMIControl.MI_TRACE_IDENTIFIER, str));
                    }
                    if (AbstractMIControl.this.getMITracingStream() != null) {
                        try {
                            String message = String.valueOf(GdbPlugin.getDebugTime()) + " " + str;
                            while (message.length() > 100) {
                                String partial = String.valueOf(message.substring(0, 100)) + "\\\n";
                                message = message.substring(100);
                                AbstractMIControl.this.getMITracingStream().write(partial.getBytes());
                            }
                            AbstractMIControl.this.getMITracingStream().write(message.getBytes());
                        }
                        catch (IOException e) {
                            AbstractMIControl.this.setMITracingStream(null);
                        }
                    }
                    this.fOutputStream.write(str.getBytes());
                    this.fOutputStream.flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                    break;
                }
            }
            try {
                if (this.fOutputStream != null) {
                    this.fOutputStream.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

