/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.qt.core.build;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.core.ConsoleOutputStream;
import org.eclipse.cdt.core.ErrorParserManager;
import org.eclipse.cdt.core.IConsoleParser;
import org.eclipse.cdt.core.IMarkerGenerator;
import org.eclipse.cdt.core.build.CBuildConfiguration;
import org.eclipse.cdt.core.build.ICBuildConfiguration;
import org.eclipse.cdt.core.build.IToolChain;
import org.eclipse.cdt.core.envvar.IEnvironmentVariable;
import org.eclipse.cdt.core.parser.ExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IExtendedScannerInfo;
import org.eclipse.cdt.core.parser.IScannerInfo;
import org.eclipse.cdt.core.resources.IConsole;
import org.eclipse.cdt.internal.qt.core.Activator;
import org.eclipse.cdt.internal.qt.core.Messages;
import org.eclipse.cdt.internal.qt.core.QtInstallManager;
import org.eclipse.cdt.qt.core.IQtBuildConfiguration;
import org.eclipse.cdt.qt.core.IQtInstall;
import org.eclipse.cdt.qt.core.IQtInstallListener;
import org.eclipse.cdt.qt.core.IQtInstallManager;
import org.eclipse.cdt.qt.core.QtInstallEvent;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class QtBuildConfiguration
extends CBuildConfiguration
implements ICBuildConfiguration,
IQtBuildConfiguration,
IQtInstallListener {
    public static final String QMAKE_COMMAND = "cdt.qt.qmake.command";
    public static final String QMAKE_ARGS = "cdt.qt.qmake.args";
    public static final String BUILD_COMMAND = "cdt.qt.buildCommand";
    private static final String QTINSTALL_NAME = "cdt.qt.install.name";
    private static final String QTINSTALL_SPEC = "cdt.qt.install.spec";
    private static final String LAUNCH_MODE = "cdt.qt.launchMode";
    private final String qtInstallSpec;
    private IQtInstall qtInstall;
    private Map<String, String> qtProperties;
    private boolean doFullBuild;
    private IEnvironmentVariable pathVar = new IEnvironmentVariable(){

        public String getValue() {
            return QtBuildConfiguration.this.getQmakeCommand().getParent().toString();
        }

        public int getOperation() {
            return 3;
        }

        public String getName() {
            return "PATH";
        }

        public String getDelimiter() {
            return File.pathSeparator;
        }
    };

    public QtBuildConfiguration(IBuildConfiguration config, String name) throws CoreException {
        super(config, name);
        IQtInstallManager manager = Activator.getService(IQtInstallManager.class);
        manager.addListener(this);
        Preferences settings = this.getSettings();
        String installName = settings.get(QTINSTALL_NAME, "");
        this.qtInstallSpec = settings.get(QTINSTALL_SPEC, "");
        if (!installName.isEmpty()) {
            this.qtInstall = manager.getInstall(Paths.get(installName, new String[0]));
            if (this.qtInstallSpec.isEmpty()) {
                settings.put(QTINSTALL_SPEC, this.qtInstall.getSpec());
                try {
                    settings.flush();
                }
                catch (BackingStoreException e) {
                    Activator.log(e);
                }
            }
        }
        if (this.getQtInstall() == null) {
            throw new CoreException(Activator.error(String.format(Messages.QtBuildConfiguration_ConfigNotFound, name)));
        }
        String oldLaunchMode = settings.get(LAUNCH_MODE, null);
        if (oldLaunchMode != null) {
            this.setLaunchMode(oldLaunchMode);
            settings.remove(LAUNCH_MODE);
            try {
                settings.flush();
            }
            catch (BackingStoreException e) {
                Activator.log(e);
            }
        }
    }

    QtBuildConfiguration(IBuildConfiguration config, String name, IToolChain toolChain, IQtInstall qtInstall, String launchMode) throws CoreException {
        super(config, name, toolChain, launchMode);
        this.qtInstall = qtInstall;
        this.qtInstallSpec = qtInstall.getSpec();
        IQtInstallManager manager = Activator.getService(IQtInstallManager.class);
        manager.addListener(this);
        Preferences settings = this.getSettings();
        settings.put(QTINSTALL_NAME, qtInstall.getQmakePath().toString());
        settings.put(QTINSTALL_SPEC, this.qtInstallSpec);
        if (launchMode != null) {
            settings.put(LAUNCH_MODE, launchMode);
        }
        try {
            settings.flush();
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IQtBuildConfiguration.class)) {
            return (T)this;
        }
        return (T)super.getAdapter(adapter);
    }

    @Override
    public IQtInstall getQtInstall() {
        IQtInstallManager manager;
        Collection<IQtInstall> candidates;
        if (this.qtInstall == null && !this.qtInstallSpec.isEmpty() && !(candidates = (manager = Activator.getService(IQtInstallManager.class)).getInstall(this.qtInstallSpec)).isEmpty()) {
            this.qtInstall = candidates.iterator().next();
        }
        return this.qtInstall;
    }

    @Override
    public void installChanged(QtInstallEvent event) {
        if (event.getType() == QtInstallEvent.REMOVED && event.getInstall().equals(this.qtInstall)) {
            this.qtInstall = null;
        }
    }

    @Override
    public Path getQmakeCommand() {
        return this.getQtInstall().getQmakePath();
    }

    @Override
    public String[] getQmakeConfig() {
        block11: {
            String qmakeArgs = (String)this.getProperties().get(QMAKE_ARGS);
            if (qmakeArgs != null) {
                return qmakeArgs.split(" ");
            }
            String launchMode = this.getLaunchMode();
            if (launchMode == null) break block11;
            switch (launchMode) {
                case "run": {
                    return new String[]{"CONFIG-=debug_and_release", "CONFIG+=release"};
                }
                case "debug": {
                    return new String[]{"CONFIG-=debug_and_release", "CONFIG+=debug"};
                }
            }
            return new String[]{"CONFIG-=debug_and_release", "CONFIG+=launch_mode_" + launchMode};
        }
        return new String[]{"CONFIG+=debug_and_release", "CONFIG+=launch_modeall"};
    }

    public Path getProjectFile() {
        File projectDir = this.getProject().getLocation().toFile();
        File[] proFiles = projectDir.listFiles((dir, name) -> name.endsWith(".pro"));
        if (proFiles.length > 0) {
            return proFiles[0].toPath();
        }
        return null;
    }

    @Override
    @Deprecated
    public Path getProgramPath() throws CoreException {
        String projectName = this.getProject().getName();
        switch (Platform.getOS()) {
            case "macosx": {
                Path appFolder = this.getBuildDirectory().resolve(String.valueOf(projectName) + ".app");
                Path contentsFolder = appFolder.resolve("Contents");
                Path macosFolder = contentsFolder.resolve("MacOS");
                return macosFolder.resolve(projectName);
            }
            case "win32": {
                return this.getBuildDirectory().resolve(String.valueOf(projectName) + ".exe");
            }
            case "linux": {
                return this.getBuildDirectory().resolve(projectName);
            }
        }
        Path releaseFolder = this.getBuildDirectory().resolve("release");
        return releaseFolder.resolve(projectName);
    }

    public String getQtProperty(String key) {
        if (this.qtProperties == null) {
            String[] stringArray;
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add(this.getQmakeCommand().toString());
            cmd.add("-E");
            String[] config = this.getQmakeConfig();
            if (config != null) {
                stringArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    String str = stringArray[n2];
                    cmd.add(str);
                    ++n2;
                }
            }
            cmd.add(this.getProjectFile().toString());
            try {
                ProcessBuilder processBuilder = new ProcessBuilder(cmd).directory(this.getProjectFile().getParent().toFile());
                this.setBuildEnvironment(processBuilder.environment());
                Process proc = processBuilder.start();
                Throwable throwable = null;
                stringArray = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(proc.getInputStream()));){
                    this.qtProperties = new HashMap<String, String>();
                    String line = reader.readLine();
                    while (line != null) {
                        int i = line.indexOf(61);
                        if (i >= 0) {
                            String k = line.substring(0, i);
                            String v = line.substring(i + 1);
                            this.qtProperties.put(k.trim(), v.trim());
                        }
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                Activator.log(e);
            }
        }
        return this.qtProperties != null ? this.qtProperties.get(key) : null;
    }

    public IEnvironmentVariable getVariable(String name) {
        if ("PATH".equals(name)) {
            return this.pathVar;
        }
        return null;
    }

    public IEnvironmentVariable[] getVariables() {
        return new IEnvironmentVariable[]{this.pathVar};
    }

    public IScannerInfo getScannerInformation(IResource resource) {
        String srcFile;
        IQtInstall qtInstall = this.getQtInstall();
        String cxx = this.getQtProperty("QMAKE_CXX");
        if (cxx == null) {
            Activator.log("No QMAKE_CXX for " + qtInstall.getSpec());
            return null;
        }
        String[] cxxSplit = cxx.split(" ");
        Path command = Paths.get(cxxSplit[0], new String[0]);
        ArrayList<String> args = new ArrayList<String>();
        int i = 1;
        while (i < cxxSplit.length) {
            args.add(cxxSplit[i]);
            ++i;
        }
        args.addAll(Arrays.asList(this.getQtProperty("QMAKE_CXXFLAGS").split(" ")));
        args.add("-o");
        args.add("-");
        if (resource instanceof IFile) {
            srcFile = resource.getLocation().toOSString();
            args.add(srcFile);
        } else {
            srcFile = "scannerInfo.cpp";
        }
        String[] includePaths = this.getQtProperty("INCLUDEPATH").split(" ");
        int i2 = 0;
        while (i2 < includePaths.length) {
            Path path = Paths.get(includePaths[i2], new String[0]);
            if (!path.isAbsolute()) {
                Path projectDir = this.getProjectFile().getParent();
                includePaths[i2] = projectDir.resolve(path).toString();
            }
            ++i2;
        }
        ExtendedScannerInfo baseScannerInfo = new ExtendedScannerInfo(null, includePaths);
        try {
            return this.getToolChain().getScannerInfo(this.getBuildConfiguration(), command, args.toArray(new String[args.size()]), (IExtendedScannerInfo)baseScannerInfo, resource, this.getBuildContainer().getLocationURI());
        }
        catch (CoreException e) {
            Activator.log(e);
            return null;
        }
    }

    public IProject[] build(int kind, Map<String, String> args, IConsole console, IProgressMonitor monitor) throws CoreException {
        String[] makeCommand;
        ConsoleOutputStream outStream;
        IProject project;
        block16: {
            project = this.getProject();
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream errStream = console.getErrorStream();
            outStream = console.getOutputStream();
            makeCommand = this.getMakeCommand();
            if (makeCommand != null) break block16;
            errStream.write(Messages.QtBuildConfiguration_MakeNotFound);
            return null;
        }
        try {
            Path buildDir = this.getBuildDirectory();
            if (this.doFullBuild || !buildDir.resolve("Makefile").toFile().exists()) {
                ArrayList<String> command = new ArrayList<String>();
                command.add(this.getQmakeCommand().toString());
                String[] config = this.getQmakeConfig();
                if (config != null) {
                    String[] stringArray = config;
                    int n = config.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String str = stringArray[n2];
                        command.add(str);
                        ++n2;
                    }
                }
                IFile projectFile = project.getFile(String.valueOf(project.getName()) + ".pro");
                command.add(projectFile.getLocation().toOSString());
                ProcessBuilder processBuilder = new ProcessBuilder(command).directory(this.getBuildDirectory().toFile());
                this.setBuildEnvironment(processBuilder.environment());
                Process process = processBuilder.start();
                StringBuffer msg = new StringBuffer();
                for (String arg : command) {
                    msg.append(arg).append(' ');
                }
                msg.append('\n');
                outStream.write(msg.toString());
                this.watchProcess(process, new IConsoleParser[0], console);
                this.doFullBuild = false;
            }
            Throwable throwable = null;
            Object var11_13 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                ArrayList<String> command = new ArrayList<String>(Arrays.asList(makeCommand));
                command.add("all");
                ProcessBuilder processBuilder = new ProcessBuilder(command).directory(buildDir.toFile());
                this.setBuildEnvironment(processBuilder.environment());
                Process process = processBuilder.start();
                outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
                this.watchProcess(process, new IConsoleParser[]{epm}, console);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            this.getProject().refreshLocal(2, monitor);
            return new IProject[]{project};
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.qt.core", "Building " + project.getName(), (Throwable)e));
        }
    }

    public void clean(IConsole console, IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.cdt.core.problem", false, 2);
            ConsoleOutputStream errStream = console.getErrorStream();
            ConsoleOutputStream outStream = console.getOutputStream();
            String[] makeCommand = this.getMakeCommand();
            if (makeCommand == null) {
                errStream.write(Messages.QtBuildConfiguration_MakeNotFound);
                return;
            }
            Path buildDir = this.getBuildDirectory();
            Throwable throwable = null;
            Object var9_11 = null;
            try (ErrorParserManager epm = new ErrorParserManager(project, this.getBuildDirectoryURI(), (IMarkerGenerator)this, this.getToolChain().getErrorParserIds());){
                ArrayList<String> command = new ArrayList<String>(Arrays.asList(makeCommand));
                command.add("clean");
                ProcessBuilder processBuilder = new ProcessBuilder(command).directory(buildDir.toFile());
                this.setBuildEnvironment(processBuilder.environment());
                Process process = processBuilder.start();
                outStream.write(String.valueOf(String.join((CharSequence)" ", command)) + '\n');
                this.watchProcess(process, new IConsoleParser[]{epm}, console);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            project.refreshLocal(2, monitor);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.cdt.qt.core", "Cleaning " + project.getName(), (Throwable)e));
        }
    }

    public String[] getMakeCommand() {
        String buildCommandStr = (String)this.getProperties().get(BUILD_COMMAND);
        if (buildCommandStr != null) {
            String[] buildCommand = buildCommandStr.split(" ");
            Path command = this.findCommand(buildCommand[0]);
            if (command == null && (command = this.findCommand("make")) == null) {
                command = this.findCommand("mingw32-make");
            }
            if (command != null) {
                buildCommand[0] = command.toString();
            }
            return buildCommand;
        }
        return null;
    }

    public Map<String, String> getDefaultProperties() {
        String qmakeArgs;
        Map defaults;
        block13: {
            block11: {
                defaults = super.getDefaultProperties();
                String qmakeCommand = this.qtInstall.getQmakePath().toString();
                defaults.put(QMAKE_COMMAND, qmakeCommand);
                String launchMode = this.getLaunchMode();
                if (launchMode == null) break block11;
                switch (launchMode) {
                    case "run": {
                        qmakeArgs = "CONFIG-=debug_and_release CONFIG+=release";
                        break;
                    }
                    case "debug": {
                        qmakeArgs = "CONFIG-=debug_and_release CONFIG+=debug";
                        break;
                    }
                    default: {
                        qmakeArgs = "CONFIG-=debug_and_release CONFIG+=launch_mode_" + launchMode;
                        break;
                    }
                }
                break block13;
            }
            qmakeArgs = "CONFIG+=debug_and_release CONFIG+=launch_modeall";
        }
        defaults.put(QMAKE_ARGS, qmakeArgs);
        String buildCommand = "make";
        if (this.findCommand(buildCommand) == null && this.findCommand(buildCommand = "mingw32-make") == null) {
            buildCommand = "make";
        }
        defaults.put(BUILD_COMMAND, buildCommand);
        return defaults;
    }

    public boolean setProperties(Map<String, String> properties) {
        if (super.setProperties(properties)) {
            QtInstallManager installManager;
            IQtInstall newInstall;
            String qmakeCommand = properties.get(QMAKE_COMMAND);
            if (qmakeCommand != null && !qmakeCommand.equals(this.qtInstall.getQmakePath().toString()) && (newInstall = (installManager = Activator.getService(QtInstallManager.class)).getInstall(Paths.get(qmakeCommand, new String[0]))) != null) {
                this.qtInstall = newInstall;
            }
            this.doFullBuild = true;
            return true;
        }
        return false;
    }
}

