/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.op.ListRemoteOperation;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.GitFlowOperation;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;

public final class FeatureListOperation
extends GitFlowOperation {
    private static final String FILE = "file:///";
    private static final String REMOTE_ORIGIN_FEATURE_PREFIX = "refs/remotes/origin/";
    private List<Ref> result = new ArrayList<Ref>();
    private int timeout;
    private FetchResult operationResult;

    public FeatureListOperation(GitFlowRepository repository, int timeout) {
        super(repository);
        this.timeout = timeout;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        String uriString = FILE + this.repository.getRepository().getDirectory().getPath();
        try {
            this.operationResult = this.fetch(monitor, this.timeout);
            URIish uri = new URIish(uriString);
            ListRemoteOperation listRemoteOperation = new ListRemoteOperation(this.repository.getRepository(), uri, this.timeout);
            listRemoteOperation.run(monitor);
            Collection remoteRefs = listRemoteOperation.getRemoteRefs();
            for (Ref ref : remoteRefs) {
                if (!ref.getName().startsWith(REMOTE_ORIGIN_FEATURE_PREFIX + this.repository.getConfig().getFeaturePrefix())) continue;
                this.result.add(ref);
            }
        }
        catch (URISyntaxException e) {
            String message = NLS.bind((String)CoreText.FeatureListOperation_unableToParse, (Object)uriString);
            throw new CoreException(Activator.error(message, e));
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new CoreException(Activator.error(targetException.getMessage(), targetException));
        }
        catch (InterruptedException e) {
            throw new CoreException(Activator.error(e.getMessage(), e));
        }
    }

    public FetchResult getOperationResult() {
        return this.operationResult;
    }

    public List<Ref> getResult() {
        return this.result;
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }
}

