/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.jobs;

import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.action.IAction;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressConstants;

public abstract class RepositoryJob
extends Job {
    public RepositoryJob(String name) {
        super(name);
    }

    protected final IStatus run(IProgressMonitor monitor) {
        try {
            IStatus status = this.performJob(monitor);
            if (status == null) {
                IStatus iStatus = Activator.createErrorStatus(MessageFormat.format(UIText.RepositoryJob_NullStatus, this.getName()), new NullPointerException());
                return iStatus;
            }
            if (!status.isOK()) {
                IStatus iStatus = status;
                return iStatus;
            }
            IAction action = this.getAction();
            if (action != null) {
                if (this.isModal()) {
                    this.showResult(action);
                } else {
                    this.setProperty(IProgressConstants.KEEP_PROPERTY, Boolean.TRUE);
                    this.setProperty(IProgressConstants.ACTION_PROPERTY, action);
                    IStatus finalStatus = this.getDeferredStatus();
                    String msg = finalStatus.getMessage();
                    if (msg == null || msg.isEmpty()) {
                        Status status2 = new Status(finalStatus.getSeverity(), finalStatus.getPlugin(), finalStatus.getCode(), action.getText(), finalStatus.getException());
                        return status2;
                    }
                    IStatus iStatus = finalStatus;
                    return iStatus;
                }
            }
            IStatus iStatus = status;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    protected abstract IStatus performJob(IProgressMonitor var1);

    protected abstract IAction getAction();

    @NonNull
    protected IStatus getDeferredStatus() {
        return new Status(0, Activator.getPluginId(), 0, "", null);
    }

    private boolean isModal() {
        Boolean modal = (Boolean)this.getProperty(IProgressConstants.PROPERTY_IN_DIALOG);
        return modal != null && modal != false;
    }

    private void showResult(final IAction action) {
        final Display display = PlatformUI.getWorkbench().getDisplay();
        if (display != null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!display.isDisposed()) {
                        action.run();
                    }
                }
            });
        }
    }
}

