/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecoretools.design.ui.wizard.pages;

import com.google.common.base.Supplier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.logger.RuntimeLoggerManager;
import org.eclipse.sirius.business.api.query.IdentifiedElementQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.MessageTranslator;
import org.eclipse.sirius.common.tools.api.util.ReflectionHelper;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.common.ui.tools.api.util.SWTUtil;
import org.eclipse.sirius.ui.tools.api.Messages;
import org.eclipse.sirius.ui.tools.api.views.ViewHelper;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.IdentifiedElement;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectRootSemanticElementWizardPage
extends WizardPage
implements Supplier<String> {
    private static final String PAGE_TITLE = "Create a new representation";
    private static final String SELECT_SEMANTIC_ELEMENT = "Select the root semantic element for the new representation.";
    private Composite pageComposite;
    private Supplier<RepresentationDescription> representationDescription;
    private Text representationName;
    private final Supplier<Session> root;
    private EObject selectedEObject;
    private FilteredTree tree;
    private TreeViewer treeViewer;

    public SelectRootSemanticElementWizardPage(Supplier<Session> root, Supplier<RepresentationDescription> representationDescription) {
        super(PAGE_TITLE);
        this.setTitle(PAGE_TITLE);
        this.root = root;
        this.setMessage(SELECT_SEMANTIC_ELEMENT);
        this.representationDescription = representationDescription;
    }

    private void computeRepresentationName(EObject selection) {
        IInterpreter interpreter = ((Session)this.root.get()).getInterpreter();
        RepresentationDescription description = (RepresentationDescription)this.representationDescription.get();
        String name = String.valueOf(Messages.createRepresentationInputDialog_NamePrefix) + MessageTranslator.INSTANCE.getMessage((EObject)description, new IdentifiedElementQuery((IdentifiedElement)description).getLabel());
        if (!StringUtil.isEmpty((String)description.getTitleExpression())) {
            try {
                name = interpreter.evaluateString(selection, description.getTitleExpression());
            }
            catch (EvaluationException e) {
                RuntimeLoggerManager.INSTANCE.error((EObject)description, (EStructuralFeature)DescriptionPackage.eINSTANCE.getRepresentationDescription_TitleExpression(), (Throwable)e);
            }
        }
        this.representationName.setText(name);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.pageComposite = new Composite(parent, 0);
        this.pageComposite.setLayout((Layout)new GridLayout());
        this.pageComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        this.treeViewer = this.createTreeViewer(this.pageComposite);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EObject firstElement;
                SelectRootSemanticElementWizardPage.this.selectedEObject = null;
                ISelection selection = event.getSelection();
                if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof EObject && SelectRootSemanticElementWizardPage.this.representationDescription.get() != null && DialectManager.INSTANCE.canCreate(firstElement = (EObject)((StructuredSelection)selection).getFirstElement(), (RepresentationDescription)SelectRootSemanticElementWizardPage.this.representationDescription.get())) {
                    SelectRootSemanticElementWizardPage.this.selectedEObject = firstElement;
                    SelectRootSemanticElementWizardPage.this.computeRepresentationName(SelectRootSemanticElementWizardPage.this.selectedEObject);
                }
                SelectRootSemanticElementWizardPage.this.setPageComplete(SelectRootSemanticElementWizardPage.this.isPageComplete());
            }
        });
        Label nameLabel = new Label(this.pageComposite, 0);
        nameLabel.setText("Name of the representation:");
        nameLabel.setLayoutData((Object)new GridData(4, 1024, false, false));
        this.representationName = new Text(this.pageComposite, 2052);
        this.representationName.setLayoutData((Object)new GridData(4, 1024, false, false));
        this.setControl((Control)this.pageComposite);
    }

    private TreeViewer createTreeViewer(Composite parent) {
        this.tree = SWTUtil.createFilteredTree((Composite)parent, (int)2820, (PatternFilter)new EObjectFilter());
        ReflectionHelper.invokeMethodWithoutException((Object)this.tree, (String)"setQuickSelectionMode", (Class[])new Class[]{Boolean.TYPE}, (Object[])new Object[]{true});
        TreeViewer viewer = this.tree.getViewer();
        GridData gridData = new GridData(4, 4, true, true);
        viewer.getControl().setLayoutData((Object)gridData);
        viewer.getTree().setHeaderVisible(false);
        viewer.getTree().setLinesVisible(false);
        viewer.setContentProvider((IContentProvider)new SessionContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider(ViewHelper.INSTANCE.createAdapterFactory()));
        return viewer;
    }

    public void dispose() {
        super.dispose();
        if (this.tree != null) {
            this.tree.dispose();
        }
        if (this.representationName != null) {
            this.representationName.dispose();
        }
        if (this.pageComposite != null) {
            this.pageComposite.dispose();
        }
    }

    public String get() {
        return this.representationName.getText();
    }

    public EObject getSelectedElement() {
        return this.selectedEObject;
    }

    public boolean isPageComplete() {
        return this.getSelectedElement() != null;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.treeViewer.setInput(this.root.get());
            this.treeViewer.refresh();
            if (this.tree.getFilterControl() != null) {
                this.tree.getFilterControl().setText("*");
            }
        }
    }

    private class EObjectFilter
    extends PatternFilter {
        private EObjectFilter() {
        }

        protected boolean isLeafMatch(Viewer viewer, Object element) {
            EObject firstElement;
            if (SelectRootSemanticElementWizardPage.this.representationDescription.get() != null && element instanceof EObject && DialectManager.INSTANCE.canCreate(firstElement = (EObject)element, (RepresentationDescription)SelectRootSemanticElementWizardPage.this.representationDescription.get())) {
                return super.isLeafMatch(viewer, element);
            }
            return false;
        }
    }

    private static final class SessionContentProvider
    implements ITreeContentProvider {
        private static Object[] empty = new Object[0];

        public void dispose() {
        }

        public Object[] getChildren(Object parentElement) {
            Object[] children = empty;
            if (parentElement instanceof Session) {
                children = ((Session)parentElement).getSemanticResources().toArray();
            } else if (parentElement instanceof EObject) {
                children = ((EObject)parentElement).eContents().toArray();
            } else if (parentElement instanceof Resource) {
                children = ((Resource)parentElement).getContents().toArray();
            }
            return children;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

