/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.parsley.dsl.formatting2;

import com.google.common.base.Objects;
import com.google.inject.Provider;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.parsley.dsl.model.AbstractControlFactory;
import org.eclipse.emf.parsley.dsl.model.AbstractFeatureCaptionProviderWithLabel;
import org.eclipse.emf.parsley.dsl.model.AbstractFeatureProvider;
import org.eclipse.emf.parsley.dsl.model.Backgrounds;
import org.eclipse.emf.parsley.dsl.model.Binding;
import org.eclipse.emf.parsley.dsl.model.BindingsSpecification;
import org.eclipse.emf.parsley.dsl.model.Configurator;
import org.eclipse.emf.parsley.dsl.model.ConfiguratorEClass;
import org.eclipse.emf.parsley.dsl.model.ConfiguratorResourceURI;
import org.eclipse.emf.parsley.dsl.model.ContentProviderChildren;
import org.eclipse.emf.parsley.dsl.model.ContentProviderElements;
import org.eclipse.emf.parsley.dsl.model.ControlFactorySpecification;
import org.eclipse.emf.parsley.dsl.model.ControlFactorySpecifications;
import org.eclipse.emf.parsley.dsl.model.DialogControlFactory;
import org.eclipse.emf.parsley.dsl.model.DialogFeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.EmfMenus;
import org.eclipse.emf.parsley.dsl.model.ExtendsClause;
import org.eclipse.emf.parsley.dsl.model.FeatureAssociatedExpression;
import org.eclipse.emf.parsley.dsl.model.FeatureBackgrounds;
import org.eclipse.emf.parsley.dsl.model.FeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.FeatureFonts;
import org.eclipse.emf.parsley.dsl.model.FeatureForegrounds;
import org.eclipse.emf.parsley.dsl.model.FeatureImages;
import org.eclipse.emf.parsley.dsl.model.FeatureLabels;
import org.eclipse.emf.parsley.dsl.model.FeatureSpecification;
import org.eclipse.emf.parsley.dsl.model.FeatureSpecifications;
import org.eclipse.emf.parsley.dsl.model.FeatureTexts;
import org.eclipse.emf.parsley.dsl.model.FeaturesProvider;
import org.eclipse.emf.parsley.dsl.model.FieldSpecification;
import org.eclipse.emf.parsley.dsl.model.Fonts;
import org.eclipse.emf.parsley.dsl.model.Foregrounds;
import org.eclipse.emf.parsley.dsl.model.FormControlFactory;
import org.eclipse.emf.parsley.dsl.model.FormFeatureCaptionProvider;
import org.eclipse.emf.parsley.dsl.model.Images;
import org.eclipse.emf.parsley.dsl.model.LabelProvider;
import org.eclipse.emf.parsley.dsl.model.MenuBuilder;
import org.eclipse.emf.parsley.dsl.model.Menus;
import org.eclipse.emf.parsley.dsl.model.Model;
import org.eclipse.emf.parsley.dsl.model.ModelPackage;
import org.eclipse.emf.parsley.dsl.model.Module;
import org.eclipse.emf.parsley.dsl.model.PartSpecification;
import org.eclipse.emf.parsley.dsl.model.PartsSpecifications;
import org.eclipse.emf.parsley.dsl.model.PolymorphicSpecification;
import org.eclipse.emf.parsley.dsl.model.ProposalCreator;
import org.eclipse.emf.parsley.dsl.model.ProviderBinding;
import org.eclipse.emf.parsley.dsl.model.ResourceManager;
import org.eclipse.emf.parsley.dsl.model.RowBackgrounds;
import org.eclipse.emf.parsley.dsl.model.RowFonts;
import org.eclipse.emf.parsley.dsl.model.RowForegrounds;
import org.eclipse.emf.parsley.dsl.model.SimpleMethodSpecification;
import org.eclipse.emf.parsley.dsl.model.TableFeaturesProvider;
import org.eclipse.emf.parsley.dsl.model.TableLabelProvider;
import org.eclipse.emf.parsley.dsl.model.TableViewerContentProvider;
import org.eclipse.emf.parsley.dsl.model.Texts;
import org.eclipse.emf.parsley.dsl.model.TypeBinding;
import org.eclipse.emf.parsley.dsl.model.ValueBinding;
import org.eclipse.emf.parsley.dsl.model.ViewSpecification;
import org.eclipse.emf.parsley.dsl.model.ViewerContentProvider;
import org.eclipse.emf.parsley.dsl.model.WithExpressions;
import org.eclipse.emf.parsley.dsl.model.WithExtendsClause;
import org.eclipse.emf.parsley.dsl.model.WithFeatureAssociatedExpressions;
import org.eclipse.emf.parsley.dsl.model.WithFields;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.formatting2.IHiddenRegionFormatter;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegion;
import org.eclipse.xtext.formatting2.regionaccess.ISemanticRegionsFinder;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.annotations.formatting2.XbaseWithAnnotationsFormatter;
import org.eclipse.xtext.xbase.annotations.xAnnotations.XAnnotation;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xtype.XImportSection;

public class EmfParsleyDslFormatter
extends XbaseWithAnnotationsFormatter {
    public void format(Object o, IFormattableDocument document) {
        if (o instanceof AbstractControlFactory) {
            this._format((AbstractControlFactory)o, document);
            return;
        }
        if (o instanceof AbstractFeatureCaptionProviderWithLabel) {
            this._format((AbstractFeatureCaptionProviderWithLabel)o, document);
            return;
        }
        if (o instanceof AbstractFeatureProvider) {
            this._format((AbstractFeatureProvider)o, document);
            return;
        }
        if (o instanceof Configurator) {
            this._format((Configurator)o, document);
            return;
        }
        if (o instanceof FeatureCaptionProvider) {
            this._format((FeatureCaptionProvider)o, document);
            return;
        }
        if (o instanceof LabelProvider) {
            this._format((LabelProvider)o, document);
            return;
        }
        if (o instanceof MenuBuilder) {
            this._format((MenuBuilder)o, document);
            return;
        }
        if (o instanceof ProposalCreator) {
            this._format((ProposalCreator)o, document);
            return;
        }
        if (o instanceof ResourceManager) {
            this._format((ResourceManager)o, document);
            return;
        }
        if (o instanceof TableLabelProvider) {
            this._format((TableLabelProvider)o, document);
            return;
        }
        if (o instanceof TableViewerContentProvider) {
            this._format((TableViewerContentProvider)o, document);
            return;
        }
        if (o instanceof ViewerContentProvider) {
            this._format((ViewerContentProvider)o, document);
            return;
        }
        if (o instanceof ControlFactorySpecification) {
            this._format((ControlFactorySpecification)o, document);
            return;
        }
        if (o instanceof FeatureAssociatedExpression) {
            this._format((FeatureAssociatedExpression)o, document);
            return;
        }
        if (o instanceof FeatureSpecification) {
            this._format((FeatureSpecification)o, document);
            return;
        }
        if (o instanceof Module) {
            this._format((Module)o, document);
            return;
        }
        if (o instanceof ProviderBinding) {
            this._format((ProviderBinding)o, document);
            return;
        }
        if (o instanceof TypeBinding) {
            this._format((TypeBinding)o, document);
            return;
        }
        if (o instanceof ValueBinding) {
            this._format((ValueBinding)o, document);
            return;
        }
        if (o instanceof ViewSpecification) {
            this._format((ViewSpecification)o, document);
            return;
        }
        if (o instanceof BindingsSpecification) {
            this._format((BindingsSpecification)o, document);
            return;
        }
        if (o instanceof ExtendsClause) {
            this._format((ExtendsClause)o, document);
            return;
        }
        if (o instanceof FieldSpecification) {
            this._format((FieldSpecification)o, document);
            return;
        }
        if (o instanceof PolymorphicSpecification) {
            this._format((PolymorphicSpecification)o, document);
            return;
        }
        if (o instanceof Model) {
            this._format((Model)o, document);
            return;
        }
        if (o instanceof PartsSpecifications) {
            this._format((PartsSpecifications)o, document);
            return;
        }
        if (o instanceof SimpleMethodSpecification) {
            this._format((SimpleMethodSpecification)o, document);
            return;
        }
        super.format(o, document);
    }

    public void _format(Model model, @Extension IFormattableDocument document) {
        XImportSection _importSection = model.getImportSection();
        this.format(_importSection, document);
        Module _module = model.getModule();
        this.format(_module, document);
    }

    public void _format(final Module module, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<Module> _function = new Procedures.Procedure1<Module>(){

            public void apply(Module it) {
                ExtendsClause _extendsClause = module.getExtendsClause();
                EmfParsleyDslFormatter.this.format(_extendsClause, document);
                BindingsSpecification _bindingsSpecification = module.getBindingsSpecification();
                EmfParsleyDslFormatter.this.format(_bindingsSpecification, document);
                LabelProvider _labelProvider = module.getLabelProvider();
                EmfParsleyDslFormatter.this.format(_labelProvider, document);
                TableLabelProvider _tableLabelProvider = module.getTableLabelProvider();
                EmfParsleyDslFormatter.this.format(_tableLabelProvider, document);
                FeatureCaptionProvider _featureCaptionProvider = module.getFeatureCaptionProvider();
                EmfParsleyDslFormatter.this.format(_featureCaptionProvider, document);
                FormFeatureCaptionProvider _formFeatureCaptionProvider = module.getFormFeatureCaptionProvider();
                EmfParsleyDslFormatter.this.format(_formFeatureCaptionProvider, document);
                DialogFeatureCaptionProvider _dialogFeatureCaptionProvider = module.getDialogFeatureCaptionProvider();
                EmfParsleyDslFormatter.this.format(_dialogFeatureCaptionProvider, document);
                FeaturesProvider _featuresProvider = module.getFeaturesProvider();
                EmfParsleyDslFormatter.this.format(_featuresProvider, document);
                TableFeaturesProvider _tableFeaturesProvider = module.getTableFeaturesProvider();
                EmfParsleyDslFormatter.this.format(_tableFeaturesProvider, document);
                FormControlFactory _formControlFactory = module.getFormControlFactory();
                EmfParsleyDslFormatter.this.format(_formControlFactory, document);
                DialogControlFactory _dialogControlFactory = module.getDialogControlFactory();
                EmfParsleyDslFormatter.this.format(_dialogControlFactory, document);
                ProposalCreator _proposalCreator = module.getProposalCreator();
                EmfParsleyDslFormatter.this.format(_proposalCreator, document);
                MenuBuilder _menuBuilder = module.getMenuBuilder();
                EmfParsleyDslFormatter.this.format(_menuBuilder, document);
                Configurator _configurator = module.getConfigurator();
                EmfParsleyDslFormatter.this.format(_configurator, document);
                ViewerContentProvider _viewerContentProvider = module.getViewerContentProvider();
                EmfParsleyDslFormatter.this.format(_viewerContentProvider, document);
                TableViewerContentProvider _tableViewerContentProvider = module.getTableViewerContentProvider();
                EmfParsleyDslFormatter.this.format(_tableViewerContentProvider, document);
                PartsSpecifications _partsSpecifications = module.getPartsSpecifications();
                EmfParsleyDslFormatter.this.format(_partsSpecifications, document);
                ResourceManager _resourceManager = module.getResourceManager();
                EmfParsleyDslFormatter.this.format(_resourceManager, document);
            }
        };
        this.indentBlock(module, document, _function);
    }

    public void _format(ExtendsClause extendsclause, @Extension IFormattableDocument document) {
        JvmTypeReference _superType = extendsclause.getSuperType();
        this.format(_superType, document);
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)extendsclause);
        ISemanticRegion _keyword = _regionFor.keyword("extends");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(_keyword, (Procedures.Procedure1)_function);
    }

    public void _format(final BindingsSpecification bindingsspecification, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<BindingsSpecification> _function = new Procedures.Procedure1<BindingsSpecification>(){

            public void apply(BindingsSpecification it) {
                EList<Binding> _bindings = bindingsspecification.getBindings();
                EmfParsleyDslFormatter.this.formatAndSeparateElementsWithNewlines(_bindings, document);
            }
        };
        this.indentBlock(bindingsspecification, document, _function);
    }

    public void _format(TypeBinding typebinding, @Extension IFormattableDocument document) {
        this.oneSpaceAfterKeyword(typebinding, "type", document);
        JvmTypeReference _typeToBind = typebinding.getTypeToBind();
        this.format(_typeToBind, document);
        this.formatBinding(typebinding, document);
    }

    public void _format(ProviderBinding providerbinding, @Extension IFormattableDocument document) {
        this.oneSpaceAfterKeyword(providerbinding, "provide", document);
        JvmTypeReference _type = providerbinding.getType();
        this.format(_type, document);
        this.formatBinding(providerbinding, document);
    }

    public void _format(ValueBinding valuebinding, @Extension IFormattableDocument document) {
        this.oneSpaceAfterKeyword(valuebinding, "value", document);
        JvmTypeReference _typeDecl = valuebinding.getTypeDecl();
        this.format(_typeDecl, document);
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)valuebinding);
        ISemanticRegion _feature = _regionFor.feature((EStructuralFeature)ModelPackage.Literals.VALUE_BINDING__ID);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(_feature, (Procedures.Procedure1)_function);
        this.formatBinding(valuebinding, document);
    }

    private void formatBinding(Binding binding, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)binding);
        ISemanticRegion _keyword = _regionFor.keyword("->");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(_keyword, (Procedures.Procedure1)_function);
        XExpression _to = binding.getTo();
        this.format(_to, document);
    }

    public void _format(final LabelProvider labelprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                Texts _texts = labelprovider.getTexts();
                EmfParsleyDslFormatter.this.formatSpecifications(_texts, document);
                Images _images = labelprovider.getImages();
                EmfParsleyDslFormatter.this.formatSpecifications(_images, document);
                Fonts _fonts = labelprovider.getFonts();
                EmfParsleyDslFormatter.this.formatSpecifications(_fonts, document);
                Foregrounds _foregrounds = labelprovider.getForegrounds();
                EmfParsleyDslFormatter.this.formatSpecifications(_foregrounds, document);
                Backgrounds _backgrounds = labelprovider.getBackgrounds();
                EmfParsleyDslFormatter.this.formatSpecifications(_backgrounds, document);
            }
        };
        this.formatWithFields(labelprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(FieldSpecification expr, @Extension IFormattableDocument document) {
        EList<XAnnotation> _annotations = expr.getAnnotations();
        for (XAnnotation annotations : _annotations) {
            this.format(annotations, document);
        }
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword = _regionFor.keyword("val");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.append(_keyword, (Procedures.Procedure1)_function);
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_1 = _regionFor_1.keyword("var");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.append(_keyword_1, (Procedures.Procedure1)_function_1);
        ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_2 = _regionFor_2.keyword("extension");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.append(_keyword_2, (Procedures.Procedure1)_function_2);
        JvmTypeReference _type = expr.getType();
        Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.append((EObject)_type, (Procedures.Procedure1)_function_3);
        ISemanticRegionsFinder _regionFor_3 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_3 = _regionFor_3.keyword("=");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(_keyword_3, (Procedures.Procedure1)_function_4);
        JvmTypeReference _type_1 = expr.getType();
        this.format(_type_1, document);
        XExpression _right = expr.getRight();
        this.format(_right, document);
        ISemanticRegionsFinder _regionFor_4 = this.textRegionExtensions.regionFor((EObject)expr);
        ISemanticRegion _keyword_4 = _regionFor_4.keyword(";");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_5 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.noSpace();
            }
        };
        document.prepend(_keyword_4, (Procedures.Procedure1)_function_5);
    }

    public void _format(final TableLabelProvider tablelabelprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                FeatureTexts _featureTexts = tablelabelprovider.getFeatureTexts();
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(_featureTexts, document);
                FeatureImages _featureImages = tablelabelprovider.getFeatureImages();
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(_featureImages, document);
                FeatureFonts _featureFonts = tablelabelprovider.getFeatureFonts();
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(_featureFonts, document);
                FeatureForegrounds _featureForegrounds = tablelabelprovider.getFeatureForegrounds();
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(_featureForegrounds, document);
                FeatureBackgrounds _featureBackgrounds = tablelabelprovider.getFeatureBackgrounds();
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(_featureBackgrounds, document);
                RowFonts _rowFonts = tablelabelprovider.getRowFonts();
                EmfParsleyDslFormatter.this.formatSpecifications(_rowFonts, document);
                RowForegrounds _rowForegrounds = tablelabelprovider.getRowForegrounds();
                EmfParsleyDslFormatter.this.formatSpecifications(_rowForegrounds, document);
                RowBackgrounds _rowBackgrounds = tablelabelprovider.getRowBackgrounds();
                EmfParsleyDslFormatter.this.formatSpecifications(_rowBackgrounds, document);
            }
        };
        this.formatWithFields(tablelabelprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(PolymorphicSpecification specification, @Extension IFormattableDocument document) {
        JvmTypeReference _parameterType = specification.getParameterType();
        this.format(_parameterType, document);
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)specification);
        ISemanticRegion _keyword = _regionFor.keyword("->");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(_keyword, (Procedures.Procedure1)_function);
        XExpression _expression = specification.getExpression();
        this.format(_expression, document);
    }

    public void _format(final FeatureCaptionProvider featurecaptionprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                FeatureTexts _featureTexts = featurecaptionprovider.getFeatureTexts();
                Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>(){

                    public List<? extends EObject> get() {
                        FeatureTexts _featureTexts = featurecaptionprovider.getFeatureTexts();
                        return _featureTexts.getSpecifications();
                    }
                };
                EmfParsleyDslFormatter.this.indentBlockAndFormatAndSeparateElementsWithNewlines(_featureTexts, document, (Provider)_function);
            }
        };
        this.formatWithFields(featurecaptionprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final AbstractFeatureCaptionProviderWithLabel featurecaptionprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                FeatureTexts _featureTexts = featurecaptionprovider.getFeatureTexts();
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(_featureTexts, document);
                FeatureLabels _featureLabels = featurecaptionprovider.getFeatureLabels();
                EmfParsleyDslFormatter.this.formatFeatureSpecifications(_featureLabels, document);
            }
        };
        this.formatWithFields(featurecaptionprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(FeatureAssociatedExpression featureassociatedexpression, @Extension IFormattableDocument document) {
        JvmTypeReference _parameterType = featureassociatedexpression.getParameterType();
        this.format(_parameterType, document);
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)featureassociatedexpression);
        ISemanticRegion _keyword = _regionFor.keyword(":");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(_keyword, (Procedures.Procedure1)_function);
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)featureassociatedexpression);
        ISemanticRegion _keyword_1 = _regionFor_1.keyword("->");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(_keyword_1, (Procedures.Procedure1)_function_1);
        XExpression _expression = featureassociatedexpression.getExpression();
        this.format(_expression, document);
    }

    public void _format(final AbstractFeatureProvider featuresprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                FeatureSpecifications _features = featuresprovider.getFeatures();
                Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>(){

                    public List<? extends EObject> get() {
                        FeatureSpecifications _features = featuresprovider.getFeatures();
                        return _features.getFeatureSpecifications();
                    }
                };
                EmfParsleyDslFormatter.this.indentBlockAndFormatAndSeparateElementsWithNewlines(_features, document, (Provider)_function);
            }
        };
        this.formatWithFields(featuresprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(FeatureSpecification featurespecification, @Extension IFormattableDocument document) {
        JvmTypeReference _parameterType = featurespecification.getParameterType();
        this.format(_parameterType, document);
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)featurespecification);
        ISemanticRegion _keyword = _regionFor.keyword("->");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(_keyword, (Procedures.Procedure1)_function);
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)featurespecification);
        List _keywords = _regionFor_1.keywords(new String[]{","});
        for (ISemanticRegion comma : _keywords) {
            Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.noSpace();
                }
            };
            ISemanticRegion _prepend = document.prepend(comma, (Procedures.Procedure1)_function_1);
            Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                public void apply(IHiddenRegionFormatter it) {
                    it.oneSpace();
                }
            };
            document.append(_prepend, (Procedures.Procedure1)_function_2);
        }
    }

    public void _format(final AbstractControlFactory controlfactory, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                ControlFactorySpecifications _controls = controlfactory.getControls();
                Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>(){

                    public List<? extends EObject> get() {
                        ControlFactorySpecifications _controls = controlfactory.getControls();
                        return _controls.getSpecifications();
                    }
                };
                EmfParsleyDslFormatter.this.indentBlockAndFormatAndSeparateElementsWithNewlines(_controls, document, (Provider)_function);
            }
        };
        this.formatWithFields(controlfactory, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(ControlFactorySpecification controlfactoryspecification, @Extension IFormattableDocument document) {
        JvmTypeReference _parameterType = controlfactoryspecification.getParameterType();
        this.format(_parameterType, document);
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor((EObject)controlfactoryspecification);
        ISemanticRegion _keyword = _regionFor.keyword(":");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(_keyword, (Procedures.Procedure1)_function);
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor((EObject)controlfactoryspecification);
        ISemanticRegion _keyword_1 = _regionFor_1.keyword("->");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(_keyword_1, (Procedures.Procedure1)_function_1);
        XExpression _expression = controlfactoryspecification.getExpression();
        this.format(_expression, document);
        ISemanticRegionsFinder _regionFor_2 = this.textRegionExtensions.regionFor((EObject)controlfactoryspecification);
        ISemanticRegion _keyword_2 = _regionFor_2.keyword("target");
        Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        document.surround(_keyword_2, (Procedures.Procedure1)_function_2);
        XExpression _target = controlfactoryspecification.getTarget();
        this.format(_target, document);
    }

    public void _format(final ProposalCreator proposalcreator, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                EList<FeatureAssociatedExpression> _proposalsSpecifications = proposalcreator.getProposalsSpecifications();
                EmfParsleyDslFormatter.this.formatAndSeparateElementsWithNewlines(_proposalsSpecifications, document);
            }
        };
        this.formatWithFields(proposalcreator, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final MenuBuilder menubuilder, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                Menus _menus = menubuilder.getMenus();
                EmfParsleyDslFormatter.this.formatSpecifications(_menus, document);
                EmfMenus _emfMenus = menubuilder.getEmfMenus();
                EmfParsleyDslFormatter.this.formatSpecifications(_emfMenus, document);
            }
        };
        this.formatWithFields(menubuilder, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final Configurator configurator, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                ConfiguratorResourceURI _resourceURI = configurator.getResourceURI();
                EmfParsleyDslFormatter.this.formatSpecifications(_resourceURI, document);
                ConfiguratorEClass _eClassSpec = configurator.getEClassSpec();
                EmfParsleyDslFormatter.this.formatSpecifications(_eClassSpec, document);
            }
        };
        this.formatWithFields(configurator, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final ViewerContentProvider viewercontentprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                ContentProviderElements _elements = viewercontentprovider.getElements();
                EmfParsleyDslFormatter.this.formatSpecifications(_elements, document);
                ContentProviderChildren _children = viewercontentprovider.getChildren();
                EmfParsleyDslFormatter.this.formatSpecifications(_children, document);
            }
        };
        this.formatWithFields(viewercontentprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final TableViewerContentProvider tableviewercontentprovider, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                ContentProviderElements _elements = tableviewercontentprovider.getElements();
                EmfParsleyDslFormatter.this.formatSpecifications(_elements, document);
            }
        };
        this.formatWithFields(tableviewercontentprovider, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(final ResourceManager resourcemanager, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<WithFields> _function = new Procedures.Procedure1<WithFields>(){

            public void apply(WithFields it) {
                SimpleMethodSpecification _initializeBody = resourcemanager.getInitializeBody();
                EmfParsleyDslFormatter.this.format(_initializeBody, document);
                SimpleMethodSpecification _saveBody = resourcemanager.getSaveBody();
                EmfParsleyDslFormatter.this.format(_saveBody, document);
            }
        };
        this.formatWithFields(resourcemanager, document, (Procedures.Procedure1<? super WithFields>)_function);
    }

    public void _format(SimpleMethodSpecification simplemethodspecification, @Extension IFormattableDocument document) {
        XExpression _body = simplemethodspecification.getBody();
        this.formatAndSeparateWithNewlines(_body, document);
    }

    public void _format(final PartsSpecifications partsspecifications, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<PartsSpecifications> _function = new Procedures.Procedure1<PartsSpecifications>(){

            public void apply(PartsSpecifications it) {
                EList<PartSpecification> _parts = partsspecifications.getParts();
                EmfParsleyDslFormatter.this.formatAndSeparateElementsWithNewlines(_parts, document);
            }
        };
        this.indentBlock(partsspecifications, document, _function);
    }

    public void _format(final ViewSpecification viewspecification, final @Extension IFormattableDocument document) {
        Procedures.Procedure1<ViewSpecification> _function = new Procedures.Procedure1<ViewSpecification>(){

            public void apply(ViewSpecification it) {
                boolean _notEquals;
                ISemanticRegionsFinder _regionFor = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification);
                ISemanticRegion _keyword = _regionFor.keyword("viewpart");
                Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.oneSpace();
                    }
                };
                document.append(_keyword, (Procedures.Procedure1)_function);
                ISemanticRegionsFinder _regionFor_1 = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification);
                ISemanticRegion _keyword_1 = _regionFor_1.keyword("viewname");
                Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.oneSpace();
                    }
                };
                document.append(_keyword_1, (Procedures.Procedure1)_function_1);
                ISemanticRegionsFinder _regionFor_2 = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification);
                ISemanticRegion _feature = _regionFor_2.feature((EStructuralFeature)ModelPackage.Literals.VIEW_SPECIFICATION__VIEW_NAME);
                Procedures.Procedure1<IHiddenRegionFormatter> _function_2 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.setNewLines(1, 1, 2);
                    }
                };
                document.append(_feature, (Procedures.Procedure1)_function_2);
                ISemanticRegionsFinder _regionFor_3 = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification);
                ISemanticRegion _keyword_2 = _regionFor_3.keyword("viewclass");
                Procedures.Procedure1<IHiddenRegionFormatter> _function_3 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.oneSpace();
                    }
                };
                document.append(_keyword_2, (Procedures.Procedure1)_function_3);
                JvmTypeReference _type = viewspecification.getType();
                EmfParsleyDslFormatter.this.format(_type, document);
                JvmTypeReference _type_1 = viewspecification.getType();
                Procedures.Procedure1<IHiddenRegionFormatter> _function_4 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                    public void apply(IHiddenRegionFormatter it) {
                        it.setNewLines(1, 1, 2);
                    }
                };
                document.append((EObject)_type_1, (Procedures.Procedure1)_function_4);
                String _category = viewspecification.getCategory();
                boolean bl = _notEquals = !Objects.equal((Object)_category, null);
                if (_notEquals) {
                    ISemanticRegionsFinder _regionFor_4 = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification);
                    ISemanticRegion _keyword_3 = _regionFor_4.keyword("viewcategory");
                    Procedures.Procedure1<IHiddenRegionFormatter> _function_5 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                        public void apply(IHiddenRegionFormatter it) {
                            it.oneSpace();
                        }
                    };
                    document.append(_keyword_3, (Procedures.Procedure1)_function_5);
                    ISemanticRegionsFinder _regionFor_5 = EmfParsleyDslFormatter.this.textRegionExtensions.regionFor((EObject)viewspecification);
                    ISemanticRegion _feature_1 = _regionFor_5.feature((EStructuralFeature)ModelPackage.Literals.VIEW_SPECIFICATION__CATEGORY);
                    Procedures.Procedure1<IHiddenRegionFormatter> _function_6 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

                        public void apply(IHiddenRegionFormatter it) {
                            it.setNewLines(1, 1, 2);
                        }
                    };
                    document.append(_feature_1, (Procedures.Procedure1)_function_6);
                }
            }
        };
        this.indentBlock(viewspecification, document, _function);
    }

    private WithExtendsClause formatWithFields(final WithFields e, final @Extension IFormattableDocument document, final Procedures.Procedure1<? super WithFields> elementsFormatter) {
        Procedures.Procedure1<WithExtendsClause> _function = new Procedures.Procedure1<WithExtendsClause>(){

            public void apply(WithExtendsClause it) {
                EmfParsleyDslFormatter.this.formatFields(e, document);
                elementsFormatter.apply((Object)e);
            }
        };
        return this.formatWithExtendsClause(e, document, (Procedures.Procedure1<? super WithExtendsClause>)_function);
    }

    private WithExtendsClause formatWithExtendsClause(final WithExtendsClause e, @Extension IFormattableDocument document, final Procedures.Procedure1<? super WithExtendsClause> elementsFormatter) {
        WithExtendsClause _xblockexpression = null;
        ExtendsClause _extendsClause = e.getExtendsClause();
        this.format(_extendsClause, document);
        Procedures.Procedure1<WithExtendsClause> _function = new Procedures.Procedure1<WithExtendsClause>(){

            public void apply(WithExtendsClause it) {
                elementsFormatter.apply((Object)e);
            }
        };
        this.indentBlock(e, document, _function);
        _xblockexpression = this.separateElementsWithNewlines(e, document);
        return _xblockexpression;
    }

    private void formatFields(WithFields withFields, @Extension IFormattableDocument document) {
        EList<FieldSpecification> _fields = withFields.getFields();
        this.formatAndSeparateElementsWithNewlines((List)_fields, document);
    }

    private <T extends EObject> EObject formatSpecifications(final WithExpressions e, @Extension IFormattableDocument document) {
        Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>(){

            public List<? extends EObject> get() {
                return e.getSpecifications();
            }
        };
        return this.indentBlockAndFormatAndSeparateElementsWithNewlines(e, document, _function);
    }

    private <T extends EObject> EObject formatFeatureSpecifications(final WithFeatureAssociatedExpressions e, @Extension IFormattableDocument document) {
        Provider<List<? extends EObject>> _function = new Provider<List<? extends EObject>>(){

            public List<? extends EObject> get() {
                return e.getSpecifications();
            }
        };
        return this.indentBlockAndFormatAndSeparateElementsWithNewlines(e, document, _function);
    }

    private <T extends EObject> EObject indentBlockAndFormatAndSeparateElementsWithNewlines(EObject parent, final @Extension IFormattableDocument document, Provider<List<? extends T>> elementsProvider) {
        boolean _notEquals;
        EObject _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)parent, null);
        if (_notEquals) {
            EObject _xblockexpression = null;
            final List list = (List)elementsProvider.get();
            Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

                public void apply(EObject it) {
                    EmfParsleyDslFormatter.this.formatAndSeparateElementsWithNewlines(list, document);
                }
            };
            this.indentBlock(parent, document, _function);
            _xifexpression = _xblockexpression = this.separateElementsWithNewlines(parent, document);
        }
        return _xifexpression;
    }

    private <T extends EObject> void formatAndSeparateElementsWithNewlines(List<? extends T> elements, @Extension IFormattableDocument document) {
        for (EObject e : elements) {
            this.formatAndSeparateWithNewlines(e, document);
        }
    }

    private <T extends EObject> T formatAndSeparateWithNewlines(T e, IFormattableDocument document) {
        T _xblockexpression = null;
        this.format(e, document);
        _xblockexpression = this.separateElementsWithNewlines(e, document);
        return _xblockexpression;
    }

    private <T extends EObject> ISemanticRegion oneSpaceAfterKeyword(T element, String k, @Extension IFormattableDocument document) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(element);
        ISemanticRegion _keyword = _regionFor.keyword(k);
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.oneSpace();
            }
        };
        return document.append(_keyword, (Procedures.Procedure1)_function);
    }

    private <T extends EObject> T separateElementsWithNewlines(T element, @Extension IFormattableDocument document) {
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.setNewLines(1, 1, 2);
            }
        };
        return (T)document.append(element, (Procedures.Procedure1)_function);
    }

    private <T extends EObject> void indentBlock(T element, @Extension IFormattableDocument document, Procedures.Procedure1<? super T> elementsFormatter) {
        ISemanticRegionsFinder _regionFor = this.textRegionExtensions.regionFor(element);
        ISemanticRegion open = _regionFor.keyword("{");
        ISemanticRegionsFinder _regionFor_1 = this.textRegionExtensions.regionFor(element);
        ISemanticRegion close = _regionFor_1.keyword("}");
        Procedures.Procedure1<IHiddenRegionFormatter> _function = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.newLine();
            }
        };
        document.append(open, (Procedures.Procedure1)_function);
        Procedures.Procedure1<IHiddenRegionFormatter> _function_1 = new Procedures.Procedure1<IHiddenRegionFormatter>(){

            public void apply(IHiddenRegionFormatter it) {
                it.indent();
            }
        };
        document.interior(open, close, (Procedures.Procedure1)_function_1);
        elementsFormatter.apply(element);
    }
}

