/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epp.internal.logging.aeri.ide.server.rest;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.client.cache.HttpCacheEntry;
import org.apache.http.client.cache.HttpCacheStorage;
import org.apache.http.client.cache.HttpCacheUpdateCallback;
import org.apache.http.client.cache.HttpCacheUpdateException;
import org.apache.http.client.cache.Resource;
import org.apache.http.impl.client.cache.HeapResource;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicStatusLine;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;

class LuceneHttpCacheStorage
implements HttpCacheStorage,
Closeable {
    private static final String KEY_FIELD_NAME = "key";
    private static final String REQUEST_DATE_FIELD_NAME = "requestDate";
    private static final String RESPONSE_DATE_FIELD_NAME = "responseDate";
    private static final String STATUS_CODE_FIELD_NAME = "statusLine/statusCode";
    private static final String REASON_PHRASE_FIELD_NAME = "statusLine/reasonPhrase";
    private static final String PROTOCOL_FIELD_NAME = "statusLine/protocolVersion/protocol";
    private static final String MINOR_PROTOCOL_VERSION_FIELD_NAME = "statusLine/protocolVersion/minor";
    private static final String MAJOR_PROTOCAL_VERSION_FIELD_NAME = "statusLine/protocolVersion/major";
    private static final String HEADER_FIELD_NAMES = "header";
    private static final int HEADER_FIELD_NAMES_LENGTH = "header".length();
    private static final String BODY_FIELD_NAME = "body";
    private static final String VARIANT_FIELD_NAMES = "variant";
    private static final int VARIANT_FIELD_NAMES_LENGTH = "variant".length();
    private final IndexWriter writer;
    private final SearcherManager searcherManager;

    LuceneHttpCacheStorage(Directory directory) throws IOException {
        IndexWriterConfig writerConfig = new IndexWriterConfig(Version.LUCENE_35, (Analyzer)new KeywordAnalyzer());
        writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        this.writer = new IndexWriter(directory, writerConfig);
        this.searcherManager = new SearcherManager(this.writer, true, null, null);
    }

    public HttpCacheEntry getEntry(String key) throws IOException {
        this.searcherManager.maybeReopen();
        IndexSearcher searcher = this.searcherManager.acquire();
        try {
            TermQuery query = new TermQuery(new Term(KEY_FIELD_NAME, key));
            TopDocs topDocs = searcher.search((Query)query, 1);
            if (topDocs.totalHits > 1) {
                throw new IOException("Corrupt index (cache key is not unique)");
            }
            ScoreDoc[] scoreDocs = topDocs.scoreDocs;
            if (scoreDocs.length > 0) {
                ScoreDoc scoreDoc = scoreDocs[0];
                Document document = searcher.doc(scoreDoc.doc);
                HttpCacheEntry httpCacheEntry = this.fromLuceneFields(document.getFields());
                return httpCacheEntry;
            }
            return null;
        }
        finally {
            this.searcherManager.release(searcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putEntry(String key, HttpCacheEntry entry) throws IOException {
        Document document = this.toLuceneDocument(key, entry);
        LuceneHttpCacheStorage luceneHttpCacheStorage = this;
        synchronized (luceneHttpCacheStorage) {
            this.writer.updateDocument(new Term(KEY_FIELD_NAME, key), document);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEntry(String key, HttpCacheUpdateCallback callback) throws IOException, HttpCacheUpdateException {
        LuceneHttpCacheStorage luceneHttpCacheStorage = this;
        synchronized (luceneHttpCacheStorage) {
            HttpCacheEntry existingEntry = this.getEntry(key);
            HttpCacheEntry newEntry = callback.update(existingEntry);
            Document newDocument = this.toLuceneDocument(key, newEntry);
            this.writer.updateDocument(new Term(KEY_FIELD_NAME, key), newDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEntry(String key) throws IOException {
        TermQuery query = new TermQuery(new Term(KEY_FIELD_NAME, key));
        LuceneHttpCacheStorage luceneHttpCacheStorage = this;
        synchronized (luceneHttpCacheStorage) {
            this.writer.deleteDocuments((Query)query);
        }
    }

    @Override
    public void close() throws IOException {
        this.searcherManager.close();
        this.writer.close();
    }

    private Document toLuceneDocument(String key, HttpCacheEntry entry) throws IOException {
        Document document = new Document();
        document.add((Fieldable)new Field(KEY_FIELD_NAME, key, Field.Store.NO, Field.Index.NOT_ANALYZED_NO_NORMS));
        for (Fieldable field : this.toLuceneFields(entry)) {
            document.add(field);
        }
        return document;
    }

    private List<Fieldable> toLuceneFields(HttpCacheEntry entry) throws IOException {
        ArrayList<Fieldable> fields = new ArrayList<Fieldable>();
        fields.add((Fieldable)new Field(REQUEST_DATE_FIELD_NAME, Long.toString(entry.getRequestDate().getTime()), Field.Store.YES, Field.Index.NO));
        fields.add((Fieldable)new Field(RESPONSE_DATE_FIELD_NAME, Long.toString(entry.getResponseDate().getTime()), Field.Store.YES, Field.Index.NO));
        StatusLine statusLine = entry.getStatusLine();
        fields.add((Fieldable)new Field(STATUS_CODE_FIELD_NAME, Integer.toString(statusLine.getStatusCode()), Field.Store.YES, Field.Index.NO));
        fields.add((Fieldable)new Field(REASON_PHRASE_FIELD_NAME, statusLine.getReasonPhrase(), Field.Store.YES, Field.Index.NO));
        ProtocolVersion protocolVersion = statusLine.getProtocolVersion();
        fields.add((Fieldable)new Field(PROTOCOL_FIELD_NAME, protocolVersion.getProtocol(), Field.Store.YES, Field.Index.NO));
        fields.add((Fieldable)new Field(MAJOR_PROTOCAL_VERSION_FIELD_NAME, Integer.toString(protocolVersion.getMajor()), Field.Store.YES, Field.Index.NO));
        fields.add((Fieldable)new Field(MINOR_PROTOCOL_VERSION_FIELD_NAME, Integer.toString(protocolVersion.getMinor()), Field.Store.YES, Field.Index.NO));
        Header[] headers = entry.getAllHeaders();
        int index = 0;
        while (index < headers.length) {
            Header header = headers[index];
            fields.add((Fieldable)new Field("header/" + index + '/' + header.getName(), header.getValue(), Field.Store.YES, Field.Index.NO));
            ++index;
        }
        Resource body = entry.getResource();
        if (body != null) {
            fields.add((Fieldable)new Field(BODY_FIELD_NAME, IOUtils.toByteArray((InputStream)body.getInputStream())));
        }
        if (entry.hasVariants()) {
            for (Map.Entry variant : entry.getVariantMap().entrySet()) {
                fields.add((Fieldable)new Field("variant/" + (String)variant.getKey(), (String)variant.getValue(), Field.Store.YES, Field.Index.NO));
            }
        }
        return fields;
    }

    private HttpCacheEntry fromLuceneFields(List<Fieldable> fields) throws IOException {
        Date requestDate = null;
        Date responseDate = null;
        int statusCode = Integer.MIN_VALUE;
        String reasonPhrase = null;
        String protocol = null;
        int majorProtocolVersion = Integer.MIN_VALUE;
        int minorProtocolVersion = Integer.MIN_VALUE;
        ArrayList<BasicHeader> responseHeaders = new ArrayList<BasicHeader>();
        HeapResource body = null;
        HashMap<String, String> variantMap = new HashMap<String, String>();
        for (Fieldable field : fields) {
            String fieldName = field.name();
            if (REQUEST_DATE_FIELD_NAME.equals(fieldName)) {
                requestDate = this.parseDateField(field);
                continue;
            }
            if (RESPONSE_DATE_FIELD_NAME.equals(fieldName)) {
                responseDate = this.parseDateField(field);
                continue;
            }
            if (STATUS_CODE_FIELD_NAME.equals(fieldName)) {
                statusCode = this.parseIntField(field);
                continue;
            }
            if (REASON_PHRASE_FIELD_NAME.equals(fieldName)) {
                reasonPhrase = field.stringValue();
                continue;
            }
            if (PROTOCOL_FIELD_NAME.equals(fieldName)) {
                protocol = field.stringValue();
                continue;
            }
            if (MAJOR_PROTOCAL_VERSION_FIELD_NAME.equals(fieldName)) {
                majorProtocolVersion = this.parseIntField(field);
                continue;
            }
            if (MINOR_PROTOCOL_VERSION_FIELD_NAME.equals(fieldName)) {
                minorProtocolVersion = this.parseIntField(field);
                continue;
            }
            if (fieldName.startsWith(HEADER_FIELD_NAMES)) {
                try {
                    int secondSlash = fieldName.indexOf(47, HEADER_FIELD_NAMES_LENGTH + 1);
                    String indexString = fieldName.substring(HEADER_FIELD_NAMES_LENGTH + 1, secondSlash);
                    int index = Integer.parseInt(indexString);
                    String headerName = fieldName.substring(secondSlash + 1);
                    String headerValue = field.stringValue();
                    BasicHeader header = new BasicHeader(headerName, headerValue);
                    responseHeaders.add(index, header);
                    continue;
                }
                catch (NumberFormatException e) {
                    throw new IOException(e);
                }
            }
            if (BODY_FIELD_NAME.equals(fieldName)) {
                body = new HeapResource(field.getBinaryValue());
                continue;
            }
            if (fieldName.startsWith(VARIANT_FIELD_NAMES)) {
                String variantKey = fieldName.substring(VARIANT_FIELD_NAMES_LENGTH + 1);
                String cacheKey = field.stringValue();
                variantMap.put(variantKey, cacheKey);
                continue;
            }
            throw new IOException("Corrupt index (unknown field: " + fieldName + ")");
        }
        try {
            ProtocolVersion protocolVersion = new ProtocolVersion(protocol, majorProtocolVersion, minorProtocolVersion);
            BasicStatusLine statusLine = new BasicStatusLine(protocolVersion, statusCode, reasonPhrase);
            return new HttpCacheEntry(requestDate, responseDate, (StatusLine)statusLine, responseHeaders.toArray(new Header[responseHeaders.size()]), body, variantMap);
        }
        catch (IllegalArgumentException e) {
            throw new IOException("Corrupt index", e);
        }
    }

    private Date parseDateField(Fieldable field) throws IOException {
        try {
            String stringValue = field.stringValue();
            long longValue = Long.parseLong(stringValue);
            return new Date(longValue);
        }
        catch (NumberFormatException e) {
            throw new IOException(field.name(), e);
        }
    }

    private int parseIntField(Fieldable field) throws IOException {
        try {
            String stringValue = field.stringValue();
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            throw new IOException(field.name(), e);
        }
    }
}

