/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.beans.property;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.eclipse.gef4.common.beans.binding.ListExpressionHelperEx;

public class SimpleListPropertyEx<E>
extends SimpleListProperty<E> {
    private ListExpressionHelperEx<E> helper = null;

    public SimpleListPropertyEx() {
    }

    public SimpleListPropertyEx(Object bean, String name) {
        super(bean, name);
    }

    public SimpleListPropertyEx(Object bean, String name, ObservableList<E> initialValue) {
        super(bean, name, initialValue);
    }

    public SimpleListPropertyEx(ObservableList<E> initialValue) {
        super(initialValue);
    }

    public void addListener(ChangeListener<? super ObservableList<E>> listener) {
        if (this.helper == null) {
            this.helper = new ListExpressionHelperEx(this);
        }
        this.helper.addListener(listener);
    }

    public void addListener(InvalidationListener listener) {
        if (this.helper == null) {
            this.helper = new ListExpressionHelperEx(this);
        }
        this.helper.addListener(listener);
    }

    public void addListener(ListChangeListener<? super E> listener) {
        if (this.helper == null) {
            this.helper = new ListExpressionHelperEx(this);
        }
        this.helper.addListener(listener);
    }

    public void bindBidirectional(Property<ObservableList<E>> other) {
        try {
            super.bindBidirectional(other);
        }
        catch (IllegalArgumentException e) {
            if ("Cannot bind property to itself".equals(e.getMessage()) && this != other) {
                if (other.getValue() == null) {
                    if (this.getValue() == null) {
                        this.setValue(FXCollections.observableList(new ArrayList()));
                    }
                } else if (this.getValue().equals(other)) {
                    this.setValue(null);
                }
                super.bindBidirectional(other);
            }
            throw e;
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof List)) {
            return false;
        }
        if (this.get() == null) {
            return false;
        }
        return this.get().equals(other);
    }

    protected void fireValueChangedEvent() {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent();
        }
    }

    protected void fireValueChangedEvent(ListChangeListener.Change<? extends E> change) {
        if (this.helper != null) {
            this.helper.fireValueChangedEvent(change);
        }
    }

    public int hashCode() {
        return 0;
    }

    public void removeListener(ChangeListener<? super ObservableList<E>> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void removeListener(ListChangeListener<? super E> listener) {
        if (this.helper != null) {
            this.helper.removeListener(listener);
        }
    }

    public void unbindBidirectional(Property<ObservableList<E>> other) {
        try {
            super.unbindBidirectional(other);
        }
        catch (IllegalArgumentException e) {
            if ("Cannot bind property to itself".equals(e.getMessage()) && this != other) {
                ObservableList oldValue = this.getValue();
                if (other.getValue() == null) {
                    this.setValue(FXCollections.observableList(new ArrayList()));
                } else {
                    this.setValue(null);
                }
                super.unbindBidirectional(other);
                this.setValue(oldValue);
            }
            throw e;
        }
    }
}

