/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef4.common.collections;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javafx.beans.InvalidationListener;
import org.eclipse.gef4.common.collections.ObservableSetMultimap;
import org.eclipse.gef4.common.collections.SetMultimapChangeListener;

public class SetMultimapListenerHelper<K, V> {
    private List<InvalidationListener> invalidationListeners = null;
    private List<SetMultimapChangeListener<? super K, ? super V>> setMultimapChangeListeners = null;
    private ObservableSetMultimap<K, V> source;
    private boolean lockInvalidationListeners;
    private boolean lockSetMultimapChangeListeners;

    public SetMultimapListenerHelper(ObservableSetMultimap<K, V> source) {
        this.source = source;
    }

    public void addListener(InvalidationListener listener) {
        if (this.invalidationListeners == null) {
            this.invalidationListeners = new ArrayList<InvalidationListener>();
        }
        if (this.lockInvalidationListeners) {
            this.invalidationListeners = new ArrayList<InvalidationListener>(this.invalidationListeners);
        }
        this.invalidationListeners.add(listener);
    }

    public void addListener(SetMultimapChangeListener<? super K, ? super V> listener) {
        if (this.setMultimapChangeListeners == null) {
            this.setMultimapChangeListeners = new ArrayList<SetMultimapChangeListener<? super K, ? super V>>();
        }
        if (this.lockSetMultimapChangeListeners) {
            this.setMultimapChangeListeners = new ArrayList<SetMultimapChangeListener<K, V>>(this.setMultimapChangeListeners);
        }
        this.setMultimapChangeListeners.add(listener);
    }

    public void fireValueChangedEvent(SetMultimapChangeListener.Change<? extends K, ? extends V> change) {
        this.notifyInvalidationListeners();
        if (change != null) {
            this.notifySetMultimapChangeListeners(change);
        }
    }

    protected ObservableSetMultimap<K, V> getSource() {
        return this.source;
    }

    protected void notifyInvalidationListeners() {
        if (this.invalidationListeners != null) {
            try {
                this.lockInvalidationListeners = true;
                for (InvalidationListener l : this.invalidationListeners) {
                    try {
                        l.invalidated(this.source);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
            }
            finally {
                this.lockInvalidationListeners = false;
            }
        }
    }

    protected void notifySetMultimapChangeListeners(SetMultimapChangeListener.Change<? extends K, ? extends V> change) {
        if (this.setMultimapChangeListeners != null) {
            try {
                this.lockSetMultimapChangeListeners = true;
                for (SetMultimapChangeListener<K, V> setMultimapChangeListener : this.setMultimapChangeListeners) {
                    change.reset();
                    try {
                        setMultimapChangeListener.onChanged(change);
                    }
                    catch (Exception e) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), e);
                    }
                }
            }
            finally {
                this.lockSetMultimapChangeListeners = false;
            }
        }
    }

    public void removeListener(InvalidationListener listener) {
        if (this.invalidationListeners == null) {
            return;
        }
        if (this.lockInvalidationListeners) {
            this.invalidationListeners = new ArrayList<InvalidationListener>(this.invalidationListeners);
        }
        Iterator<InvalidationListener> iterator = this.invalidationListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.invalidationListeners.isEmpty()) {
            this.invalidationListeners = null;
        }
    }

    public void removeListener(SetMultimapChangeListener<? super K, ? super V> listener) {
        if (this.setMultimapChangeListeners == null) {
            return;
        }
        if (this.lockSetMultimapChangeListeners) {
            this.setMultimapChangeListeners = new ArrayList<SetMultimapChangeListener<K, V>>(this.setMultimapChangeListeners);
        }
        Iterator<SetMultimapChangeListener<K, V>> iterator = this.setMultimapChangeListeners.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().equals(listener)) continue;
            iterator.remove();
            break;
        }
        if (this.setMultimapChangeListeners.isEmpty()) {
            this.setMultimapChangeListeners = null;
        }
    }

    public static class AtomicChange<K, V>
    extends SetMultimapChangeListener.Change<K, V> {
        private SetMultimap<K, V> previousContents;
        private ElementarySubChange<K, V>[] elementarySubChanges;
        private int cursor = -1;

        public AtomicChange(ObservableSetMultimap<K, V> source, SetMultimap<K, V> previousContents, ElementarySubChange<K, V> elementarySubChange) {
            super(source);
            this.previousContents = previousContents;
            this.elementarySubChanges = new ElementarySubChange[]{elementarySubChange};
        }

        public AtomicChange(ObservableSetMultimap<K, V> source, SetMultimap<K, V> previousContents, List<ElementarySubChange<K, V>> elementarySubChanges) {
            super(source);
            this.previousContents = previousContents;
            this.elementarySubChanges = elementarySubChanges.toArray(new ElementarySubChange[0]);
        }

        public AtomicChange(ObservableSetMultimap<K, V> source, SetMultimapChangeListener.Change<? extends K, ? extends V> change) {
            super(source);
            this.previousContents = HashMultimap.create(change.getPreviousContents());
            ArrayList<ElementarySubChange<K, ? extends V>> elementarySubChanges = new ArrayList<ElementarySubChange<K, ? extends V>>();
            while (change.next()) {
                elementarySubChanges.add(new ElementarySubChange<K, V>(change.getKey(), change.getValuesRemoved(), change.getValuesAdded()));
            }
            change.reset();
            this.elementarySubChanges = elementarySubChanges.toArray(new ElementarySubChange[0]);
        }

        private void checkCursor() {
            String methodName = Thread.currentThread().getStackTrace()[2].getMethodName();
            if (this.cursor == -1) {
                throw new IllegalStateException("Need to call next() before " + methodName + "() can be called.");
            }
            if (this.cursor >= this.elementarySubChanges.length) {
                throw new IllegalStateException("May only call " + methodName + "() if next() returned true.");
            }
        }

        @Override
        public K getKey() {
            this.checkCursor();
            return this.elementarySubChanges[this.cursor].getKey();
        }

        @Override
        public SetMultimap<K, V> getPreviousContents() {
            return Multimaps.unmodifiableSetMultimap(this.previousContents);
        }

        @Override
        public Set<V> getValuesAdded() {
            this.checkCursor();
            return this.elementarySubChanges[this.cursor].getValuesAdded();
        }

        @Override
        public Set<V> getValuesRemoved() {
            this.checkCursor();
            return this.elementarySubChanges[this.cursor].getValuesRemoved();
        }

        @Override
        public boolean next() {
            ++this.cursor;
            return this.cursor < this.elementarySubChanges.length;
        }

        @Override
        public void reset() {
            this.cursor = -1;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.elementarySubChanges.length) {
                sb.append(this.elementarySubChanges[i].toString());
                if (i < this.elementarySubChanges.length - 1) {
                    sb.append(" ");
                }
                ++i;
            }
            return sb.toString();
        }

        @Override
        public boolean wasAdded() {
            this.checkCursor();
            return this.elementarySubChanges[this.cursor].wasAdded();
        }

        @Override
        public boolean wasRemoved() {
            this.checkCursor();
            return this.elementarySubChanges[this.cursor].wasRemoved();
        }
    }

    public static class ElementarySubChange<K, V> {
        private K key = null;
        private Set<V> removedValues;
        private Set<V> addedValues;

        public ElementarySubChange(K key, Set<? extends V> removedValues, Set<? extends V> addedValues) {
            this.key = key;
            this.removedValues = new HashSet<V>(removedValues);
            this.addedValues = new HashSet<V>(addedValues);
        }

        public K getKey() {
            return this.key;
        }

        public Set<V> getValuesAdded() {
            return this.addedValues;
        }

        public Set<V> getValuesRemoved() {
            return this.removedValues;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            if (this.wasAdded()) {
                if (this.wasRemoved()) {
                    builder.append("Replaced ").append(this.removedValues).append(" by ").append(this.addedValues);
                } else {
                    builder.append("Added ").append(this.addedValues);
                }
            } else {
                builder.append("Removed ").append(this.removedValues);
            }
            builder.append(" for key ").append(this.key).append(".");
            return builder.toString();
        }

        public boolean wasAdded() {
            return !this.addedValues.isEmpty();
        }

        public boolean wasRemoved() {
            return !this.removedValues.isEmpty();
        }
    }
}

