/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarpackagerfat;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarBuilder;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarPackagerUtil;
import org.eclipse.jdt.internal.ui.jarpackagerfat.FatJarRsrcUrlManifestProvider;
import org.eclipse.jdt.ui.jarpackager.IManifestProvider;
import org.eclipse.jdt.ui.jarpackager.JarPackageData;
import org.eclipse.swt.widgets.Shell;

public class FatJarRsrcUrlBuilder
extends FatJarBuilder {
    public static final String BUILDER_ID = "org.eclipse.jdt.ui.fat_jar_rsrc_url_builder";
    public static final String JAR_RSRC_LOADER_ZIP = "jar-in-jar-loader.zip";
    private Set<String> jarNames;
    private JarPackageData fJarPackage;

    @Override
    public String getId() {
        return BUILDER_ID;
    }

    @Override
    public boolean isMergeManifests() {
        return false;
    }

    @Override
    public boolean isRemoveSigners() {
        return false;
    }

    @Override
    public String getManifestClasspath() {
        return ".";
    }

    @Override
    public IManifestProvider getManifestProvider() {
        return new FatJarRsrcUrlManifestProvider(this);
    }

    @Override
    public void open(JarPackageData jarPackage, Shell displayShell, MultiStatus status) throws CoreException {
        super.open(jarPackage, displayShell, status);
        this.fJarPackage = jarPackage;
        this.jarNames = new HashSet<String>();
        try {
            this.writeRsrcUrlClasses();
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", e.getMessage(), (Throwable)e));
        }
    }

    @Override
    public void writeArchive(ZipFile jarFile, IProgressMonitor progressMonitor) {
        File jarPathFile = new File(jarFile.getName());
        String jarName = jarPathFile.getName();
        while (this.jarNames.contains(jarName)) {
            jarName = FatJarPackagerUtil.nextNumberedFileName(jarName);
        }
        this.jarNames.add(jarName);
        JarEntry newEntry = new JarEntry(jarName);
        newEntry.setMethod(0);
        byte[] readBuffer = new byte[4096];
        try {
            if (!this.fJarPackage.isCompressed()) {
                JarPackagerUtil.calculateCrcAndSize(newEntry, new FileInputStream(jarPathFile), readBuffer);
            }
            this.getJarWriter().addZipEntryStream(newEntry, new FileInputStream(jarPathFile), jarName);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeRsrcUrlClasses() throws IOException {
        InputStream is = JavaPlugin.getDefault().getBundle().getEntry(JAR_RSRC_LOADER_ZIP).openStream();
        ZipInputStream zis = new ZipInputStream(is);
        ZipEntry zipEntry = zis.getNextEntry();
        while (zipEntry != null) {
            if (!zipEntry.isDirectory()) {
                String entryName = zipEntry.getName();
                byte[] content = FatJarPackagerUtil.readInputStream(zis);
                this.getJarWriter().addZipEntryStream(zipEntry, new ByteArrayInputStream(content), entryName);
            }
            zipEntry = zis.getNextEntry();
        }
    }
}

