/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.server;

import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jgit.lfs.errors.LfsBandwidthLimitExceeded;
import org.eclipse.jgit.lfs.errors.LfsException;
import org.eclipse.jgit.lfs.errors.LfsInsufficientStorage;
import org.eclipse.jgit.lfs.errors.LfsRateLimitExceeded;
import org.eclipse.jgit.lfs.errors.LfsRepositoryNotFound;
import org.eclipse.jgit.lfs.errors.LfsRepositoryReadOnly;
import org.eclipse.jgit.lfs.errors.LfsUnavailable;
import org.eclipse.jgit.lfs.errors.LfsValidationError;
import org.eclipse.jgit.lfs.server.LargeFileRepository;
import org.eclipse.jgit.lfs.server.LfsObject;
import org.eclipse.jgit.lfs.server.TransferHandler;

public abstract class LfsProtocolServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String CONTENTTYPE_VND_GIT_LFS_JSON = "application/vnd.git-lfs+json; charset=utf-8";
    private static final int SC_RATE_LIMIT_EXCEEDED = 429;
    private static final int SC_BANDWIDTH_LIMIT_EXCEEDED = 509;
    private Gson gson = this.createGson();

    protected abstract LargeFileRepository getLargeFileRepository(LfsRequest var1, String var2) throws LfsException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)res.getOutputStream(), StandardCharsets.UTF_8));
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)req.getInputStream(), StandardCharsets.UTF_8));
        LfsRequest request = (LfsRequest)this.gson.fromJson((Reader)r, LfsRequest.class);
        String path = req.getPathInfo();
        res.setContentType(CONTENTTYPE_VND_GIT_LFS_JSON);
        LargeFileRepository repo = null;
        try {
            repo = this.getLargeFileRepository(request, path);
            if (repo == null) {
                throw new LfsException("unexpected error");
            }
            res.setStatus(200);
            TransferHandler handler = TransferHandler.forOperation(request.operation, repo, request.objects);
            this.gson.toJson((Object)handler.process(), (Appendable)w);
        }
        catch (LfsValidationError e) {
            this.sendError(res, w, 422, e.getMessage());
        }
        catch (LfsRepositoryNotFound e) {
            this.sendError(res, w, 404, e.getMessage());
        }
        catch (LfsRepositoryReadOnly e) {
            this.sendError(res, w, 403, e.getMessage());
        }
        catch (LfsRateLimitExceeded e) {
            this.sendError(res, w, 429, e.getMessage());
        }
        catch (LfsBandwidthLimitExceeded e) {
            this.sendError(res, w, 509, e.getMessage());
        }
        catch (LfsInsufficientStorage e) {
            this.sendError(res, w, 507, e.getMessage());
        }
        catch (LfsUnavailable e) {
            this.sendError(res, w, 503, e.getMessage());
        }
        catch (LfsException e) {
            this.sendError(res, w, 500, e.getMessage());
        }
        finally {
            ((Writer)w).flush();
        }
    }

    private void sendError(HttpServletResponse rsp, Writer writer, int status, String message) {
        rsp.setStatus(status);
        this.gson.toJson((Object)new Error(message), (Appendable)writer);
    }

    private Gson createGson() {
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).disableHtmlEscaping().create();
    }

    static class Error {
        String message;

        Error(String m) {
            this.message = m;
        }
    }

    protected static class LfsRequest {
        private String operation;
        private List<LfsObject> objects;

        protected LfsRequest() {
        }

        public String getOperation() {
            return this.operation;
        }

        public List<LfsObject> getObjects() {
            return this.objects;
        }
    }
}

