/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.lfs.lib;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import org.eclipse.jgit.lfs.internal.LfsText;

public final class Constants {
    public static final String LFS = "lfs";
    public static final String LONG_HASH_FUNCTION = "SHA-256";
    public static final int LONG_OBJECT_ID_LENGTH = 32;
    public static final int LONG_OBJECT_ID_STRING_LENGTH = 64;
    public static final String CONTENT_TYPE_GIT_LFS_JSON = "application/vnd.git-lfs+json";
    public static final String HDR_APPLICATION_OCTET_STREAM = "application/octet-stream";

    public static MessageDigest newMessageDigest() {
        try {
            return MessageDigest.getInstance(LONG_HASH_FUNCTION);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(MessageFormat.format(LfsText.get().requiredHashFunctionNotAvailable, LONG_HASH_FUNCTION), nsae);
        }
    }

    static {
        if (32 != Constants.newMessageDigest().getDigestLength()) {
            throw new LinkageError(LfsText.get().incorrectLONG_OBJECT_ID_LENGTH);
        }
    }
}

