/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jubula.client.core.businessprocess.compcheck.CompletenessGuard;
import org.eclipse.jubula.client.core.businessprocess.compcheck.ProblemPropagator;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.rules.SingleJobRule;
import org.eclipse.jubula.client.core.utils.ITreeNodeOperation;
import org.eclipse.jubula.client.core.utils.TreeTraverser;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.JobUtils;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletenessBP
implements DataEventDispatcher.IProjectStateListener {
    private static Logger log = LoggerFactory.getLogger(CompletenessBP.class);
    private static CompletenessBP instance;

    private CompletenessBP() {
        DataEventDispatcher ded = DataEventDispatcher.getInstance();
        ded.addProjectStateListener((DataEventDispatcher.IProjectStateListener)this);
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        IExecutionListener saveListener = new IExecutionListener(){

            public void preExecute(String commandId, ExecutionEvent event) {
            }

            public void postExecuteSuccess(String commandId, Object returnValue) {
                if (this.isInteresting(commandId)) {
                    CompletenessBP.this.completeProjectCheck();
                }
            }

            public void postExecuteFailure(String commandId, ExecutionException exception) {
                if (this.isInteresting(commandId)) {
                    CompletenessBP.this.completeProjectCheck();
                }
            }

            public void notHandled(String commandId, NotHandledException exception) {
            }

            private boolean isInteresting(String commandId) {
                boolean isInteresting = false;
                if ("org.eclipse.ui.file.save".equals(commandId) || "org.eclipse.ui.file.saveAll".equals(commandId)) {
                    isInteresting = true;
                }
                return isInteresting;
            }
        };
        commandService.addExecutionListener(saveListener);
    }

    public static CompletenessBP getInstance() {
        if (instance == null) {
            instance = new CompletenessBP();
        }
        return instance;
    }

    public void handleProjectStateChanged(DataEventDispatcher.ProjectState state) {
        if (DataEventDispatcher.ProjectState.opened.equals((Object)state)) {
            this.completeProjectCheck();
        }
    }

    public void completeProjectCheck() {
        IProjectPO root = GeneralStorage.getInstance().getProject();
        if (root != null) {
            try {
                IWorkbench workbench = PlatformUI.getWorkbench();
                workbench.getDecoratorManager().setEnabled("org.eclipse.jubula.client.ui.rcp.decorators.completenessCheckDecorator", false);
                UICompletenessCheckOperation cc = new UICompletenessCheckOperation("Completeness Check");
                cc.setRule(SingleJobRule.COMPLETENESSRULE);
                JobUtils.executeJob((Job)cc, null);
                Job[] jobArray = Job.getJobManager().find((Object)cc);
                int n = jobArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Job job = jobArray[n2];
                    if (job != cc) {
                        job.cancel();
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public static class UICompletenessCheckOperation
    extends Job {
        public UICompletenessCheckOperation(String name) {
            super(name);
        }

        public boolean belongsTo(Object family) {
            if (family instanceof UICompletenessCheckOperation) {
                return true;
            }
            return super.belongsTo(family);
        }

        public IStatus run(IProgressMonitor monitor) {
            DataEventDispatcher ded = DataEventDispatcher.getInstance();
            monitor.beginTask(Messages.CompletenessCheckRunningOperation, -1);
            int status = 0;
            try {
                IProjectPO project = GeneralStorage.getInstance().getProject();
                TreeTraverser treeTraverser = new TreeTraverser((INodePO)project, (ITreeNodeOperation)new ProblemPropagator.ProblemCleanupOperation());
                treeTraverser.setMonitor(monitor);
                treeTraverser.traverse(true);
                ded.fireCompletenessCheckStarted();
                CompletenessGuard.checkAll((INodePO)project, (IProgressMonitor)monitor);
            }
            finally {
                if (monitor.isCanceled()) {
                    status = 8;
                } else {
                    ded.fireCompletenessCheckFinished();
                }
                monitor.done();
            }
            return new Status(status, "org.eclipse.jubula.client.core", this.getName());
        }
    }
}

