/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.businessprocess;

import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jubula.client.archive.businessprocess.FileStorageBP;
import org.eclipse.jubula.client.archive.errorhandling.IProjectNameConflictResolver;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.persistence.Persistor;
import org.eclipse.jubula.client.core.persistence.ProjectPM;
import org.eclipse.jubula.client.core.progress.AbstractRunnableWithProgress;
import org.eclipse.jubula.client.core.progress.IProgressConsole;
import org.eclipse.jubula.client.core.utils.DatabaseStateDispatcher;
import org.eclipse.jubula.client.core.utils.DatabaseStateEvent;
import org.eclipse.jubula.client.core.utils.IDatabaseStateListener;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.ComboBoxDialog;
import org.eclipse.jubula.client.ui.rcp.handlers.project.OpenProjectHandler;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportFileBP
implements IProjectNameConflictResolver,
IDatabaseStateListener {
    private static Logger log = LoggerFactory.getLogger(ImportFileBP.class);
    private static ImportFileBP instance = null;

    public ImportFileBP() {
        FileStorageBP.setProjectNameConflictResolver((IProjectNameConflictResolver)this);
        DatabaseStateDispatcher.addDatabaseStateListener((IDatabaseStateListener)this);
    }

    public static ImportFileBP getInstance() {
        if (instance == null) {
            instance = new ImportFileBP();
        }
        return instance;
    }

    public void importProject(final List<URL> fileURLs, final boolean openProject) {
        block12: {
            try {
                if (fileURLs == null) {
                    return;
                }
                try {
                    AbstractRunnableWithProgress<IProjectPO> importProjectRunnable = new AbstractRunnableWithProgress<IProjectPO>(){

                        public void run(IProgressMonitor monitor) throws InterruptedException {
                            monitor.setTaskName(Messages.ImportFileBPWaitWhileImporting);
                            this.setResult(FileStorageBP.importProject((List)fileURLs, (IProgressMonitor)monitor, (IProgressConsole)Plugin.getDefault(), (boolean)openProject));
                            Persistor.instance().updateDbStatistics();
                            ProjectPM.clearCaches();
                        }
                    };
                    PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)importProjectRunnable);
                    IProjectPO projectToOpen = (IProjectPO)importProjectRunnable.getResult();
                    if (projectToOpen == null) break block12;
                    OpenProjectHandler.OpenProjectOperation openOp = new OpenProjectHandler.OpenProjectOperation(projectToOpen);
                    try {
                        PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)openOp);
                    }
                    catch (InvocationTargetException ite) {
                        log.error(Messages.ErrorOccurredDuringImport, ite.getCause());
                        openOp.handleOperationException();
                    }
                    catch (InterruptedException interruptedException) {
                        openOp.handleOperationException();
                    }
                }
                catch (InvocationTargetException ite) {
                    log.error(Messages.ErrorOccurredDuringImport, ite.getCause());
                }
                catch (InterruptedException interruptedException) {
                    this.showCancelImport(Plugin.getDefault());
                }
            }
            finally {
                Plugin.stopLongRunning();
            }
        }
    }

    public void importProjects(IProjectImportInfoProvider importInfo, IProgressMonitor monitor) throws InterruptedException {
        List<URL> fileURLs = importInfo.getFileURLs();
        boolean openProject = importInfo.getIsOpenProject();
        FileStorageBP.importProject(fileURLs, (IProgressMonitor)monitor, (IProgressConsole)Plugin.getDefault(), (boolean)openProject);
    }

    public URL getProjectTemplateUrl() {
        Bundle b = Platform.getBundle((String)"org.eclipse.jubula.client.ui.rcp");
        Enumeration e = b.findEntries("resources/template", "*.jub", false);
        return e.hasMoreElements() ? (URL)e.nextElement() : null;
    }

    public String resolveNameConflict(List<String> availableNames) {
        ComboBoxDialog dialog = new ComboBoxDialog(Plugin.getShell(), new ArrayList<String>(availableNames), Messages.ImportFileComboActionProjMessage, Messages.ImportFileActionProjTitle, IconConstants.IMPORT_PROJECT, Messages.ImportFileActionProjShell, Messages.ImportFileActionProjLabel);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.dialogProjectImportRenameContextId");
        dialog.open();
        return dialog.getReturnCode() == 0 ? dialog.getSelection() : null;
    }

    protected void writeLineToConsole(String string, boolean b) {
        Plugin.getDefault().writeLineToConsole(string, b);
    }

    protected void writeErrorLineToConsole(String string, boolean b) {
        Plugin.getDefault().writeErrorLineToConsole(string, b);
    }

    private void showCancelImport(IProgressConsole console) {
        console.writeErrorLine(NLS.bind((String)Messages.ImportFileActionErrorImportFailed, (Object)Messages.ImportOperationCancelledByUser));
    }

    public void reactOnDatabaseEvent(DatabaseStateEvent e) {
        switch (e.getState()) {
            case DB_SCHEME_CREATED: {
                ImportUnboundModulesJob importUnboundModules = new ImportUnboundModulesJob(org.eclipse.jubula.client.archive.i18n.Messages.ImportUnboundModulesJob);
                importUnboundModules.setUser(true);
                importUnboundModules.schedule();
                break;
            }
        }
    }

    public static interface IProjectImportInfoProvider {
        public List<URL> getFileURLs();

        public boolean getIsOpenProject();
    }

    private final class ImportUnboundModulesJob
    extends Job {
        public ImportUnboundModulesJob(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            Plugin.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Bundle b = Platform.getBundle((String)"org.eclipse.jubula.client.ui.rcp");
                    Enumeration e = b.findEntries("resources/library/", "*.jub", false);
                    ArrayList<URL> unboundModuleURLs = new ArrayList<URL>();
                    while (e.hasMoreElements()) {
                        unboundModuleURLs.add((URL)e.nextElement());
                    }
                    ImportFileBP.this.importProject(unboundModuleURLs, false);
                }
            });
            return Status.OK_STATUS;
        }
    }
}

