/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.widgets;

import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellEditorListener;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jubula.client.core.businessprocess.CompNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ComponentNamesBP;
import org.eclipse.jubula.client.core.businessprocess.ICompNameValidator;
import org.eclipse.jubula.client.core.businessprocess.IComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameMapper;
import org.eclipse.jubula.client.core.businessprocess.ReusedCompNameValidator;
import org.eclipse.jubula.client.core.events.DataChangedEvent;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICompNamesPairPO;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestSuitePO;
import org.eclipse.jubula.client.core.persistence.IncompatibleTypeException;
import org.eclipse.jubula.client.core.persistence.PMAlreadyLockedException;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.ui.constants.IconConstants;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.controllers.PMExceptionHandler;
import org.eclipse.jubula.client.ui.rcp.editors.AbstractTestCaseEditor;
import org.eclipse.jubula.client.ui.rcp.editors.IJBEditor;
import org.eclipse.jubula.client.ui.rcp.editors.JBEditorHelper;
import org.eclipse.jubula.client.ui.rcp.editors.TestSuiteEditor;
import org.eclipse.jubula.client.ui.rcp.i18n.Messages;
import org.eclipse.jubula.client.ui.rcp.utils.Utils;
import org.eclipse.jubula.client.ui.rcp.widgets.CompNameCellValidator;
import org.eclipse.jubula.client.ui.rcp.widgets.CompNamePopupTextCellEditor;
import org.eclipse.jubula.client.ui.utils.ErrorHandlingUtil;
import org.eclipse.jubula.client.ui.utils.LayoutUtil;
import org.eclipse.jubula.tools.internal.exception.Assert;
import org.eclipse.jubula.tools.internal.exception.JBException;
import org.eclipse.jubula.tools.internal.i18n.CompSystemI18n;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbenchPart;

public class ComponentNamesTableComposite
extends Composite
implements DataEventDispatcher.IDataChangedListener {
    private static final String COLUMN_PROPAGATE = "propagate";
    private static final String COLUMN_OLD_NAME = "firstName";
    private static final String COLUMN_NEW_NAME = "secondName";
    private static final String COLUMN_TYPE_NAME = "type";
    private static final int COLUMN_WIDTH = 70;
    private static final int NEW_NAME_COLUMN_WIDTH = 190;
    private CheckboxTableViewer m_tableViewer;
    private CellModifier m_cellModifier;
    private CompNamesBP m_compNamesBP = new CompNamesBP();
    private boolean m_invalidData = false;
    private IExecTestCasePO m_selectedExecNode;
    private IWorkbenchPart m_selectedExecNodeOwner;
    private ICompNamesPairPO m_selectedPair = null;
    private boolean m_editable;
    private CellEditorListener m_cellEditorListener = new CellEditorListener();
    private TableSelectionChangedListener m_selectionChangedListener = new TableSelectionChangedListener();
    private CompNamePopupTextCellEditor m_cellEdit;
    private CheckStateListener m_checkStateListener = new CheckStateListener();
    private IComponentNameMapper m_compMapper;

    public ComponentNamesTableComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout(this);
        Table table = new Table((Composite)this, 67616);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        table.setLayoutData((Object)new GridData(1808));
        TableColumn tc1 = new TableColumn(table, 0x1000000);
        tc1.setImage(IconConstants.PROPAGATE_IMAGE);
        TableColumn tc2 = new TableColumn(table, 16384);
        tc2.setText(Messages.CompNamesViewOldNameColumn);
        TableColumn tc3 = new TableColumn(table, 16384);
        tc3.setText(Messages.CompNamesViewNewNameColumn);
        TableColumn tc4 = new TableColumn(table, 16384);
        tc4.setText(Messages.CompNamesViewTypeColumn);
        ComponentNamesTableCompositeContentProvider provider = new ComponentNamesTableCompositeContentProvider();
        this.m_tableViewer = new CheckboxTableViewer(table);
        this.m_tableViewer.setContentProvider((IContentProvider)provider);
        this.m_tableViewer.setLabelProvider((IBaseLabelProvider)new ComponentNamesTableCompositeLabelProvider());
        this.m_tableViewer.setColumnProperties(new String[]{COLUMN_PROPAGATE, COLUMN_OLD_NAME, COLUMN_NEW_NAME, COLUMN_TYPE_NAME});
        this.setCompMapper(Plugin.getActiveCompMapper());
        this.setCellEdit(new CompNamePopupTextCellEditor(this.getCompMapper(), (Composite)table));
        CellEditor[] cellEditorArray = new CellEditor[4];
        cellEditorArray[2] = this.getCellEdit();
        this.m_tableViewer.setCellEditors(cellEditorArray);
        this.getCellEdit().addListener(this.m_cellEditorListener);
        this.setCellModifier(new CellModifier());
        this.m_tableViewer.setCellModifier((ICellModifier)this.getCellModifier());
        this.m_tableViewer.addCheckStateListener((ICheckStateListener)this.m_checkStateListener);
        this.m_tableViewer.addSelectionChangedListener((ISelectionChangedListener)this.m_selectionChangedListener);
        DataEventDispatcher.getInstance().addDataChangedListener((DataEventDispatcher.IDataChangedListener)this, true);
        Plugin.getHelpSystem().setHelp((Control)this, "org.eclipse.jubula.client.ua.help.compNameViewContextId");
        this.setSelectedExecNode(null);
        this.setSelectedExecNodeOwner(null);
    }

    private void searchAndSetComponentType(ICompNamesPairPO pair) {
        IPersistentObject orig;
        if (!StringUtils.isEmpty((String)pair.getType())) {
            return;
        }
        if (this.getSelectedExecNodeOwner() instanceof IJBEditor && ((orig = ((IJBEditor)this.getSelectedExecNodeOwner()).getEditorHelper().getEditSupport().getOriginal()) instanceof ISpecTestCasePO || orig instanceof ITestSuitePO)) {
            INodePO origNode = (INodePO)orig;
            for (Object node : origNode.getUnmodifiableNodeList()) {
                if (!CompNamesBP.searchCompType((ICompNamesPairPO)pair, node)) continue;
                return;
            }
        }
        if (StringUtils.isEmpty((String)pair.getType())) {
            CompNamesBP.searchCompType((ICompNamesPairPO)pair, (Object)this.getSelectedExecNode());
        }
    }

    private void setLayout(Composite c) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        c.setLayout((Layout)layout);
        GridData layoutData = new GridData(1808);
        layoutData.grabExcessHorizontalSpace = true;
        c.setLayoutData((Object)layoutData);
    }

    private void updateTableInput() {
        boolean editable = false;
        if (this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor) {
            editable = true;
        }
        List input = null;
        if (this.getSelectedExecNode() != null) {
            input = this.m_compNamesBP.getAllCompNamesPairs(this.getSelectedExecNode());
            for (ICompNamesPairPO pair : input) {
                this.searchAndSetComponentType(pair);
            }
            IWorkbenchPart activePart = Plugin.getActivePart();
            if (activePart instanceof IJBEditor) {
                this.setCompMapper((IComponentNameMapper)((IJBEditor)activePart).getEditorHelper().getEditSupport().getCompMapper());
            }
            this.getCellEdit().setValidator(new CompNameCellValidator(this.m_tableViewer, (ICompNameValidator)new ReusedCompNameValidator(this.getCompMapper())));
        }
        this.m_tableViewer.setInput(input);
        this.m_editable = editable;
        TableItem[] tableItemArray = this.m_tableViewer.getTable().getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (editable) {
                item.setForeground(LayoutUtil.DEFAULT_OS_COLOR);
            } else {
                item.setForeground(LayoutUtil.GRAY_COLOR);
            }
            item.setGrayed(!editable);
            ++n2;
        }
        Table table = this.m_tableViewer.getTable();
        if (table.getItemCount() != 0) {
            TableColumn[] columns = table.getColumns();
            int columnCount = columns.length;
            int i = 1;
            while (i < columnCount) {
                TableColumn column = columns[i];
                column.pack();
                if (column.getWidth() < 70) {
                    column.setWidth(70);
                }
                ++i;
            }
            for (ICompNamesPairPO pair : input) {
                this.m_tableViewer.setChecked((Object)pair, pair.isPropagated());
            }
            TableColumn propagationColumn = table.getColumn(0);
            propagationColumn.setResizable(false);
            propagationColumn.setWidth(38);
            TableColumn newNameColumn = table.getColumn(2);
            if (newNameColumn.getWidth() < 190) {
                newNameColumn.setWidth(190);
            }
        }
        this.controlPropagation(editable);
    }

    public void dispose() {
        this.getCellEdit().removeListener(this.m_cellEditorListener);
        this.m_tableViewer.removeCheckStateListener((ICheckStateListener)this.m_checkStateListener);
        this.m_tableViewer.removeSelectionChangedListener((ISelectionChangedListener)this.m_selectionChangedListener);
        this.m_tableViewer = null;
        DataEventDispatcher.getInstance().removeDataChangedListener((DataEventDispatcher.IDataChangedListener)this);
        super.dispose();
    }

    private void updatePropagated(ICompNamesPairPO pair, boolean propagated) {
        if (this.m_compNamesBP.updateCompNamesPair(this.getSelectedExecNode(), pair, propagated)) {
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.getSelectedExecNode(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
        }
    }

    private void updateSecondName(ICompNamesPairPO pair, String secondName) {
        if (!this.getInvalidData()) {
            if (this.getSelectedExecNodeOwner() instanceof IJBEditor) {
                if (this.getSelectedExecNode() != null) {
                    IJBEditor editor = (IJBEditor)this.getSelectedExecNodeOwner();
                    IWritableComponentNameMapper compMapper = editor.getEditorHelper().getEditSupport().getCompMapper();
                    try {
                        if (this.m_compNamesBP.updateCompNamesPair(this.getSelectedExecNode(), pair, secondName, compMapper)) {
                            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)this.getSelectedExecNode(), DataEventDispatcher.DataState.StructureModified, DataEventDispatcher.UpdateState.onlyInEditor);
                        }
                    }
                    catch (IncompatibleTypeException e) {
                        this.setInvalidData(true);
                        ErrorHandlingUtil.createMessageDialog((JBException)e, (Object[])e.getErrorMessageParams(), null);
                    }
                    catch (PMAlreadyLockedException pme) {
                        this.setInvalidData(true);
                        PMExceptionHandler.handlePMAlreadyLockedException(pme, new String[]{Messages.TheComponentName, secondName});
                    }
                    catch (PMException pme) {
                        this.setInvalidData(true);
                        PMExceptionHandler.handlePMExceptionForEditor(pme, editor);
                    }
                }
            } else {
                Assert.notReached((String)Messages.selectedExecNodeOwnerIsNotAnInstanceOfIJBEditor);
            }
        }
    }

    private void setInvalidData(boolean invalidData) {
        this.m_invalidData = invalidData;
    }

    private boolean getInvalidData() {
        return this.m_invalidData;
    }

    public boolean setFocus() {
        return this.m_tableViewer.getTable().setFocus();
    }

    public void setSelectedExecNode(IExecTestCasePO selectedExecNode) {
        this.m_selectedExecNode = selectedExecNode;
        this.updateTableInput();
    }

    private IExecTestCasePO getSelectedExecNode() {
        return this.m_selectedExecNode;
    }

    public void setSelectedExecNodeOwner(IWorkbenchPart selectedExecNodeOwner) {
        this.m_selectedExecNodeOwner = selectedExecNodeOwner;
    }

    private IWorkbenchPart getSelectedExecNodeOwner() {
        return this.m_selectedExecNodeOwner;
    }

    private void setCellModifier(CellModifier cellModifier) {
        this.m_cellModifier = cellModifier;
    }

    private CellModifier getCellModifier() {
        return this.m_cellModifier;
    }

    public void controlPropagation(boolean allow) {
        this.getCellModifier().setModifiable(allow);
    }

    private void setCompMapper(IComponentNameMapper compMapper) {
        this.m_compMapper = compMapper;
    }

    private IComponentNameMapper getCompMapper() {
        return this.m_compMapper;
    }

    private void setCellEdit(CompNamePopupTextCellEditor cellEdit) {
        this.m_cellEdit = cellEdit;
    }

    public CompNamePopupTextCellEditor getCellEdit() {
        return this.m_cellEdit;
    }

    public void handleDataChanged(DataChangedEvent ... events) {
        DataChangedEvent[] dataChangedEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DataChangedEvent e = dataChangedEventArray[n2];
            this.handleDataChanged(e.getPo(), e.getDataState());
            ++n2;
        }
    }

    public void handleDataChanged(IPersistentObject po, DataEventDispatcher.DataState dataState) {
        IExecTestCasePO selectedExecNode = this.getSelectedExecNode();
        if (selectedExecNode != null && selectedExecNode.equals((Object)po)) {
            this.m_tableViewer.refresh();
        }
    }

    private final class CellEditorListener
    implements ICellEditorListener {
        private CellEditorListener() {
        }

        public void applyEditorValue() {
            String newName;
            Object value = ComponentNamesTableComposite.this.getCellEdit().getValue();
            String string = newName = value != null ? value.toString() : "";
            if (ComponentNamesTableComposite.this.getCellEdit().isDirty()) {
                ComponentNamesTableComposite.this.updateSecondName(ComponentNamesTableComposite.this.m_selectedPair, newName);
            }
        }

        public void cancelEditor() {
        }

        public void editorValueChanged(boolean oldValidState, boolean newValidState) {
        }
    }

    private final class CellModifier
    implements ICellModifier {
        private boolean m_modifiable = true;

        private CellModifier() {
        }

        private ICompNamesPairPO getPair(Object element) {
            return (ICompNamesPairPO)(element instanceof Item ? ((Item)element).getData() : element);
        }

        public boolean canModify(Object element, String property) {
            boolean editable = false;
            if (ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor && ((AbstractTestCaseEditor)ComponentNamesTableComposite.this.getSelectedExecNodeOwner()).getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
                editable = true;
            }
            if (editable && element instanceof ICompNamesPairPO) {
                ICompNamesPairPO compNamesPair = (ICompNamesPairPO)element;
                return ComponentNamesTableComposite.COLUMN_NEW_NAME.equals(property) && this.isModifiable() && CompNamesBP.isValidCompNamePair((ICompNamesPairPO)compNamesPair);
            }
            return false;
        }

        public Object getValue(Object element, String property) {
            if (ComponentNamesTableComposite.this.getCompMapper() != null) {
                return ComponentNamesTableComposite.this.getCompMapper().getCompNameCache().getName(this.getPair(element).getSecondName());
            }
            return ComponentNamesBP.getInstance().getName(this.getPair(element).getSecondName());
        }

        public void modify(Object element, String property, Object value) {
            if (this.getValue(element, property).equals(value) || value != null && ((String)value).trim().length() == 0) {
                return;
            }
            ComponentNamesTableComposite.this.updateSecondName(this.getPair(element), (String)value);
        }

        public void setModifiable(boolean modifiable) {
            this.m_modifiable = modifiable;
        }

        public boolean isModifiable() {
            return this.m_modifiable;
        }
    }

    private final class CheckStateListener
    implements ICheckStateListener {
        private CheckStateListener() {
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean editable = false;
            if (ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor && ((AbstractTestCaseEditor)ComponentNamesTableComposite.this.getSelectedExecNodeOwner()).getEditorHelper().requestEditableState() == JBEditorHelper.EditableState.OK) {
                editable = true;
            }
            if (editable) {
                ICompNamesPairPO pair = (ICompNamesPairPO)event.getElement();
                ComponentNamesTableComposite.this.getCellModifier().setModifiable(ComponentNamesTableComposite.this.m_editable && !"".equals(pair.getType()));
                if (!ComponentNamesTableComposite.this.getCellModifier().isModifiable() || ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof TestSuiteEditor) {
                    ComponentNamesTableComposite.this.m_tableViewer.setChecked((Object)pair, pair.isPropagated());
                    return;
                }
                ComponentNamesTableComposite.this.updatePropagated(pair, event.getChecked());
            }
        }
    }

    private class ComponentNamesTableCompositeContentProvider
    implements IStructuredContentProvider {
        private ComponentNamesTableCompositeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)inputElement).toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class ComponentNamesTableCompositeLabelProvider
    implements ITableLabelProvider {
        private ComponentNamesTableCompositeLabelProvider() {
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            ComponentNamesTableComposite.this.searchAndSetComponentType((ICompNamesPairPO)element);
            String type = ((ICompNamesPairPO)element).getType();
            switch (columnIndex) {
                case 0: {
                    if ("".equals(type)) {
                        ComponentNamesTableComposite.this.m_tableViewer.getTable().getColumn(0).pack();
                        return IconConstants.WARNING_IMAGE;
                    }
                    return null;
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            ICompNamesPairPO pair = (ICompNamesPairPO)element;
            Table table = ComponentNamesTableComposite.this.m_tableViewer.getTable();
            switch (columnIndex) {
                case 0: {
                    return "";
                }
                case 1: {
                    if (ComponentNamesTableComposite.this.getCompMapper() != null) {
                        return ComponentNamesTableComposite.this.getCompMapper().getCompNameCache().getName(pair.getFirstName());
                    }
                    return ComponentNamesBP.getInstance().getName(pair.getFirstName());
                }
                case 2: {
                    if (ComponentNamesTableComposite.this.getCompMapper() != null) {
                        return ComponentNamesTableComposite.this.getCompMapper().getCompNameCache().getName(pair.getSecondName());
                    }
                    return ComponentNamesBP.getInstance().getName(pair.getSecondName());
                }
                case 3: {
                    ComponentNamesTableComposite.this.searchAndSetComponentType(pair);
                    String type = pair.getType();
                    int i = 0;
                    while (i < table.getItems().length) {
                        if (table.getItems()[i].getData() != null && table.getItems()[i].getData().equals(pair)) {
                            TableItem item;
                            if ("".equals(type)) {
                                type = "CompNamesView.errorText";
                                item = table.getItem(i);
                                item.setForeground(3, item.getDisplay().getSystemColor(3));
                                item.setFont(3, LayoutUtil.ITALIC_TAHOMA);
                                if (ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor) {
                                    ComponentNamesTableComposite.this.m_tableViewer.setGrayed((Object)pair, false);
                                    ComponentNamesTableComposite.this.m_tableViewer.setChecked((Object)pair, false);
                                }
                            } else {
                                item = table.getItem(i);
                                item.setForeground(3, LayoutUtil.GRAY_COLOR);
                                item.setFont(3, LayoutUtil.NORMAL_TAHOMA);
                                if (ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor) {
                                    item.setForeground(3, LayoutUtil.DEFAULT_OS_COLOR);
                                    ComponentNamesTableComposite.this.m_tableViewer.setGrayed((Object)pair, true);
                                    ComponentNamesTableComposite.this.m_tableViewer.setChecked((Object)pair, true);
                                }
                            }
                        }
                        ++i;
                    }
                    return CompSystemI18n.getString((String)type);
                }
            }
            return null;
        }
    }

    private class TableSelectionChangedListener
    implements ISelectionChangedListener {
        private TableSelectionChangedListener() {
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (!(event.getSelection() instanceof IStructuredSelection)) {
                return;
            }
            Object o = ((IStructuredSelection)event.getSelection()).getFirstElement();
            if (o instanceof ICompNamesPairPO && ComponentNamesTableComposite.this.getSelectedExecNodeOwner() instanceof AbstractTestCaseEditor) {
                ICompNamesPairPO pair = (ICompNamesPairPO)o;
                ComponentNamesTableComposite.this.m_selectedPair = pair;
                ComponentNamesTableComposite.this.getCellModifier().setModifiable(ComponentNamesTableComposite.this.m_editable && !"".equals(pair.getType()));
                if (!ComponentNamesTableComposite.this.getCellModifier().isModifiable()) {
                    return;
                }
                String filter = pair.getType();
                if (filter == null || "".equals(filter)) {
                    IExecTestCasePO execNode = ComponentNamesTableComposite.this.getSelectedExecNode();
                    IPersistentObject po = ((AbstractTestCaseEditor)ComponentNamesTableComposite.this.getSelectedExecNodeOwner()).getEditorHelper().getEditSupport().getOriginal();
                    if (po instanceof ISpecTestCasePO) {
                        for (Object node : ((ISpecTestCasePO)po).getUnmodifiableNodeList()) {
                            if (!node.equals(ComponentNamesTableComposite.this.getSelectedExecNode())) continue;
                            execNode = (IExecTestCasePO)node;
                            break;
                        }
                    }
                    filter = Utils.getComponentType(execNode, pair.getFirstName());
                }
                ComponentNamesTableComposite.this.getCellEdit().setFilter(filter);
                ComponentNamesTableComposite.this.setInvalidData(false);
            } else {
                ComponentNamesTableComposite.this.m_selectedPair = null;
            }
        }
    }
}

