/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.launchbar.ui.internal;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchMode;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.launchbar.core.ILaunchBarManager;
import org.eclipse.launchbar.core.ILaunchDescriptor;
import org.eclipse.launchbar.core.internal.ExecutableExtension;
import org.eclipse.launchbar.core.target.ILaunchTarget;
import org.eclipse.launchbar.ui.ILaunchBarUIManager;
import org.eclipse.launchbar.ui.internal.Activator;
import org.eclipse.launchbar.ui.internal.LaunchBarLaunchConfigDialog;
import org.eclipse.launchbar.ui.internal.Messages;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LaunchBarUIManager
implements ILaunchBarUIManager {
    private Map<String, ExecutableExtension<ILabelProvider>> descriptorLabelProviders = null;
    private ILaunchBarManager manager = Activator.getService(ILaunchBarManager.class);

    private void init() {
        if (this.descriptorLabelProviders == null) {
            IExtension[] extensions;
            this.descriptorLabelProviders = new HashMap<String, ExecutableExtension<ILabelProvider>>();
            IExtensionPoint point = Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.launchbar.ui", "launchBarUIContributions");
            IExtension[] iExtensionArray = extensions = point.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    String elementName = element.getName();
                    if (elementName.equals("descriptorUI")) {
                        String descriptorTypeId = element.getAttribute("descriptorTypeId");
                        ExecutableExtension labelProvider = new ExecutableExtension(element, "labelProvider");
                        this.descriptorLabelProviders.put(descriptorTypeId, (ExecutableExtension<ILabelProvider>)labelProvider);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    @Override
    public ILabelProvider getLabelProvider(ILaunchDescriptor descriptor) throws CoreException {
        this.init();
        ExecutableExtension<ILabelProvider> provider = this.descriptorLabelProviders.get(this.manager.getDescriptorTypeId(descriptor.getType()));
        return provider != null ? (ILabelProvider)provider.get() : null;
    }

    @Override
    public IStatus openConfigurationEditor(ILaunchDescriptor descriptor) {
        if (descriptor == null) {
            return Status.OK_STATUS;
        }
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        IStatus s = this.canOpenConfigurationEditor(descriptor);
        if (!s.isOK()) {
            MessageDialog.openError((Shell)shell, (String)s.getMessage(), (String)(s.getException() == null ? s.getMessage() : s.getException().getMessage()));
            return s;
        }
        try {
            ILaunchMode mode = this.manager.getActiveLaunchMode();
            ILaunchTarget target = this.manager.getActiveLaunchTarget();
            ILaunchConfiguration config = this.manager.getLaunchConfiguration(descriptor, target);
            ILaunchConfigurationWorkingCopy workingCopy = config.getWorkingCopy();
            LaunchBarLaunchConfigDialog dialog = new LaunchBarLaunchConfigDialog(shell, workingCopy, descriptor, mode, target);
            if (dialog.open() == 0 && !workingCopy.getOriginal().equals(workingCopy) && !workingCopy.getOriginal().getAttributes().equals(workingCopy.getAttributes())) {
                workingCopy.doSave();
            }
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private IStatus canOpenConfigurationEditor(ILaunchDescriptor desc) {
        if (desc == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.DescriptorMustNotBeNull, (Throwable)new Exception(Messages.DescriptorMustNotBeNullDesc));
        }
        ILaunchBarManager manager = Activator.getService(ILaunchBarManager.class);
        ILaunchMode mode = null;
        ILaunchTarget target = null;
        try {
            mode = manager.getActiveLaunchMode();
            target = manager.getActiveLaunchTarget();
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        if (target == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.NoActiveTarget, (Throwable)new Exception(Messages.NoActiveTargetDesc));
        }
        ILaunchConfigurationType configType = null;
        try {
            configType = manager.getLaunchConfigurationType(desc, target);
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
        if (mode == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.NoLaunchModeSelected, (Throwable)new Exception(Messages.NoLaunchModeSelected));
        }
        ILaunchGroup group = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(configType, mode.getIdentifier());
        if (group == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.NoLaunchGroupSelected, (Throwable)new Exception(Messages.NoLaunchGroupSelected));
        }
        String mode2 = group.getMode();
        if (mode2 == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.NoLaunchModeSelected, (Throwable)new Exception(Messages.CannotEditLaunchConfiguration));
        }
        LaunchGroupExtension groupExt = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(group.getIdentifier());
        if (groupExt == null) return new Status(4, "org.eclipse.launchbar.ui", Messages.CannotEditLaunchConfiguration, (Throwable)new Exception(Messages.CannotEditLaunchConfiguration));
        ILaunchConfiguration config = null;
        try {
            config = manager.getLaunchConfiguration(desc, target);
        }
        catch (CoreException coreException) {}
        if (config == null) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.LaunchConfigurationNotFound, (Throwable)new Exception(Messages.LaunchConfigurationNotFoundDesc));
        }
        try {
            LaunchConfigurationPresentationManager mgr = LaunchConfigurationPresentationManager.getDefault();
            mgr.getTabGroup(config, mode.getIdentifier());
            return Status.OK_STATUS;
        }
        catch (CoreException coreException) {
            return new Status(4, "org.eclipse.launchbar.ui", Messages.NoLaunchTabsDefined, (Throwable)new Exception(Messages.NoLaunchTabsDefinedDesc));
        }
    }
}

