/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;

public class ResourceCleaner {
    private static final Path EMPTY_PATH = new Path("");
    private final IProject project;
    private List<IFolder> folders = new ArrayList<IFolder>();
    private List<IFile> files = new ArrayList<IFile>();
    private Set<IFolder> keepers = new HashSet<IFolder>();

    public ResourceCleaner(IProject project) {
        this.project = project;
    }

    public ResourceCleaner(IProject project, IFolder ... foldersToKeep) {
        this.project = project;
        if (foldersToKeep != null) {
            IFolder[] iFolderArray = foldersToKeep;
            int n = foldersToKeep.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder folder = iFolderArray[n2];
                if (folder != null) {
                    this.keepers.add(folder);
                    IContainer parent = folder.getParent();
                    while (parent instanceof IFolder) {
                        this.keepers.add((IFolder)parent);
                        parent = parent.getParent();
                    }
                }
                ++n2;
            }
        }
    }

    public void addFolder(IPath folderPath) {
        if (folderPath == null || EMPTY_PATH.equals((Object)folderPath)) {
            return;
        }
        this.addFolder(this.project.getFolder(folderPath));
    }

    public void addFolder(IFolder folder) {
        if (folder != null && !folder.exists() && !folder.getProject().getFullPath().equals((Object)folder.getFullPath())) {
            this.folders.add(folder);
            this.addInexistentParentFolders((IResource)folder);
        }
    }

    public void addFiles(IPath ... filePaths) {
        if (filePaths == null) {
            return;
        }
        IPath[] iPathArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            IPath fileName = iPathArray[n2];
            IFile fileToDelete = this.project.getFile(fileName);
            if (!fileToDelete.exists()) {
                this.files.add(fileToDelete);
                this.addInexistentParentFolders((IResource)fileToDelete);
            }
            ++n2;
        }
    }

    public void addFiles(IFile ... filesToDelete) {
        if (filesToDelete == null) {
            return;
        }
        IFile[] iFileArray = filesToDelete;
        int n = filesToDelete.length;
        int n2 = 0;
        while (n2 < n) {
            IFile fileToDelete = iFileArray[n2];
            if (!fileToDelete.exists()) {
                this.files.add(fileToDelete);
                this.addInexistentParentFolders((IResource)fileToDelete);
            }
            ++n2;
        }
    }

    public void cleanUp() throws CoreException {
        NullProgressMonitor monitor = new NullProgressMonitor();
        for (IFile file : this.files) {
            if (!file.exists()) continue;
            file.delete(true, (IProgressMonitor)monitor);
        }
        for (IFolder folder : this.folders) {
            if (!folder.exists() || folder.members().length != 0) continue;
            folder.delete(true, (IProgressMonitor)monitor);
        }
    }

    protected void addInexistentParentFolders(IResource resource) {
        IContainer parentContainer = resource.getParent();
        while (parentContainer instanceof IFolder) {
            if (this.keepers.contains(parentContainer) || parentContainer.exists()) break;
            IFolder parent = (IFolder)parentContainer;
            this.folders.add(parent);
            parentContainer = parentContainer.getParent();
        }
    }
}

