/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.internal.conversion;

import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.model.Build;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jst.j2ee.project.facet.IJ2EEFacetConstants;
import org.eclipse.jst.j2ee.web.project.facet.WebFacetUtils;
import org.eclipse.m2e.wtp.WTPProjectsUtil;
import org.eclipse.m2e.wtp.internal.conversion.AbstractWtpProjectConversionParticipant;
import org.eclipse.m2e.wtp.internal.conversion.MavenPluginUtils;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;

public class WebProjectConverter
extends AbstractWtpProjectConversionParticipant {
    private static final String DEFAULT_WAR_SOURCE_FOLDER = "src/main/webapp";
    private static final String WAR_SOURCE_DIRECTORY_KEY = "warSourceDirectory";
    private static final String FAIL_IF_MISSING_WEBXML_KEY = "failOnMissingWebXml";

    public void convert(IProject project, Model model, IProgressMonitor monitor) throws CoreException {
        if (!this.accept(project) || !"war".equals(model.getPackaging())) {
            return;
        }
        IVirtualComponent component = ComponentCore.createComponent((IProject)project);
        if (component == null) {
            return;
        }
        this.setWarPlugin(component, model);
    }

    private void setWarPlugin(IVirtualComponent component, Model model) throws CoreException {
        String webContent;
        Build build = this.getCloneOrCreateBuild(model);
        String warPluginVersion = this.getWarPluginVersion();
        Plugin warPlugin = this.setPlugin(build, "org.apache.maven.plugins", "maven-war-plugin", warPluginVersion);
        IFolder webContentFolder = this.findWebRootFolder(component);
        boolean customized = false;
        if (webContentFolder != null && !DEFAULT_WAR_SOURCE_FOLDER.equals(webContent = webContentFolder.getProjectRelativePath().toPortableString())) {
            MavenPluginUtils.configure(warPlugin, WAR_SOURCE_DIRECTORY_KEY, webContent);
            customized = true;
        }
        try {
            VersionRange mwp300 = VersionRange.createFromVersionSpec((String)"[3.0.0,)");
            if (mwp300.containsVersion((ArtifactVersion)new DefaultArtifactVersion(warPluginVersion))) {
                customized = true;
            } else {
                IProjectFacetVersion webVersion;
                IFacetedProject fProject = ProjectFacetsManager.create((IProject)component.getProject());
                if (fProject != null && (webVersion = fProject.getProjectFacetVersion(IJ2EEFacetConstants.DYNAMIC_WEB_FACET)) != null && webVersion.compareTo((Object)IJ2EEFacetConstants.DYNAMIC_WEB_24) > 0) {
                    MavenPluginUtils.configure(warPlugin, FAIL_IF_MISSING_WEBXML_KEY, "false");
                    customized = true;
                }
            }
        }
        catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {}
        if (customized) {
            model.setBuild(build);
        }
    }

    private IFolder findWebRootFolder(IVirtualComponent component) {
        return WTPProjectsUtil.getDefaultDeploymentDescriptorFolder(component.getRootFolder());
    }

    @Override
    protected IProjectFacet getRequiredFaced() {
        return WebFacetUtils.WEB_FACET;
    }

    private String getWarPluginVersion() {
        String version = System.getProperty("org.eclipse.m2e.wtp.conversion.warplugin.version");
        if (version != null) {
            return version;
        }
        return MavenPluginUtils.getMostRecentPluginVersion("org.apache.maven.plugins", "maven-war-plugin", "3.0.0");
    }
}

