/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.io.Serializable;

public class BugzillaVersion
implements Comparable<BugzillaVersion>,
Serializable {
    private static final long serialVersionUID = 2027987556171301044L;
    public static final BugzillaVersion MIN_VERSION = new BugzillaVersion("2.18");
    public static final BugzillaVersion BUGZILLA_2_18 = new BugzillaVersion("2.18");
    public static final BugzillaVersion BUGZILLA_2_22 = new BugzillaVersion("2.22");
    public static final BugzillaVersion BUGZILLA_3_0 = new BugzillaVersion("3.0");
    public static final BugzillaVersion BUGZILLA_3_2 = new BugzillaVersion("3.2");
    public static final BugzillaVersion BUGZILLA_3_4 = new BugzillaVersion("3.4");
    public static final BugzillaVersion BUGZILLA_3_4_7 = new BugzillaVersion("3.4.7");
    public static final BugzillaVersion BUGZILLA_3_5 = new BugzillaVersion("3.5");
    public static final BugzillaVersion BUGZILLA_3_6 = new BugzillaVersion("3.6");
    public static final BugzillaVersion BUGZILLA_4_0 = new BugzillaVersion("4.0");
    public static final BugzillaVersion BUGZILLA_4_2 = new BugzillaVersion("4.2");
    public static final BugzillaVersion BUGZILLA_4_4 = new BugzillaVersion("4.4");
    public static final BugzillaVersion BUGZILLA_4_5_2 = new BugzillaVersion("4.5.2");
    public static final BugzillaVersion BUGZILLA_5_0 = new BugzillaVersion("5.0");
    public static final BugzillaVersion BUGZILLA_5_1 = new BugzillaVersion("5.1");
    public static final BugzillaVersion BUGZILLA_HEAD = new BugzillaVersion("5.1");
    public static final BugzillaVersion MAX_VERSION = BUGZILLA_5_0;
    private final int major;
    private final int minor;
    private int micro;
    private final boolean rc;
    private final boolean plus;

    public BugzillaVersion(String version) {
        String[] segments;
        if (version == null) {
            segments = new String[]{};
            this.rc = false;
            this.plus = false;
        } else {
            version = version.toUpperCase();
            this.rc = version.contains("RC");
            this.plus = version.contains("+");
            if (this.plus) {
                version = version.replace("+", "");
            }
            segments = this.rc ? version.split("(\\.|([R][C]))") : version.split("\\.");
        }
        this.major = segments.length > 0 ? this.parse(segments[0]) : 0;
        this.minor = segments.length > 1 ? this.parse(segments[1]) : 0;
        int n = this.micro = segments.length > 2 ? this.parse(segments[2]) : 0;
        if (this.rc) {
            this.micro -= 100;
        }
    }

    private int parse(String segment) {
        try {
            return segment.length() == 0 ? 0 : Integer.parseInt(this.getVersion(segment));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private String getVersion(String segment) {
        int n = segment.indexOf(45);
        return n == -1 ? segment : segment.substring(0, n);
    }

    public boolean isSmallerOrEquals(BugzillaVersion v) {
        return this.compareTo(v) <= 0;
    }

    public boolean isSmaller(BugzillaVersion v) {
        return this.compareTo(v) < 0;
    }

    @Override
    public int compareTo(BugzillaVersion v) {
        if (this.major < v.major) {
            return -1;
        }
        if (this.major > v.major) {
            return 1;
        }
        if (this.minor < v.minor) {
            return -1;
        }
        if (this.minor > v.minor) {
            return 1;
        }
        if (this.micro < v.micro) {
            return -1;
        }
        if (this.micro > v.micro) {
            return 1;
        }
        if (this.plus != v.plus) {
            if (this.plus) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    public int compareMajorMinorOnly(BugzillaVersion v) {
        if (this.major < v.major) {
            return -1;
        }
        if (this.major > v.major) {
            return 1;
        }
        if (this.minor < v.minor) {
            return -1;
        }
        if (this.minor > v.minor) {
            return 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(this.major));
        sb.append(".").append(Integer.toString(this.minor));
        if (this.micro > 0) {
            sb.append(".").append(Integer.toString(this.micro));
        } else if (this.micro < 0) {
            sb.append("RC").append(Integer.toString(this.micro + 100));
        }
        if (this.plus) {
            sb.append("+");
        }
        return sb.toString();
    }
}

