/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.IFeatureModelDelta;
import org.eclipse.pde.internal.core.IFeatureModelListener;
import org.eclipse.pde.internal.core.IPluginModelListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PluginModelDelta;
import org.eclipse.pde.internal.core.feature.FeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.dialogs.FeatureSelectionDialog;
import org.eclipse.pde.internal.ui.dialogs.PluginSelectionDialog;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.actions.SortAction;
import org.eclipse.pde.internal.ui.editor.feature.FeatureDependenciesPage;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.osgi.service.prefs.Preferences;

public class RequiresSection
extends TableSection
implements IPluginModelListener,
IFeatureModelListener {
    private static final int RECOMPUTE_IMPORT = 3;
    private static final int REMOVE = 2;
    private static final int NEW_FEATURE = 1;
    private static final int NEW_PLUGIN = 0;
    private Button fSyncButton;
    private TableViewer fPluginViewer;
    private Action fDeleteAction;
    private SortAction fSortAction;
    private Action fOpenAction;

    public RequiresSection(FeatureDependenciesPage page, Composite parent) {
        super((PDEFormPage)page, parent, 128, new String[]{PDEUIMessages.FeatureEditor_RequiresSection_plugin, PDEUIMessages.FeatureEditor_RequiresSection_feature, PDEUIMessages.FeatureEditor_RequiresSection_remove, PDEUIMessages.FeatureEditor_RequiresSection_compute});
        this.getSection().setText(PDEUIMessages.FeatureEditor_RequiresSection_title);
        this.getSection().setDescription(PDEUIMessages.FeatureEditor_RequiresSection_desc);
        this.getTablePart().setEditable(false);
    }

    public void commit(boolean onSave) {
        super.commit(onSave);
    }

    @Override
    public void createClient(Section section, FormToolkit toolkit) {
        final IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        section.setLayout((Layout)FormLayoutFactory.createClearGridLayout(false, 1));
        GridData data = new GridData(1808);
        section.setLayoutData((Object)data);
        Composite container = this.createClientContainer((Composite)section, 2, toolkit);
        this.fSyncButton = toolkit.createButton(container, PDEUIMessages.FeatureEditor_RequiresSection_sync, 32);
        GridData gd = new GridData(256);
        gd.horizontalSpan = 2;
        this.fSyncButton.setLayoutData((Object)gd);
        this.fSyncButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IEclipsePreferences eclipsePrefs = Platform.getPreferencesService().getRootNode();
                Preferences prefs = eclipsePrefs.node("instance").node("org.eclipse.pde.ui");
                prefs.putBoolean(model.getFeature().getLabel(), RequiresSection.this.fSyncButton.getSelection());
            }
        });
        this.createViewerPartControl(container, 2, 2, toolkit);
        EditableTablePart tablePart = this.getTablePart();
        this.fPluginViewer = tablePart.getTableViewer();
        this.fPluginViewer.setContentProvider((IContentProvider)new ImportContentProvider());
        this.fPluginViewer.setComparator(ListUtil.NAME_COMPARATOR);
        this.fPluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.fDeleteAction = new Action(){

            public void run() {
                RequiresSection.this.handleDelete();
            }
        };
        this.fDeleteAction.setText(PDEUIMessages.Actions_delete_label);
        this.fOpenAction = new Action(PDEUIMessages.Actions_open_label){

            public void run() {
                RequiresSection.this.handleOpen();
            }
        };
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
        this.createSectionToolbar(section, toolkit);
    }

    private void createSectionToolbar(Section section, FormToolkit toolkit) {
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolbar = toolBarManager.createControl((Composite)section);
        Cursor handCursor = Display.getCurrent().getSystemCursor(21);
        toolbar.setCursor(handCursor);
        this.fSortAction = new SortAction(this.getStructuredViewerPart().getViewer(), PDEUIMessages.FeatureEditor_RequiresSection_sortAlpha, ListUtil.NAME_COMPARATOR, null, null);
        toolBarManager.add((IAction)this.fSortAction);
        toolBarManager.update(true);
        section.setTextClient((Control)toolbar);
    }

    @Override
    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNewPlugin();
                break;
            }
            case 1: {
                this.handleNewFeature();
                break;
            }
            case 2: {
                this.handleDelete();
                break;
            }
            case 3: {
                this.recomputeImports();
            }
        }
    }

    private void handleNewPlugin() {
        BusyIndicator.showWhile((Display)this.fPluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IPluginModelBase[] allModels = PluginRegistry.getActiveModels();
                ArrayList<IPluginModelBase> newModels = new ArrayList<IPluginModelBase>();
                int i = 0;
                while (i < allModels.length) {
                    if (RequiresSection.this.canAdd(allModels[i])) {
                        newModels.add(allModels[i]);
                    }
                    ++i;
                }
                IPluginModelBase[] candidateModels = newModels.toArray(new IPluginModelBase[newModels.size()]);
                PluginSelectionDialog dialog = new PluginSelectionDialog(RequiresSection.this.fPluginViewer.getTable().getShell(), candidateModels, true);
                if (dialog.open() == 0) {
                    Object[] models = dialog.getResult();
                    try {
                        RequiresSection.this.doAdd(models);
                    }
                    catch (CoreException e) {
                        PDEPlugin.log(e);
                    }
                }
            }
        });
    }

    private boolean canAdd(IPluginModelBase candidate) {
        IPluginBase plugin = candidate.getPluginBase();
        if (candidate.isFragmentModel()) {
            return false;
        }
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeatureImport[] imports = model.getFeature().getImports();
        int i = 0;
        while (i < imports.length) {
            IFeatureImport fimport = imports[i];
            if (plugin.getId().equals(fimport.getId())) {
                return false;
            }
            ++i;
        }
        IFeaturePlugin[] fplugins = model.getFeature().getPlugins();
        int i2 = 0;
        while (i2 < fplugins.length) {
            IFeaturePlugin fplugin = fplugins[i2];
            if (plugin.getId().equals(fplugin.getId())) {
                return false;
            }
            ++i2;
        }
        return true;
    }

    private void handleNewFeature() {
        BusyIndicator.showWhile((Display)this.fPluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

            @Override
            public void run() {
                IFeatureModel[] allModels = PDECore.getDefault().getFeatureModelManager().getModels();
                ArrayList<IFeatureModel> newModels = new ArrayList<IFeatureModel>();
                int i = 0;
                while (i < allModels.length) {
                    if (RequiresSection.this.canAdd(allModels[i])) {
                        newModels.add(allModels[i]);
                    }
                    ++i;
                }
                IFeatureModel[] candidateModels = newModels.toArray(new IFeatureModel[newModels.size()]);
                FeatureSelectionDialog dialog = new FeatureSelectionDialog(RequiresSection.this.fPluginViewer.getTable().getShell(), candidateModels, true);
                if (dialog.open() == 0) {
                    Object[] models = dialog.getResult();
                    try {
                        RequiresSection.this.doAdd(models);
                    }
                    catch (CoreException e) {
                        PDECore.log((Throwable)e);
                    }
                }
            }
        });
    }

    private void doAdd(Object[] candidates) throws CoreException {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureImport[] added = new IFeatureImport[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IFeatureModel candidate;
            FeatureImport fimport = (FeatureImport)model.getFactory().createImport();
            if (candidates[i] instanceof IFeatureModel) {
                candidate = (IFeatureModel)candidates[i];
                fimport.loadFrom(candidate.getFeature());
            } else {
                candidate = (IPluginModelBase)candidates[i];
                IPluginBase pluginBase = candidate.getPluginBase();
                fimport.setId(pluginBase.getId());
            }
            added[i] = fimport;
            ++i;
        }
        feature.addImports(added);
    }

    private boolean canAdd(IFeatureModel candidate) {
        IFeature cfeature = candidate.getFeature();
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        if (cfeature.getId().equals(feature.getId()) && cfeature.getVersion().equals(feature.getVersion())) {
            return false;
        }
        IFeatureImport[] features = feature.getImports();
        int i = 0;
        while (i < features.length) {
            if (features[i].getId().equals(cfeature.getId()) && features[i].getVersion() != null && features[i].getVersion().equals(cfeature.getVersion())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void handleDelete() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (!model.isEditable()) {
            return;
        }
        IFeature feature = model.getFeature();
        IStructuredSelection selection = (IStructuredSelection)this.fPluginViewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        try {
            IFeatureImport[] deleted = new IFeatureImport[selection.size()];
            int i = 0;
            for (IFeatureImport iimport : selection) {
                deleted[i++] = iimport;
            }
            feature.removeImports(deleted);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleSelectAll() {
        IStructuredContentProvider provider = (IStructuredContentProvider)this.fPluginViewer.getContentProvider();
        Object[] elements = provider.getElements(this.fPluginViewer.getInput());
        StructuredSelection ssel = new StructuredSelection(elements);
        this.fPluginViewer.setSelection((ISelection)ssel);
    }

    @Override
    protected void handleDoubleClick(IStructuredSelection selection) {
        this.handleOpen();
    }

    private void handleOpen() {
        IStructuredSelection sel = (IStructuredSelection)this.fPluginViewer.getSelection();
        Object obj = sel.getFirstElement();
        if (obj instanceof FeatureImport) {
            FeatureImport featureImport = (FeatureImport)obj;
            if (featureImport.getType() == 0) {
                ManifestEditor.open(featureImport.getPlugin(), false);
            } else if (featureImport.getType() == 1) {
                IFeature feature = featureImport.getFeature();
                FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
                IFeatureModel model = manager.findFeatureModel(feature.getId(), feature.getVersion());
                FeatureEditor.openFeatureEditor(model);
            }
        }
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        PDECore.getDefault().getModelManager().removePluginModelListener((IPluginModelListener)this);
        PDECore.getDefault().getFeatureModelManager().removeFeatureModelListener((IFeatureModelListener)this);
        super.dispose();
    }

    @Override
    public boolean doGlobalAction(String actionId) {
        if (actionId.equals(ActionFactory.DELETE.getId())) {
            BusyIndicator.showWhile((Display)this.fPluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    RequiresSection.this.handleDelete();
                }
            });
            return true;
        }
        if (actionId.equals(ActionFactory.CUT.getId())) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals(ActionFactory.PASTE.getId())) {
            this.doPaste();
            return true;
        }
        if (actionId.equals(ActionFactory.SELECT_ALL.getId())) {
            BusyIndicator.showWhile((Display)this.fPluginViewer.getTable().getDisplay(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    RequiresSection.this.handleSelectAll();
                }
            });
            return true;
        }
        return false;
    }

    public void expandTo(Object object) {
        if (object instanceof IFeatureImport) {
            StructuredSelection ssel = new StructuredSelection(object);
            this.fPluginViewer.setSelection((ISelection)ssel);
        }
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        StructuredSelection selection = (StructuredSelection)this.fPluginViewer.getSelection();
        if (!selection.isEmpty()) {
            manager.add((IAction)this.fOpenAction);
            manager.add((IAction)this.fDeleteAction);
            manager.add((IContributionItem)new Separator());
        }
        this.getPage().getPDEEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    @Override
    protected void registerPopupMenu(MenuManager popupMenuManager) {
        IEditorSite site = (IEditorSite)this.getPage().getSite();
        site.registerContextMenu(String.valueOf(site.getId()) + ".plugins", popupMenuManager, (ISelectionProvider)this.fViewerPart.getViewer(), false);
    }

    @Override
    protected void selectionChanged(IStructuredSelection selection) {
        this.getPage().getPDEEditor().setSelection((ISelection)selection);
        this.getPage().getManagedForm().fireSelectionChanged((IFormPart)this, (ISelection)selection);
        this.updateButtons();
    }

    private void updateButtons() {
        EditableTablePart tablePart = this.getTablePart();
        Table table = tablePart.getTableViewer().getTable();
        TableItem[] tableSelection = table.getSelection();
        boolean hasSelection = tableSelection.length > 0;
        tablePart.setButtonEnabled(2, this.isEditable() && hasSelection);
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        if (!model.isEditable()) {
            this.getTablePart().setButtonEnabled(0, false);
            this.getTablePart().setButtonEnabled(1, false);
            this.getTablePart().setButtonEnabled(2, false);
            this.getTablePart().setButtonEnabled(3, false);
            this.fSyncButton.setEnabled(false);
        }
        IEclipsePreferences eclipsePrefs = Platform.getPreferencesService().getRootNode();
        Preferences prefs = eclipsePrefs.node("instance").node("org.eclipse.pde.ui");
        this.fSyncButton.setSelection(prefs.getBoolean(model.getFeature().getLabel(), false));
        model.addModelChangedListener((IModelChangedListener)this);
        PDECore.getDefault().getModelManager().addPluginModelListener((IPluginModelListener)this);
        PDECore.getDefault().getFeatureModelManager().addFeatureModelListener((IFeatureModelListener)this);
    }

    @Override
    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
            return;
        }
        if (e.getChangeType() == 3) {
            Object obj = e.getChangedObjects()[0];
            if (obj instanceof IFeatureImport) {
                this.fPluginViewer.refresh(obj);
            }
        } else {
            Object obj = e.getChangedObjects()[0];
            if (obj instanceof IFeatureImport) {
                if (e.getChangeType() == 1) {
                    this.fPluginViewer.add(e.getChangedObjects());
                    if (e.getChangedObjects().length > 0) {
                        this.fPluginViewer.setSelection((ISelection)new StructuredSelection(e.getChangedObjects()[0]));
                    }
                } else {
                    this.fPluginViewer.remove(e.getChangedObjects());
                }
            } else if (obj instanceof IFeaturePlugin && this.fSyncButton.getSelection()) {
                this.recomputeImports();
            }
        }
    }

    private void recomputeImports() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        try {
            feature.computeImports();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void modelsChanged(final PluginModelDelta delta) {
        this.getSection().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RequiresSection.this.getSection().isDisposed()) {
                    return;
                }
                ModelEntry[] added = delta.getAddedEntries();
                ModelEntry[] removed = delta.getRemovedEntries();
                ModelEntry[] changed = delta.getChangedEntries();
                if (RequiresSection.this.hasModels(added) || RequiresSection.this.hasModels(removed) || RequiresSection.this.hasModels(changed)) {
                    RequiresSection.this.markStale();
                }
            }
        });
    }

    private boolean hasModels(ModelEntry[] entries) {
        if (entries == null) {
            return false;
        }
        return entries.length > 0;
    }

    public void modelsChanged(final IFeatureModelDelta delta) {
        this.getSection().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (RequiresSection.this.getSection().isDisposed()) {
                    return;
                }
                IFeatureModel[] added = delta.getAdded();
                IFeatureModel[] removed = delta.getRemoved();
                IFeatureModel[] changed = delta.getChanged();
                if (RequiresSection.this.hasModels(added) || RequiresSection.this.hasModels(removed) || RequiresSection.this.hasModels(changed)) {
                    RequiresSection.this.markStale();
                }
            }
        });
    }

    private boolean hasModels(IFeatureModel[] models) {
        if (models == null) {
            return false;
        }
        IFeatureModel thisModel = (IFeatureModel)this.getPage().getModel();
        int i = 0;
        while (i < models.length) {
            if (models[i] != thisModel) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void setFocus() {
        if (this.fPluginViewer != null) {
            this.fPluginViewer.getTable().setFocus();
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        this.fPluginViewer.setInput((Object)feature);
        this.updateButtons();
        super.refresh();
    }

    @Override
    public boolean canPaste(Clipboard clipboard) {
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && objects.length > 0) {
            return this.canPaste(null, objects);
        }
        return false;
    }

    @Override
    protected boolean canPaste(Object target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (!(objects[i] instanceof FeatureImport)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected void doPaste() {
        Clipboard clipboard = this.getPage().getPDEEditor().getClipboard();
        Object[] objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance());
        if (objects != null && this.canPaste(null, objects)) {
            this.doPaste(null, objects);
        }
    }

    @Override
    protected void doPaste(Object target, Object[] objects) {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        if (!model.isEditable()) {
            return;
        }
        IFeatureImport[] imports = new IFeatureImport[objects.length];
        try {
            int i = 0;
            while (i < objects.length) {
                FeatureImport fImport = (FeatureImport)objects[i];
                fImport.setModel(model);
                fImport.setParent((IFeatureObject)feature);
                imports[i] = fImport;
                ++i;
            }
            feature.addImports(imports);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    void fireSelection() {
        ISelection sel = this.fPluginViewer.getSelection();
        if (!sel.isEmpty()) {
            this.fPluginViewer.setSelection(this.fPluginViewer.getSelection());
        } else if (this.fPluginViewer.getElementAt(0) != null) {
            this.fPluginViewer.setSelection((ISelection)new StructuredSelection(this.fPluginViewer.getElementAt(0)));
        }
    }

    @Override
    protected boolean createCount() {
        return true;
    }

    class ImportContentProvider
    implements IStructuredContentProvider {
        ImportContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IFeature) {
                IFeatureImport[] imports = ((IFeature)parent).getImports();
                ArrayList<IFeatureImport> displayable = new ArrayList<IFeatureImport>();
                int i = 0;
                while (i < imports.length) {
                    if (!imports[i].isPatch()) {
                        displayable.add(imports[i]);
                    }
                    ++i;
                }
                return displayable.toArray();
            }
            return new Object[0];
        }
    }
}

