/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.ecl.parser.model;

import java.util.ArrayList;
import org.eclipse.rcptt.core.ecl.model.BuiltinProcDecl;
import org.eclipse.rcptt.core.ecl.model.Declaration;
import org.eclipse.rcptt.core.ecl.model.IDeclContainer;
import org.eclipse.rcptt.core.ecl.model.ProcDecl;
import org.eclipse.rcptt.core.ecl.model.VarDecl;
import org.eclipse.rcptt.core.ecl.parser.ast.Id;
import org.eclipse.rcptt.core.ecl.parser.ast.Node;
import org.eclipse.rcptt.core.ecl.parser.ast.NodeVisitor;
import org.eclipse.rcptt.core.ecl.parser.ast.Reference;
import org.eclipse.rcptt.core.ecl.parser.ast.Script;
import org.eclipse.rcptt.core.ecl.parser.model.OccurrencesSettings;
import org.eclipse.rcptt.core.ecl.parser.model.Resolver;

public class Finder {
    private OccurrencesSettings settings;
    private static Node[] empty = new Node[0];

    public Finder(OccurrencesSettings settings) {
        this.settings = settings;
    }

    public Node[] find(final Script script, int offset, final IDeclContainer container) {
        if (!this.settings.enabled) {
            return empty;
        }
        Reference ref = Resolver.resolve(script, offset, container);
        if (ref == null) {
            return empty;
        }
        final Declaration decl = ref.dest;
        if (decl instanceof BuiltinProcDecl && !this.settings.commands) {
            return empty;
        }
        if (!(decl instanceof BuiltinProcDecl) && decl instanceof ProcDecl && !this.settings.procs) {
            return empty;
        }
        if (decl instanceof VarDecl && ((VarDecl)decl).isGlobal && !this.settings.globals) {
            return empty;
        }
        if (decl instanceof VarDecl && !((VarDecl)decl).isGlobal && !this.settings.locals) {
            return empty;
        }
        final ArrayList<Id> result = new ArrayList<Id>();
        script.accept(new NodeVisitor(){

            @Override
            public void exit(Node node) {
                if (!(node instanceof Id)) {
                    return;
                }
                Reference ref = Resolver.resolve(script, node.begin, container);
                if (ref != null && ref.dest == decl) {
                    result.add(node);
                }
            }

            @Override
            public boolean enter(Node node) {
                return true;
            }
        });
        if (decl.container.getResource() != null && decl.container.getResource().equals(container.getResource())) {
            result.add(new Id(decl.name, decl.location.begin, decl.location.end));
        }
        return result.toArray(new Node[result.size()]);
    }
}

