/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.console;

import java.util.List;
import org.eclipse.osgi.framework.console.CommandInterpreter;
import org.eclipse.osgi.framework.console.CommandProvider;
import org.eclipse.riena.communication.core.IRemoteServiceReference;
import org.eclipse.riena.communication.core.IRemoteServiceRegistration;
import org.eclipse.riena.communication.core.IRemoteServiceRegistry;
import org.eclipse.riena.communication.core.RemoteServiceDescription;
import org.eclipse.riena.communication.core.publisher.IServicePublishBinder;

public class CommunicationConsole
implements CommandProvider {
    private IServicePublishBinder servicePublisher;
    private IRemoteServiceRegistry serviceRegistry;

    public String getHelp() {
        return "---riena communication---\n\tremotestatus - list all services";
    }

    public void _remotestatus(CommandInterpreter ci) throws Exception {
        this.printToPublishServices();
        this.printPublishedServices();
        this.printRegisteredRemoteServices();
    }

    private void printToPublishServices() {
        RemoteServiceDescription[] rsDescs;
        if (this.servicePublisher == null) {
            return;
        }
        RemoteServiceDescription[] remoteServiceDescriptionArray = rsDescs = this.servicePublisher.getAllServices();
        int n = rsDescs.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteServiceDescription rsDesc = remoteServiceDescriptionArray[n2];
            if (rsDesc.getState() == RemoteServiceDescription.State.UNREGISTERED) {
                System.out.println("Riena:: not published end point=(" + rsDesc + ")");
            }
            ++n2;
        }
    }

    private void printPublishedServices() {
        if (this.servicePublisher == null) {
            return;
        }
        RemoteServiceDescription[] rsDescs = this.servicePublisher.getAllServices();
        boolean found = false;
        RemoteServiceDescription[] remoteServiceDescriptionArray = rsDescs;
        int n = rsDescs.length;
        int n2 = 0;
        while (n2 < n) {
            RemoteServiceDescription rsDesc = remoteServiceDescriptionArray[n2];
            if (rsDesc.getState() == RemoteServiceDescription.State.REGISTERED) {
                found = true;
                System.out.println("Riena:: Published OSGi Service=(" + rsDesc + ")");
            }
            ++n2;
        }
        if (!found) {
            System.out.println("Riena:: no OSGi services published");
            return;
        }
    }

    private void printRegisteredRemoteServices() {
        if (this.serviceRegistry == null) {
            return;
        }
        List rsRegs = this.serviceRegistry.registeredServices(null);
        if (rsRegs.size() == 0) {
            System.out.println("Riena:: no RemoteServiceProxies registered");
            return;
        }
        for (IRemoteServiceRegistration rsReg : rsRegs) {
            IRemoteServiceReference rsRef = rsReg.getReference();
            System.out.println("Riena:: Registered RemoteServiceProxy=(" + rsRef + ")");
        }
    }

    public void bind(IServicePublishBinder servicePublisher) {
        this.servicePublisher = servicePublisher;
    }

    public void unbind(IServicePublishBinder servicePublisher) {
        this.servicePublisher = null;
    }

    public void bind(IRemoteServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    public void unbind(IRemoteServiceRegistry serviceRegistry) {
        this.serviceRegistry = null;
    }
}

