/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.communication.factory.hessian.serializer;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import com.caucho.hessian.io.Deserializer;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.hessian.io.Serializer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.riena.communication.core.RemoteFailure;
import org.eclipse.riena.communication.factory.hessian.serializer.AbstractRienaSerializerFactory;

public class InputStreamSerializerFactory
extends AbstractRienaSerializerFactory {
    public Deserializer getDeserializer(Class cl) throws HessianProtocolException {
        if (this.isInputStream(cl)) {
            return new AbstractDeserializer(){

                public Object readObject(AbstractHessianInput in) throws IOException {
                    try {
                        byte[] bytes = in.readBytes();
                        return new ByteArrayInputStream(bytes);
                    }
                    catch (HessianProtocolException e) {
                        throw new RemoteFailure("Error while reading Attachment content. Probably incomplete or interrupted Attachment inputstream. " + e.getMessage());
                    }
                }
            };
        }
        return null;
    }

    public Serializer getSerializer(Class cl) throws HessianProtocolException {
        if (this.isInputStream(cl)) {
            return new AbstractSerializer(){

                public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
                    if (obj == null) {
                        out.writeNull();
                        return;
                    }
                    InputStream is = (InputStream)obj;
                    try {
                        byte[] buf = new byte[1024];
                        int len = 0;
                        while (true) {
                            try {
                                len = is.read(buf, 0, buf.length);
                            }
                            catch (IOException iOException) {
                                out.writeNull();
                                break;
                            }
                            if (len <= 0) break;
                            out.writeByteBufferPart(buf, 0, len);
                        }
                        out.writeByteBufferEnd(buf, 0, 0);
                    }
                    finally {
                        is.close();
                    }
                }
            };
        }
        return null;
    }

    private boolean isInputStream(Class<?> cl) {
        if (cl == InputStream.class) {
            return true;
        }
        Class<?> superCl = cl;
        while (superCl != null && superCl != Object.class) {
            if ((superCl = superCl.getSuperclass()) != InputStream.class) continue;
            return true;
        }
        return false;
    }

    @Override
    public Class<?>[] getReplacedSerializerTypes() {
        return new Class[]{InputStream.class};
    }

    @Override
    public Class<?>[] getReplacedDeserializerTypes() {
        return new Class[]{InputStream.class};
    }
}

