/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.monitor.client;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.Literal;
import org.eclipse.riena.core.util.Millis;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.core.wire.InjectService;
import org.eclipse.riena.internal.monitor.client.Activator;
import org.eclipse.riena.monitor.client.Category;
import org.eclipse.riena.monitor.client.ISender;
import org.eclipse.riena.monitor.client.IStore;
import org.eclipse.riena.monitor.common.Collectible;
import org.eclipse.riena.monitor.common.IReceiver;

public class SimpleSender
implements ISender,
IExecutableExtension {
    private IStore store;
    private IReceiver receiver;
    private boolean started;
    private long retryTime;
    private final Map<String, Sender> senders = new HashMap<String, Sender>();
    private static final String RETRY_TIME = "retryTime";
    private static final String RETRY_TIME_DEFAULT = "15 m";
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SimpleSender.class);

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        Map properties = null;
        try {
            properties = PropertiesUtils.asMap((Object)data, (Map)Literal.map((Object)RETRY_TIME, (Object)RETRY_TIME_DEFAULT), (String[])new String[0]);
            this.retryTime = Millis.valueOf((String)((String)properties.get(RETRY_TIME)));
            Assert.isLegal((this.retryTime > 0L ? 1 : 0) != 0, (String)"retryTime must be greater than 0.");
        }
        catch (IllegalArgumentException e) {
            throw this.configurationException("Bad configuration.", e);
        }
    }

    private CoreException configurationException(String message, Exception e) {
        return new CoreException((IStatus)new Status(4, "org.eclipse.riena.monitor.client", message, (Throwable)e));
    }

    @InjectService(useRanking=true)
    public void bind(IReceiver receiver) {
        this.receiver = receiver;
    }

    public void unbind(IReceiver receiver) {
        this.receiver = null;
    }

    @Override
    public void start(IStore store, Collection<Category> categories) {
        if (this.started) {
            return;
        }
        Assert.isNotNull((Object)store, (String)"store must not be null");
        Assert.isNotNull(categories, (String)"categories must not be null");
        this.store = store;
        this.started = true;
        for (Category category : categories) {
            Sender sender = new Sender(category.getName());
            this.senders.put(category.getName(), sender);
            sender.tryIt(Millis.seconds((int)5));
        }
    }

    @Override
    public void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        for (Sender sender : this.senders.values()) {
            sender.cancel();
        }
        this.senders.clear();
    }

    @Override
    public synchronized void triggerTransfer(String categoryName) {
        if (!this.started) {
            return;
        }
        Sender sender = this.senders.get(categoryName);
        if (sender == null) {
            return;
        }
        sender.tryIt(0L);
    }

    private final class Sender
    extends Job {
        private final String category;
        private boolean retrying;
        private static final String CAUSED_BY = " Caused by: ";

        private Sender(String category) {
            super("SimpleSender");
            this.category = category;
        }

        private void tryIt(long delay) {
            if (this.retrying) {
                LOGGER.log(4, "Sender(" + this.category + ") retry already scheduled.");
                return;
            }
            this.schedule(delay);
        }

        protected IStatus run(IProgressMonitor monitor) {
            LOGGER.log(4, "Sender(" + this.category + ") started with" + (this.retrying ? "" : "out") + " retry");
            if (SimpleSender.this.receiver == null) {
                LOGGER.log(4, "Sender(" + this.category + ") ended (no receiver)");
                return Status.OK_STATUS;
            }
            List<Collectible<?>> transferables = SimpleSender.this.store.retrieveTransferables(this.category);
            if (transferables.size() == 0) {
                LOGGER.log(4, "Sender(" + this.category + ") ended (nothing to send)");
                return Status.OK_STATUS;
            }
            this.transfer(transferables);
            LOGGER.log(4, "Sender(" + this.category + ") ended");
            return Status.OK_STATUS;
        }

        private void transfer(List<Collectible<?>> transferables) {
            block4: {
                LOGGER.log(4, "sender transfer " + transferables.size() + " transferables:");
                for (Collectible<?> transferable : transferables) {
                    LOGGER.log(4, " - " + transferable.toLogString());
                }
                try {
                    if (SimpleSender.this.receiver.take(System.currentTimeMillis(), transferables)) {
                        SimpleSender.this.store.commitTransferred(transferables);
                        this.retrying = false;
                        break block4;
                    }
                    throw new RuntimeException("Retry sending later because receiver rejected it.");
                }
                catch (Throwable t) {
                    LOGGER.log(4, "sending failed with: " + this.condense(t));
                    LOGGER.log(4, "retrying in " + SimpleSender.this.retryTime + " milli seconds");
                    this.retrying = true;
                    this.schedule(SimpleSender.this.retryTime);
                }
            }
        }

        private String condense(Throwable throwable) {
            StringBuilder bob = new StringBuilder();
            do {
                bob.append(throwable.toString()).append(CAUSED_BY);
            } while ((throwable = throwable.getCause()) != null);
            bob.setLength(bob.length() - CAUSED_BY.length());
            return bob.toString();
        }
    }
}

