/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation;

import org.eclipse.riena.core.singleton.SessionSingletonProvider;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.navigation.ApplicationNodeManagerInternal;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.IModuleNode;
import org.eclipse.riena.navigation.INavigationProcessor;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;

public final class ApplicationNodeManager {
    private static final SingletonProvider<ApplicationNodeManagerInternal> ANMI = new SessionSingletonProvider(ApplicationNodeManagerInternal.class);

    private ApplicationNodeManager() {
    }

    public static IApplicationNode getApplicationNode() {
        return ((ApplicationNodeManagerInternal)ANMI.getInstance()).getApplicationNode();
    }

    public static IApplicationNode getApplicationNode(String name) {
        return ((ApplicationNodeManagerInternal)ANMI.getInstance()).getApplicationNode(name);
    }

    public static synchronized void clear() {
        ((ApplicationNodeManagerInternal)ANMI.getInstance()).clear();
    }

    public static synchronized void registerApplicationNode(IApplicationNode node) {
        ((ApplicationNodeManagerInternal)ANMI.getInstance()).registerApplicationNode(node);
    }

    public static INavigationProcessor getDefaultNavigationProcessor() {
        return ((ApplicationNodeManagerInternal)ANMI.getInstance()).getDefaultNavigationProcessor();
    }

    public static ISubApplicationNode locateActiveSubApplicationNode() {
        return ((ApplicationNodeManagerInternal)ANMI.getInstance()).locateActiveSubApplicationNode();
    }

    public static IModuleGroupNode locateActiveModuleGroupNode() {
        return ((ApplicationNodeManagerInternal)ANMI.getInstance()).locateActiveModuleGroupNode();
    }

    public static IModuleNode locateActiveModuleNode() {
        return ((ApplicationNodeManagerInternal)ANMI.getInstance()).locateActiveModuleNode();
    }

    public static ISubModuleNode locateActiveSubModuleNode() {
        return ((ApplicationNodeManagerInternal)ANMI.getInstance()).locateActiveSubModuleNode();
    }

    public static ISubModuleNode getActiveSubModule(IModuleNode node) {
        for (ISubModuleNode child : node.getChildren()) {
            ISubModuleNode subModuleNode = ApplicationNodeManager.getActiveSubModule(child);
            if (subModuleNode == null) continue;
            return ApplicationNodeManager.getActiveSubModule(child);
        }
        return null;
    }

    public static ISubModuleNode getActiveSubModule(ISubModuleNode node) {
        if (node.isActivated()) {
            return node;
        }
        for (ISubModuleNode child : node.getChildren()) {
            ISubModuleNode subModuleNode = ApplicationNodeManager.getActiveSubModule(child);
            if (subModuleNode == null) continue;
            return subModuleNode;
        }
        return null;
    }
}

