/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.security.common.authorization;

import java.security.Permissions;
import java.security.Principal;
import javax.security.auth.Subject;
import org.eclipse.riena.core.cache.GenericObjectCache;
import org.eclipse.riena.core.util.ContainerModel;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.security.common.authorization.IPermissionCacheExtension;
import org.eclipse.riena.security.common.authorization.IPermissionCache;

public class PermissionCache
implements IPermissionCache {
    private final GenericObjectCache<String, Permissions> permCache = new GenericObjectCache();

    public PermissionCache() {
        this.permCache.setName("PermissionCache");
        if (ContainerModel.isClient()) {
            this.permCache.setMinimumSize(1);
            this.permCache.setTimeout(999999000);
        } else {
            this.permCache.setMinimumSize(100);
            this.permCache.setTimeout(360000);
        }
    }

    @Override
    public Permissions getPermissions(Principal principal) {
        return (Permissions)this.permCache.get((Object)principal.getName());
    }

    @Override
    public void putPermissions(Principal principal, Permissions permissions) {
        this.permCache.put((Object)principal.getName(), (Object)permissions);
    }

    @Override
    public void purgePermissions(Subject subject) {
    }

    @Override
    public void purgePermissions(Principal principal) {
    }

    @InjectExtension(min=0, max=1)
    public void update(IPermissionCacheExtension permissionCacheExtension) {
        if (permissionCacheExtension != null) {
            this.permCache.setMinimumSize(permissionCacheExtension.getMinimumSize());
            int timeout = permissionCacheExtension.getTimeout();
            this.permCache.setTimeout(timeout == -1 ? Integer.MAX_VALUE : timeout);
        }
    }
}

