/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.simpleservices.authorizationservice.store;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.security.Permission;
import java.security.Permissions;
import java.security.Principal;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.riena.security.authorizationservice.IPermissionStore;
import org.eclipse.riena.security.common.SecurityFailure;
import org.eclipse.riena.security.common.authorization.PermissionClassFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FilePermissionStore
implements IPermissionStore {
    private final Document permissionTree;

    public FilePermissionStore(File permissionFile) throws SAXException, IOException, ParserConfigurationException {
        this(new FileInputStream(permissionFile));
    }

    public FilePermissionStore(InputStream inputStream) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        this.permissionTree = db.parse(new InputSource(inputStream));
    }

    public Permissions loadPermissions(Principal principal) {
        Permissions allPerms = new Permissions();
        NodeList nl = this.permissionTree.getDocumentElement().getElementsByTagName("principal");
        int i = 0;
        while (i < nl.getLength()) {
            Element el = (Element)nl.item(i);
            String principalClazz = el.getAttribute("class");
            String principalName = el.getAttribute("name");
            if (principalClazz.equals(principal.getClass().getName()) && principalName.equals(principal.getName()) && principal.getClass().getName().equals(el.getAttribute("class"))) {
                NodeList nlPerms = el.getElementsByTagName("permission");
                int x = 0;
                while (x < nlPerms.getLength()) {
                    Element ePerm = (Element)nlPerms.item(x);
                    String clazz = ePerm.getAttribute("class");
                    String name = ePerm.getAttribute("name");
                    String action = ePerm.getAttribute("action");
                    try {
                        Permission perm;
                        Constructor constr;
                        Class permClass = PermissionClassFactory.retrieveClass((String)clazz);
                        if (action != null && action.length() > 0) {
                            try {
                                int actInt = Integer.parseInt(action);
                                constr = permClass.getConstructor(String.class, Integer.TYPE);
                                perm = (Permission)constr.newInstance(name, actInt);
                            }
                            catch (NumberFormatException numberFormatException) {
                                constr = permClass.getConstructor(String.class, String.class);
                                perm = (Permission)constr.newInstance(name, action);
                            }
                        } else {
                            constr = permClass.getConstructor(String.class);
                            perm = (Permission)constr.newInstance(name);
                        }
                        if (perm != null) {
                            allPerms.add(perm);
                        }
                    }
                    catch (Exception e) {
                        throw new SecurityFailure("Creating permission '" + clazz + "' failed", (Throwable)e);
                    }
                    ++x;
                }
            }
            ++i;
        }
        return allPerms;
    }
}

