/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.core.annotationprocessor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.eclipse.riena.core.annotationprocessor.AnnotatedOverriddenMethodsGuard;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.ridgets.annotation.OnActionCallback;

@NonUITestCase
public class AnnotatedOverriddenMethodsGuardTest
extends RienaTestCase {
    private AnnotatedOverriddenMethodsGuard guard = null;

    protected void setUp() throws Exception {
        super.setUp();
        this.guard = new AnnotatedOverriddenMethodsGuard();
    }

    public void testM1() throws Throwable {
        AnnotatedOverriddenMethodsGuardTest.assertTrue((boolean)this.add(A.class, "m1", new Class[0]));
        AnnotatedOverriddenMethodsGuardTest.assertFalse((boolean)this.add(B.class, "m1", new Class[0]));
    }

    public void testM2() throws Throwable {
        AnnotatedOverriddenMethodsGuardTest.assertTrue((boolean)this.add(A.class, "m2", new Class[0]));
        AnnotatedOverriddenMethodsGuardTest.assertTrue((boolean)this.add(B.class, "m2", new Class[0]));
    }

    public void testM3() throws Throwable {
        AnnotatedOverriddenMethodsGuardTest.assertTrue((boolean)this.add(A.class, "m3", new Class[0]));
        AnnotatedOverriddenMethodsGuardTest.assertFalse((boolean)this.add(B.class, "m3", new Class[0]));
    }

    public void testM4() throws Throwable {
        AnnotatedOverriddenMethodsGuardTest.assertTrue((boolean)this.add(A.class, "m4", new Class[0]));
        AnnotatedOverriddenMethodsGuardTest.assertTrue((boolean)this.add(B.class, "m4", new Class[0]));
    }

    public void testM5() throws Throwable {
        AnnotatedOverriddenMethodsGuardTest.assertTrue((boolean)this.add(A.class, "m5", new Class[0]));
        AnnotatedOverriddenMethodsGuardTest.assertTrue((boolean)this.add(B.class, "m5", Integer.TYPE));
    }

    private boolean add(Class<?> clazz, String methodName, Class<?> ... parameterTypes) throws Throwable {
        Method method = clazz.getDeclaredMethod(methodName, parameterTypes);
        Annotation[] annotations = method.getAnnotations();
        return this.guard.add(annotations.length == 0 ? null : annotations[0], method);
    }

    private static class A {
        private A() {
        }

        protected void m1() {
        }

        private void m2() {
        }

        @OnActionCallback(ridgetId="A.m3")
        protected void m3() {
        }

        @OnActionCallback(ridgetId="A.m4")
        protected void m4() {
        }

        @OnActionCallback(ridgetId="A.m5")
        protected void m5() {
        }
    }

    private static class B
    extends A {
        private B() {
        }

        @Override
        public void m1() {
        }

        private void m2() {
        }

        @Override
        @OnActionCallback(ridgetId="A.m3")
        protected void m3() {
        }

        @Override
        @OnActionCallback(ridgetId="B.m4")
        protected void m4() {
        }

        @OnActionCallback(ridgetId="A.m5")
        protected void m5(int i) {
        }
    }
}

