/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.core.util.Nop;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractSWTRidgetTest;
import org.eclipse.riena.internal.ui.ridgets.swt.CompositeRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.ridgets.ICompositeRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.swt.uibinding.SwtControlRidgetMapper;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class CompositeRidgetTest
extends AbstractSWTRidgetTest {
    @Override
    protected IRidget createRidget() {
        return new CompositeRidget();
    }

    @Override
    protected Widget createWidget(Composite parent) {
        Composite result = new Composite(parent, 0);
        result.setData("binding_property", (Object)"pbId");
        return result;
    }

    protected ICompositeRidget getRidget() {
        return (ICompositeRidget)super.getRidget();
    }

    protected Composite getWidget() {
        return (Composite)super.getWidget();
    }

    public void testCompositeToRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        Composite composite = new Composite((Composite)this.getShell(), 0);
        composite.setData("binding_property", (Object)"id1");
        CompositeRidgetTest.assertNotNull((Object)composite.getData("binding_property"));
        CompositeRidgetTest.assertSame(CompositeRidget.class, (Object)mapper.getRidgetClass((Object)composite));
    }

    public void testGroupToRidgetMapping() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        Group group = new Group((Composite)this.getShell(), 0);
        group.setData("binding_property", (Object)"id2");
        CompositeRidgetTest.assertNotNull((Object)group.getData("binding_property"));
        CompositeRidgetTest.assertSame(CompositeRidget.class, (Object)mapper.getRidgetClass((Object)group));
    }

    public void testCompositeToRidgetMappingWithNoId() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        Composite composite = new Composite((Composite)this.getShell(), 0);
        this.assertNullId(mapper, composite);
        composite.setData("binding_property", (Object)"");
        this.assertEmptyId(mapper, composite);
    }

    public void testGroupToRidgetMappingWithNoId() {
        SwtControlRidgetMapper mapper = SwtControlRidgetMapper.getInstance();
        Composite composite = new Composite((Composite)this.getShell(), 0);
        this.assertNullId(mapper, composite);
        composite.setData("binding_property", (Object)"");
        this.assertEmptyId(mapper, composite);
    }

    @Override
    public void testGetFocusable() {
        this.createTextWidget();
        super.testGetFocusable();
    }

    @Override
    public void testSetFocusable() {
        this.createTextWidget();
        super.testSetFocusable();
    }

    @Override
    public void testRequestFocus() throws Exception {
        this.createTextWidget();
        super.testRequestFocus();
    }

    private void assertEmptyId(SwtControlRidgetMapper mapper, Composite control) {
        CompositeRidgetTest.assertEquals((Object)"", (Object)control.getData("binding_property"));
        try {
            mapper.getRidgetClass((Object)control);
            CompositeRidgetTest.fail();
        }
        catch (BindingException bindingException) {
            this.ok("expected");
        }
    }

    private void assertNullId(SwtControlRidgetMapper mapper, Composite control) {
        CompositeRidgetTest.assertEquals(null, (Object)control.getData("binding_property"));
        try {
            mapper.getRidgetClass((Object)control);
            CompositeRidgetTest.fail();
        }
        catch (BindingException bindingException) {
            this.ok("expected");
        }
    }

    private void createTextWidget() {
        Composite control = this.getWidget();
        Text txt = new Text(control, 2048);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)txt, "txt");
        TextRidget txtRidget = new TextRidget();
        txtRidget.setUIControl((Object)txt);
        ICompositeRidget ridget = this.getRidget();
        ridget.addRidget("txt", (IRidget)txtRidget);
    }

    @Override
    public void testGetMenuItemCount() {
        ICompositeRidget ridget = this.getRidget();
        try {
            ridget.getMenuItemCount();
            CompositeRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }

    @Override
    public void testGetMenuItem() {
        ICompositeRidget ridget = this.getRidget();
        try {
            ridget.getMenuItem(0);
            CompositeRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }

    @Override
    public void testAddMenuItem() {
        ICompositeRidget ridget = this.getRidget();
        try {
            ridget.addMenuItem("MenuItemWithoutIcon");
            CompositeRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }

    @Override
    public void testRemoveMenuItem() {
        ICompositeRidget ridget = this.getRidget();
        try {
            ridget.removeMenuItem("MenuItemWithIcon");
            CompositeRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }

    @Override
    public void testGetMenuItemEmptyContextMenu() {
        try {
            ICompositeRidget ridget = this.getRidget();
            ridget.getMenuItem(0);
            CompositeRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }

    @Override
    public void testGetMenuItemNotExistingItem() {
        ICompositeRidget ridget = this.getRidget();
        try {
            ridget.getMenuItem(0);
            CompositeRidgetTest.fail((String)"UnsupportedOperationException expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Nop.reason((String)"UnsupportedOperationException expected");
        }
    }
}

