/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuRidget;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class MenuRidgetTest
extends RienaTestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        super.setUp();
        this.shell = new Shell();
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
        super.tearDown();
    }

    public void testCheckUIControl() {
        MyMenuRidget ridget = new MyMenuRidget();
        ridget.checkUIControl(null);
        this.ok("no BindingException expected");
        Menu menu = new Menu((Control)this.shell);
        MenuItem menuItem = new MenuItem(menu, 0);
        try {
            ridget.checkUIControl(menuItem);
            MenuRidgetTest.fail((String)"BindingException was expected");
        }
        catch (BindingException bindingException) {
            this.ok("BindingException was expected");
        }
        menuItem = new MenuItem(menu, 64);
        try {
            ridget.checkUIControl(menuItem);
        }
        catch (BindingException bindingException) {
            MenuRidgetTest.fail((String)"No BindingException was expected");
        }
    }

    public void testGetChild() {
        MenuRidget ridget = new MenuRidget();
        MenuItemRidget retRidget = (MenuItemRidget)ReflectionUtils.invokeHidden((Object)ridget, (String)"getChild", (Object[])new Object[]{"4711"});
        MenuRidgetTest.assertNull((Object)retRidget);
        Menu menu = new Menu((Control)this.shell);
        MenuItem menuItem1 = new MenuItem(menu, 0);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)menuItem1, "4711");
        MenuItemRidget itemRidget = new MenuItemRidget();
        itemRidget.setUIControl((Object)menuItem1);
        ridget.addChild(itemRidget);
        retRidget = (MenuItemRidget)ReflectionUtils.invokeHidden((Object)ridget, (String)"getChild", (Object[])new Object[]{"4711"});
        MenuRidgetTest.assertSame((Object)itemRidget, (Object)retRidget);
    }

    public void testRemoveChild() {
        MenuRidget ridget = new MenuRidget();
        Menu menu = new Menu((Control)this.shell);
        MenuItem menuItem1 = new MenuItem(menu, 0);
        SWTBindingPropertyLocator.getInstance().setBindingProperty((Object)menuItem1, "4711");
        MenuItemRidget itemRidget = new MenuItemRidget();
        itemRidget.setUIControl((Object)menuItem1);
        ridget.addChild(itemRidget);
        MenuItem menuItem2 = new MenuItem(menu, 0);
        ReflectionUtils.invokeHidden((Object)ridget, (String)"removeChild", (Object[])new Object[]{menuItem2});
        MenuRidgetTest.assertEquals((int)1, (int)ridget.getChildren().size());
        ReflectionUtils.invokeHidden((Object)ridget, (String)"removeChild", (Object[])new Object[]{menuItem1});
        MenuRidgetTest.assertEquals((int)0, (int)ridget.getChildren().size());
    }

    private static class MyMenuRidget
    extends MenuRidget {
        private MyMenuRidget() {
        }

        public void checkUIControl(Object uiControl) {
            super.checkUIControl(uiControl);
        }
    }
}

