/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.navigation.IModuleGroupNode;
import org.eclipse.riena.navigation.INavigationNode;
import org.eclipse.riena.navigation.ISubApplicationNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.model.ModuleGroupNode;
import org.eclipse.riena.navigation.model.SubApplicationNode;
import org.eclipse.riena.navigation.ui.swt.views.NavigationViewPart;

@NonUITestCase
public class NavigationViewPartTest
extends TestCase {
    public void testGetActiveModuleGroupNode() {
        SubApplicationNode sa1 = new SubApplicationNode();
        ModuleGroupNode mg1 = new ModuleGroupNode(new NavigationNodeId("mg1"));
        sa1.addChild((INavigationNode)mg1);
        ModuleGroupNode mg2 = new ModuleGroupNode(new NavigationNodeId("mg2"));
        sa1.addChild((INavigationNode)mg2);
        ModuleGroupNode mg3 = new ModuleGroupNode(new NavigationNodeId("mg3"));
        sa1.addChild((INavigationNode)mg3);
        MockNavigationViewPart viewPart = new MockNavigationViewPart();
        viewPart.setSubAppNode((ISubApplicationNode)sa1);
        IModuleGroupNode activeNode = viewPart.getActiveModuleGroupNode();
        NavigationViewPartTest.assertNull((Object)activeNode);
        mg2.activate(null);
        activeNode = viewPart.getActiveModuleGroupNode();
        NavigationViewPartTest.assertSame((Object)mg2, (Object)activeNode);
        mg1.activate(null);
        activeNode = viewPart.getActiveModuleGroupNode();
        NavigationViewPartTest.assertSame((Object)mg1, (Object)activeNode);
    }

    private class MockNavigationViewPart
    extends NavigationViewPart {
        private ISubApplicationNode subAppNode;

        private MockNavigationViewPart() {
        }

        public ISubApplicationNode getSubApplicationNode() {
            return this.getSubAppNode();
        }

        public ISubApplicationNode getSubAppNode() {
            return this.subAppNode;
        }

        public void setSubAppNode(ISubApplicationNode subAppNode) {
            this.subAppNode = subAppNode;
        }
    }
}

