/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.core.resource;

import junit.framework.TestCase;
import org.eclipse.riena.core.test.collect.NonUITestCase;
import org.eclipse.riena.ui.core.resource.IconManager;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.core.resource.IconState;

@NonUITestCase
public class IconManagerTest
extends TestCase {
    public void testGetIconID() {
        IconManager manager = new IconManager();
        String iconID = manager.getIconID(null, null, null);
        IconManagerTest.assertNull((Object)iconID);
        iconID = manager.getIconID(null, IconSize.B22, IconState.HOVER);
        IconManagerTest.assertNull((Object)iconID);
        iconID = manager.getIconID("star", IconSize.B22, IconState.HOVER);
        String expectedID = "star" + IconState.HOVER.getDefaultMapping() + IconSize.B22.getDefaultMapping();
        IconManagerTest.assertEquals((String)expectedID, (String)iconID);
    }

    public void testGetName() {
        IconManager manager = new IconManager();
        String name = manager.getName(null);
        IconManagerTest.assertNull((Object)name);
        name = manager.getName("star");
        IconManagerTest.assertNull((Object)name);
        String iconID = manager.getIconID("star", null);
        name = manager.getName(iconID);
        IconManagerTest.assertEquals((String)"star", (String)name);
        iconID = manager.getIconID("star", IconSize.B22, IconState.HOVER);
        name = manager.getName(iconID);
        IconManagerTest.assertEquals((String)"star", (String)name);
    }

    public void testGetSize() {
        IconManager manager = new IconManager();
        IconSize size = manager.getSize(null);
        IconManagerTest.assertNull((Object)size);
        size = manager.getSize("star");
        IconManagerTest.assertNull((Object)size);
        String iconID = manager.getIconID("star", null);
        size = manager.getSize(iconID);
        IconManagerTest.assertNull((Object)size);
        iconID = manager.getIconID("star", IconSize.B22, IconState.HOVER);
        size = manager.getSize(iconID);
        IconManagerTest.assertEquals((Object)IconSize.B22, (Object)size);
        iconID = manager.getIconID("moon", IconSize.NONE);
        size = manager.getSize(iconID);
        IconManagerTest.assertEquals((Object)IconSize.NONE, (Object)size);
    }

    public void testGetState() {
        IconManager manager = new IconManager();
        IconState state = manager.getState(null);
        IconManagerTest.assertNull((Object)state);
        state = manager.getState("star");
        IconManagerTest.assertNull((Object)state);
        String iconID = manager.getIconID("star", null);
        state = manager.getState(iconID);
        IconManagerTest.assertEquals((Object)IconState.NORMAL, (Object)state);
        iconID = manager.getIconID("star", IconSize.B22, IconState.HOVER);
        state = manager.getState(iconID);
        IconManagerTest.assertEquals((Object)IconState.HOVER, (Object)state);
        iconID = manager.getIconID("moon", IconSize.NONE);
        state = manager.getState(iconID);
        IconManagerTest.assertEquals((Object)IconState.NORMAL, (Object)state);
    }

    public void testHasExtension() {
        IconManager manager = new IconManager();
        String abc = "123";
        IconManagerTest.assertFalse((boolean)manager.hasExtension(abc));
        abc = ".";
        IconManagerTest.assertFalse((boolean)manager.hasExtension(abc));
        abc = "1.";
        IconManagerTest.assertTrue((boolean)manager.hasExtension(abc));
        abc = "1.2";
        IconManagerTest.assertTrue((boolean)manager.hasExtension(abc));
        abc = ".2";
        IconManagerTest.assertFalse((boolean)manager.hasExtension(abc));
    }
}

