/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets;

import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.riena.core.test.RienaTestCase;
import org.eclipse.riena.core.test.collect.NonGatherableTestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.ridgets.CustomValueBindingSupport;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.IValueBindingSupportProvider;
import org.eclipse.riena.ui.ridgets.ValueBindingSupport;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.junit.Test;

@NonGatherableTestCase(value=" This test case works local but not on the build server!!!")
public class ValueBindingSupportProviderTest
extends RienaTestCase {
    private DefaultRealm realm;

    protected void setUp() throws Exception {
        super.setUp();
        this.realm = new DefaultRealm();
    }

    protected void tearDown() throws Exception {
        this.realm.dispose();
        this.realm = null;
        super.tearDown();
    }

    @Test
    public void testGetValueBindingSupportNoExtension() throws Exception {
        ValueBindingSupport bindingSupport = IValueBindingSupportProvider.ExtensionAccess.createInstance(ITextRidget.class, (IObservableValue)new WritableValue());
        ValueBindingSupportProviderTest.assertNull((Object)bindingSupport);
    }

    @Test
    public void testGetCustomValueBindingSupport() throws Exception {
        this.addPluginXml(ValueBindingSupportProviderTest.class, "bindingSupportExtension.xml");
        ValueBindingSupport bindingSupport = IValueBindingSupportProvider.ExtensionAccess.createInstance(ITextRidget.class, (IObservableValue)new WritableValue());
        ValueBindingSupportProviderTest.assertSame(CustomValueBindingSupport.class, bindingSupport.getClass());
        this.removeExtension("org.eclipse.riena.ui.ridgets.ValueBindingSupportProviderTest");
    }

    @Test
    public void testGetCustomValueBindingSupportThrowsException() throws Exception {
        this.addPluginXml(ValueBindingSupportProviderTest.class, "bindingSupportExtensionThrowsException.xml");
        ValueBindingSupport bindingSupport = IValueBindingSupportProvider.ExtensionAccess.createInstance(ITextRidget.class, (IObservableValue)new WritableValue());
        ValueBindingSupportProviderTest.assertNull((Object)bindingSupport);
        this.removeExtension("org.eclipse.riena.ui.ridgets.ValueBindingSupportProviderTest");
    }

    @Test
    public void testAbstractValueRidget() throws Exception {
        TextRidget ridget = new TextRidget();
        ValueBindingSupportProviderTest.assertSame(ValueBindingSupport.class, ridget.getValueBindingSupport().getClass());
        this.addPluginXml(ValueBindingSupportProviderTest.class, "bindingSupportExtension.xml");
        TextRidget ridget2 = new TextRidget();
        ValueBindingSupportProviderTest.assertSame(CustomValueBindingSupport.class, ridget2.getValueBindingSupport().getClass());
        this.removeExtension("org.eclipse.riena.ui.ridgets.ValueBindingSupportProviderTest");
    }
}

