/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.marker;

import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.test.collect.ManualTestCase;
import org.eclipse.riena.internal.ui.ridgets.swt.TextRidget;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.MessageMarker;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.marker.StatuslineMessageMarkerViewer;
import org.eclipse.riena.ui.ridgets.swt.DefaultRealm;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

@ManualTestCase
public class StatuslineMessageMarkerViewerTest
extends TestCase {
    private static final String EMPTY_STATUSLINE_MESSAGE = "TestEmptyStatusline";
    private DefaultRealm realm;
    private Shell shell;
    private StatuslineMessageMarkerViewer statuslineMessageMarkerViewer;
    private IStatuslineRidget statuslineRidget;
    private Text text1;
    private Text text2;
    private TextRidget ridget1;
    private TextRidget ridget2;

    protected void setUp() throws Exception {
        super.setUp();
        this.realm = new DefaultRealm();
        this.shell = new Shell();
        this.shell.setLayout((Layout)new RowLayout(512));
        this.text1 = new Text((Composite)this.shell, 4);
        this.text2 = new Text((Composite)this.shell, 4);
        this.ridget1 = new TextRidget();
        this.ridget2 = new TextRidget();
        this.ridget1.setUIControl((Object)this.text1);
        this.ridget2.setUIControl((Object)this.text2);
        this.statuslineRidget = (IStatuslineRidget)EasyMock.createMock(IStatuslineRidget.class);
        this.statuslineMessageMarkerViewer = new StatuslineMessageMarkerViewer(this.statuslineRidget);
        this.statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)this.ridget1);
        this.statuslineMessageMarkerViewer.addRidget((IBasicMarkableRidget)this.ridget2);
        this.shell.setSize(100, 100);
        this.shell.setLocation(0, 0);
        this.shell.open();
        this.text1.setFocus();
    }

    protected void tearDown() throws Exception {
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        this.statuslineRidget = null;
        this.ridget1 = null;
        this.ridget2 = null;
        this.text1.dispose();
        this.text1 = null;
        this.text2.dispose();
        this.text2 = null;
        this.shell.dispose();
        this.shell = null;
        this.realm.dispose();
        this.realm = null;
        super.tearDown();
    }

    public void testHandleFocusEvents() throws Exception {
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)EMPTY_STATUSLINE_MESSAGE);
        this.statuslineRidget.error("Test Error in Adapter 1");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.ridget1.addMarker((IMarker)new ErrorMessageMarker("Test Error in Adapter 1"));
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)"Test Error in Adapter 1");
        this.statuslineRidget.setMessage(EMPTY_STATUSLINE_MESSAGE);
        this.statuslineRidget.clear();
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.text2.setFocus();
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
    }

    public void testHandleFocusEventsAndModifiedMessage() throws Exception {
        ErrorMessageMarker errorMessageMarker1 = new ErrorMessageMarker("Test Error in Adapter 1");
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)EMPTY_STATUSLINE_MESSAGE);
        this.statuslineRidget.error("Test Error in Adapter 1");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.ridget1.addMarker((IMarker)errorMessageMarker1);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)"Some message by somebody else");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.text2.setFocus();
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)"Some message by somebody else");
        this.statuslineRidget.error("Test Error in Adapter 1");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.text1.setFocus();
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)"Test Error in Adapter 1");
        this.statuslineRidget.setMessage("Some message by somebody else");
        this.statuslineRidget.clear();
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.ridget1.removeMarker((IMarker)errorMessageMarker1);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)"Some message by somebody else");
        this.statuslineRidget.error("Another Test Error in Adapter 1");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.ridget1.addMarker((IMarker)new ErrorMessageMarker("Another Test Error in Adapter 1"));
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)"Another Test Error in Adapter 1");
        this.statuslineRidget.setMessage("Some message by somebody else");
        this.statuslineRidget.clear();
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.text2.setFocus();
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
    }

    public void testRemoveRidget() throws Exception {
        ErrorMessageMarker errorMessageMarker1 = new ErrorMessageMarker("Test Error in Adapter 1");
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)EMPTY_STATUSLINE_MESSAGE);
        this.statuslineRidget.error("Test Error in Adapter 1");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.ridget1.addMarker((IMarker)errorMessageMarker1);
        this.text1.setFocus();
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.statuslineMessageMarkerViewer.removeRidget((IBasicMarkableRidget)this.ridget2);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)"Test Error in Adapter 1");
        this.statuslineRidget.setMessage(EMPTY_STATUSLINE_MESSAGE);
        this.statuslineRidget.clear();
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.statuslineMessageMarkerViewer.removeRidget((IBasicMarkableRidget)this.ridget1);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
    }

    public void testAddAndRemoveMarkerType() throws Exception {
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.ridget2.addMarker((IMarker)new MessageMarker("TestDifferentMarkerType"));
        this.statuslineMessageMarkerViewer.addMarkerType(MessageMarker.class);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)EMPTY_STATUSLINE_MESSAGE);
        this.statuslineRidget.clear();
        this.statuslineRidget.setMessage("TestDifferentMarkerType");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.text2.setFocus();
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)"TestDifferentMarkerType");
        this.statuslineRidget.setMessage(EMPTY_STATUSLINE_MESSAGE);
        this.statuslineRidget.clear();
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.statuslineMessageMarkerViewer.removeMarkerType(MessageMarker.class);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)EMPTY_STATUSLINE_MESSAGE);
        this.statuslineRidget.clear();
        this.statuslineRidget.setMessage("TestDifferentMarkerType");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.statuslineMessageMarkerViewer.addMarkerType(MessageMarker.class);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
    }

    public void testSetVisible() throws Exception {
        this.statuslineMessageMarkerViewer.setVisible(false);
        this.ridget1.addMarker((IMarker)new ErrorMessageMarker("Test Error in Adapter 1"));
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)EMPTY_STATUSLINE_MESSAGE);
        this.statuslineRidget.error("Test Error in Adapter 1");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.statuslineMessageMarkerViewer.setVisible(true);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)"Test Error in Adapter 1");
        this.statuslineRidget.clear();
        this.statuslineRidget.setMessage(EMPTY_STATUSLINE_MESSAGE);
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.statuslineMessageMarkerViewer.setVisible(false);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.text2.setFocus();
        this.text1.setFocus();
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
    }

    public void testTwoMarkers() throws Exception {
        ErrorMessageMarker marker1 = new ErrorMessageMarker("Test Error 1 in Adapter 1");
        this.statuslineMessageMarkerViewer.addMarkerType(MessageMarker.class);
        MessageMarker marker2 = new MessageMarker("Test Error 2 in Adapter 1");
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)EMPTY_STATUSLINE_MESSAGE);
        this.statuslineRidget.error("Test Error 1 in Adapter 1");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.ridget1.addMarker((IMarker)marker1);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        this.statuslineRidget.error("Test Error 1 in Adapter 1 Test Error 2 in Adapter 1");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.ridget1.addMarker((IMarker)marker2);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        this.statuslineRidget.clear();
        this.statuslineRidget.setMessage("Test Error 2 in Adapter 1");
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.ridget1.removeMarker((IMarker)marker1);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
        EasyMock.reset((Object[])new Object[]{this.statuslineRidget});
        EasyMock.expect((Object)this.statuslineRidget.getMessage()).andReturn((Object)"Test Error 2 in Adapter 1");
        this.statuslineRidget.setMessage(EMPTY_STATUSLINE_MESSAGE);
        this.statuslineRidget.clear();
        EasyMock.replay((Object[])new Object[]{this.statuslineRidget});
        this.ridget1.removeMarker((IMarker)marker2);
        EasyMock.verify((Object[])new Object[]{this.statuslineRidget});
    }
}

