/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import junit.framework.TestCase;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.riena.core.test.collect.UITestCase;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.ui.swt.AbstractMasterDetailsComposite;
import org.eclipse.riena.ui.swt.layout.DpiGridLayout;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;

@UITestCase
public class AbstractMasterDetailsCompositeTest
extends TestCase {
    private Shell shell;

    protected void setUp() throws Exception {
        this.shell = new Shell(Display.getDefault(), 17648);
        this.shell.setLayout((Layout)new FillLayout());
    }

    protected void tearDown() throws Exception {
        SwtUtilities.dispose((Widget)this.shell);
    }

    public void testAbstractMasterDetailsComposite() throws Exception {
        RienaDefaultLnf defaultLnf = LnfManager.getLnf();
        MyLnf lnf = new MyLnf();
        lnf.setUseDpiGridLayout(false);
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        lnf.initialize();
        MyMasterDetailsComposite composite = new MyMasterDetailsComposite((Composite)this.shell, -1, 128);
        AbstractMasterDetailsCompositeTest.assertTrue((boolean)(composite.getLayout() instanceof GridLayout));
        lnf.setUseDpiGridLayout(true);
        composite = new MyMasterDetailsComposite((Composite)this.shell, -1, 128);
        AbstractMasterDetailsCompositeTest.assertTrue((boolean)(composite.getLayout() instanceof DpiGridLayout));
        LnfManager.setLnf((RienaDefaultLnf)defaultLnf);
    }

    public void testGetMargins() throws Exception {
        MyLnf lnf = new MyLnf();
        lnf.setUseDpiGridLayout(false);
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        lnf.initialize();
        MyMasterDetailsComposite composite = new MyMasterDetailsComposite((Composite)this.shell, -1, 128);
        ((GridLayout)composite.getLayout()).marginHeight = 10;
        ((GridLayout)composite.getLayout()).marginWidth = 12;
        AbstractMasterDetailsCompositeTest.assertEquals((int)10, (int)composite.getMargins().x);
        AbstractMasterDetailsCompositeTest.assertEquals((int)12, (int)composite.getMargins().y);
        lnf.setUseDpiGridLayout(true);
        composite = new MyMasterDetailsComposite((Composite)this.shell, -1, 128);
        ((DpiGridLayout)composite.getLayout()).marginHeight = 4;
        ((DpiGridLayout)composite.getLayout()).marginWidth = 6;
        AbstractMasterDetailsCompositeTest.assertEquals((int)4, (int)composite.getMargins().x);
        AbstractMasterDetailsCompositeTest.assertEquals((int)6, (int)composite.getMargins().y);
    }

    public void testGetSpacing() throws Exception {
        MyLnf lnf = new MyLnf();
        lnf.setUseDpiGridLayout(false);
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        lnf.initialize();
        MyMasterDetailsComposite composite = new MyMasterDetailsComposite((Composite)this.shell, -1, 128);
        Composite masterAreaComposite = (Composite)ReflectionUtils.getHidden((Object)((Object)composite), (String)"master");
        ((GridLayout)masterAreaComposite.getLayout()).horizontalSpacing = 33;
        ((GridLayout)composite.getLayout()).verticalSpacing = 22;
        AbstractMasterDetailsCompositeTest.assertEquals((int)33, (int)composite.getSpacing().x);
        AbstractMasterDetailsCompositeTest.assertEquals((int)22, (int)composite.getSpacing().y);
        lnf.setUseDpiGridLayout(true);
        composite = new MyMasterDetailsComposite((Composite)this.shell, -1, 128);
        masterAreaComposite = (Composite)ReflectionUtils.getHidden((Object)((Object)composite), (String)"master");
        ((DpiGridLayout)masterAreaComposite.getLayout()).horizontalSpacing = 9;
        ((DpiGridLayout)composite.getLayout()).verticalSpacing = 16;
        AbstractMasterDetailsCompositeTest.assertEquals((int)9, (int)composite.getSpacing().x);
        AbstractMasterDetailsCompositeTest.assertEquals((int)16, (int)composite.getSpacing().y);
    }

    public void testSetMargins() throws Exception {
        MyLnf lnf = new MyLnf();
        lnf.setUseDpiGridLayout(false);
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        lnf.initialize();
        MyMasterDetailsComposite composite = new MyMasterDetailsComposite((Composite)this.shell, -1, 128);
        composite.setMargins(12, 34);
        AbstractMasterDetailsCompositeTest.assertEquals((int)12, (int)composite.getMargins().x);
        AbstractMasterDetailsCompositeTest.assertEquals((int)34, (int)composite.getMargins().y);
        lnf.setUseDpiGridLayout(true);
        composite = new MyMasterDetailsComposite((Composite)this.shell, -1, 128);
        composite.setMargins(9, 8);
        AbstractMasterDetailsCompositeTest.assertEquals((int)9, (int)composite.getMargins().x);
        AbstractMasterDetailsCompositeTest.assertEquals((int)8, (int)composite.getMargins().y);
    }

    public void testSetSpacing() throws Exception {
        MyLnf lnf = new MyLnf();
        lnf.setUseDpiGridLayout(false);
        LnfManager.setLnf((RienaDefaultLnf)lnf);
        lnf.initialize();
        MyMasterDetailsComposite composite = new MyMasterDetailsComposite((Composite)this.shell, -1, 128);
        composite.setSpacing(11, 22);
        AbstractMasterDetailsCompositeTest.assertEquals((int)11, (int)composite.getSpacing().x);
        AbstractMasterDetailsCompositeTest.assertEquals((int)22, (int)composite.getSpacing().y);
        lnf.setUseDpiGridLayout(true);
        composite = new MyMasterDetailsComposite((Composite)this.shell, -1, 128);
        composite.setSpacing(31, 41);
        AbstractMasterDetailsCompositeTest.assertEquals((int)31, (int)composite.getSpacing().x);
        AbstractMasterDetailsCompositeTest.assertEquals((int)41, (int)composite.getSpacing().y);
    }

    private static class MyLnf
    extends RienaDefaultLnf {
        private boolean dpi;

        private MyLnf() {
        }

        public void setUseDpiGridLayout(boolean dpi) {
            this.dpi = dpi;
        }

        public boolean useDpiGridLayout() {
            return this.dpi;
        }
    }

    private static class MyMasterDetailsComposite
    extends AbstractMasterDetailsComposite {
        public MyMasterDetailsComposite(Composite parent, int style, int orientation) {
            super(parent, style, orientation);
        }

        protected Control createTable(Composite tableComposite, TableColumnLayout layout) {
            return new Table(tableComposite, -1);
        }
    }
}

