/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.EventListener;
import org.eclipse.riena.core.util.ReflectionUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.core.wire.Wire;
import org.eclipse.riena.internal.ui.ridgets.swt.IRenderDisabledStateWidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DisabledMarkerVisualizer {
    private static final EventListener DISABLED_MARKER_PAINTER = SWTFacade.getDefault().createDisabledPainter();
    private static boolean isRCP = SWTFacade.isRCP();
    private final IRidget ridget;
    private static IRenderDisabledStateWidget[] renderDisabledStateWidgets;

    public DisabledMarkerVisualizer(IRidget ridget) {
        this.ridget = ridget;
        Wire.instance((Object)this).andStart();
    }

    public void updateDisabled() {
        Control control = this.getControl();
        if (control == null) {
            return;
        }
        boolean enabled = this.getRidget().isEnabled();
        this.updateDisabled(control, enabled);
    }

    protected void removePaintlistener(Control control) {
        SWTFacade facade = SWTFacade.getDefault();
        facade.removePaintListener(control, DISABLED_MARKER_PAINTER);
    }

    protected void addPaintlistener(Control control) {
        SWTFacade facade = SWTFacade.getDefault();
        facade.addPaintListener(control, DISABLED_MARKER_PAINTER);
    }

    private Control getControl() {
        return (Control)this.getRidget().getUIControl();
    }

    private IRidget getRidget() {
        return this.ridget;
    }

    public void updateDisabled(Control control, boolean enabled) {
        control.setEnabled(enabled);
        this.updatePaintListener(control, enabled);
        control.redraw();
    }

    private void updatePaintListener(Control control, boolean enabled) {
        if (this.dontAddDisabledPainter(control)) {
            return;
        }
        this.removePaintlistener(control);
        if (!enabled) {
            this.addPaintlistener(control);
        }
        if (control instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)control;
            Control[] controlArray = children = this.getChildren(composite);
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.updatePaintListener(child, enabled);
                ++n2;
            }
        }
    }

    protected boolean dontAddDisabledPainter(Control control) {
        if (renderDisabledStateWidgets != null) {
            IRenderDisabledStateWidget[] iRenderDisabledStateWidgetArray = renderDisabledStateWidgets;
            int n = renderDisabledStateWidgets.length;
            int n2 = 0;
            while (n2 < n) {
                IRenderDisabledStateWidget renderDisabledStateWidget = iRenderDisabledStateWidgetArray[n2];
                if (control.getClass().equals(renderDisabledStateWidget.getWidgetClass())) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    private Control[] getChildren(Composite parent) {
        Control[] result = parent.getChildren();
        if (isRCP && parent instanceof CCombo) {
            result = new Control[]{(Control)ReflectionUtils.getHidden((Object)parent, (String)"text"), (Control)ReflectionUtils.getHidden((Object)parent, (String)"arrow")};
        }
        return result;
    }

    @InjectExtension
    public static void update(IRenderDisabledStateWidget[] renderDisabledStateWidgets) {
        DisabledMarkerVisualizer.renderDisabledStateWidgets = renderDisabledStateWidgets;
    }
}

