/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemProperties;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuRidget;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class MenuProperties
extends MenuItemProperties {
    private final Decorations menuParent;
    private final int menuStyle;
    private final MenuItemProperties[] children;

    public MenuProperties(MenuRidget ridget) {
        super(ridget);
        MenuItem item = ridget.getUIControl();
        Assert.isNotNull((Object)item);
        Menu menu = item.getMenu();
        Assert.isNotNull((Object)menu);
        this.menuParent = menu.getParent();
        this.menuStyle = menu.getStyle();
        List<MenuItemRidget> childRidgets = ridget.getChildren();
        this.children = new MenuItemProperties[childRidgets.size()];
        int i = 0;
        while (i < this.children.length) {
            MenuItemRidget childRidget = childRidgets.get(i);
            this.children[i] = childRidget instanceof MenuRidget ? new MenuProperties((MenuRidget)childRidget) : new MenuItemProperties(childRidget);
            ++i;
        }
    }

    @Override
    protected MenuRidget getRidget() {
        return (MenuRidget)super.getRidget();
    }

    @Override
    protected MenuItem createItem() {
        MenuItem menuItem = new MenuItem(this.getParent(), this.getStyle(), this.getIndex());
        this.setAllProperties((Item)menuItem, true);
        Menu menu = new Menu(this.menuParent, this.menuStyle);
        menuItem.setMenu(menu);
        MenuItemProperties[] menuItemPropertiesArray = this.children;
        int n = this.children.length;
        int n2 = 0;
        while (n2 < n) {
            MenuItemProperties child = menuItemPropertiesArray[n2];
            child.createItem(menu);
            this.getRidget().addChild(child.getRidget());
            ++n2;
        }
        this.getRidget().setUIControl(menuItem);
        return menuItem;
    }
}

