/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.riena.internal.ui.ridgets.swt.AbstractItemProperties;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuItemRidget;
import org.eclipse.riena.internal.ui.ridgets.swt.MenuProperties;
import org.eclipse.riena.ui.ridgets.IMenuRidget;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.MenuItem;

public class MenuRidget
extends MenuItemRidget
implements IMenuRidget {
    private final List<MenuItemRidget> children = new ArrayList<MenuItemRidget>();
    private final DisposeListener disposeListener = new ChildDisposeListener();

    @Override
    protected void checkUIControl(Object uiControl) {
        this.checkType(uiControl, MenuItem.class);
        if (uiControl != null && !this.isMenu((MenuItem)uiControl)) {
            throw new BindingException("Menu item is not a cascade menu item!");
        }
    }

    @Override
    AbstractItemProperties createProperties() {
        return new MenuProperties(this);
    }

    public void addChild(MenuItemRidget child) {
        this.children.add(child);
        child.getUIControl().addDisposeListener(this.disposeListener);
    }

    public List<MenuItemRidget> getChildren() {
        return this.children;
    }

    private MenuItemRidget getChild(String id) {
        List<MenuItemRidget> menuItems = this.getChildren();
        for (MenuItemRidget menuItem : menuItems) {
            if (menuItem.getID() == null || !menuItem.getID().equals(id)) continue;
            return menuItem;
        }
        return null;
    }

    private void removeChild(MenuItem item) {
        String id = SWTBindingPropertyLocator.getInstance().locateBindingProperty((Object)item);
        MenuItemRidget child = this.getChild(id);
        if (child != null) {
            this.getChildren().remove((Object)child);
        }
    }

    private class ChildDisposeListener
    implements DisposeListener {
        private ChildDisposeListener() {
        }

        public void widgetDisposed(DisposeEvent e) {
            if (e.getSource() instanceof MenuItem) {
                MenuItem item = (MenuItem)e.getSource();
                MenuRidget.this.removeChild(item);
            }
        }
    }
}

