/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.internal.ui.ridgets.swt.NumericTextRidget;

public class NumericString {
    private Digit start;
    private final boolean isGrouping;

    public NumericString(String value, boolean isGrouping) {
        Assert.isNotNull((Object)value);
        if (value.length() > 0) {
            Digit prev = null;
            int i = 0;
            while (i < value.length()) {
                char ch = value.charAt(i);
                prev = new Digit(ch, prev);
                if (i == 0) {
                    this.start = prev;
                }
                ++i;
            }
        }
        this.isGrouping = isGrouping;
        if (isGrouping) {
            this.applyGrouping();
        }
    }

    public int delete(int from, int to, char ch) {
        int delta;
        Assert.isLegal((-1 < from ? 1 : 0) != 0);
        Assert.isLegal((from < to ? 1 : 0) != 0);
        int n = delta = '\b' == ch ? -1 : 1;
        if (to - from == 1) {
            Digit fromDigit = this.findDigit(from);
            fromDigit.delete(delta);
        } else {
            Digit fromDigit = this.findDigit(from);
            Digit toDigitExcl = this.findDigit(to);
            boolean endsWithSep = toDigitExcl != null && toDigitExcl.prev != null && toDigitExcl.prev.isDecimalSeparator();
            fromDigit.delete(toDigitExcl);
            if (endsWithSep && toDigitExcl.prev != null) {
                toDigitExcl.prev.setCursorBefore();
            } else if (toDigitExcl != null) {
                toDigitExcl.setCursorBefore();
            } else {
                Digit lastDigit = this.getLastDigit();
                if (lastDigit != null && lastDigit == this.start && lastDigit.isDecimalSeparator()) {
                    lastDigit.setCursorBefore();
                } else if (lastDigit != null) {
                    lastDigit.setCursorAfter();
                }
            }
        }
        this.applyGrouping();
        return this.getCursorLocation();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.start != null) {
            Digit current = this.start;
            while (current != null) {
                result.append(current.toString());
                current = current.next;
            }
        }
        return result.toString();
    }

    private void applyGrouping() {
        if (!this.isGrouping) {
            return;
        }
        Digit here = this.start;
        while (here != null) {
            if (here.isGroupingSeparator()) {
                here.deleteThis();
            }
            here = here.next;
        }
        Digit decSep = null;
        Digit lastDigit = null;
        here = this.start;
        while (decSep == null && here != null) {
            if (here.isDecimalSeparator()) {
                decSep = here;
            }
            if (here.next == null) {
                lastDigit = here;
            }
            here = here.next;
        }
        Digit firstDigit = decSep != null ? decSep.prev : lastDigit;
        int i = 2;
        while (firstDigit != null) {
            if (i == 0 && firstDigit.prev != null && Character.isDigit(firstDigit.prev.ch)) {
                Digit sep = new Digit(NumericTextRidget.GROUPING_SEPARATOR, null);
                sep.next = firstDigit;
                sep.prev = firstDigit.prev;
                firstDigit.prev.next = sep;
                firstDigit.prev = sep;
                i = 4;
            }
            --i;
            firstDigit = firstDigit.prev;
        }
    }

    private int getCursorLocation() {
        int result = this.start == null ? 0 : -1;
        Digit here = this.start;
        int index = 0;
        while (result == -1 && here != null) {
            if (here.isCursorBeforeMe()) {
                result = index;
            } else if (here.isCursorAfterMe()) {
                result = index + 1;
            }
            ++index;
            here = here.next;
        }
        return result;
    }

    private Digit getLastDigit() {
        Digit result = this.start;
        while (result != null && result.next != null) {
            result = result.next;
        }
        return result;
    }

    private Digit findDigit(int index) {
        Digit result = null;
        Digit here = this.start;
        int count = index;
        while (here != null && count >= 0) {
            if (count == 0) {
                result = here;
            }
            here = here.next;
            --count;
        }
        return result;
    }

    private final class Digit {
        private final char ch;
        private boolean cursorAfterMe;
        private boolean cursorBeforeMe;
        private Digit prev;
        private Digit next;

        public Digit(char ch, Digit prev) {
            this.ch = ch;
            this.prev = prev;
            if (prev != null) {
                prev.next = this;
            }
        }

        public void deleteThis() {
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev == null) {
                NumericString.this.start = this.next;
            }
            if (this.cursorAfterMe) {
                if (this.next != null) {
                    this.next.setCursorBefore();
                } else if (this.prev != null) {
                    this.prev.setCursorAfter();
                }
            }
            if (this.cursorBeforeMe) {
                if (this.prev != null) {
                    this.prev.setCursorAfter();
                } else if (this.next != null) {
                    this.next.setCursorBefore();
                }
            }
        }

        public void delete(int delta) {
            Assert.isLegal((delta == -1 || delta == 1 ? 1 : 0) != 0);
            if (this.isSeparator()) {
                if (delta == -1) {
                    if (this.prev != null) {
                        this.prev.delete(delta);
                    } else {
                        this.setCursorBefore();
                    }
                } else if (delta == 1) {
                    if (this.next != null) {
                        this.next.delete(delta);
                    } else {
                        this.setCursorAfter();
                    }
                }
            } else {
                this.deleteThis();
                if (this.prev != null) {
                    this.prev.setCursorAfter();
                } else if (this.next != null) {
                    this.next.setCursorBefore();
                }
            }
        }

        public void delete(Digit end) {
            if (this != end) {
                boolean hasNext;
                boolean hasPrev = this.prev != null;
                boolean bl = hasNext = this.next != null;
                if (!this.isDecimalSeparator()) {
                    if (hasPrev) {
                        this.prev.next = this.next;
                    } else {
                        NumericString.this.start = this.next;
                    }
                    if (hasNext) {
                        this.next.prev = this.prev;
                    }
                }
                if (hasNext) {
                    this.next.delete(end);
                }
            }
        }

        public boolean isCursorAfterMe() {
            return this.cursorAfterMe;
        }

        public boolean isCursorBeforeMe() {
            return this.cursorBeforeMe;
        }

        public boolean isSeparator() {
            return this.isDecimalSeparator() || this.isGroupingSeparator();
        }

        public boolean isDecimalSeparator() {
            return NumericTextRidget.DECIMAL_SEPARATOR == this.ch;
        }

        public boolean isGroupingSeparator() {
            return NumericTextRidget.GROUPING_SEPARATOR == this.ch;
        }

        public void setCursorAfter() {
            this.resetCursorLocation();
            this.cursorAfterMe = true;
            if (this.next != null) {
                this.next.cursorBeforeMe = true;
            }
        }

        public void setCursorBefore() {
            this.resetCursorLocation();
            this.cursorBeforeMe = true;
            if (this.prev != null) {
                this.prev.cursorAfterMe = true;
            }
        }

        public String toString() {
            return String.valueOf(this.ch);
        }

        private void resetCursorLocation() {
            Digit p = this;
            while (p != null) {
                p.cursorAfterMe = false;
                p.cursorBeforeMe = false;
                p = p.prev;
            }
            Digit n = this.next;
            while (n != null) {
                n.cursorAfterMe = false;
                n.cursorBeforeMe = false;
                n = n.next;
            }
        }
    }
}

