/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.annotationprocessor.AnnotationProcessor;
import org.eclipse.riena.core.marker.IMarkable;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.ridgets.AbstractCompositeRidget;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMarkableRidget;
import org.eclipse.riena.ui.ridgets.IMasterDetailsActionRidgetFacade;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.IStatuslineRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.swt.AbstractMasterDetailsComposite;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractMasterDetailsRidget
extends AbstractCompositeRidget
implements IMasterDetailsRidget {
    private static final GlobalMandatoryMarker GLOBAL_MARKER = new GlobalMandatoryMarker();
    private IObservableList rowObservables;
    private IMasterDetailsDelegate delegate;
    private DataBindingContext dbc;
    private Object blankEntry;
    private Object editable;
    private IRidgetContainer detailRidgets;
    private boolean applyRequiresNoErrors;
    private boolean applyRequiresNoMandatories;
    private boolean applyTriggersNew;
    private boolean detailsEnabled;
    private boolean ignoreChanges;
    private boolean isDirectWriting;
    private boolean isHideMarkersOnNew;
    private boolean isHidingMarkersOnNew;
    private boolean isShowingGlobalMarker;
    private boolean isSuggestedEditable;
    private boolean removeCancelsNew;
    private boolean removeTriggersNew;
    private StoredSelection preNewSelection;
    private ActionRidgetFacade actionRidgetFacade = new ActionRidgetFacade();

    public AbstractMasterDetailsRidget() {
        this.addPropertyChangeListener(null, new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if (!AbstractMasterDetailsRidget.this.hasApplyButton() || AbstractMasterDetailsRidget.this.isDirectWriting || AbstractMasterDetailsRidget.this.ignoreChanges || AbstractMasterDetailsRidget.this.delegate == null || AbstractMasterDetailsRidget.this.editable == null || !AbstractMasterDetailsRidget.this.applyRequiresNoErrors && !AbstractMasterDetailsRidget.this.applyRequiresNoMandatories && "marker".equals(propertyName) || "enabled".equals(propertyName) || "textInternal".equals(propertyName) || "output".equals(propertyName) || "markerHiding".equals(propertyName) || "marker".equals(propertyName) && AbstractMasterDetailsRidget.this.getApplyButtonRidget() == evt.getSource()) {
                    return;
                }
                AbstractMasterDetailsRidget.this.updateMarkers(evt);
                AbstractMasterDetailsRidget.this.updateApplyButton();
            }
        });
    }

    public final void bindToModel(IObservableList rowObservables, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] columnHeaders) {
        this.rowObservables = rowObservables;
        this.bindTableToModel(rowObservables, rowClass, columnPropertyNames, columnHeaders);
    }

    public final void bindToModel(Object listHolder, String listPropertyName, Class<? extends Object> rowClass, String[] columnPropertyNames, String[] headerNames) {
        IObservableList rowObservableList = AbstractSWTWidgetRidget.isBean(rowClass) ? BeansObservables.observeList((Object)listHolder, (String)listPropertyName) : PojoObservables.observeList((Object)listHolder, (String)listPropertyName);
        this.bindToModel(rowObservableList, rowClass, columnPropertyNames, headerNames);
    }

    public boolean canSuggest() {
        boolean result = true;
        if (this.areDetailsChanged()) {
            result = this.getUIControl().confirmDiscardChanges();
        }
        return result;
    }

    public void configureRidgets() {
        this.configureTableRidget();
        if (this.hasNewButton()) {
            this.getNewButtonRidget().addListener(new IActionListener(){

                public void callback() {
                    if (AbstractMasterDetailsRidget.this.canAdd()) {
                        AbstractMasterDetailsRidget.this.handleAdd();
                    }
                }
            });
        }
        if (this.hasRemoveButton()) {
            this.getRemoveButtonRidget().addListener(new IActionListener(){

                public void callback() {
                    if (AbstractMasterDetailsRidget.this.hasPreNewSelection()) {
                        if (AbstractMasterDetailsRidget.this.canCancel()) {
                            AbstractMasterDetailsRidget.this.handleCancel();
                        }
                    } else if (AbstractMasterDetailsRidget.this.canRemove()) {
                        AbstractMasterDetailsRidget.this.handleRemove();
                    }
                }
            });
        }
        if (this.hasApplyButton()) {
            this.getApplyButtonRidget().addListener(new IActionListener(){

                public void callback() {
                    if (AbstractMasterDetailsRidget.this.canApply()) {
                        AbstractMasterDetailsRidget.this.handleApply();
                    }
                }
            });
        }
        this.setEnabled(false, this.detailsEnabled);
        final IObservableValue viewerSelection = this.getSelectionObservable();
        Assert.isLegal((this.dbc == null ? 1 : 0) != 0);
        if (this.hasRemoveButton()) {
            this.dbc = new DataBindingContext();
            this.bindEnablementToValue(this.dbc, (IRidget)this.getRemoveButtonRidget(), (IObservableValue)new ComputedValue(Boolean.TYPE){

                protected Object calculate() {
                    return viewerSelection.getValue() != null;
                }
            });
        }
        DirectWritingPropertyChangeListener directWritingPCL = new DirectWritingPropertyChangeListener();
        for (IRidget ridget : this.getDetailRidgetContainer().getRidgets()) {
            ridget.addPropertyChangeListener((PropertyChangeListener)directWritingPCL);
        }
    }

    private IRidgetContainer getDetailRidgetContainer() {
        if (this.detailRidgets == null) {
            this.detailRidgets = new DetailRidgetContainer();
        }
        return this.detailRidgets;
    }

    public final IMasterDetailsDelegate getDelegate() {
        return this.delegate;
    }

    public final Object getSelection() {
        return this.getSelectionObservable().getValue();
    }

    public AbstractMasterDetailsComposite getUIControl() {
        return (AbstractMasterDetailsComposite)super.getUIControl();
    }

    public boolean isApplyRequiresNoErrors() {
        return this.applyRequiresNoErrors;
    }

    public boolean isApplyRequiresNoMandatories() {
        return this.applyRequiresNoMandatories;
    }

    public boolean isApplyTriggersNew() {
        return this.applyTriggersNew && this.hasNewButton();
    }

    public boolean isDirectWriting() {
        return this.isDirectWriting;
    }

    public boolean isHideMandatoryAndErrorMarkersOnNewEntries() {
        return this.isHideMarkersOnNew;
    }

    public boolean isRemoveCancelsNew() {
        return this.removeCancelsNew && this.hasRemoveButton();
    }

    public boolean isRemoveTriggersNew() {
        return this.removeTriggersNew && this.hasRemoveButton();
    }

    public void setApplyRequiresNoErrors(boolean requiresNoErrors) {
        if (this.applyRequiresNoErrors != requiresNoErrors) {
            this.applyRequiresNoErrors = requiresNoErrors;
            this.updateApplyButton();
        }
    }

    public void setApplyRequiresNoMandatories(boolean requiresNoMandatories) {
        if (this.applyRequiresNoMandatories != requiresNoMandatories) {
            this.applyRequiresNoMandatories = requiresNoMandatories;
            this.updateApplyButton();
        }
    }

    public void setApplyTriggersNew(boolean triggersNew) {
        this.applyTriggersNew = triggersNew;
    }

    public void setColumnWidths(Object[] widths) {
        ((ITableRidget)this.getTableRidget()).setColumnWidths(widths);
    }

    public final void setDelegate(IMasterDetailsDelegate delegate) {
        Assert.isLegal((this.delegate == null ? 1 : 0) != 0, (String)"setDelegate can only be called once");
        Assert.isLegal((delegate != null ? 1 : 0) != 0, (String)"delegate cannot be null");
        this.delegate = delegate;
        delegate.configureRidgets(this.getDetailRidgetContainer());
        AnnotationProcessor.getInstance().processMethods((Object)this.getDetailRidgetContainer(), (Object)delegate);
    }

    public void setDirectWriting(boolean directWriting) {
        if (directWriting != this.isDirectWriting) {
            this.isDirectWriting = directWriting;
            if (this.hasApplyButton()) {
                this.getApplyButtonRidget().setVisible(!directWriting);
            }
        }
    }

    public void setHideMandatoryAndErrorMarkersOnNewEntries(boolean hideMarkers) {
        this.isHideMarkersOnNew = hideMarkers;
    }

    public void setRemoveCancelsNew(boolean cancelsNew) {
        this.removeCancelsNew = cancelsNew;
    }

    public void setRemoveTriggersNew(boolean triggersNew) {
        this.removeTriggersNew = triggersNew;
    }

    public void setSelection(Object newSelection) {
        this.setTableSelection(newSelection);
        this.handleSelectionChange(newSelection);
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            this.revealTableSelection();
        }
    }

    public void suggestNewEntry() {
        Object entry = this.delegate.createMasterEntry();
        this.suggestNewEntry(entry, false);
    }

    public void suggestNewEntry(Object entry) {
        this.suggestNewEntry(entry, true);
    }

    public void suggestNewEntry(Object entry, boolean treatAsDirty) {
        this.ignoreChanges = true;
        try {
            if (!this.isDirectWriting) {
                this.clearTableSelection();
                this.editable = entry;
                this.delegate.prepareItemSelected(this.editable);
                this.updateMarkers(this.isHideMarkersOnNew, this.isShowGlobalMarker());
                this.setEnabled(treatAsDirty, true);
                this.isSuggestedEditable = treatAsDirty;
                this.updateDetails(this.editable);
                this.ignoreChanges = true;
                this.delegate.itemSelected(this.editable);
            } else {
                this.editable = entry;
                this.delegate.itemCreated(this.editable);
                this.rowObservables.add(this.editable);
                this.getTableRidget().updateFromModel();
                this.setSelection(this.editable);
                this.isSuggestedEditable = false;
                this.updateMarkers(this.isHideMarkersOnNew, this.isShowGlobalMarker());
                this.setEnabled(false, true);
                this.updateDetails(this.editable);
            }
            if (!this.setFocusToFirstDetailsRidget()) {
                this.getApplyButtonRidget().requestFocus();
            }
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    private boolean setFocusToFirstDetailsRidget() {
        Collection ridgets = this.getDetailRidgetContainer().getRidgets();
        IRidget[] ridgetArray = ridgets.toArray(new IRidget[ridgets.size()]);
        if (!ridgets.isEmpty()) {
            int i = ridgetArray.length - 1;
            while (i >= 0) {
                IRidget current = ridgetArray[i];
                if (current.isEnabled() && current.isFocusable() && (!(current instanceof IMarkableRidget) || !((IMarkableRidget)current).isOutputOnly())) {
                    current.requestFocus();
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    public final void updateApplyButton() {
        if (!this.hasApplyButton()) {
            return;
        }
        if (this.applyRequiresNoErrors || this.applyRequiresNoMandatories) {
            boolean isEnabled = !(!this.areDetailsChanged() || this.applyRequiresNoErrors && this.hasErrors(this.getDetailRidgetContainer()) || this.applyRequiresNoMandatories && this.hasMandatories(this.getDetailRidgetContainer()));
            this.getApplyButtonRidget().setEnabled(isEnabled);
        } else {
            this.getApplyButtonRidget().setEnabled(this.areDetailsChanged());
        }
        if (this.delegate != null) {
            this.delegate.updateMasterDetailsActionRidgets((IMasterDetailsActionRidgetFacade)this.actionRidgetFacade, this.editable);
        }
    }

    public void updateFromModel() {
        this.checkDelegate();
        super.updateFromModel();
    }

    protected void checkUIControl(Object uiControl) {
        this.checkType(uiControl, AbstractMasterDetailsComposite.class);
    }

    protected abstract void bindTableToModel(IObservableList var1, Class<? extends Object> var2, String[] var3, String[] var4);

    protected abstract void configureTableRidget();

    protected abstract void clearTableSelection();

    protected abstract Object getTableSelection();

    protected abstract IObservableValue getSelectionObservable();

    protected abstract void revealTableSelection();

    protected abstract void setTableSelection(Object var1);

    protected final boolean areDetailsChanged() {
        if (this.detailsEnabled && this.editable != null) {
            return this.isSuggestedEditable || this.delegate.isChanged(this.editable, this.delegate.getWorkingCopy());
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void handleSelectionChange(Object newSelection) {
        table = (IMarkableRidget)this.getRidget(IMarkableRidget.class, "mdTable");
        errorMarkers = table.getMarkersOfType(ErrorMarker.class);
        for (ErrorMarker m : errorMarkers) {
            table.removeMarker((IMarker)m);
        }
        this.updateBorder((IRidget)table);
        this.ignoreChanges = true;
        try {
            this.delegate.prepareItemSelected(newSelection);
            this.updateBorder((IRidget)table);
            this.delegate.updateMasterDetailsActionRidgets((IMasterDetailsActionRidgetFacade)this.actionRidgetFacade, newSelection);
            if (newSelection != null) {
                if (this.editable == null) {
                    this.updateMarkers(true, false);
                }
                this.editable = newSelection;
                this.setEnabled(false, true);
                this.updateDetails(this.editable);
                this.updateMarkers(false, false);
            } else {
                this.setEnabled(false, false);
                this.clearSelection();
                this.setEnabled(false, false);
                this.updateMarkers(false, false);
            }
            this.ignoreChanges = true;
            this.delegate.itemSelected(newSelection);
            this.clearPreNewSelection();
        }
        finally {
            this.ignoreChanges = false;
            ** for (m : errorMarkers)
        }
lbl-1000:
        // 1 sources

        {
            table.addMarker((IMarker)m);
            continue;
        }
lbl34:
        // 1 sources

        this.updateBorder((IRidget)table);
    }

    private void updateBorder(IRidget ridget) {
        if (ridget == null || !(ridget.getUIControl() instanceof Control)) {
            return;
        }
        ((Control)ridget.getUIControl()).getDisplay().update();
    }

    protected boolean isUIControlVisible() {
        return this.getUIControl().isVisible();
    }

    protected final void updateEnabled() {
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            if (!this.isEnabled()) {
                this.clearSelection();
                this.clearTableSelection();
                Collection ridgets = this.getRidgets();
                for (IRidget ridget : ridgets) {
                    ridget.setEnabled(false);
                }
            } else {
                if (this.getTableRidget() != null) {
                    this.getTableRidget().setEnabled(true);
                }
                if (this.getNewButtonRidget() != null) {
                    this.getNewButtonRidget().setEnabled(true);
                }
            }
            control.setEnabled(this.isEnabled());
        }
    }

    protected final void updateToolTipText() {
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            control.setToolTipText(this.getToolTipText());
        }
    }

    protected final void updateVisible() {
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            control.setVisible(!this.isMarkedHidden());
        }
    }

    private void assertIsBoundToModel() {
        if (this.rowObservables == null) {
            throw new BindingException("ridget not bound to model");
        }
    }

    private void bindEnablementToValue(DataBindingContext dbc, IRidget ridget, IObservableValue value) {
        Assert.isNotNull((Object)ridget);
        Assert.isNotNull((Object)value);
        IObservableValue ridgetObservable = BeansObservables.observeValue((Object)ridget, (String)"enabled");
        dbc.bindValue(ridgetObservable, value, null, null);
        ridgetObservable.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                if (AbstractMasterDetailsRidget.this.delegate != null) {
                    AbstractMasterDetailsRidget.this.delegate.updateMasterDetailsActionRidgets((IMasterDetailsActionRidgetFacade)AbstractMasterDetailsRidget.this.actionRidgetFacade, AbstractMasterDetailsRidget.this.getTableSelection());
                }
            }
        });
    }

    private boolean canAdd() {
        boolean result = true;
        if (this.areDetailsChanged()) {
            result = this.getUIControl().confirmDiscardChanges();
        }
        return result;
    }

    private boolean canApply() {
        String reason = this.delegate.isValid(this.getDetailRidgetContainer());
        if (reason != null) {
            this.getUIControl().warnApplyFailed(reason);
        }
        return reason == null;
    }

    private boolean canApplyDirectly() {
        boolean noMandatories;
        boolean noErrors;
        boolean bl = this.applyRequiresNoErrors ? !this.hasErrors(this.getDetailRidgetContainer()) : (noErrors = true);
        boolean bl2 = this.applyRequiresNoMandatories ? !this.hasMandatories(this.getDetailRidgetContainer()) : (noMandatories = true);
        return noErrors && noMandatories && this.delegate.isValid(this.getDetailRidgetContainer()) == null;
    }

    private boolean canCancel() {
        boolean result = true;
        if (this.areDetailsChanged()) {
            result = this.getUIControl().confirmDiscardChanges();
        }
        return result;
    }

    private boolean canRemove() {
        Object selection = this.getSelection();
        Assert.isNotNull((Object)selection);
        String reason = this.delegate.isRemovable(selection);
        if (reason != null) {
            this.getUIControl().warnRemoveFailed(reason);
            return false;
        }
        return this.getUIControl().confirmRemove(selection);
    }

    private void checkDelegate() {
        if (this.delegate == null) {
            throw new IllegalStateException("no delegate: call setDelegate(...)");
        }
    }

    private void clearPreNewSelection() {
        this.preNewSelection = null;
    }

    protected void clearSelection() {
        this.updateDetails(this.getBlankEntry());
        this.editable = null;
    }

    private Object getBlankEntry() {
        if (this.blankEntry == null) {
            this.blankEntry = this.delegate.createMasterEntry();
        }
        return this.blankEntry;
    }

    private Control getDetailsControl() {
        Composite result = null;
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            result = control.getDetails();
        }
        return result;
    }

    private IRidget getTableRidget() {
        return this.getRidget("mdTable");
    }

    private IActionRidget getNewButtonRidget() {
        return (IActionRidget)this.getRidget(IActionRidget.class, "mdNewButton");
    }

    private IActionRidget getRemoveButtonRidget() {
        return (IActionRidget)this.getRidget(IActionRidget.class, "mdRemoveButton");
    }

    private IActionRidget getApplyButtonRidget() {
        return (IActionRidget)this.getRidget(IActionRidget.class, "mdApplyButton");
    }

    private boolean hasErrors(IRidgetContainer ridgetContainer) {
        boolean foundMarker = this.hasErrors(ridgetContainer.getRidgets());
        if (!foundMarker) {
            Iterator iter = ridgetContainer.getRidgets().iterator();
            while (!foundMarker && iter.hasNext()) {
                IRidget ridget = (IRidget)iter.next();
                if (!(ridget instanceof IRidgetContainer)) continue;
                foundMarker = this.hasErrors((IRidgetContainer)ridget);
            }
        }
        return foundMarker;
    }

    private boolean hasErrors(Collection<? extends IRidget> ridgets) {
        for (IRidget iRidget : ridgets) {
            IMarkableRidget markableRidget;
            if (!(iRidget instanceof IMarkableRidget) || !(markableRidget = (IMarkableRidget)iRidget).isEnabled() || markableRidget.getMarkersOfType(ErrorMarker.class).size() <= 0) continue;
            return true;
        }
        return false;
    }

    private boolean hasMandatories(IRidgetContainer ridgetContainer) {
        boolean foundMarker = this.hasMandatories(ridgetContainer.getRidgets());
        if (!foundMarker) {
            Iterator iter = ridgetContainer.getRidgets().iterator();
            while (!foundMarker && iter.hasNext()) {
                IRidget ridget = (IRidget)iter.next();
                if (!(ridget instanceof IRidgetContainer)) continue;
                foundMarker = this.hasMandatories((IRidgetContainer)ridget);
            }
        }
        return foundMarker;
    }

    private boolean hasMandatories(Collection<? extends IRidget> ridgets) {
        for (IRidget iRidget : ridgets) {
            IMarkableRidget markableRidget;
            if (!(iRidget instanceof IMarkableRidget) || !(markableRidget = (IMarkableRidget)iRidget).isEnabled()) continue;
            for (MandatoryMarker marker : markableRidget.getMarkersOfType(MandatoryMarker.class)) {
                if (marker.isDisabled()) continue;
                return true;
            }
        }
        return false;
    }

    private boolean hasNewButton() {
        return this.getNewButtonRidget() != null;
    }

    private boolean hasPreNewSelection() {
        return this.preNewSelection != null;
    }

    private boolean hasRemoveButton() {
        return this.getRemoveButtonRidget() != null;
    }

    private boolean hasApplyButton() {
        return this.getApplyButtonRidget() != null;
    }

    private boolean isShowGlobalMarker() {
        return !this.delegate.isValidMaster((IMasterDetailsRidget)this);
    }

    private void setEnabled(boolean applyEnabled, boolean detailsEnabled) {
        this.ignoreChanges = true;
        try {
            if (this.hasApplyButton()) {
                this.getApplyButtonRidget().setEnabled(applyEnabled);
            }
            if (!applyEnabled) {
                this.isSuggestedEditable = false;
            }
            this.detailsEnabled = detailsEnabled;
            for (IRidget ridget : this.getDetailRidgetContainer().getRidgets()) {
                ridget.setEnabled(detailsEnabled);
            }
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    private void setFocusToDetails() {
        final Control focusable = this.getDetailsControl();
        if (focusable != null) {
            focusable.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!focusable.isDisposed()) {
                        AbstractMasterDetailsRidget.this.clearTableSelection();
                        focusable.setFocus();
                    }
                }
            });
        }
    }

    private void setFocusToTable() {
        AbstractMasterDetailsComposite control = this.getUIControl();
        if (control != null) {
            final Control table = control.getTable();
            table.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!table.isDisposed()) {
                        table.setFocus();
                        AbstractMasterDetailsRidget.this.clearTableSelection();
                    }
                }
            });
        }
    }

    private void storePreNewSelection() {
        Assert.isTrue((boolean)this.removeCancelsNew);
        Object tableSelection = this.getTableSelection();
        if (this.preNewSelection == null || tableSelection != null) {
            this.preNewSelection = new StoredSelection(tableSelection);
        }
        this.clearTableSelection();
        if (this.hasRemoveButton()) {
            this.getRemoveButtonRidget().setEnabled(true);
        }
    }

    private void traceEvent(PropertyChangeEvent evt) {
        String className = evt.getSource().getClass().getSimpleName();
        System.out.println(String.format("prop: %s %s", evt.getPropertyName(), className));
    }

    protected void updateDetails(Object masterEntry) {
        Assert.isNotNull((Object)masterEntry);
        this.ignoreChanges = true;
        try {
            this.delegate.copyMasterEntry(masterEntry, this.delegate.getWorkingCopy());
            this.delegate.updateDetails(this.getDetailRidgetContainer());
        }
        finally {
            this.ignoreChanges = false;
        }
    }

    private synchronized void updateMarkers(boolean hideMarkers, boolean showGlobalMarker) {
        if (this.isHidingMarkersOnNew != hideMarkers) {
            this.isHidingMarkersOnNew = hideMarkers;
            for (IRidget ridget : this.getDetailRidgetContainer().getRidgets()) {
                if (!(ridget instanceof IBasicMarkableRidget)) continue;
                IBasicMarkableRidget markableRidget = (IBasicMarkableRidget)ridget;
                if (this.isHidingMarkersOnNew) {
                    if (showGlobalMarker) {
                        markableRidget.hideMarkersOfType(new Class[]{ErrorMarker.class});
                        continue;
                    }
                    markableRidget.hideMarkersOfType(new Class[]{ErrorMarker.class, MandatoryMarker.class});
                    continue;
                }
                markableRidget.showMarkersOfType(new Class[]{ErrorMarker.class, MandatoryMarker.class});
            }
        }
        if (this.isShowingGlobalMarker != showGlobalMarker) {
            this.isShowingGlobalMarker = showGlobalMarker;
            for (IRidget ridget : this.getDetailRidgetContainer().getRidgets()) {
                if (!(ridget instanceof IMarkable)) continue;
                IMarkable markable = (IMarkable)ridget;
                if (this.isShowingGlobalMarker) {
                    markable.addMarker((IMarker)GLOBAL_MARKER);
                    continue;
                }
                markable.removeMarker((IMarker)GLOBAL_MARKER);
            }
        }
    }

    private void updateMarkers(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (evt.getSource() == this.getTableRidget() || "showing".equals(propertyName)) {
            return;
        }
        this.updateMarkers(false, false);
    }

    public void handleAdd() {
        if (!this.isDirectWriting) {
            this.editable = this.delegate.createMasterEntry();
            this.delegate.itemCreated(this.editable);
            this.updateMarkers(this.isHideMarkersOnNew, this.isShowGlobalMarker());
            this.setEnabled(false, true);
            this.updateDetails(this.editable);
            if (this.isRemoveCancelsNew()) {
                this.storePreNewSelection();
            } else {
                this.clearTableSelection();
            }
            this.getUIControl().getDetails().setFocus();
        } else {
            this.editable = this.delegate.createMasterEntry();
            this.delegate.itemCreated(this.editable);
            this.rowObservables.add(this.editable);
            this.getTableRidget().updateFromModel();
            this.setSelection(this.editable);
            this.updateMarkers(this.isHideMarkersOnNew, this.isShowGlobalMarker());
            this.setEnabled(false, true);
            this.updateDetails(this.editable);
            this.getUIControl().getDetails().setFocus();
        }
    }

    public void handleApply() {
        this.assertIsBoundToModel();
        Assert.isNotNull((Object)this.editable);
        this.delegate.prepareItemApplied(this.editable);
        this.delegate.copyWorkingCopy(this.delegate.getWorkingCopy(), this.editable);
        if (!this.rowObservables.contains(this.editable)) {
            this.rowObservables.add(this.editable);
            this.getTableRidget().updateFromModel();
            this.setTableSelection(this.editable);
        } else {
            this.getTableRidget().updateFromModel();
        }
        this.revealTableSelection();
        this.delegate.itemApplied(this.editable);
        this.clearPreNewSelection();
        if (!this.isDirectWriting && this.isApplyTriggersNew()) {
            this.handleAdd();
            this.setFocusToDetails();
        } else {
            this.setEnabled(false, false);
            this.updateMarkers(false, false);
            this.setFocusToTable();
        }
    }

    public void handleCancel() {
        Object oldSelection;
        this.assertIsBoundToModel();
        if (this.hasRemoveButton()) {
            this.getRemoveButtonRidget().setEnabled(false);
        }
        if ((oldSelection = this.preNewSelection.getSelection()) == null && !this.isDirectWriting() && this.isRemoveTriggersNew()) {
            this.clearPreNewSelection();
            this.handleAdd();
            this.setFocusToDetails();
        } else {
            this.setSelection(oldSelection);
            this.clearPreNewSelection();
        }
    }

    public void handleRemove() {
        this.assertIsBoundToModel();
        Object selection = this.getSelection();
        Assert.isNotNull((Object)selection);
        this.rowObservables.remove(selection);
        this.setEnabled(false, false);
        this.clearSelection();
        this.clearTableSelection();
        this.getTableRidget().updateFromModel();
        this.setEnabled(false, false);
        this.delegate.itemRemoved(selection);
        if (!this.isDirectWriting && this.isRemoveTriggersNew()) {
            this.handleAdd();
            this.setFocusToDetails();
        }
    }

    private final class ActionRidgetFacade
    implements IMasterDetailsActionRidgetFacade {
        private ActionRidgetFacade() {
        }

        public IActionRidget getAddActionRidget() {
            return (IActionRidget)AbstractMasterDetailsRidget.this.getRidget(IActionRidget.class, "mdNewButton");
        }

        public IActionRidget getApplyActionRidget() {
            return (IActionRidget)AbstractMasterDetailsRidget.this.getRidget(IActionRidget.class, "mdApplyButton");
        }

        public IActionRidget getRemoveActionRidget() {
            return (IActionRidget)AbstractMasterDetailsRidget.this.getRidget(IActionRidget.class, "mdRemoveButton");
        }
    }

    private final class DetailRidgetContainer
    implements IRidgetContainer {
        private List<IRidget> detailRidgets;
        private boolean configured = false;

        private DetailRidgetContainer() {
        }

        public void addRidget(String id, IRidget ridget) {
            throw new UnsupportedOperationException("not supported");
        }

        public boolean removeRidget(String id) {
            throw new UnsupportedOperationException("not supported");
        }

        public void configureRidgets() {
            throw new UnsupportedOperationException("not supported");
        }

        public <R extends IRidget> R getRidget(String id) {
            return (R)AbstractMasterDetailsRidget.this.getRidget(id);
        }

        public <R extends IRidget> R getRidget(Class<R> ridgetClazz, String id) {
            return (R)AbstractMasterDetailsRidget.this.getRidget(ridgetClazz, id);
        }

        public Collection<? extends IRidget> getRidgets() {
            if (this.detailRidgets == null || this.detailRidgets.isEmpty()) {
                this.detailRidgets = this.getDetailRidgets();
            }
            return this.detailRidgets;
        }

        private List<IRidget> getDetailRidgets() {
            ArrayList<IRidget> result = new ArrayList<IRidget>(AbstractMasterDetailsRidget.this.getRidgets());
            result.remove(AbstractMasterDetailsRidget.this.getNewButtonRidget());
            result.remove(AbstractMasterDetailsRidget.this.getRemoveButtonRidget());
            result.remove(AbstractMasterDetailsRidget.this.getApplyButtonRidget());
            result.remove(AbstractMasterDetailsRidget.this.getTableRidget());
            return result;
        }

        public void setConfigured(boolean configured) {
            this.configured = configured;
        }

        public boolean isConfigured() {
            return this.configured;
        }

        public void setStatuslineToShowMarkerMessages(IStatuslineRidget statuslineToShowMarkerMessages) {
        }
    }

    private final class DirectWritingPropertyChangeListener
    implements PropertyChangeListener {
        private DirectWritingPropertyChangeListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propertyName = evt.getPropertyName();
            if (!AbstractMasterDetailsRidget.this.isDirectWriting || AbstractMasterDetailsRidget.this.ignoreChanges || AbstractMasterDetailsRidget.this.delegate == null || AbstractMasterDetailsRidget.this.editable == null || !AbstractMasterDetailsRidget.this.applyRequiresNoErrors && !AbstractMasterDetailsRidget.this.applyRequiresNoMandatories && "marker".equals(propertyName) || "enabled".equals(propertyName) || "textInternal".equals(propertyName) || "output".equals(propertyName) || "markerHiding".equals(propertyName)) {
                return;
            }
            AbstractMasterDetailsRidget.this.updateMarkers(evt);
            if (AbstractMasterDetailsRidget.this.canApplyDirectly()) {
                AbstractMasterDetailsRidget.this.delegate.prepareItemApplied(AbstractMasterDetailsRidget.this.editable);
                AbstractMasterDetailsRidget.this.delegate.copyWorkingCopy(AbstractMasterDetailsRidget.this.delegate.getWorkingCopy(), AbstractMasterDetailsRidget.this.editable);
                AbstractMasterDetailsRidget.this.delegate.itemApplied(AbstractMasterDetailsRidget.this.editable);
                AbstractMasterDetailsRidget.this.getTableRidget().updateFromModel();
                AbstractMasterDetailsRidget.this.setTableSelection(AbstractMasterDetailsRidget.this.editable);
            }
        }
    }

    private static final class GlobalMandatoryMarker
    extends MandatoryMarker {
        GlobalMandatoryMarker() {
            super(false);
        }

        public boolean isDisabled() {
            return false;
        }
    }

    private static final class StoredSelection {
        private final Object selection;

        StoredSelection(Object selection) {
            this.selection = selection;
        }

        private Object getSelection() {
            return this.selection;
        }
    }
}

