/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.databinding.BindingException;
import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.core.marker.IMarker;
import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.internal.ui.ridgets.swt.Activator;
import org.eclipse.riena.ui.core.marker.DisabledMarker;
import org.eclipse.riena.ui.core.marker.ErrorMarker;
import org.eclipse.riena.ui.core.marker.ErrorMessageMarker;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.core.marker.MandatoryMarker;
import org.eclipse.riena.ui.core.marker.OutputMarker;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.AbstractRidget;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IBasicMarkableRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.listener.ClickEvent;
import org.eclipse.riena.ui.ridgets.listener.IClickListener;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractSWTWidgetRidget
extends AbstractRidget
implements IBasicMarkableRidget {
    private ListenerList<IClickListener> clickListeners;
    private ListenerList<IActionListener> doubleClickListeners;
    private Widget uiControl;
    private String toolTip = null;
    private ErrorMessageMarker errorMarker;
    private DisabledMarker disabledMarker;
    private MandatoryMarker mandatoryMarker;
    private OutputMarker outputMarker;
    private HiddenMarker hiddenMarker;
    private AbstractMarkerSupport markerSupport;
    private Listener visibilityListener;
    private ClickForwarder mouseListener;

    public static boolean isBean(Class<?> clazz) {
        try {
            clazz.getMethod("addPropertyChangeListener", PropertyChangeListener.class);
            return true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
    }

    public final synchronized void addMarker(IMarker marker) {
        if (this.markerSupport == null) {
            this.markerSupport = this.createMarkerSupport();
            this.markerSupport.setRidget((IBasicMarkableRidget)this);
            this.unbindMarkerSupport();
        }
        if (marker instanceof MandatoryMarker) {
            ((MandatoryMarker)marker).setDisabled(this.isDisableMandatoryMarker());
        }
        this.markerSupport.addMarker(marker);
    }

    public void addClickListener(IClickListener listener) {
        Assert.isNotNull((Object)listener, (String)"listener is null");
        if (this.clickListeners == null) {
            this.clickListeners = new ListenerList(IClickListener.class);
        }
        this.clickListeners.add((Object)listener);
    }

    public void removeClickListener(IClickListener listener) {
        if (this.clickListeners != null) {
            this.clickListeners.remove((Object)listener);
        }
    }

    public void addDoubleClickListener(IActionListener listener) {
        Assert.isNotNull((Object)listener, (String)"listener is null");
        if (this.doubleClickListeners == null) {
            this.doubleClickListeners = new ListenerList(IActionListener.class);
        }
        this.doubleClickListeners.add((Object)listener);
    }

    public void removeDoubleClickListener(IActionListener listener) {
        if (this.doubleClickListeners != null) {
            this.doubleClickListeners.remove((Object)listener);
        }
    }

    public String getID() {
        return this.getID(this.getUIControl());
    }

    public String getID(Object uiControl) {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        return locator.locateBindingProperty(uiControl);
    }

    public Set<Class<IMarker>> getHiddenMarkerTypes() {
        if (this.markerSupport != null) {
            return this.markerSupport.getHiddenMarkerTypes();
        }
        return new HashSet<Class<IMarker>>();
    }

    public final Collection<IMarker> getMarkers() {
        if (this.markerSupport != null) {
            return this.markerSupport.getMarkers();
        }
        return Collections.emptySet();
    }

    public final <T extends IMarker> Collection<T> getMarkersOfType(Class<T> type) {
        if (this.markerSupport != null) {
            return this.markerSupport.getMarkersOfType(type);
        }
        return Collections.emptySet();
    }

    public final String getToolTipText() {
        return this.toolTip;
    }

    public Widget getUIControl() {
        return this.uiControl;
    }

    public Set<Class<IMarker>> hideMarkersOfType(Class<? extends IMarker> ... types) {
        if (this.markerSupport == null) {
            this.markerSupport = this.createMarkerSupport();
            this.markerSupport.setRidget((IBasicMarkableRidget)this);
        }
        return this.markerSupport.hideMarkersOfType((Class[])types);
    }

    public boolean hasFocus() {
        return false;
    }

    public boolean isEnabled() {
        return this.getMarkersOfType(DisabledMarker.class).isEmpty();
    }

    public final boolean isErrorMarked() {
        return !this.getMarkersOfType(ErrorMarker.class).isEmpty();
    }

    public boolean isFocusable() {
        return false;
    }

    @Deprecated
    public final boolean isMandatory() {
        return !this.getMarkersOfType(MandatoryMarker.class).isEmpty();
    }

    public final boolean isOutputOnly() {
        return !this.getMarkersOfType(OutputMarker.class).isEmpty();
    }

    public final void removeAllMarkers() {
        if (this.markerSupport != null) {
            this.markerSupport.removeAllMarkers();
        }
    }

    public final boolean removeMarker(IMarker marker) {
        if (this.markerSupport != null) {
            return this.markerSupport.removeMarker(marker);
        }
        return false;
    }

    public void requestFocus() {
    }

    public synchronized void setEnabled(boolean enabled) {
        if (enabled) {
            if (this.disabledMarker != null) {
                this.removeMarker((IMarker)this.disabledMarker);
            }
        } else {
            if (this.disabledMarker == null) {
                this.disabledMarker = new DisabledMarker();
            }
            this.addMarker((IMarker)this.disabledMarker);
        }
    }

    public final void setErrorMarked(boolean errorMarked) {
        this.setErrorMarked(errorMarked, null);
    }

    public void setFocusable(boolean focusable) {
    }

    public final void setMandatory(boolean mandatory) {
        if (!mandatory) {
            if (this.mandatoryMarker != null) {
                this.removeMarker((IMarker)this.mandatoryMarker);
            }
        } else {
            if (this.mandatoryMarker == null) {
                this.mandatoryMarker = new MandatoryMarker();
            }
            this.addMarker((IMarker)this.mandatoryMarker);
        }
    }

    public final void setOutputOnly(boolean outputOnly) {
        if (!outputOnly) {
            if (this.outputMarker != null) {
                this.removeMarker((IMarker)this.outputMarker);
            }
        } else {
            if (this.outputMarker == null) {
                this.outputMarker = new OutputMarker();
            }
            this.addMarker((IMarker)this.outputMarker);
        }
    }

    public final void setToolTipText(String toolTipText) {
        String oldValue = this.toolTip;
        this.toolTip = toolTipText;
        this.updateToolTip();
        this.firePropertyChange("tooltip", oldValue, this.toolTip);
    }

    public void setUIControl(Object uiControl) {
        this.checkUIControl(uiControl);
        this.uninstallListeners();
        this.unbindUIControl();
        this.unbindMarkerSupport();
        if (!SwtUtilities.isDisposed((Widget)this.uiControl)) {
            this.uiControl.setData(IRidget.class.getName(), null);
        }
        this.uiControl = (Widget)uiControl;
        if (this.uiControl != null) {
            this.uiControl.setData(IRidget.class.getName(), (Object)this);
        }
        this.bindMarkerSupport();
        this.updateEnabled();
        this.updateMarkers();
        this.updateToolTip();
        this.bindUIControl();
        this.installListeners();
    }

    public final void setVisible(boolean visible) {
        if (this.hiddenMarker == null) {
            this.hiddenMarker = new HiddenMarker();
        }
        if (visible) {
            this.removeMarker((IMarker)this.hiddenMarker);
        } else {
            this.addMarker((IMarker)this.hiddenMarker);
        }
    }

    public Set<Class<IMarker>> showMarkersOfType(Class<? extends IMarker> ... types) {
        if (this.markerSupport == null) {
            return new HashSet<Class<IMarker>>();
        }
        return this.markerSupport.showMarkersOfType((Class[])types);
    }

    public boolean decorateVisibleControlArea() {
        return true;
    }

    protected final void checkType(Object uiControl, Class<?> type) {
        try {
            super.checkType(uiControl, type);
        }
        catch (BindingException e) {
            String bindingId = this.getID(uiControl);
            if (bindingId != null) {
                String message = "Unexpected uicontrol has the binding ID " + bindingId;
                throw new BindingException(message, (Throwable)e);
            }
            throw e;
        }
    }

    protected abstract void checkUIControl(Object var1);

    protected abstract void bindUIControl();

    protected abstract void unbindUIControl();

    public abstract boolean isDisableMandatoryMarker();

    protected abstract void updateEnabled();

    protected abstract void updateToolTip();

    protected AbstractMarkerSupport createMarkerSupport() {
        AbstractMarkerSupport lnfMarkerSupport = null;
        if (LnfManager.getLnf() != null) {
            lnfMarkerSupport = LnfManager.getLnf().getMarkerSupport(((Object)((Object)this)).getClass());
        }
        if (lnfMarkerSupport == null) {
            lnfMarkerSupport = new MarkerSupport();
        }
        lnfMarkerSupport.init((IBasicMarkableRidget)this, this.propertyChangeSupport);
        Assert.isNotNull((Object)lnfMarkerSupport, (String)"Marker support is null!");
        return lnfMarkerSupport;
    }

    protected final void disableMandatoryMarkers(boolean disable) {
        for (IMarker iMarker : this.getMarkersOfType(MandatoryMarker.class)) {
            MandatoryMarker mMarker = (MandatoryMarker)iMarker;
            mMarker.setDisabled(disable);
        }
    }

    protected final synchronized void flash() {
        if (this.getUIControl() != null) {
            if (this.markerSupport == null) {
                this.markerSupport = this.createMarkerSupport();
                this.markerSupport.setRidget((IBasicMarkableRidget)this);
            }
            this.markerSupport.flash();
        }
    }

    protected Image getManagedImage(String key, IconSize imageSize) {
        Image image = Activator.getSharedImage(key, imageSize);
        if (image == null) {
            image = ImageStore.getInstance().getMissingImage();
        }
        return image;
    }

    protected Image getManagedImage(String key) {
        return this.getManagedImage(key, IconSize.NONE);
    }

    protected boolean hasChanged(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue == null || newValue == null) {
            return true;
        }
        return !oldValue.equals(newValue);
    }

    protected void installListeners() {
        if (this.getUIControl() != null) {
            if (this.visibilityListener == null) {
                this.visibilityListener = new VisibilityListener();
            }
            if (this.getUIControl() instanceof Control) {
                this.addHierarchyVisibilityListener(((Control)this.getUIControl()).getParent(), this.visibilityListener);
            }
            this.mouseListener = new ClickForwarder();
            if (this.getUIControl() instanceof Control) {
                Control control = (Control)this.getUIControl();
                control.addMouseListener((MouseListener)this.mouseListener);
            }
        }
    }

    protected final void setErrorMarked(boolean errorMarked, String message) {
        if (!errorMarked) {
            if (this.errorMarker != null) {
                this.removeMarker((IMarker)this.errorMarker);
            }
        } else {
            if (this.errorMarker == null) {
                this.errorMarker = new ErrorMessageMarker(message);
            } else {
                this.errorMarker.setMessage(message);
            }
            this.addMarker((IMarker)this.errorMarker);
        }
    }

    protected void uninstallListeners() {
        if (this.getUIControl() instanceof Control) {
            Control control = (Control)this.getUIControl();
            if (this.visibilityListener != null) {
                this.removeHierarchyVisibilityListener(control.getParent(), this.visibilityListener);
            }
            control.removeMouseListener((MouseListener)this.mouseListener);
        }
    }

    public void updateMarkers() {
        if (this.markerSupport != null) {
            this.markerSupport.updateMarkers();
        }
    }

    protected ClickEvent createClickEvent(MouseEvent e) {
        return new ClickEvent((IRidget)this, e.button);
    }

    protected MouseListener getClickForwarder() {
        return this.mouseListener;
    }

    private void addHierarchyVisibilityListener(Composite parent, Listener listener) {
        if (parent != null && !parent.isDisposed()) {
            parent.addListener(22, listener);
            parent.addListener(23, listener);
            this.addHierarchyVisibilityListener(parent.getParent(), listener);
        }
    }

    private void bindMarkerSupport() {
        if (this.markerSupport != null) {
            this.markerSupport.bind();
        }
    }

    private void removeHierarchyVisibilityListener(Composite parent, Listener listener) {
        if (parent != null && !parent.isDisposed()) {
            parent.removeListener(22, listener);
            parent.removeListener(23, listener);
            this.removeHierarchyVisibilityListener(parent.getParent(), listener);
        }
    }

    private void unbindMarkerSupport() {
        if (this.markerSupport != null) {
            this.markerSupport.unbind();
        }
    }

    private final class ClickForwarder
    implements MouseListener {
        private int pressedBtn;
        private boolean doubleClickInProcess = false;

        private ClickForwarder() {
        }

        public void mouseDoubleClick(MouseEvent e) {
            this.pressedBtn = -1;
            if (!AbstractSWTWidgetRidget.this.isEnabled()) {
                return;
            }
            if (this.doubleClickInProcess) {
                return;
            }
            try {
                this.doubleClickInProcess = true;
                if (AbstractSWTWidgetRidget.this.doubleClickListeners != null) {
                    IActionListener[] iActionListenerArray = (IActionListener[])AbstractSWTWidgetRidget.this.doubleClickListeners.getListeners();
                    int n = iActionListenerArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IActionListener listener = iActionListenerArray[n2];
                        listener.callback();
                        ++n2;
                    }
                }
            }
            finally {
                this.doubleClickInProcess = false;
            }
        }

        public void mouseDown(MouseEvent e) {
            this.pressedBtn = -1;
            if (!AbstractSWTWidgetRidget.this.isEnabled()) {
                return;
            }
            Point point = new Point(e.x, e.y);
            if (this.isOverWidget(point)) {
                this.pressedBtn = e.button;
            }
        }

        public void mouseUp(MouseEvent e) {
            if (!AbstractSWTWidgetRidget.this.isEnabled()) {
                this.pressedBtn = -1;
                return;
            }
            Point point = new Point(e.x, e.y);
            if (e.button == this.pressedBtn && this.isOverWidget(point)) {
                this.fireClickEvent(e);
            }
            this.pressedBtn = -1;
        }

        private boolean isOverWidget(Point point) {
            if (SwtUtilities.isDisposed((Widget)AbstractSWTWidgetRidget.this.getUIControl())) {
                return false;
            }
            if (AbstractSWTWidgetRidget.this.getUIControl() instanceof Control) {
                Control control = (Control)AbstractSWTWidgetRidget.this.getUIControl();
                Rectangle widgetBounds = control.getBounds();
                return point.x <= widgetBounds.width && point.x >= 0 && point.y <= widgetBounds.height && point.y >= 0;
            }
            return true;
        }

        private void fireClickEvent(MouseEvent e) {
            if (AbstractSWTWidgetRidget.this.clickListeners != null) {
                ClickEvent event = AbstractSWTWidgetRidget.this.createClickEvent(e);
                IClickListener[] iClickListenerArray = (IClickListener[])AbstractSWTWidgetRidget.this.clickListeners.getListeners();
                int n = iClickListenerArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IClickListener listener = iClickListenerArray[n2];
                    listener.callback(event);
                    ++n2;
                }
            }
        }
    }

    private final class VisibilityListener
    implements Listener {
        private VisibilityListener() {
        }

        public void handleEvent(Event event) {
            final Widget control = AbstractSWTWidgetRidget.this.getUIControl();
            if (AbstractSWTWidgetRidget.this.markerSupport != null && !AbstractSWTWidgetRidget.this.getMarkers().isEmpty() && !SwtUtilities.isDisposed((Widget)control)) {
                control.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!SwtUtilities.isDisposed((Widget)control)) {
                            AbstractSWTWidgetRidget.this.markerSupport.fireShowingPropertyChangeEvent();
                        }
                    }
                });
            }
        }
    }
}

