/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.swt.views;

import java.util.EventListener;
import org.eclipse.riena.ui.swt.facades.SWTFacade;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.ImageStore;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DialogGrabCorner
extends Composite {
    public DialogGrabCorner(Composite parent, int style) {
        super(parent, style);
        this.setBackground(parent.getBackground());
        this.setData("sizeexecutor", "grabcorner");
        this.setLayoutData();
        SWTFacade facade = SWTFacade.getDefault();
        facade.addPaintListener((Control)this, (EventListener)((Object)new GrabPaintListener()));
        facade.createGrabCornerListenerWithTracker((Control)this);
    }

    private void setLayoutData() {
        Point grabCornerSize = DialogGrabCorner.getGrabCornerSize();
        FormData grabFormData = new FormData();
        grabFormData.width = grabCornerSize.x;
        grabFormData.height = grabCornerSize.y;
        grabFormData.bottom = new FormAttachment(100, 0);
        grabFormData.right = new FormAttachment(100, 0);
        this.setLayoutData(grabFormData);
    }

    public static Point getGrabCornerSize() {
        Point grabCornerSize = new Point(0, 0);
        Image grabCorner = DialogGrabCorner.getGrabCornerImage();
        if (grabCorner != null) {
            grabCornerSize = new Point(grabCorner.getBounds().width, grabCorner.getBounds().height);
        }
        return grabCornerSize;
    }

    private static Image getGrabCornerImage() {
        Image image = LnfManager.getLnf().getImage("Dialog.grabCornerImage");
        if (image == null) {
            image = ImageStore.getInstance().getMissingImage();
        }
        return image;
    }

    private static class GrabPaintListener
    implements PaintListener {
        private GrabPaintListener() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Image grabCornerImage = DialogGrabCorner.getGrabCornerImage();
            if (grabCornerImage != null) {
                gc.drawImage(grabCornerImage, 0, 0);
            }
        }
    }
}

