/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.facades.internal;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.riena.ui.swt.facades.internal.AbstractNavigationToolTip;
import org.eclipse.riena.ui.swt.lnf.rienadefault.RienaDefaultLnf;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class SubModuleToolTip
extends AbstractNavigationToolTip {
    private final Tree tree;
    private final ILabelProvider labelProvider;

    public SubModuleToolTip(Tree parent, ILabelProvider labelProvider) {
        super((Control)parent);
        this.tree = parent;
        Assert.isNotNull((Object)labelProvider);
        this.labelProvider = labelProvider;
        this.setShift(new Point(0, 0));
    }

    public Point getLocation(Point tipSize, Event event) {
        Point location = super.getLocation(tipSize, event);
        TreeItem item = this.getTreeItem(event);
        if (item != null) {
            location = this.tree.toDisplay(item.getBounds().x, item.getBounds().y);
        }
        return location;
    }

    @Override
    protected boolean shouldCreateToolTip(Event event) {
        boolean should = super.shouldCreateToolTip(event);
        if (should) {
            String longText;
            String text = this.getItemText(event);
            should = !text.equals(longText = this.getItemLongText(event));
        }
        return should;
    }

    @Override
    protected String getToolTipText(Event event) {
        return this.getItemLongText(event);
    }

    @Override
    protected Integer getLnfDelay(RienaDefaultLnf lnf) {
        return lnf.getIntegerSetting("SubModuleItemToolTip.popupDelay");
    }

    @Override
    protected Font getLnfFont(RienaDefaultLnf lnf) {
        return lnf.getFont("SubModuleItemToolTip.font");
    }

    @Override
    protected Color getLnfBackground(RienaDefaultLnf lnf) {
        return lnf.getColor("SubModuleItemToolTip.background");
    }

    @Override
    protected Color getLnfForeground(RienaDefaultLnf lnf) {
        return lnf.getColor("SubModuleItemToolTip.foreground");
    }

    private String getItemLongText(Event event) {
        String result = "";
        TreeItem item = this.getTreeItem(event);
        if (item != null) {
            Object element = item.getData();
            result = this.labelProvider.getText(element);
        }
        return result;
    }

    private String getItemText(Event event) {
        String text = "";
        TreeItem item = this.getTreeItem(event);
        if (item != null) {
            text = item.getText();
        }
        return text;
    }

    private TreeItem getTreeItem(Event event) {
        Point point = new Point(event.x, event.y);
        return this.tree.getItem(point);
    }
}

