/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt;

import org.eclipse.core.runtime.Assert;
import org.eclipse.riena.internal.ui.swt.MultilineButton;
import org.eclipse.riena.ui.swt.EventForwarder;
import org.eclipse.riena.ui.swt.layout.DpiGridLayout;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ChoiceComposite
extends Composite
implements SelectionListener {
    private final boolean isMulti;
    private int marginHeight;
    private int marginWidth;
    private int vSpacing;
    private int hSpacing = 3;
    private int orientation;
    private boolean isEditable;
    private Color bgColor;
    private boolean wrapOptionsText;
    private final Composite content;

    public ChoiceComposite(Composite parent, int style) {
        this(parent, style, true);
    }

    public ChoiceComposite(Composite parent, int style, boolean multipleSelection) {
        super(parent, style);
        this.isMulti = multipleSelection;
        this.orientation = 512;
        this.isEditable = true;
        DpiGridLayout layout = new DpiGridLayout(1, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        this.setLayout(layout);
        new Text((Composite)this, 0).setLayoutData((Object)new GridData(1, 0));
        this.content = new Composite((Composite)this, 0);
        this.content.setLayoutData((Object)new GridData(1808));
        this.applyLayout();
    }

    public Button createChild(String caption) {
        int style = this.isMulti ? 32 : 16;
        Button result = this.wrapOptionsText ? new MultilineButton(this.content, style |= 0x40) : new Button(this.content, style);
        result.setText(caption);
        result.setForeground(this.getForeground());
        result.setBackground(this.getBackground());
        result.addSelectionListener((SelectionListener)this);
        new EventForwarder((Control)result, (Control)this);
        this.updateEnabled((Control)result, this.isEnabled());
        return result;
    }

    public final boolean getEditable() {
        this.checkWidget();
        return this.isEditable;
    }

    public final Point getMargins() {
        return new Point(this.marginHeight, this.marginWidth);
    }

    public int getOrientation() {
        return this.orientation;
    }

    public final Point getSpacing() {
        return new Point(this.hSpacing, this.vSpacing);
    }

    public final boolean isMultipleSelection() {
        return this.isMulti;
    }

    public final void setBackground(Color color) {
        this.setRedraw(false);
        try {
            this.bgColor = color;
            this.updateBgColor();
        }
        finally {
            this.setRedraw(true);
        }
    }

    public final void setEditable(boolean editable) {
        this.isEditable = editable;
        this.updateEnabled(this.getEnabled());
    }

    public final void setEnabled(boolean enabled) {
        this.setRedraw(false);
        try {
            super.setEnabled(enabled);
            this.updateEnabled(enabled);
            this.updateBgColor();
        }
        finally {
            this.setRedraw(true);
        }
    }

    public final void setForeground(Color color) {
        this.setRedraw(false);
        try {
            super.setForeground(color);
            Control[] controlArray = this.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                child.setForeground(color);
                ++n2;
            }
        }
        finally {
            this.setRedraw(true);
        }
    }

    public final void setMargins(int marginHeight, int marginWidth) {
        Assert.isLegal((marginHeight >= 0 ? 1 : 0) != 0, (String)("marginHeight must be greater or equal to zero: " + marginHeight));
        Assert.isLegal((marginWidth >= 0 ? 1 : 0) != 0, (String)("marginWidth must be greater or equal to zero: " + marginWidth));
        this.marginHeight = marginHeight;
        this.marginWidth = marginWidth;
        this.applyLayout();
    }

    public final void setOrientation(int orientation) {
        Assert.isLegal((orientation == 512 || orientation == 256 ? 1 : 0) != 0);
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.applyLayout();
        }
    }

    public final void setSpacing(int hSpacing, int vSpacing) {
        Assert.isLegal((hSpacing >= 0 ? 1 : 0) != 0, (String)("hSpacing must be greater or equal to zero: " + hSpacing));
        Assert.isLegal((vSpacing >= 0 ? 1 : 0) != 0, (String)("vSpacing must be greater or equal to zero: " + vSpacing));
        this.hSpacing = hSpacing;
        this.vSpacing = vSpacing;
        this.applyLayout();
    }

    public void widgetSelected(SelectionEvent e) {
        if (!this.isEditable) {
            Button button = (Button)e.widget;
            button.setSelection(button.isEnabled());
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    public void setWrapOptionsText(boolean wrapOptionsText) {
        this.wrapOptionsText = wrapOptionsText;
    }

    public Control[] getChildrenButtons() {
        return this.content.getChildren();
    }

    public boolean setFocus() {
        return this.isMulti ? this.content.setFocus() : super.setFocus();
    }

    public Composite getContentComposite() {
        return this.content;
    }

    private void applyLayout() {
        if (this.orientation == 512) {
            FillLayout layout = new FillLayout(512);
            layout.marginHeight = SwtUtilities.convertYToDpiTruncate(this.marginHeight);
            layout.marginWidth = SwtUtilities.convertXToDpiTruncate(this.marginWidth);
            layout.spacing = SwtUtilities.convertYToDpiTruncate(this.vSpacing);
            this.content.setLayout((Layout)layout);
        } else {
            RowLayout layout = new RowLayout(256);
            layout.center = true;
            layout.marginHeight = SwtUtilities.convertYToDpiTruncate(this.marginHeight);
            layout.marginWidth = SwtUtilities.convertXToDpiTruncate(this.marginWidth);
            layout.marginLeft = 0;
            layout.marginRight = 0;
            layout.marginTop = 0;
            layout.marginBottom = 0;
            layout.spacing = SwtUtilities.convertXToDpiTruncate(this.hSpacing);
            layout.wrap = false;
            this.content.setLayout((Layout)layout);
        }
    }

    private void updateBgColor() {
        this.updateBgColor(this.isEnabled() && this.bgColor != null ? this.bgColor : this.getParent().getBackground());
    }

    private void updateBgColor(Color color) {
        Control child;
        super.setBackground(color);
        this.content.setBackground(color);
        Control[] controlArray = this.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            child.setBackground(color);
            ++n2;
        }
        controlArray = this.getChildrenButtons();
        n = controlArray.length;
        n2 = 0;
        while (n2 < n) {
            child = controlArray[n2];
            child.setBackground(color);
            ++n2;
        }
    }

    private void updateEnabled(boolean isEnabled) {
        Control[] controlArray = this.getChildrenButtons();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            this.updateEnabled(child, isEnabled);
            ++n2;
        }
    }

    private void updateEnabled(Control child, boolean isEnabled) {
        if (!this.isEditable && isEnabled) {
            Button button = (Button)child;
            child.setEnabled(button.getSelection());
        } else {
            child.setEnabled(isEnabled);
        }
    }
}

