/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.swt.utils;

import com.kitfox.svg.SVGCache;
import com.kitfox.svg.SVGDiagram;
import com.kitfox.svg.SVGException;
import com.kitfox.svg.SVGRoot;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.eclipse.equinox.log.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.singleton.SingletonProvider;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.core.wire.InjectExtension;
import org.eclipse.riena.internal.ui.swt.Activator;
import org.eclipse.riena.ui.core.resource.IIconManager;
import org.eclipse.riena.ui.core.resource.IconManagerProvider;
import org.eclipse.riena.ui.core.resource.IconSize;
import org.eclipse.riena.ui.core.resource.IconState;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.IImagePathExtension;
import org.eclipse.riena.ui.swt.utils.ImageFileExtension;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public final class ImageStore {
    private Image missingImage;
    private IImagePathExtension[] iconPaths;
    private static final SingletonProvider<ImageStore> IS = new SingletonProvider(ImageStore.class);
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), ImageStore.class);

    private ImageStore() {
    }

    public static ImageStore getInstance() {
        return (ImageStore)IS.getInstance();
    }

    public Image getImage(String imageName, ImageFileExtension fileExtension, IconSize imageSize) {
        Point dpi = SwtUtilities.getDpi();
        String fullName = this.getFullScaledName(imageName, fileExtension, dpi);
        Image image = this.loadImage(fullName);
        if (image != null) {
            return image;
        }
        fullName = this.getFullSvgName(imageName, imageSize);
        image = this.loadSvgImage(fullName, imageSize);
        if (image != null) {
            return image;
        }
        dpi = SwtUtilities.getDefaultDpi();
        fullName = this.getFullScaledName(imageName, fileExtension, dpi);
        image = this.loadImage(fullName);
        if (image != null) {
            return image;
        }
        fullName = this.getFullName(imageName, fileExtension);
        image = this.loadImage(fullName);
        if (image != null) {
            return image;
        }
        String defaultIconName = this.getDefaultIconMangerImageName(imageName);
        if (!StringUtils.equals((CharSequence)defaultIconName, (CharSequence)imageName)) {
            fullName = this.getFullName(defaultIconName, fileExtension);
            image = this.loadImage(fullName);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String imageName, ImageFileExtension fileExtension) {
        Image image = this.getImage(imageName, fileExtension);
        if (image == null) {
            return null;
        }
        return ImageDescriptor.createFromImage((Image)image);
    }

    public URI getImageUri(String imageName, ImageFileExtension fileExtension) {
        URI uri = null;
        Point dpi = SwtUtilities.getDpi();
        String fullName = this.getFullScaledName(imageName, fileExtension, dpi);
        uri = this.getUri(fullName);
        if (uri != null) {
            return uri;
        }
        fullName = this.getFullName(imageName, fileExtension);
        uri = this.getUri(fullName);
        if (uri != null) {
            return uri;
        }
        dpi = SwtUtilities.getDefaultDpi();
        fullName = this.getFullScaledName(imageName, fileExtension, dpi);
        uri = this.getUri(fullName);
        if (uri != null) {
            return uri;
        }
        String defaultIconName = this.getDefaultIconMangerImageName(imageName);
        if (!StringUtils.equals((CharSequence)defaultIconName, (CharSequence)imageName)) {
            fullName = this.getFullName(defaultIconName, fileExtension);
            uri = this.getUri(fullName);
        }
        return uri;
    }

    private URI getUri(String fullName) {
        URL imageUrl = this.getImageUrl(fullName);
        if (imageUrl != null) {
            try {
                return imageUrl.toURI();
            }
            catch (URISyntaxException ex) {
                LOGGER.log(4, "Can't create URI.", (Throwable)ex);
            }
        }
        return null;
    }

    private String getDefaultIconMangerImageName(String imageName) {
        IconState state;
        IIconManager iconManager = IconManagerProvider.getInstance().getIconManager();
        String name = iconManager.getName(imageName);
        IconSize size = iconManager.getSize(imageName);
        if (size == null || size.getClass() != IconSize.class) {
            size = IconSize.NONE;
        }
        if ((state = iconManager.getState(imageName)) == null || state.getClass() != IconState.class) {
            state = IconState.NORMAL;
        }
        IIconManager defaultIconManager = IconManagerProvider.getInstance().getDefaultIconManager();
        String defaultIconName = defaultIconManager.getIconID(name, size, state);
        return defaultIconName;
    }

    public Image getImage(String imageName) {
        return this.getImage(imageName, ImageFileExtension.PNG, IconSize.NONE);
    }

    public Image getImage(String imageName, IconSize imageSize) {
        return this.getImage(imageName, ImageFileExtension.PNG, imageSize);
    }

    public Image getImage(String imageName, ImageFileExtension fileExtension) {
        return this.getImage(imageName, fileExtension, IconSize.NONE);
    }

    private String getFullName(String imageName, ImageFileExtension fileExtension) {
        if (StringUtils.isEmpty((CharSequence)imageName)) {
            return null;
        }
        String fullName = imageName;
        if (imageName.indexOf(46) < 0 && fileExtension != null) {
            fullName = String.valueOf(fullName) + "." + fileExtension.getFileNameExtension();
        }
        return fullName;
    }

    private String getFullScaledName(String imageName, ImageFileExtension fileExtension, Point dpi) {
        if (StringUtils.isEmpty((CharSequence)imageName)) {
            return null;
        }
        if (imageName.indexOf(46) >= 0) {
            return null;
        }
        if (fileExtension == null) {
            return null;
        }
        String fullName = this.addImageScaleSuffix(imageName, fileExtension, dpi);
        if (fullName != null) {
            fullName = String.valueOf(fullName) + "." + fileExtension.getFileNameExtension();
            return fullName;
        }
        return null;
    }

    private String getFullSvgName(String imageName, IconSize imageSize) {
        if (StringUtils.isEmpty((CharSequence)imageName)) {
            return null;
        }
        String svgExtension = String.valueOf('.') + ImageFileExtension.SVG.getFileNameExtension();
        if (imageName.endsWith(svgExtension)) {
            return imageName;
        }
        if (imageName.indexOf(46) >= 0) {
            return null;
        }
        String fullName = imageName;
        if (imageSize != null && imageSize != IconSize.NONE && fullName.endsWith(imageSize.getDefaultMapping())) {
            int endIndex = fullName.length() - imageSize.getDefaultMapping().length();
            fullName = fullName.substring(0, endIndex);
        }
        fullName = String.valueOf(fullName) + svgExtension;
        return fullName;
    }

    private synchronized Image loadImage(String fullName) {
        if (StringUtils.isEmpty((CharSequence)fullName)) {
            return null;
        }
        if (Activator.getDefault() == null) {
            return null;
        }
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        Image image = imageRegistry.get(fullName);
        if (image == null || image.isDisposed()) {
            ImageDescriptor descriptor = this.getImageDescriptor(fullName);
            if (descriptor == null) {
                return null;
            }
            imageRegistry.remove(fullName);
            imageRegistry.put(fullName, descriptor);
            image = imageRegistry.get(fullName);
        }
        return image;
    }

    private synchronized Image loadSvgImage(String fullName, IconSize imageSize) {
        String registryKey;
        if (StringUtils.isEmpty((CharSequence)fullName)) {
            return null;
        }
        if (Activator.getDefault() == null) {
            return null;
        }
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        Image image = imageRegistry.get(registryKey = String.valueOf(fullName) + "?" + imageSize);
        if ((image == null || image.isDisposed()) && (image = this.createSvgImage(fullName, imageSize)) != null) {
            imageRegistry.remove(registryKey);
            imageRegistry.put(registryKey, image);
            image = imageRegistry.get(registryKey);
        }
        return image;
    }

    private Image createSvgImage(String fullName, IconSize imageSize) {
        Display display = SwtUtilities.getDisplay();
        if (display == null) {
            return null;
        }
        URL url = this.getImageUrl(fullName);
        if (url == null) {
            return null;
        }
        URI svgUri = SVGCache.getSVGUniverse().loadSVG(url);
        SVGDiagram diagram = SVGCache.getSVGUniverse().getDiagram(svgUri);
        if (diagram == null) {
            return null;
        }
        Rectangle bounds = this.getImageBounds(diagram, imageSize);
        BufferedImage bi = new BufferedImage(bounds.width, bounds.height, 2);
        Graphics2D ig2 = bi.createGraphics();
        AffineTransform at = new AffineTransform();
        at.setToScale((float)bounds.width / diagram.getWidth(), (float)bounds.height / diagram.getHeight());
        ig2.transform(at);
        ig2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        ig2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        ig2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        try {
            try {
                SVGRoot root = diagram.getRoot();
                root.build();
                diagram.setIgnoringClipHeuristic(true);
                root.render(ig2);
            }
            catch (SVGException e) {
                e.printStackTrace();
                SVGCache.getSVGUniverse().clear();
                return null;
            }
        }
        finally {
            SVGCache.getSVGUniverse().clear();
        }
        ImageData imageData = SwtUtilities.convertAwtImageToImageData(bi);
        if (imageData == null) {
            return null;
        }
        return new Image((Device)display, imageData);
    }

    private Rectangle getImageBounds(SVGDiagram svgDiagram, IconSize imageSize) {
        int x = 0;
        int y = 0;
        int width = 0;
        int height = 0;
        if (imageSize == null || imageSize == IconSize.NONE) {
            if (svgDiagram != null) {
                width = Math.round(svgDiagram.getWidth());
                height = Math.round(svgDiagram.getHeight());
            }
        } else {
            width = imageSize.getWidth();
            height = imageSize.getHeight();
        }
        x = SwtUtilities.convertXToDpi(x);
        y = SwtUtilities.convertYToDpi(y);
        width = SwtUtilities.convertXToDpi(width);
        height = SwtUtilities.convertYToDpi(height);
        return new Rectangle(x, y, width, height);
    }

    private ImageDescriptor getImageDescriptor(String fullName) {
        URL url = this.getImageUrl(fullName);
        if (url != null) {
            return ImageDescriptor.createFromURL((URL)url);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Image resource \"");
        sb.append(fullName);
        sb.append("\" not found in:");
        IImagePathExtension[] iImagePathExtensionArray = this.iconPaths;
        int n = this.iconPaths.length;
        int n2 = 0;
        while (n2 < n) {
            IImagePathExtension iconPath = iImagePathExtensionArray[n2];
            sb.append("\n  ");
            sb.append(iconPath.getContributingBundle().getLocation());
            sb.append(iconPath.getPath());
            ++n2;
        }
        LOGGER.log(4, sb.toString());
        return null;
    }

    private URL getImageUrl(String fullName) {
        if (this.iconPaths != null) {
            IImagePathExtension[] iImagePathExtensionArray = this.iconPaths;
            int n = this.iconPaths.length;
            int n2 = 0;
            while (n2 < n) {
                IImagePathExtension iconPath = iImagePathExtensionArray[n2];
                String fullPath = String.valueOf(iconPath.getPath()) + '/' + fullName;
                URL url = iconPath.getContributingBundle().getEntry(fullPath);
                if (url != null) {
                    return url;
                }
                ++n2;
            }
        }
        return null;
    }

    public synchronized Image getMissingImage() {
        if (this.missingImage == null) {
            this.missingImage = ImageDescriptor.getMissingImageDescriptor().createImage();
        }
        return this.missingImage;
    }

    public String addImageScaleSuffix(String imageName, ImageFileExtension fileExtension) {
        return this.addImageScaleSuffix(imageName, fileExtension, SwtUtilities.getDpi());
    }

    public String addImageScaleSuffix(String imageName, ImageFileExtension fileExtension, Point dpi) {
        String scaledName;
        String suffix;
        if (LnfManager.isLnfCreated() && !StringUtils.isEmpty((CharSequence)(suffix = LnfManager.getLnf().getIconScaleSuffix(dpi))) && this.imageExists(scaledName = String.valueOf(imageName) + suffix, fileExtension)) {
            return scaledName;
        }
        return imageName;
    }

    private synchronized boolean imageExists(String imageName, ImageFileExtension fileExtension) {
        String fullName = this.getFullName(imageName, fileExtension);
        ImageDescriptor descriptor = this.getImageDescriptor(fullName);
        return descriptor != null;
    }

    @InjectExtension
    public void update(IImagePathExtension[] iconPaths) {
        this.iconPaths = iconPaths;
    }
}

